/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cast;
import coldfusion.runtime.xml.Handler;
import coldfusion.runtime.xml.Registry;
import coldfusion.runtime.xml.SerializationException;
import coldfusion.runtime.xml.SimpleTypeReader;
import coldfusion.runtime.xml.StAXXMLReader;
import coldfusion.runtime.xml.StringBuilderXMLGenerator;
import coldfusion.runtime.xml.XMLReader;
import coldfusion.xml.rpc.CFComponentSkeleton;
import coldfusion.xml.rpc.DocumentQueryBean;
import coldfusion.xml.rpc.QueryBean;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLizerUtils {
    private static final Logger logger = CFLogs.SERVER_LOG;
    public static XMLStreamWriter xsw;

    public static String serializeXML(Object o, boolean useCustomSerializer) throws SerializationException {
        StringBuilderXMLGenerator generator = new StringBuilderXMLGenerator();
        Registry registry = Registry.getRegistry(FusionContext.getCurrent().getApplicationName());
        Handler serializer = registry.getSerializer(o);
        serializer.serialize(generator, o, useCustomSerializer);
        return generator.getXML();
    }

    public static Object deserializeXML(Class type, Object xmlObj, boolean useCustomSerializer) {
        Object o;
        String xml;
        try {
            xml = Cast._String(xmlObj).trim();
        }
        catch (Exception ex) {
            throw new XMLParseInvalidTypeException();
        }
        try {
            Registry registry = Registry.getRegistry(FusionContext.getCurrent().getApplicationName());
            String dataType = XMLizerUtils.getType(type, xml);
            Handler deserializer = registry.getDeserializer(dataType);
            XMLReader reader = XMLizerUtils.getReader(xml, dataType);
            reader.next();
            o = deserializer.deserialize(reader, type, useCustomSerializer);
        }
        catch (Throwable t) {
            logger.error("Error parsing XML string", t);
            throw new XMLParseException(t);
        }
        return o;
    }

    private static String getTypeFromXML(String xml) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(null);
            InputSource is = new InputSource(new StringReader(xml));
            Document doc = builder.parse(is);
            String localName = doc.getFirstChild().getNodeName();
            if (localName != null) {
                if ("STRUCT".equals(localName = localName.toUpperCase())) {
                    return "STRUCT";
                }
                if ("QUERY".equals(localName)) {
                    return "QUERY";
                }
                if ("COMPONENT".equals(localName)) {
                    return "COMPONENT";
                }
                if ("ARRAY".equals(localName)) {
                    return "ARRAY";
                }
            }
            return "DOCUMENT";
        }
        catch (Exception e) {
            Object localName = null;
            try {
                Cast._double(xml, false, false);
                return "NUMBER";
            }
            catch (Exception exception) {
                try {
                    Cast._boolean(xml);
                    return "BOOLEAN";
                }
                catch (Exception exception2) {
                    try {
                        Cast._Date(xml);
                        return "DATE";
                    }
                    catch (Exception exception3) {
                        return "STRING";
                    }
                }
            }
        }
    }

    private static XMLReader getReader(String xml, String dataType) throws XMLStreamException, FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        XMLReader reader = null;
        reader = "NUMBER".equals(dataType) || "DATE".equals(dataType) || "BOOLEAN".equals(dataType) || "STRING".equals(dataType) || "BINARY".equals(dataType) ? new SimpleTypeReader(xml) : new StAXXMLReader(xml);
        return reader;
    }

    private static String getType(Class type, String xml) {
        if (Map.class.isAssignableFrom(type)) {
            return "STRUCT";
        }
        if (QueryBean.class.isAssignableFrom(type) || DocumentQueryBean.class.isAssignableFrom(type)) {
            return "QUERY";
        }
        if (CFComponentSkeleton.class.isAssignableFrom(type)) {
            return "COMPONENT";
        }
        if (Number.class.isAssignableFrom(type)) {
            return "NUMBER";
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return "BOOLEAN";
        }
        if (Date.class.isAssignableFrom(type) || Calendar.class.isAssignableFrom(type)) {
            return "DATE";
        }
        if (type == byte[].class) {
            return "BINARY";
        }
        if (type.isArray()) {
            return "ARRAY";
        }
        if (Object.class.equals((Object)type)) {
            return XMLizerUtils.getTypeFromXML(xml);
        }
        if (Document.class.equals((Object)type)) {
            return "DOCUMENT";
        }
        return null;
    }

    static {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            xsw = XMLOutputFactory.newInstance().createXMLStreamWriter(stream);
        }
        catch (Exception e) {
            xsw = null;
        }
    }

    public static class XMLParseInvalidTypeException
    extends ApplicationException {
    }

    public static class XMLParseException
    extends ApplicationException {
        public XMLParseException(Throwable e) {
            super(e);
        }

        public String getRootMessage() {
            String message = this.rootCause.getMessage();
            if (null != message && message.endsWith(".")) {
                message = message.substring(0, message.length() - 1);
            }
            return message;
        }
    }
}

