/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.async;

import coldfusion.log.CFLogs;
import coldfusion.runtime.async.CallableMethod;
import coldfusion.runtime.async.CallableResult;
import coldfusion.runtime.async.ColdfusionFuture;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;

public class CallableCompletionService
extends ExecutorCompletionService {
    Map<Integer, CallableMethod> callablesMap = new ConcurrentHashMap<Integer, CallableMethod>();

    public CallableCompletionService(Executor executor) {
        super(executor);
    }

    @Override
    public Future submit(Callable task2) {
        if (task2 == null) {
            throw new NullPointerException();
        }
        try {
            CallableMethod callableMethod = (CallableMethod)task2;
            this.callablesMap.put(callableMethod.hashCode(), callableMethod);
            Future future = super.submit(callableMethod);
            return new ColdfusionFuture(future, callableMethod.getMethod());
        }
        catch (ClassCastException ex) {
            CFLogs.APPLICATION_LOG.error(ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Future take() {
        try {
            Future future = super.take();
            CallableResult result = (CallableResult)future.get();
            ColdfusionFuture cfFuture = new ColdfusionFuture(future, result.getMethod());
            return cfFuture;
        }
        catch (InterruptedException | ExecutionException ex) {
            CFLogs.APPLICATION_LOG.error(ex);
            throw new RuntimeException(ex);
        }
    }
}

