/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.async;

import coldfusion.concurrent.CFThreadPoolExecutor;
import coldfusion.concurrent.Constants;
import coldfusion.concurrent.ExecutorThreadFactory;
import coldfusion.concurrent.ExecutorUtils;
import coldfusion.concurrent.exception.CorePoolSizeExceedsLimitException;
import coldfusion.concurrent.exception.CorePoolSizeExceedsMaxPoolSizeException;
import coldfusion.concurrent.exception.CorePoolSizeNegativeException;
import coldfusion.concurrent.exception.KeepAliveTimeNegativeException;
import coldfusion.concurrent.exception.MaxPoolSizeExceedsLimitException;
import coldfusion.concurrent.exception.MaxPoolSizeNegativeException;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.log.CFLogs;
import coldfusion.runtime.async.ExecutionServiceConstants;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.util.RB;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class Executor {
    private static ExecutorService executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorService getInstance() {
        if (executor != null) return executor;
        Class<Executor> clazz = Executor.class;
        synchronized (Executor.class) {
            if (executor == null) {
                RuntimeService runtimeSvc = ServiceFactory.getRuntimeService();
                try {
                    Executor.validateAsyncCorePoolSize(runtimeSvc.getCorePoolSize(), false);
                }
                catch (Exception ex) {
                    CFLogs.SERVER_LOG.info(ex);
                    CFLogs.SERVER_LOG.info(RB.getString(Executor.class, "Executor.CorePoolSize.DefaultingForStdEdition", ExecutionServiceConstants.DEFAULT_CORE_POOL_SIZE_STD_EDITION));
                    runtimeSvc.setCorePoolSize(ExecutionServiceConstants.DEFAULT_CORE_POOL_SIZE_STD_EDITION);
                }
                try {
                    Executor.validateAsyncMaxPoolSize(runtimeSvc.getMaxPoolSize(), false);
                }
                catch (Exception ex) {
                    CFLogs.SERVER_LOG.info(ex);
                    CFLogs.SERVER_LOG.info(RB.getString(Executor.class, "Executor.MaxPoolSize.DefaultingForStdEdition", ExecutionServiceConstants.DEFAULT_MAX_POOL_SIZE_STD_EDITION));
                    runtimeSvc.setMaxPoolSize(ExecutionServiceConstants.DEFAULT_MAX_POOL_SIZE_STD_EDITION);
                }
                try {
                    Executor.validateKeepAliveTime(runtimeSvc.getKeepAliveTime(), false);
                }
                catch (Exception ex) {
                    CFLogs.SERVER_LOG.info(ex);
                    CFLogs.SERVER_LOG.info(RB.getString(Executor.class, "Executor.KeepAliveTime.Defaulting", ExecutionServiceConstants.DEFAULT_KEEP_ALIVE_TIME));
                    runtimeSvc.setKeepAliveTime(ExecutionServiceConstants.DEFAULT_KEEP_ALIVE_TIME);
                }
                executor = CFThreadPoolExecutor.get(runtimeSvc.getCorePoolSize(), runtimeSvc.getMaxPoolSize(), runtimeSvc.getKeepAliveTime(), TimeUnit.MILLISECONDS, new ExecutorThreadFactory("runasync"));
                CFLogs.SERVER_LOG.info(RB.getString(Executor.class, "Executor.Initialization", runtimeSvc.getCorePoolSize(), (Object)runtimeSvc.getMaxPoolSize(), (Object)runtimeSvc.getKeepAliveTime()));
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Executor.shutdown(ExecutionServiceConstants.EXECUTOR_JVM_SHUTDOWN_TIME);
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return executor;
        }
    }

    public static boolean hasConfigChanged() {
        boolean hasChanged = false;
        RuntimeService runtimeSvc = ServiceFactory.getRuntimeService();
        if (((ThreadPoolExecutor)executor).getCorePoolSize() != runtimeSvc.getCorePoolSize() || ((ThreadPoolExecutor)executor).getMaximumPoolSize() != runtimeSvc.getMaxPoolSize() || ((ThreadPoolExecutor)executor).getKeepAliveTime(TimeUnit.MILLISECONDS) != runtimeSvc.getKeepAliveTime()) {
            hasChanged = true;
        }
        return hasChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void restartExecutorWithChangedParams() {
        if (executor == null || executor.isShutdown() || executor.isTerminated() || !Executor.hasConfigChanged()) return;
        Class<Executor> clazz = Executor.class;
        synchronized (Executor.class) {
            if (executor == null) return;
            Executor.shutdown(Constants.EXECUTOR_CONFIG_CHANGE_SHUTDOWN_TIME);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void validateAsyncCorePoolSize(int corePoolSize, boolean setToExecutor) {
        int maxThreads;
        RuntimeService runtimeSvc = ServiceFactory.getRuntimeService();
        int rtMaxPoolSize = runtimeSvc.getMaxPoolSize();
        if (corePoolSize < 0) {
            throw new CorePoolSizeNegativeException();
        }
        if ("standard".equals(FeatureRouter.getInstance().getServerEdition().getEditionName()) && corePoolSize > (maxThreads = FeatureRouter.getInstance().getServerEdition().getPoolSizeLimitForAsync())) {
            throw new CorePoolSizeExceedsLimitException(maxThreads);
        }
        if (corePoolSize > rtMaxPoolSize) {
            throw new CorePoolSizeExceedsMaxPoolSizeException();
        }
        if (setToExecutor && executor != null) {
            ((ThreadPoolExecutor)executor).setCorePoolSize(runtimeSvc.getCorePoolSize());
        }
    }

    public static void validateAsyncMaxPoolSize(int maxPoolSize, boolean setToExecutor) {
        int maxThreads;
        RuntimeService runtimeSvc = ServiceFactory.getRuntimeService();
        if (maxPoolSize < 0) {
            throw new MaxPoolSizeNegativeException();
        }
        if ("standard".equals(FeatureRouter.getInstance().getServerEdition().getEditionName()) && maxPoolSize > (maxThreads = FeatureRouter.getInstance().getServerEdition().getPoolSizeLimitForAsync())) {
            throw new MaxPoolSizeExceedsLimitException(maxThreads);
        }
        if (setToExecutor && executor != null) {
            ((ThreadPoolExecutor)executor).setMaximumPoolSize(maxPoolSize);
        }
    }

    public static void validateKeepAliveTime(long keepAliveTime, boolean setToExecutor) {
        if (keepAliveTime < 0L) {
            throw new KeepAliveTimeNegativeException();
        }
        if (setToExecutor && executor != null) {
            ((ThreadPoolExecutor)executor).setKeepAliveTime(keepAliveTime, TimeUnit.MILLISECONDS);
        }
    }

    public static int getActiveThreadCount() {
        return ExecutorUtils.getActiveThreadCount(executor);
    }

    public static int getQueuedThreadCount() {
        return ExecutorUtils.getQueuedThreadCount(executor);
    }

    public static int getCurrentPoolSize() {
        return ExecutorUtils.getCurrentPoolSize(executor);
    }

    public static int getLargestPoolSize() {
        return ExecutorUtils.getLargestPoolSize(executor);
    }

    public static long getCompletedTaskCount() {
        return ExecutorUtils.getCompletedTaskCount(executor);
    }

    public static long getTotalTaskCount() {
        return ExecutorUtils.getTotalTaskCount(executor);
    }

    private static void shutdown(long shutdownTime) {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(shutdownTime, TimeUnit.MILLISECONDS)) {
                List<Runnable> list = executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            CFLogs.SERVER_LOG.error(e);
        }
        finally {
            executor = null;
        }
    }
}

