/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.dotnet;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.NeoException;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class AssemblyManifestReader {
    private Method loadFromMeth;
    private Method loadMeth;
    private Method getReferencedAssemblies;
    private Logger logger = CFLogs.DOTNET_LOG;
    private ClassLoader loader;

    public AssemblyManifestReader(File dotNetCoreJar) {
        try {
            this.loader = new URLClassLoader(new URL[]{dotNetCoreJar.toURL()}, this.getClass().getClassLoader());
            Class<?> assemblyClass = this.loader.loadClass("System.Reflection.Assembly");
            Class<?> assemblyNameClass = this.loader.loadClass("System.Reflection.AssemblyName");
            this.loadFromMeth = assemblyClass.getMethod("LoadFrom", String.class);
            this.loadMeth = assemblyClass.getMethod("Load", assemblyNameClass);
            this.getReferencedAssemblies = assemblyClass.getMethod("GetReferencedAssemblies", new Class[0]);
        }
        catch (MalformedURLException assemblyClass) {
        }
        catch (ClassNotFoundException e) {
            throw new ManifestReaderInitException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ManifestReaderInitException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getReferencedAssemblies(String assemblyPath) {
        ArrayList<String> referencedAssemblies = new ArrayList<String>(2);
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.loader);
        try {
            Object assembly = this.loadFromMeth.invoke(null, assemblyPath);
            Object[] assemblyNames = (Object[])this.getReferencedAssemblies.invoke(assembly, new Object[0]);
            for (int j = 0; j < assemblyNames.length; ++j) {
                Object assemblyName = assemblyNames[j];
                try {
                    this.loadMeth.invoke(null, assemblyName);
                    referencedAssemblies.add(assemblyName.toString());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error in retrieving the referenced assembly", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        return referencedAssemblies.toArray(new String[referencedAssemblies.size()]);
    }

    public static class ManifestReaderInitException
    extends NeoException {
        ManifestReaderInitException(Throwable ex) {
            super(ex);
        }
    }
}

