/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.dotnet;

import coldfusion.log.CFLogs;
import coldfusion.runtime.dotnet.CFDotNetTranslator;
import coldfusion.util.SoftCache;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class DotNetHashtable
extends Hashtable {
    private static SoftCache methodCache = new SoftCache(){

        @Override
        protected Object fetch(Object key) {
            return new HashtableReflectionData((Class)key);
        }
    };

    public DotNetHashtable(Object dotNetHashtable) {
        try {
            HashtableReflectionData reflectionData = (HashtableReflectionData)methodCache.get(dotNetHashtable.getClass());
            Object enumerator = reflectionData.enumMethod.invoke(dotNetHashtable, new Object[0]);
            while (((Boolean)reflectionData.moveNextMethod.invoke(enumerator, new Object[0])).booleanValue()) {
                Object key = reflectionData.getKeyMethod.invoke(enumerator, new Object[0]);
                key = CFDotNetTranslator.dotnetToCF(key);
                Object value = reflectionData.getValueMethod.invoke(enumerator, new Object[0]);
                value = CFDotNetTranslator.dotnetToCF(value);
                super.put(key, value);
            }
        }
        catch (Throwable e) {
            CFLogs.DOTNET_LOG.error(e);
        }
    }

    private static class HashtableReflectionData {
        Method enumMethod;
        Method moveNextMethod;
        Method getKeyMethod;
        Method getValueMethod;

        public HashtableReflectionData(Class hashTableClass) {
            try {
                this.enumMethod = hashTableClass.getMethod("GetEnumerator", new Class[0]);
                Class<?> enumeratorClass = hashTableClass.getClassLoader().loadClass("System.Collections.IDictionaryEnumerator");
                this.moveNextMethod = enumeratorClass.getMethod("MoveNext", new Class[0]);
                this.getKeyMethod = enumeratorClass.getMethod("Get_Key", new Class[0]);
                this.getValueMethod = enumeratorClass.getMethod("Get_Value", new Class[0]);
            }
            catch (Throwable e) {
                CFLogs.DOTNET_LOG.error(e);
            }
        }
    }
}

