/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.dotnet;

import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.runtime.DotNetAssemblyNotRegisteredException;
import coldfusion.runtime.java.JavaProxy;
import jakarta.servlet.jsp.PageContext;

public class DotNetProxy
extends JavaProxy {
    private ClassLoader loader;

    public DotNetProxy(Class clazz) {
        super(clazz);
        this.loader = clazz.getClassLoader();
    }

    public DotNetProxy(Object o) {
        super(o);
        this.loader = o.getClass().getClassLoader();
    }

    @Override
    public Object invoke(String methodName, Object[] args, PageContext pageContext) throws Throwable {
        RequestMonitorEventProcessor.onFunctionStart(methodName, null, true);
        ClassLoader origCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.loader);
        try {
            Object object = super.invoke(methodName, args, pageContext);
            return object;
        }
        catch (Throwable th) {
            if (th.getClass().getName().equals("com.jnbridge.jnbcore.DotNetClassNotFoundException")) {
                throw new DotNetAssemblyNotRegisteredException(th);
            }
            throw th;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCL);
            RequestMonitorEventProcessor.onFunctionEnd(methodName, null, TagAttributeList.getInstance("method", methodName).addTagAttribute("isExternal", true).getTagAttributes(), true);
        }
    }
}

