/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.dotnet;

import coldfusion.runtime.ApplicationException;
import com.jnbridge.jnbcore.DotNetSide;
import java.io.IOException;
import java.net.Socket;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class DotNetServerAgent {
    private static final Set serverSet = new HashSet();
    private static boolean initialized = false;

    public static void setCurrent(String host, String port, String protocol, boolean secure) {
        String serverName = DotNetServerAgent.getDotNetServerName(host, port, protocol, secure);
        if (!DotNetServerAgent.isDotnetSideRunning(host, port)) {
            throw new DotNetSideNotRunningException(host, port);
        }
        DotNetSide.setServer((String)serverName, (boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isDotnetSideRunning(String host, String port) {
        int portInt = Integer.parseInt(port);
        Socket sock = null;
        try {
            sock = new Socket(host, portInt);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (sock != null) {
                    sock.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDotNetServerName(String host, String port, String protocol, boolean secure) {
        Object servername = protocol + "_" + host + "_" + port + "_" + secure;
        if (serverSet.contains(servername = ((String)servername).toUpperCase())) {
            return servername;
        }
        Set set = serverSet;
        synchronized (set) {
            if (!serverSet.contains(servername)) {
                Properties props = new Properties();
                props.setProperty("dotNetSide.serverType", protocol);
                props.setProperty("dotNetSide.host", host);
                props.setProperty("dotNetSide.port", port);
                props.setProperty("useSSL", "" + secure);
                if (!initialized) {
                    DotNetSide.init((Properties)props);
                    initialized = true;
                }
                DotNetSide.addServer((String)servername, (Properties)props);
                serverSet.add(servername);
            }
        }
        return servername;
    }

    public static class DotNetSideNotRunningException
    extends ApplicationException {
        public String host;
        public String port;

        public DotNetSideNotRunningException(String host, String port) {
            this.host = host;
            this.port = port;
        }
    }
}

