/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.dotnet;

import coldfusion.log.CFLogs;
import coldfusion.runtime.ProxyFactory;
import coldfusion.runtime.dotnet.CFDotNetTranslator;
import coldfusion.runtime.dotnet.DotNetProxy;
import coldfusion.runtime.dotnet.DotNetProxyFactory;
import coldfusion.runtime.dotnet.ProxyGenerator;
import coldfusion.server.ConfigMap;
import coldfusion.server.DotNetService;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.ServiceRuntimeException;
import coldfusion.util.IPAddressUtils;
import com.jnbridge.jnbcore.JNBMain;
import com.jnbridge.jnbcore.server.ServerException;
import java.io.File;
import java.net.Socket;
import java.util.Properties;

public class DotNetServiceImpl
extends ServiceBase
implements DotNetService {
    private int port = 6085;
    private String host = "127.0.0.1";
    private String ipWhitelist = "127.0.0.1";
    private int localDotnetPort = 6086;
    private String localDotnetHost = this.host;
    private String protocol = "tcp";
    private File configFile;
    private ConfigMap settings;
    private static final String PROTOCOL_STR = "protocol";
    private static final String PORT_STR = "port";
    private static final String HOST_STR = "hostIP";
    private static final String IP_WHITELIST_STR = "ipWhitelist";
    private static final String LOCAL_DOTNET_PORT_STR = "dotnetport";
    private static final String LOCAL_DOTNET_HOST_STR = "dotnethost";
    private static final String JNBRIDGE_INSTALL_DIR = "install_dir";
    private static final String LOCALHOST_IP = "127.0.0.1";
    private ProxyGenerator proxyGenerator;
    private File binDir;
    private String outputDir;
    private boolean dynamicReloading;
    private boolean jnbridgeInstalled;
    private static Class dotnetObjectBaseClass;
    private static Class dotnetSideProxyClass;

    public DotNetServiceImpl(File configFile) {
        this.configFile = configFile;
    }

    @Override
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getIpWhitelist() {
        return this.ipWhitelist;
    }

    public void setIpWhitelist(String ipWhitelist) {
        SecurityService securityService = ServiceFactory.getSecurityService();
        securityService.authenticateAdmin();
        try {
            this.ipWhitelist = ipWhitelist;
            this.settings.put(IP_WHITELIST_STR, (Object)this.ipWhitelist);
            if (this.settings.get(HOST_STR) == null || String.valueOf(this.settings.get(HOST_STR)).trim().length() == 0) {
                this.settings.put(HOST_STR, (Object)LOCALHOST_IP);
            }
            this.store();
        }
        catch (ServiceException e) {
            throw new ServiceRuntimeException(e);
        }
    }

    @Override
    public void setLocalDotnetPort(int port) {
        this.localDotnetPort = port;
    }

    @Override
    public int getLocalDotnetPort() {
        return this.localDotnetPort;
    }

    @Override
    public void setLocalDotnetHost(String host) {
        this.localDotnetHost = host;
    }

    @Override
    public String getLocalDotnetHost() {
        return this.localDotnetHost;
    }

    @Override
    public File getJNBridgeBinDir() {
        return this.binDir;
    }

    @Override
    public boolean isJNBridgeInstalled() {
        return this.jnbridgeInstalled;
    }

    @Override
    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    @Override
    public String getOutputDir() {
        return this.outputDir;
    }

    @Override
    public void setDynamicReloadingEnabled(boolean enabled) {
        this.dynamicReloading = enabled;
    }

    @Override
    public boolean isDynamicReloadingEnabled() {
        return this.dynamicReloading;
    }

    @Override
    public Object getProxyGenerator() {
        if (this.proxyGenerator == null) {
            this.proxyGenerator = new ProxyGenerator(this.binDir, this.host, "" + this.port, this.protocol);
        }
        return this.proxyGenerator;
    }

    public static boolean IsPortActive(String host, int port) {
        boolean IsActive;
        Socket s = null;
        try {
            s = new Socket(host, port);
            try {
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            IsActive = true;
        }
        catch (Exception ex) {
            IsActive = false;
        }
        return IsActive;
    }

    @Override
    public void start() throws ServiceException {
        super.start();
        this.dynamicReloading = !ServiceFactory.getRuntimeService().isTrustedCache();
        Properties props = new Properties();
        props.setProperty("javaSide.serverType", this.protocol);
        props.setProperty("javaSide.hostIP", this.host);
        props.setProperty("javaSide.port", "" + this.port);
        props.setProperty("dotNetSide.ipWhitelist", this.ipWhitelist);
        try {
            JNBMain.start((Properties)props);
        }
        catch (ServerException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void stop() throws ServiceException {
        super.stop();
        try {
            JNBMain.stop();
        }
        catch (ServerException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public void load() throws ServiceException {
        try {
            if (this.configFile.exists()) {
                String installDir;
                String dotNetHostStr;
                String dotNetportStr;
                this.settings = (ConfigMap)this.deserialize(this.configFile);
                this.protocol = (String)this.settings.get(PROTOCOL_STR);
                String portStr = (String)this.settings.get(PORT_STR);
                this.port = Integer.parseInt(portStr);
                this.host = (String)this.settings.get(HOST_STR);
                if (this.host == null || this.host.trim().length() == 0) {
                    this.host = LOCALHOST_IP;
                }
                this.ipWhitelist = (String)this.settings.get(IP_WHITELIST_STR);
                if (this.ipWhitelist == null) {
                    this.ipWhitelist = LOCALHOST_IP;
                }
                if ((dotNetportStr = (String)this.settings.get(LOCAL_DOTNET_PORT_STR)) != null && dotNetportStr.length() != 0) {
                    this.localDotnetPort = Integer.parseInt(dotNetportStr);
                }
                if ((dotNetHostStr = (String)this.settings.get(LOCAL_DOTNET_HOST_STR)) != null && dotNetHostStr.trim().length() > 0 && IPAddressUtils.validateIPAdress(dotNetHostStr)) {
                    this.localDotnetHost = dotNetHostStr;
                }
                if ((installDir = (String)this.settings.get(JNBRIDGE_INSTALL_DIR)) != null && installDir.trim().length() > 0) {
                    this.binDir = new File(installDir);
                    this.jnbridgeInstalled = this.binDir.exists();
                }
            }
        }
        catch (Throwable ex) {
            CFLogs.SERVER_LOG.applog("information", "DotNetService", "Unable to read neo-dotnet.xml. Creating default one.", ex);
        }
        if (this.settings == null) {
            this.settings = new ConfigMap();
            this.settings.put(PROTOCOL_STR, (Object)this.protocol);
            this.settings.put(PORT_STR, (Object)("" + this.port));
            this.settings.put(HOST_STR, (Object)this.host);
            this.settings.put(IP_WHITELIST_STR, (Object)this.ipWhitelist);
            this.settings.put(LOCAL_DOTNET_PORT_STR, (Object)String.valueOf(this.localDotnetPort));
            this.settings.put(LOCAL_DOTNET_HOST_STR, (Object)LOCALHOST_IP);
            if (this.binDir != null && this.binDir.exists()) {
                this.settings.put(JNBRIDGE_INSTALL_DIR, (Object)this.binDir.getAbsolutePath());
            }
            this.store();
        }
        this.settings.setConfigMapListener(this);
    }

    @Override
    public void store() throws ServiceException {
        this.serialize(this.settings, this.configFile);
    }

    @Override
    public boolean isDotNetClass(Class clazz) {
        return dotnetObjectBaseClass.isAssignableFrom(clazz) || dotnetSideProxyClass.isAssignableFrom(clazz);
    }

    @Override
    public boolean isProxyParent(Class clazz) {
        return clazz.isAssignableFrom(dotnetObjectBaseClass) || clazz.isAssignableFrom(dotnetSideProxyClass);
    }

    @Override
    public boolean isDotNetObject(Object obj) {
        return dotnetObjectBaseClass.isInstance(obj) || dotnetSideProxyClass.isInstance(obj);
    }

    @Override
    public Object convertToSystemObject(Class t, Object sysObj) {
        return CFDotNetTranslator.convertToSystemObject(t, sysObj);
    }

    @Override
    public Object cfToDotnet(Object cfObj) {
        return CFDotNetTranslator.cfToDotnet(cfObj);
    }

    @Override
    public ProxyFactory getDotNetProxyFactory() {
        return new DotNetProxyFactory();
    }

    @Override
    public Object dotnetToCF(Object dotNetObj) {
        return CFDotNetTranslator.dotnetToCF(dotNetObj);
    }

    @Override
    public Object autoConvertDotnetToCF(Object dotNetObj) {
        return CFDotNetTranslator.autoConvertDotnetToCF(dotNetObj);
    }

    @Override
    public boolean isDotNetProxy(Object obj) {
        return obj != null && obj instanceof DotNetProxy;
    }

    static {
        try {
            dotnetObjectBaseClass = DotNetServiceImpl.class.getClassLoader().loadClass("com.jnbridge.jnbcore.DotNetObjectBase");
            dotnetSideProxyClass = DotNetServiceImpl.class.getClassLoader().loadClass("com.jnbridge.jnbcore.DotNetSideProxy");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

