/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.dotnet;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.dotnet.AssemblyManifestReader;
import coldfusion.runtime.dotnet.DotNetServerAgent;
import coldfusion.runtime.dotnet.ProxyGenerationException;
import coldfusion.server.DotNetService;
import coldfusion.server.ServiceFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ProxyGenerator {
    private String jnbProxy;
    private String host;
    private String port;
    private String protocol;
    private static Set coreSystemClasses;
    private static final boolean isWindows;
    private static Logger logger;
    private AssemblyManifestReader manifestReader;

    public ProxyGenerator(File jnbProBinDir, String host, String port, String protocol) {
        this.jnbProxy = new File(jnbProBinDir, "jnbproxy.exe").getAbsolutePath();
        this.host = host;
        this.port = port;
        this.protocol = protocol;
    }

    void setCoreSystemClasses(Set classSet) {
        coreSystemClasses = classSet;
    }

    public void setAssemblyManifestReader(AssemblyManifestReader assemblyManifestReader) {
        this.manifestReader = assemblyManifestReader;
    }

    public void generateProxy(String className, List assemblies, List proxyList, File outputJar, boolean includeSupportingClasses) throws ProxyGenerationException {
        String assemblyPath = this.getAssemblyPath(assemblies);
        this.generateProxy(className, assemblyPath, proxyList, outputJar, includeSupportingClasses);
    }

    public void generateProxy(String className, String assemblyPath, List proxyList, File outputJar, boolean includeSupportingClasses) throws ProxyGenerationException {
        if (!isWindows) {
            throw new UnsupportedOperationException("Proxy Generation not supported on Non-Windows systems");
        }
        String[] commandArray = this.getProxyGenCommandArray(className, assemblyPath, proxyList, outputJar, includeSupportingClasses);
        this.executeProxyGen(commandArray);
    }

    public void generateProxy(Set classes, List assemblies, List proxyList, File outputJar, boolean includeSupportingClasses) throws ProxyGenerationException {
        if (!isWindows) {
            throw new UnsupportedOperationException("Proxy Generation not supported on Non-Windows systems");
        }
        String assemblyPath = this.getAssemblyPath(assemblies);
        String[] commandArray = this.getProxyGenCommandArray(classes, assemblyPath, proxyList, outputJar, includeSupportingClasses);
        this.executeProxyGen(commandArray);
    }

    public void generateProxy(File classListFile, String assemblyPath, List proxyList, File outputJar, boolean includeSupportingClasses) throws ProxyGenerationException {
        if (!isWindows) {
            throw new UnsupportedOperationException("Proxy Generation not supported on Non-Windows systems");
        }
        List cmdList = this.getCommandList(assemblyPath, proxyList, outputJar, includeSupportingClasses);
        cmdList.add("/f");
        cmdList.add(classListFile.getAbsolutePath());
        String[] commandArray = cmdList.toArray(new String[cmdList.size()]);
        this.executeProxyGen(commandArray);
    }

    private void executeProxyGen(final String[] commandArray) throws ProxyGenerationException {
        if (System.getSecurityManager() == null) {
            this._executeProxyGen(commandArray);
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        ProxyGenerator.this._executeProxyGen(commandArray);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new ProxyGenerationException(e);
            }
        }
    }

    private void _executeProxyGen(String[] commandArray) throws ProxyGenerationException {
        int exitValue;
        Runtime runtime = Runtime.getRuntime();
        try {
            Process p = runtime.exec(commandArray);
            this.consumeStreams(p);
            p.waitFor();
            exitValue = p.exitValue();
        }
        catch (Throwable e) {
            logger.error("Error while generating the proxy jar : ", e);
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < commandArray.length; ++i) {
                buff.append(commandArray[i]).append(" ");
            }
            logger.error("Command to generate proxy was " + buff.toString());
            throw new ProxyGenerationException(e);
        }
        if (exitValue != 0) {
            throw new ProxyGenerationException();
        }
    }

    public Set getDependentClasses(String className, List assemblies, boolean includeCoreClasses) throws ProxyGenerationException {
        return this.getDependentClasses(className, this.getAssemblyPath(assemblies), includeCoreClasses);
    }

    public Set getDependentClasses(final String className, final String assemblyPath, final boolean includeCoreClasses) throws ProxyGenerationException {
        Set result;
        if (System.getSecurityManager() == null) {
            return this._getDependentClasses(className, assemblyPath, includeCoreClasses);
        }
        try {
            result = (Set)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ProxyGenerator.this._getDependentClasses(className, assemblyPath, includeCoreClasses);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new ProxyGenerationException(e);
        }
        return result;
    }

    public Set _getDependentClasses(String className, String assemblyPath, boolean includeCoreClasses) throws ProxyGenerationException {
        if (!isWindows) {
            throw new UnsupportedOperationException("Proxy Generation not supported on Non-Windows systems");
        }
        Runtime runtime = Runtime.getRuntime();
        String[] commandArray = this.getListCommandArray(className, assemblyPath);
        try {
            Process p = runtime.exec(commandArray);
            HashSet classSet = new HashSet();
            this.readClasses(p.getInputStream(), classSet, includeCoreClasses);
            this.consumeStream(p.getErrorStream(), true);
            p.waitFor();
            return classSet;
        }
        catch (Throwable e) {
            logger.error("Error occurred in generating the dependent class list " + Arrays.asList(commandArray), e);
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < commandArray.length; ++i) {
                buff.append(commandArray[i]).append(" ");
            }
            logger.error("Command to generate proxy was " + buff.toString());
            throw new ProxyGenerationException(e);
        }
    }

    private void readClasses(final InputStream in, final Set classSet, final boolean includeCoreClasses) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                try {
                    String className;
                    boolean listStarted = false;
                    while ((className = reader.readLine()) != null) {
                        if (listStarted) {
                            if (includeCoreClasses) {
                                classSet.add(className);
                                continue;
                            }
                            if (coreSystemClasses == null || coreSystemClasses.contains(className)) continue;
                            classSet.add(className);
                            continue;
                        }
                        if (!className.startsWith("List of supporting classes")) continue;
                        listStarted = true;
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }).start();
    }

    private void consumeStreams(Process p) {
        this.consumeStream(p.getInputStream(), false);
        this.consumeStream(p.getErrorStream(), true);
    }

    private void consumeStream(final InputStream in, final boolean log) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] buff = new byte[512];
                try {
                    int read;
                    while ((read = in.read(buff)) != -1) {
                        if (!log) continue;
                        logger.error(new String(buff, 0, read));
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }).start();
    }

    private String[] getListCommandArray(String className, String assemblyPath) {
        List cmdList = this.getCommandList(assemblyPath, null, null, true);
        cmdList.add("/ls");
        cmdList.add(className);
        return cmdList.toArray(new String[cmdList.size()]);
    }

    private String[] getProxyGenCommandArray(String className, String assemblyPath, List proxyList, File outputJar, boolean includeSupportingClasses) {
        List cmdList = this.getCommandList(assemblyPath, proxyList, outputJar, includeSupportingClasses);
        cmdList.add(className);
        return cmdList.toArray(new String[cmdList.size()]);
    }

    private String[] getProxyGenCommandArray(Set classes, String assemblyPath, List proxyList, File outputJar, boolean includeSupportingClasses) {
        List cmdList = this.getCommandList(assemblyPath, proxyList, outputJar, includeSupportingClasses);
        cmdList.addAll(classes);
        return cmdList.toArray(new String[cmdList.size()]);
    }

    private List getCommandList(String assemblyPath, List proxyList, File outputJar, boolean includeSupportingClasses) {
        String proxiesPath;
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(this.jnbProxy);
        if (assemblyPath != null && assemblyPath.length() > 0) {
            cmdList.add("/al");
            cmdList.add(assemblyPath);
        }
        cmdList.add("/host");
        cmdList.add(this.host);
        if (outputJar != null) {
            cmdList.add("/d");
            cmdList.add(outputJar.getParent());
            cmdList.add("/n");
            String name = outputJar.getName();
            int indexOfDot = name.lastIndexOf(46);
            if (indexOfDot != -1) {
                name = name.substring(0, indexOfDot);
            }
            cmdList.add(name);
        } else {
            cmdList.add("/ls");
        }
        if (!includeSupportingClasses) {
            cmdList.add("/ns");
        }
        if ((proxiesPath = this.expandList(proxyList)) != null) {
            cmdList.add("/proxiespath");
            cmdList.add(proxiesPath);
        }
        cmdList.add("/nj");
        cmdList.add("/pd");
        cmdList.add("j2n");
        cmdList.add("/port");
        cmdList.add(this.port);
        cmdList.add("/pro");
        String protocolStr = this.protocol.equalsIgnoreCase("http") ? "h" : "b";
        cmdList.add(protocolStr);
        cmdList.add("/cf");
        return cmdList;
    }

    private String expandList(List list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String semicolon = "";
        for (int i = 0; i < list.size(); ++i) {
            File file = (File)list.get(i);
            sb.append(semicolon).append(file.getAbsolutePath());
            semicolon = ";";
        }
        return sb.toString();
    }

    private String getAssemblyPath(List assemblies) {
        String assemblyPath = this.expandList(assemblies);
        if (this.manifestReader == null) {
            return assemblyPath;
        }
        HashSet<String> referencedSet = new HashSet<String>();
        DotNetService dotNetService = ServiceFactory.getDotNetService();
        DotNetServerAgent.setCurrent(dotNetService.getLocalDotnetHost(), "" + dotNetService.getLocalDotnetPort(), dotNetService.getProtocol(), false);
        for (int i = 0; i < assemblies.size(); ++i) {
            File file = (File)assemblies.get(i);
            String[] references = this.manifestReader.getReferencedAssemblies(file.getAbsolutePath());
            for (int j = 0; j < references.length; ++j) {
                String reference = references[j];
                referencedSet.add(reference);
            }
        }
        if (referencedSet.size() == 0) {
            return assemblyPath;
        }
        StringBuffer sb = new StringBuffer(assemblyPath);
        String semicolon = ";";
        Iterator iterator = referencedSet.iterator();
        while (iterator.hasNext()) {
            sb.append(semicolon).append((String)iterator.next());
        }
        return sb.toString();
    }

    static {
        isWindows = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS");
        logger = CFLogs.DOTNET_LOG;
    }
}

