/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.java;

import coldfusion.cfc.ComponentProxyFactory;
import coldfusion.cfc.DummyHttpServletRequest;
import coldfusion.cfc.DummyHttpServletResponse;
import coldfusion.filter.FusionContext;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.Cast;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.java.JavaProxyFactory;
import coldfusion.runtime.java.ObjectHandler;
import coldfusion.server.SystemInfo;
import coldfusion.xml.rpc.CFCServlet;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CFCDynamicProxy
implements InvocationHandler {
    private TemplateProxy cfc;
    private static HashSet<Method> objectMethods;

    private CFCDynamicProxy(TemplateProxy cfc) {
        this.cfc = cfc;
    }

    public static Object createDynamicProxy(String cfcName, List<String> interfaces, NeoPageContext pageContext, String importList) throws Throwable {
        TemplateProxy cfcInstance = (TemplateProxy)ComponentProxyFactory.getProxy(cfcName, pageContext, importList, null);
        return CFCDynamicProxy.createDynamicProxy(cfcInstance, interfaces, pageContext, importList);
    }

    public static Object createDynamicProxy(TemplateProxy cfcInstance, List<String> interfaces, NeoPageContext pageContext, String importList) throws Throwable {
        CFCDynamicProxy proxy = new CFCDynamicProxy(cfcInstance);
        return Proxy.newProxyInstance(CFCDynamicProxy.getClassLoader(), CFCDynamicProxy.getInterfaces(interfaces), (InvocationHandler)proxy);
    }

    public static Object createDynamicProxy(TemplateProxy cfcInstance, Set<String> interfaces) throws Throwable {
        CFCDynamicProxy proxy = new CFCDynamicProxy(cfcInstance);
        return Proxy.newProxyInstance(CFCDynamicProxy.getClassLoader(), CFCDynamicProxy.getInterfaces(interfaces), (InvocationHandler)proxy);
    }

    public static Class getJavaClass(String name) throws ClassNotFoundException {
        return Class.forName(name, false, CFCDynamicProxy.getClassLoader());
    }

    private static ClassLoader getClassLoader() {
        ApplicationScope app = ApplicationScopeTracker.getApplicationScope(FusionContext.getCurrent().getApplicationName());
        ClassLoader classLoader = null;
        if (app != null) {
            classLoader = JavaProxyFactory.getAppClassLoader(app);
        }
        if (classLoader == null) {
            classLoader = CFCDynamicProxy.class.getClassLoader();
        }
        return classLoader;
    }

    private static Class<?>[] getInterfaces(Collection<String> interfaces) {
        Class[] classes = new Class[interfaces.size()];
        Iterator<String> i = interfaces.iterator();
        int j = 0;
        ClassLoader classLoader = CFCDynamicProxy.getClassLoader();
        while (i.hasNext()) {
            Class<?> targetCls;
            String interfaceStr = null;
            try {
                interfaceStr = i.next();
                targetCls = classLoader.loadClass(interfaceStr);
            }
            catch (ClassNotFoundException e) {
                throw new InterfaceNotResolvedException(interfaceStr, e);
            }
            classes[j] = targetCls;
            ++j;
        }
        return classes;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object obj;
        block7: {
            FusionContext fusionContext = FusionContext.getCurrent();
            if (fusionContext == null) {
                CFCDynamicProxy.setUpFusionContext(this.cfc.getCfcFullyQualifiedName());
            }
            if (args == null) {
                args = new Object[]{};
            }
            obj = null;
            try {
                obj = this.cfc.proxyInvoke(method, proxy, args, FusionContext.getCurrent().pageContext, false);
            }
            catch (TemplateProxy.InvalidMethodNameException e) {
                if (objectMethods.contains(method)) {
                    obj = method.invoke((Object)this.cfc, args);
                }
                if (method.isDefault()) {
                    obj = CFCDynamicProxy.getAndInvokeDefaultHandle(proxy, method, args);
                }
                if (obj != null) break block7;
                throw e;
            }
        }
        if (obj != null) {
            obj = Cast._cast(obj, method.getReturnType());
        }
        return obj;
    }

    private static void setUpFusionContext(String sourceCFC) throws Throwable {
        FusionContext fusionContext = new FusionContext();
        fusionContext.setServletObjects((Servlet)CFCServlet.getCFCServlet(), (ServletRequest)new DummyHttpServletRequest(sourceCFC), (ServletResponse)new DummyHttpServletResponse());
        fusionContext.setUseMappings(true);
        fusionContext.setPagePath(sourceCFC);
        FusionContext.setCurrent(fusionContext);
        fusionContext.SymTab_initForRequest(false);
    }

    public static Object getAndInvokeDefaultHandle(Object proxy, Method method, Object[] args) throws Throwable {
        if (SystemInfo.isJava8()) {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            constructor.setAccessible(true);
            return ((MethodHandles.Lookup)constructor.newInstance(method.getDeclaringClass())).in(method.getDeclaringClass()).unreflectSpecial(method, method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(args);
        }
        return MethodHandles.lookup().findSpecial(method.getDeclaringClass(), method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(args);
    }

    public static Map.Entry<Method, Boolean> getJavaDefaultMethod(TemplateProxy cfc, String methodName, Object[] args) throws ClassNotFoundException {
        Set<String> impls = cfc.getOtherImplementingInterfaces().get("java");
        for (String s : impls) {
            Class clazz = CFCDynamicProxy.getJavaClass(s);
            Map.Entry<Method, Boolean> methodCFMLResolved = new ObjectHandler(clazz).findDefaultMethod(methodName, args);
            if (methodCFMLResolved.getKey() == null || !methodCFMLResolved.getKey().isDefault()) continue;
            return methodCFMLResolved;
        }
        return null;
    }

    static {
        Method[] methods;
        objectMethods = new HashSet();
        for (Method method : methods = Object.class.getMethods()) {
            objectMethods.add(method);
        }
    }

    public static class InterfaceNotResolvedException
    extends NeoException {
        public String interfaceName;

        public InterfaceNotResolvedException(String interfaceName, Throwable e) {
            super(e);
            this.interfaceName = interfaceName;
        }
    }

    public static class InterfaceOverloadMethodsException
    extends NeoException {
        public String interfaceName;

        public InterfaceOverloadMethodsException(String interfaceName) {
            this.interfaceName = interfaceName;
        }
    }
}

