/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.java;

import coldfusion.runtime.AppClassLoaderHelper;
import coldfusion.runtime.java.DynamicClassLoader;
import coldfusion.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JavaDynamicClassLoader
extends DynamicClassLoader {
    private boolean useDoPrivileged = true;
    private AppClassLoaderHelper appClassLoaderHelper;

    public JavaDynamicClassLoader(ClassLoader parent, boolean delegateToParent, boolean useDoPrivileged, AppClassLoaderHelper appClassLoaderHelper) {
        super(parent, delegateToParent);
        this.useDoPrivileged = useDoPrivileged;
        this.appClassLoaderHelper = appClassLoaderHelper;
    }

    @Override
    protected Class findClass(final String name) throws ClassNotFoundException {
        try {
            if (this.useDoPrivileged) {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return JavaDynamicClassLoader.this.findClass0(name);
                    }
                });
            }
            return this.findClass0(name);
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
    }

    private Class findClass0(String name) throws ClassNotFoundException {
        String packagename;
        Package pkg;
        String path = name.replace('.', '/').concat(".class");
        int i = name.lastIndexOf(".");
        if (i != -1 && (pkg = this.getPackage(packagename = name.substring(0, i))) == null) {
            this.definePackage(packagename, null, null, null, null, null, null, null);
        }
        try {
            byte[] bytes;
            InputStream in = this.getInputStream(path);
            if (in != null && (bytes = IOUtils.toByteArray(in)) != null) {
                return this.defineClass(name, bytes, 0, bytes.length);
            }
            throw new ClassNotFoundException(name);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    private InputStream getInputStream(String name) throws IOException {
        for (int i = 0; i < this.classpath.size(); ++i) {
            JarEntry jarEntry;
            final File file = (File)this.classpath.get(i);
            boolean isDir = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return file.isDirectory();
                }
            });
            if (isDir) {
                final File clazzFile = new File(file, name);
                boolean exists = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return clazzFile.exists();
                    }
                });
                if (!exists) continue;
                return new FileInputStream(clazzFile);
            }
            String filename = file.getName().toLowerCase();
            if (!filename.endsWith(".jar") && !filename.endsWith(".zip")) continue;
            JarFile jarFile = (JarFile)this.jarMap.get(file);
            if (jarFile == null) {
                try {
                    jarFile = new JarFile(file, false);
                }
                catch (IOException e) {
                    continue;
                }
                this.jarMap.put(file, jarFile);
            }
            if ((jarEntry = jarFile.getJarEntry(name)) == null) continue;
            if (this.appClassLoaderHelper != null) {
                this.appClassLoaderHelper.checkPermission(file);
            }
            return jarFile.getInputStream(jarEntry);
        }
        return null;
    }

    @Override
    public void release() {
        super.release();
        this.useDoPrivileged = true;
        this.appClassLoaderHelper = null;
    }
}

