/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.java;

import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.runtime.DotNetAssemblyNotRegisteredException;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.Invokable;
import coldfusion.runtime.JavaProxyWrapper;
import coldfusion.runtime.ObjectException;
import coldfusion.runtime.dotnet.DotNetDynamicClassLoader;
import coldfusion.runtime.java.ClassUtility;
import coldfusion.runtime.java.ExceptionCache;
import coldfusion.runtime.java.Introspectable;
import coldfusion.runtime.java.JavaObjectInstantiationException;
import coldfusion.runtime.java.MethodExecutionException;
import coldfusion.runtime.java.ObjectHandler;
import coldfusion.runtime.java.ParameterConversionException;
import coldfusion.runtime.java.ReflectionCache;
import jakarta.servlet.jsp.PageContext;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;

public class JavaProxy
implements Invokable,
Serializable {
    protected Class mClazz;
    protected Object mObject;
    protected Introspectable mReflector;
    private Object[] mOutArgs = new Object[0];
    private MemoryTrackerProxy memoryTrackerProxy;
    private String name;

    public JavaProxy(Class clazz) {
        this.mClazz = clazz;
        this.mReflector = ReflectionCache.get(this.mClazz);
    }

    public JavaProxy(Object o) {
        this.mClazz = o.getClass();
        this.mObject = o;
        this.mReflector = ReflectionCache.get(this.mClazz);
    }

    public JavaProxy(JavaProxyWrapper jProxyWrapper) {
        this(jProxyWrapper.getMClazz());
        this.mObject = jProxyWrapper.getMObject();
    }

    protected JavaProxy() {
    }

    public Object getObject() {
        return this.mObject;
    }

    public Class getClazz() {
        return this.mClazz;
    }

    public void setInstance(Object o) {
        this.mObject = o;
    }

    @Override
    public Object invoke(String methodName, Object[] args, PageContext pageContext) throws Throwable {
        RequestMonitorEventProcessor.onFunctionStart(methodName, null, true);
        Object[] UnwrappedArgs = ClassUtility.UnWrap(this.mClazz, args);
        Object result = null;
        this.mOutArgs = null;
        if (methodName.equalsIgnoreCase("init")) {
            this.mObject = this.CreateObject(UnwrappedArgs);
            return this.mObject;
        }
        if (methodName.equals("getClass") && args.length == 0) {
            return this.mClazz;
        }
        ObjectHandler o = (ObjectHandler)this.mReflector;
        Method m = o.findMethod(methodName, UnwrappedArgs);
        if (m != null) {
            if (this.mObject == null && !Modifier.isStatic(m.getModifiers())) {
                this.createObjectWithDefaultConstructor();
            }
            try {
                result = m.invoke(this.mObject, UnwrappedArgs);
                this.mOutArgs = UnwrappedArgs;
            }
            catch (InvocationTargetException ie) {
                ExceptionCache.push(this.mObject, ie.getTargetException());
                throw ie.getTargetException();
            }
            catch (Exception e) {
                ExceptionCache.push(this.mObject, e);
                throw new MethodExecutionException(methodName, e);
            }
        }
        Class clazz = o.getmClazz();
        if (clazz.getClassLoader() instanceof DotNetDynamicClassLoader) {
            m = o.findMethodUsingCFMLRules(methodName, UnwrappedArgs);
        } else if (o.getmClazz().isInterface()) {
            for (Method method : o.getmClazz().getDeclaredMethods()) {
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                List<Parameter> paramList = Arrays.asList(method.getParameters());
                Type[] genericParameterTypes = method.getGenericParameterTypes();
                int count = 0;
                boolean foundMethod = true;
                for (Parameter parameter : paramList) {
                    if (!parameter.getParameterizedType().equals(genericParameterTypes[count])) {
                        foundMethod = false;
                        break;
                    }
                    ++count;
                }
                if (!foundMethod) continue;
                m = method;
                break;
            }
        } else {
            m = o.findMethodUsingCFMLRules(methodName, UnwrappedArgs);
        }
        if (this.mObject == null && !Modifier.isStatic(m.getModifiers())) {
            this.createObjectWithDefaultConstructor();
        }
        try {
            Object[] cfargs = ClassUtility.ReInterpret(UnwrappedArgs, m.getParameterTypes());
            try {
                m.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            result = m.invoke(this.mObject, cfargs);
            this.mOutArgs = cfargs;
        }
        catch (InvocationTargetException ie) {
            ExceptionCache.push(this.mObject, ie.getTargetException());
            throw ie.getTargetException();
        }
        catch (Exception e) {
            ExceptionCache.push(this.mObject, e);
            throw new MethodExecutionException(methodName, e);
        }
        if (this.memoryTrackerProxy != null) {
            this.memoryTrackerProxy.onReplace(this.getName(), this.mObject, null);
        }
        result = ClassUtility.wrapCustom(result);
        RequestMonitorEventProcessor.onFunctionEnd(methodName, null, TagAttributeList.getInstance("method", methodName).addTagAttribute("isExternal", true).getTagAttributes(), true);
        return result;
    }

    public Object[] getOutArgs() {
        return this.mOutArgs;
    }

    private Object CreateObject(Object[] args) throws Exception {
        Constructor c = this.mReflector.findConstructor(args);
        if (c != null) {
            try {
                this.mObject = c.newInstance(args);
            }
            catch (InvocationTargetException e) {
                throw (Exception)e.getTargetException();
            }
            catch (Exception e) {
                if (e.getClass().getName().equals("com.jnbridge.jnbcore.DotNetClassNotFoundException")) {
                    throw new DotNetAssemblyNotRegisteredException(e);
                }
                throw new JavaObjectInstantiationException(e);
            }
        }
        c = this.mReflector.findConstructorUsingCFMLRules(args);
        if (c == null) {
            throw new NoSuchConstructorException(this.mClazz, args);
        }
        try {
            Object[] cfargs = ClassUtility.ReInterpret(args, c.getParameterTypes());
            this.mObject = c.newInstance(cfargs);
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getTargetException();
        }
        catch (ExpressionException ee) {
            throw new ParameterConversionException("init", ee);
        }
        catch (Exception e) {
            if (e.getClass().getName().equals("com.jnbridge.jnbcore.DotNetClassNotFoundException")) {
                throw new DotNetAssemblyNotRegisteredException(e);
            }
            throw new JavaObjectInstantiationException(e);
        }
        return this.mObject;
    }

    private Object createObjectWithDefaultConstructor() {
        try {
            this.mObject = this.mClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            if (e.getClass().getName().equals("com.jnbridge.jnbcore.DotNetClassNotFoundException")) {
                throw new DotNetAssemblyNotRegisteredException(e);
            }
            throw new JavaObjectInstantiationException(true, (Throwable)e);
        }
        return this.mObject;
    }

    public String toString() {
        if (this.mObject == null) {
            return "Undefined";
        }
        return this.mObject.toString();
    }

    public MemoryTrackerProxy getMemoryTrackerProxy() {
        return this.memoryTrackerProxy;
    }

    public void setMemoryTrackerProxy(MemoryTrackerProxy memoryTrackerProxy) {
        this.memoryTrackerProxy = memoryTrackerProxy;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object writeReplace() throws NotSerializableException {
        JavaProxyWrapper jProxyWrapper = new JavaProxyWrapper();
        jProxyWrapper.setMClazz(this.mClazz);
        jProxyWrapper.setMObject(this.mObject);
        return jProxyWrapper;
    }

    public static class NoSuchConstructorException
    extends ObjectException {
        public String argTypes;
        private Class clazz;

        public String getClassName() {
            return this.clazz.getName();
        }

        NoSuchConstructorException(Class clazz, Object[] args) {
            this.clazz = clazz;
            if (args.length > 0) {
                StringBuffer bArgTypes = new StringBuffer();
                for (int i = 0; i < args.length; ++i) {
                    if (i > 0) {
                        bArgTypes.append(", ");
                    }
                    bArgTypes.append(args[i].getClass().getName());
                }
                this.argTypes = bArgTypes.toString();
            } else {
                this.argTypes = "";
            }
        }
    }
}

