/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.java;

import coldfusion.runtime.java.Introspectable;
import coldfusion.runtime.java.ObjectHandler;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ExecutionError;
import java.util.concurrent.ExecutionException;

public final class ReflectionCache {
    private static final boolean cacheEnabled = System.getProperty("coldfusion.cachejavaproxy", "true").equalsIgnoreCase("true");
    private static final LoadingCache<Class<?>, ObjectHandler> classCache = CacheBuilder.newBuilder().softValues().weakKeys().build(new CacheLoader<Class<?>, ObjectHandler>(){

        public ObjectHandler load(Class<?> type) {
            return new ObjectHandler(type);
        }
    });

    private ReflectionCache() {
    }

    public static Introspectable get(Class type) {
        if (cacheEnabled) {
            try {
                return (Introspectable)classCache.get((Object)type);
            }
            catch (ExecutionException executionException) {
            }
            catch (ExecutionError executionError) {
                // empty catch block
            }
        }
        return new ObjectHandler(type);
    }
}

