/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.locale;

import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.IllegalNumberFormatArgumentException;
import coldfusion.runtime.locale.CFLocaleNumberFormatException;
import java.math.BigInteger;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Hashtable;
import java.util.Locale;

public class CFNumberFormat {
    private static Hashtable symbolMap = new Hashtable();
    static final char start_paren = '(';
    static final char end_paren = ')';
    static final char thousands_sep = ',';
    static final char decimal_point = '.';
    static final char dollar_sign = '$';
    static final char digit_nine = '9';
    static final char digit_underscore = '_';
    static final char digit_zero = '0';
    static final char space_pad = ' ';
    static final char center = 'C';
    static final char left = 'L';
    static final char neg_sign = '-';
    static final char pos_sign = '+';
    static final char underscore = '_';
    static final String START_PAREN = "(";
    static final String END_PAREN = ")";
    static final String ZERO_STRING = "0";
    static final Boolean oldRoundingMethod = Boolean.valueOf(System.getProperty("coldfusion.roundoff.oldstyle", "true"));

    public static String LsNumberFormat(double number, String mask, Locale thisLocale) throws CFLocaleNumberFormatException {
        String numberString;
        Object strRightFormatAndSign;
        int i;
        BigInteger TempInt;
        int numberDecimalPos;
        int exponentPos;
        boolean bNegativeNumber = false;
        boolean bUseParens = false;
        boolean bUsePlus = false;
        boolean bUsePlusSpace = false;
        boolean bSigned = false;
        boolean bDollarSign = false;
        boolean bDecimal = false;
        boolean bThousandsSep = false;
        int maskLen = mask.length();
        DecimalFormatSymbols sym = (DecimalFormatSymbols)symbolMap.get(thisLocale);
        if (sym == null) {
            sym = new DecimalFormatSymbols(thisLocale);
            symbolMap.put(thisLocale, sym);
        }
        char decimalPoint = sym.getDecimalSeparator();
        char groupSeparator = sym.getGroupingSeparator();
        if (maskLen < 1) {
            throw new IllegalNumberFormatArgumentException("zero length string", number);
        }
        String strValidMask = "_9.0()+-,LCR$^";
        for (int i2 = 0; i2 < mask.length(); ++i2) {
            if (strValidMask.indexOf(mask.charAt(i2)) >= 0) continue;
            throw new IllegalNumberFormatArgumentException(mask, number);
        }
        Object String_number = Double.toString(number);
        if (number < 0.0) {
            String_number = ((String)String_number).substring(1);
            bNegativeNumber = true;
        }
        if (!oldRoundingMethod.booleanValue()) {
            int digitCountRight = 0;
            boolean decimalPointSeen = false;
            for (int i3 = 0; i3 < maskLen; ++i3) {
                char c;
                if (mask.charAt(i3) == '.') {
                    decimalPointSeen = true;
                    continue;
                }
                if (!decimalPointSeen || (c = mask.charAt(i3)) != '9' && c != '_' && c != '0') continue;
                ++digitCountRight;
            }
            double dPow10 = Math.pow(10.0, digitCountRight);
            double numAfterRoundOff = (!bNegativeNumber ? Math.floor(dPow10 * Math.abs(number) + 0.5) : Math.ceil(dPow10 * Math.abs(number) - 0.51)) / dPow10;
            String_number = Double.toString(numAfterRoundOff);
        }
        if ((exponentPos = ((String)String_number).indexOf(69)) > -1) {
            int exp = Integer.parseInt(((String)String_number).substring(exponentPos + 1));
            int EPos = ((String)String_number).lastIndexOf(69);
            int decPos = ((String)String_number).lastIndexOf(46);
            boolean bPosExp = true;
            if (((String)String_number).lastIndexOf(45) > -1) {
                bPosExp = false;
            }
            StringBuffer intZeros = new StringBuffer();
            int decPartLen = ((String)String_number).substring(decPos + 1, EPos).length();
            if (decPartLen < exp) {
                for (int i4 = 0; i4 < exp - decPartLen; ++i4) {
                    intZeros.append(ZERO_STRING);
                }
            }
            String remDigits = "";
            if (decPos + 1 + exp < EPos && bPosExp) {
                remDigits = ((String)String_number).substring(decPos + 1 + exp, EPos);
            }
            String_number = bPosExp && EPos > decPos + Math.abs(exp) ? ((String)String_number).substring(0, 1) + ((String)String_number).substring(decPos + 1, decPos + 1 + Math.abs(exp)) : ((String)String_number).substring(0, 1) + ((String)String_number).substring(decPos + 1, EPos);
            StringBuilder zeros = new StringBuilder();
            for (int i5 = 1; i5 < Math.abs(exp); ++i5) {
                zeros.append('0');
            }
            String_number = !bPosExp ? "0." + zeros + (String)String_number : (remDigits.length() == 0 ? (String)String_number + intZeros + "." + zeros : (String)String_number + "." + remDigits);
        }
        Object String_integerNum = (numberDecimalPos = ((String)String_number).indexOf(46)) > -1 ? ((String)String_number).substring(0, numberDecimalPos) : String_number;
        int int_numberLen = ((String)String_integerNum).length();
        String sign = "";
        int digitCountLeft = 0;
        int digitCountRight = 0;
        int zeropadright = 0;
        int plusSignPos = mask.indexOf(43);
        int nineDigitPos = mask.indexOf(57);
        int negSignPos = mask.indexOf(45);
        int underscorePos = mask.indexOf(95);
        int startparenPos = mask.indexOf(40);
        int dollarSignPos = mask.indexOf(36);
        int endparenPos = mask.indexOf(41);
        boolean bSpacePadLeft = true;
        int decimalpos = mask.indexOf(46);
        int zeroPos = mask.indexOf(48);
        if (zeroPos >= 0 && (zeroPos < decimalpos || decimalpos == -1)) {
            bSpacePadLeft = false;
        }
        if (mask.indexOf(44) >= 0) {
            bThousandsSep = true;
        }
        if (dollarSignPos >= 0) {
            bDollarSign = true;
        }
        if (plusSignPos >= 0) {
            bUsePlus = true;
        }
        if (negSignPos >= 0) {
            bUsePlusSpace = true;
        }
        if (startparenPos >= 0 || endparenPos >= 0) {
            bUseParens = true;
        }
        for (int i6 = 0; i6 < maskLen; ++i6) {
            char c;
            if (mask.charAt(i6) == '.') {
                bDecimal = true;
                continue;
            }
            if (!bDecimal) {
                c = mask.charAt(i6);
                if (c != '9' && c != '_' && c != '0') continue;
                ++digitCountLeft;
                continue;
            }
            c = mask.charAt(i6);
            if (c != '9' && c != '_' && c != '0') continue;
            ++zeropadright;
            ++digitCountRight;
        }
        Object decimalPart = bDecimal && numberDecimalPos != -1 ? ((String)String_number).substring(numberDecimalPos + 1) : (!bDecimal ? ((String)String_number).substring(numberDecimalPos + 1) : "");
        StringBuffer zeropadleftSB = new StringBuffer("");
        int spacePadCount = 0;
        if (int_numberLen < digitCountLeft) {
            for (int i7 = 1; i7 <= digitCountLeft - int_numberLen; ++i7) {
                if (bSpacePadLeft) {
                    ++spacePadCount;
                    continue;
                }
                zeropadleftSB = zeropadleftSB.append('0');
            }
        }
        StringBuffer zeropadrightSB = new StringBuffer("");
        if (((String)decimalPart).length() < digitCountRight) {
            for (int i8 = 1; i8 <= digitCountRight - ((String)decimalPart).length(); ++i8) {
                zeropadrightSB.append('0');
            }
        }
        boolean bIncrementInteger = false;
        if (((String)decimalPart).length() > digitCountRight && digitCountRight > 0) {
            Integer truncatedDigit = Integer.valueOf(((String)decimalPart).substring(digitCountRight, digitCountRight + 1));
            decimalPart = ((String)decimalPart).substring(0, digitCountRight);
            if (truncatedDigit >= 5) {
                boolean bSigDigitAdded = false;
                if (((String)decimalPart).startsWith(ZERO_STRING)) {
                    decimalPart = "1" + (String)decimalPart;
                    bSigDigitAdded = true;
                }
                long l = Long.parseLong((String)decimalPart);
                int tmplen = ((String)decimalPart).length();
                decimalPart = Long.toString(++l);
                if (bSigDigitAdded) {
                    decimalPart = ((String)decimalPart).substring(1);
                }
                if (tmplen < ((String)decimalPart).length()) {
                    bIncrementInteger = true;
                    decimalPart = ((String)decimalPart).substring(2) + ZERO_STRING;
                }
            }
            if (((String)decimalPart).length() >= digitCountRight) {
                decimalPart = ((String)decimalPart).substring(0, digitCountRight);
            }
        }
        if (((String)decimalPart).length() > 0 && Integer.decode(((String)decimalPart).substring(0, 1)) >= 5 && digitCountRight == 0) {
            TempInt = new BigInteger((String)String_integerNum);
            BigInteger bigOne = BigInteger.ONE;
            TempInt = TempInt.add(bigOne);
            String_integerNum = TempInt.toString();
        }
        if (bIncrementInteger) {
            TempInt = new BigInteger((String)String_integerNum);
            BigInteger bigOne = BigInteger.ONE;
            TempInt = TempInt.add(bigOne);
            String_integerNum = TempInt.toString();
        }
        if (digitCountRight - zeropadright > 0) {
            decimalPart = ((String)decimalPart).substring(0, digitCountRight - zeropadright);
        } else if (digitCountRight != zeropadright | digitCountRight == 0 & zeropadright == 0) {
            decimalPart = "";
        }
        StringBuffer SB_numberString = new StringBuffer((String)String_integerNum);
        if (((String)String_integerNum).indexOf(45) == 0) {
            SB_numberString = SB_numberString.replace(0, 1, "");
        }
        if (!bNegativeNumber) {
            if (bUsePlusSpace) {
                bSigned = true;
                sign = " ";
            } else if (bUsePlus) {
                bSigned = true;
                sign = "+";
            }
        } else if (bUsePlus) {
            bSigned = true;
            sign = "-";
        } else if (bUsePlusSpace) {
            bSigned = true;
            sign = "-";
        }
        if (bNegativeNumber && !bUseParens && !bUsePlus && !bUsePlusSpace) {
            bSigned = true;
            sign = "-";
        }
        boolean bRightAlignSign = false;
        boolean bRightAlignDollar = false;
        Object strLeftFormatAndSign = "";
        int intLeftSpaceCount = 0;
        int intRightSpaceCount = 0;
        if (spacePadCount > 0) {
            if (mask.indexOf(67) >= 0) {
                if (spacePadCount % 2 == 1) {
                    intRightSpaceCount = intLeftSpaceCount = (spacePadCount + 1) / 2;
                } else {
                    intLeftSpaceCount = spacePadCount / 2;
                    intRightSpaceCount = spacePadCount / 2;
                }
            } else if (mask.indexOf(76) >= 0) {
                intLeftSpaceCount = spacePadCount;
            } else {
                intRightSpaceCount = spacePadCount;
            }
        }
        StringBuffer spacepadleftSB = new StringBuffer();
        StringBuffer spacepadrightSB = new StringBuffer();
        for (i = 1; i <= intRightSpaceCount; ++i) {
            spacepadleftSB.append(' ');
        }
        for (i = 1; i <= intLeftSpaceCount; ++i) {
            spacepadrightSB.append(' ');
        }
        String strSpacingLeft = spacepadleftSB.toString();
        String strSpacingRight = spacepadrightSB.toString();
        if (underscorePos < dollarSignPos && startparenPos == -1) {
            bRightAlignDollar = true;
            if (!(underscorePos != -1 || plusSignPos <= -1 && negSignPos <= -1 || plusSignPos - dollarSignPos != 1 && dollarSignPos - plusSignPos != 1 && negSignPos - dollarSignPos != 1 && dollarSignPos - negSignPos != 1)) {
                bRightAlignDollar = false;
            }
            if (dollarSignPos < nineDigitPos && nineDigitPos < decimalpos) {
                bRightAlignDollar = false;
            }
        } else if (underscorePos >= 0 && underscorePos < dollarSignPos && startparenPos >= 0) {
            bRightAlignDollar = true;
        }
        if (bSigned || bUseParens) {
            if (underscorePos != -1 && (underscorePos < plusSignPos || underscorePos < negSignPos || underscorePos < startparenPos)) {
                bRightAlignSign = true;
            }
            if (!bRightAlignSign) {
                if (nineDigitPos != -1 && (nineDigitPos < plusSignPos || nineDigitPos < negSignPos || nineDigitPos < startparenPos)) {
                    bRightAlignSign = true;
                }
                if (nineDigitPos != -1 && plusSignPos == -1 && startparenPos == -1 && endparenPos == -1 && dollarSignPos == -1) {
                    bRightAlignSign = true;
                }
            }
            strRightFormatAndSign = endparenPos < (underscorePos = mask.lastIndexOf(95)) && endparenPos != -1 ? END_PAREN + strSpacingRight : (endparenPos > underscorePos & bNegativeNumber & sign.length() == 0 ? strSpacingRight + END_PAREN : strSpacingRight);
        } else {
            strRightFormatAndSign = strSpacingRight;
        }
        if (!bSigned && bUseParens && bNegativeNumber) {
            strLeftFormatAndSign = START_PAREN;
            if (endparenPos < 0) {
                strRightFormatAndSign = END_PAREN + strSpacingRight;
            }
        } else if (bSigned) {
            strLeftFormatAndSign = sign;
        }
        if (bDollarSign) {
            String dollarSign = sym.getCurrencySymbol();
            strLeftFormatAndSign = bRightAlignDollar & bRightAlignSign ? strSpacingLeft + dollarSign + (String)strLeftFormatAndSign : (bRightAlignDollar & !bRightAlignSign ? (String)strLeftFormatAndSign + strSpacingLeft + dollarSign : (!bRightAlignDollar & bRightAlignSign ? dollarSign + strSpacingLeft + (String)strLeftFormatAndSign : dollarSign + (String)strLeftFormatAndSign + strSpacingLeft));
        } else {
            strLeftFormatAndSign = bRightAlignSign ? strSpacingLeft + (String)strLeftFormatAndSign : (!bRightAlignSign ? (String)strLeftFormatAndSign + strSpacingLeft : (String)strLeftFormatAndSign + strSpacingLeft);
        }
        if (bThousandsSep) {
            SB_numberString = SB_numberString.insert(0, zeropadleftSB.toString());
            zeropadleftSB.delete(0, zeropadleftSB.length());
            SB_numberString = SB_numberString.reverse();
            StringBuffer SB_newnumberString = new StringBuffer("");
            int bufferLen = SB_numberString.length();
            if (bufferLen >= 4) {
                for (int i9 = 0; i9 < bufferLen; ++i9) {
                    if (i9 % 3 == 0 & i9 != 0 & i9 != bufferLen) {
                        SB_newnumberString.append(groupSeparator);
                    }
                    SB_newnumberString.append(SB_numberString.charAt(i9));
                }
            } else {
                SB_newnumberString = SB_numberString;
            }
            SB_newnumberString = SB_newnumberString.reverse();
            numberString = SB_newnumberString.toString();
        } else {
            numberString = SB_numberString.toString();
        }
        String finalNumberString = (String)strLeftFormatAndSign + zeropadleftSB + numberString + (String)(bDecimal ? decimalPoint + (String)decimalPart : "") + zeropadrightSB + (String)strRightFormatAndSign;
        return finalNumberString;
    }

    public static double LsParseNumber(String NumAsString, Locale loc) throws CFLocaleNumberFormatException {
        NumberFormat format = NumberFormat.getInstance(loc);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < NumAsString.length(); ++i) {
            char c = NumAsString.charAt(i);
            if (c == ' ' || c == '+') continue;
            sb.append(c);
        }
        ParsePosition ps = new ParsePosition(0);
        int numLen = sb.toString().length();
        Number num = format.parse(sb.toString(), ps);
        if (numLen > ps.getIndex()) {
            throw new UnparseableCFLocaleNumberException(sb.toString());
        }
        return num.doubleValue();
    }

    public static class UnparseableCFLocaleNumberException
    extends ExpressionException {
        String num;

        UnparseableCFLocaleNumberException(String stNum) {
            this.num = stNum;
        }

        public String getNum() {
            return this.num;
        }
    }
}

