/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.protobuf;

import coldfusion.runtime.protobuf.CFProtoMessage;
import coldfusion.util.RB;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ProtocolStringList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class CFProtocolBuffer {
    private Set<String> protoNames;
    private Map<String, Descriptors.FileDescriptor> descriptorMap = new HashMap<String, Descriptors.FileDescriptor>();
    private String protoFileName;
    long generatedTime;

    CFProtocolBuffer(String fDescriptorPath, String protoFileName) throws IOException, Descriptors.DescriptorValidationException {
        this.protoFileName = protoFileName;
        this.resolveDescriptors(fDescriptorPath);
        this.generatedTime = new File(fDescriptorPath).lastModified();
    }

    private void resolveDescriptors(String fDescriptorPath) throws IOException, Descriptors.DescriptorValidationException {
        FileInputStream input = new FileInputStream(fDescriptorPath);
        DescriptorProtos.FileDescriptorSet fileDescriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)input);
        this.protoNames = fileDescriptorSet.getFileList().stream().map(l -> l.getName()).collect(Collectors.toSet());
        while (this.descriptorMap.size() < fileDescriptorSet.getFileCount()) {
            for (DescriptorProtos.FileDescriptorProto fdProto : fileDescriptorSet.getFileList()) {
                if (this.descriptorMap.containsKey(fdProto.getName())) continue;
                ProtocolStringList dependencyList = fdProto.getDependencyList();
                ArrayList<Descriptors.FileDescriptor> resolvedFdList = new ArrayList<Descriptors.FileDescriptor>();
                for (String depName : dependencyList) {
                    if (!this.protoNames.contains(depName)) {
                        throw new IllegalArgumentException(RB.getString((Object)this, "PROTOBUF.IMPORT_RESOLVE_ERROR", new Object[]{depName, fdProto.getName()}));
                    }
                    Descriptors.FileDescriptor fd = this.descriptorMap.get(depName);
                    if (fd == null) continue;
                    resolvedFdList.add(fd);
                }
                if (resolvedFdList.size() != dependencyList.size()) continue;
                Descriptors.FileDescriptor[] fds = new Descriptors.FileDescriptor[resolvedFdList.size()];
                Descriptors.FileDescriptor fd = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fdProto, (Descriptors.FileDescriptor[])resolvedFdList.toArray(fds));
                this.descriptorMap.put(fdProto.getName(), fd);
            }
        }
    }

    public CFProtoMessage lookup(String messageType) {
        Descriptors.Descriptor des;
        if (messageType == null) {
            List descriptors = this.descriptorMap.get(this.protoFileName).getMessageTypes();
            if (descriptors.size() > 1) {
                throw new IllegalArgumentException(RB.getString(this, "PROTOBUF.TOO_MANY_MESSAGE"));
            }
            if (descriptors.size() == 0) {
                throw new IllegalArgumentException(RB.getString(this, "PROTOBUF.NO_MESSAGE_FOUND"));
            }
            des = (Descriptors.Descriptor)descriptors.get(0);
        } else {
            if (messageType.isEmpty()) {
                throw new IllegalArgumentException(RB.getString(this, "PROTOBUF.EMPTY_MESSAGE"));
            }
            des = this.descriptorMap.get(this.protoFileName).findMessageTypeByName(messageType);
        }
        return new CFProtoMessage(des);
    }

    public Set<String> getProtoNames() {
        return this.protoNames;
    }
}

