/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.protobuf;

import coldfusion.server.SystemInfo;
import java.util.HashMap;
import java.util.Map;

public class PlatformDetector {
    public static final String osArch = System.getProperty("os.arch").toLowerCase();
    public static final String osName = System.getProperty("os.name").toLowerCase();
    public static final String UNIVERSAL_BINARY = "universal_binary";

    public static OS getOS() {
        return SystemInfo.isLinux() ? OS.LINUX : (SystemInfo.isMac() ? OS.MAC : (SystemInfo.isWindows() ? OS.WINDOWS : (SystemInfo.isSolaris() ? OS.SOLARIS : OS.OTHERS)));
    }

    public static OS_ARCH getOsArchitecture() {
        if (osArch.matches("^(x8664|amd64|ia32e|em64t|x64)$")) {
            return OS_ARCH.x86_64;
        }
        if (osArch.matches("^(x8632|x86|i[3-6]86|ia32|x32)$")) {
            return OS_ARCH.x86_32;
        }
        if ("ppc64le".equals(osArch)) {
            return OS_ARCH.ppcle_64;
        }
        return OS_ARCH.lookupArch(osArch);
    }

    public static enum OS {
        WINDOWS("windows"),
        LINUX("linux"),
        MAC("osx"),
        SOLARIS("solaris"),
        OTHERS("others");

        String val;

        private OS(String type) {
            this.val = type;
        }

        public String getValue() {
            return this.val;
        }
    }

    public static enum OS_ARCH {
        x86_64("x86_64"),
        x86_32("x86_32"),
        ppcle_64("ppcle_64"),
        aarch_64("aarch_64"),
        s390_64("s390_64"),
        UNKNOWN("unknown");

        String val;
        private static Map<String, OS_ARCH> lookup;

        private OS_ARCH(String type) {
            this.val = type;
        }

        public String getValue() {
            return this.val;
        }

        public static OS_ARCH lookupArch(String val) {
            OS_ARCH arch = lookup.get(val);
            return arch == null ? UNKNOWN : arch;
        }

        static {
            lookup = new HashMap<String, OS_ARCH>(5);
            for (OS_ARCH d : OS_ARCH.values()) {
                lookup.put(d.getValue(), d);
            }
        }
    }
}

