/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.protobuf;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.protobuf.CFProtoBufCore;
import coldfusion.runtime.protobuf.CFProtoMessage;
import coldfusion.runtime.protobuf.CFProtocolBuffer;
import coldfusion.runtime.provider.SerializerProxyWrapper;
import coldfusion.sql.imq.imqTable;
import coldfusion.util.RB;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProtocolBufferUtils {
    private static final String PROTOBUF = "PROTOBUF";
    public static final String SCHEMA_KEY = "SCHEMA";
    public static final String MESSAGE_TYPE = "MESSAGE_TYPE";
    private static final Logger logger = CFLogs.SERVER_LOG;
    public static final String PROTO_PATH = "PROTO_PATH";

    public static Object serialize(Object data, String schema, String messageType, String queryFormat, boolean useCustomSerialization) {
        if (schema == null) {
            throw new ProtocolBufferSerializationException(RB.getString(ProtocolBufferUtils.class, "PROTOBUF.NULL_SCHEMA"));
        }
        if (data instanceof List) {
            return ((List)data).stream().map(d -> ProtocolBufferUtils.serializeObject(d, schema, messageType, queryFormat, useCustomSerialization, "")).collect(Collectors.toList());
        }
        return ProtocolBufferUtils.serializeObject(data, schema, messageType, queryFormat, useCustomSerialization, "");
    }

    public static Object serialize(Object data, String schema, String messageType, String queryFormat, boolean useCustomSerialization, String protoPath) {
        if (schema == null) {
            throw new ProtocolBufferSerializationException(RB.getString(ProtocolBufferUtils.class, "PROTOBUF.NULL_SCHEMA"));
        }
        if (data instanceof List) {
            return ((List)data).stream().map(d -> ProtocolBufferUtils.serializeObject(d, schema, messageType, queryFormat, useCustomSerialization, protoPath)).collect(Collectors.toList());
        }
        return ProtocolBufferUtils.serializeObject(data, schema, messageType, queryFormat, useCustomSerialization, protoPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object serializeObject(Object data, String schema, String messageType, String queryFormat, boolean useCustomSerialization, String protoPath) {
        SerializerProxyWrapper serializerProxy;
        if (useCustomSerialization && null != (serializerProxy = JSONUtils.getSerializerProxy())) {
            FusionContext context = FusionContext.getCurrent();
            Object oldData = context.getCurrentSerializedData();
            try {
                if ((oldData == null || !oldData.equals(data)) && serializerProxy.canSerialize(PROTOBUF)) {
                    context.setCurrentSerializedData(data);
                    HashMap<String, String> additionalArgs = new HashMap<String, String>(1);
                    additionalArgs.put(SCHEMA_KEY, schema);
                    additionalArgs.put(MESSAGE_TYPE, messageType);
                    if (protoPath != null && !protoPath.isEmpty()) {
                        additionalArgs.put(PROTO_PATH, protoPath);
                    }
                    Object object = serializerProxy.serialize(data, PROTOBUF, additionalArgs);
                    return object;
                }
            }
            catch (Throwable e) {
                logger.error(e);
            }
            finally {
                context.setCurrentSerializedData(oldData);
            }
        }
        try {
            String json;
            CFProtocolBuffer protocolBuffer = CFProtoBufCore.getCfProtocolBuffer(new CFProtoBufCore.CFProtoSchema(schema, protoPath));
            boolean fixCase = !(data instanceof String);
            String string = json = fixCase ? JSONUtils.serializeJSON(data, queryFormat, false, false) : (String)data;
            if (queryFormat == "struct" && data instanceof imqTable) {
                JSONArray array = new JSONArray(json);
                ArrayList<Object> l = new ArrayList<Object>();
                for (int i = 0; i < array.length(); ++i) {
                    l.add(ProtocolBufferUtils.fixCaseAndConvertToByteArray(array.get(i).toString(), protocolBuffer, messageType, fixCase));
                }
                return l;
            }
            return ProtocolBufferUtils.fixCaseAndConvertToByteArray(json, protocolBuffer, messageType, fixCase);
        }
        catch (ProtocolBufferSerializationException ex) {
            throw ex;
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                throw new ProtocolBufferSerializationException(e, e.getCause().getMessage());
            }
            throw new ProtocolBufferSerializationException(e, e.getMessage());
        }
    }

    private static Object fixCaseAndConvertToByteArray(String json, CFProtocolBuffer protocolBuffer, String messageType, boolean fixCase) throws IOException, JSONException {
        CFProtoMessage message = protocolBuffer.lookup(messageType);
        if (fixCase) {
            json = ProtocolBufferUtils.fixKeyCaseJSON(json, message);
        }
        return ProtocolBufferUtils.convertToByteArray(json, message);
    }

    private static String fixKeyCaseJSON(String json, CFProtoMessage message) throws JSONException {
        Descriptors.Descriptor desc = message.getDescriptor();
        JSONObject jsonObject = new JSONObject(json);
        ProtocolBufferUtils.updateKeys(jsonObject, desc);
        return jsonObject.toString();
    }

    private static void updateKeys(JSONObject jsonObject, Descriptors.Descriptor desc) throws JSONException {
        if (jsonObject == null || desc == null) {
            return;
        }
        Iterator iterator = jsonObject.keys();
        ArrayList keys = new ArrayList();
        iterator.forEachRemaining(keys::add);
        Map<String, String> keyMap = desc.getFields().stream().collect(Collectors.toMap(field -> field.getName().toLowerCase(), field -> field.getName()));
        for (String key : keys) {
            String actualKey = keyMap.get(key.toLowerCase());
            if (actualKey != null && !key.equals(actualKey)) {
                jsonObject.put(actualKey, jsonObject.get(key));
                jsonObject.remove(key);
            }
            if (actualKey == null || !(jsonObject.get(actualKey) instanceof JSONObject)) continue;
            ProtocolBufferUtils.updateKeys((JSONObject)jsonObject.get(actualKey), desc.findFieldByName(actualKey).getMessageType());
        }
    }

    private static Object convertToByteArray(String json, CFProtoMessage message) throws IOException {
        return message.toBinary(json);
    }

    public static Object deserialize(Object data, String schema, String messageType, boolean strictMapping, boolean useCustomSerialization) {
        return ProtocolBufferUtils.deserialize(data, schema, messageType, strictMapping, useCustomSerialization, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(Object data, String schema, String messageType, boolean strictMapping, boolean useCustomSerialization, String protoPath) {
        SerializerProxyWrapper serializerProxy;
        if (schema == null) {
            throw new ProtocolBufferSerializationException(RB.getString(ProtocolBufferUtils.class, "PROTOBUF.NULL_SCHEMA"));
        }
        if (data instanceof List) {
            return ((List)data).stream().map(d -> ProtocolBufferUtils.deserialize(d, schema, messageType, strictMapping, useCustomSerialization, protoPath)).collect(Collectors.toList());
        }
        if (useCustomSerialization && null != (serializerProxy = JSONUtils.getSerializerProxy())) {
            FusionContext context = FusionContext.getCurrent();
            Object oldData = context.getCurrentSerializedData();
            try {
                if ((null == oldData || !oldData.equals(data)) && serializerProxy.canDeSerialize(PROTOBUF)) {
                    context.setCurrentSerializedData(data);
                    HashMap<String, String> additionalArgs = new HashMap<String, String>(1);
                    additionalArgs.put(SCHEMA_KEY, schema);
                    additionalArgs.put(MESSAGE_TYPE, messageType);
                    if (protoPath != null && !protoPath.isEmpty()) {
                        additionalArgs.put(PROTO_PATH, protoPath);
                    }
                    Object object = serializerProxy.deserialize(data, PROTOBUF, "", additionalArgs);
                    return object;
                }
            }
            catch (Throwable e) {
                logger.error(e);
            }
            finally {
                context.setCurrentSerializedData(oldData);
            }
        }
        return ProtocolBufferUtils.deserializeObject(data, schema, messageType, strictMapping, protoPath);
    }

    private static Object deserializeObject(Object data, String schema, String messageType, boolean strictMapping, String protoPath) {
        try {
            if (!(data instanceof byte[])) {
                throw new ProtocolBufferDeserializationException(RB.getString(ProtocolBufferUtils.class, "PROTOBUF.INCORRECT_DATA_TYPE"));
            }
            return JSONUtils.deserializeJSON(ProtocolBufferUtils.deserializeToJSON((byte[])data, schema, messageType, protoPath), strictMapping, false);
        }
        catch (ProtocolBufferSerializationException ex) {
            throw ex;
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                throw new ProtocolBufferDeserializationException(e, e.getCause().getMessage());
            }
            throw new ProtocolBufferDeserializationException(e, e.getMessage());
        }
    }

    private static Object deserializeToJSON(byte[] data, String schema, String messageType, String protoPath) throws IOException {
        return CFProtoBufCore.getCfProtocolBuffer(new CFProtoBufCore.CFProtoSchema(schema, protoPath)).lookup(messageType).fromBinary(data);
    }

    public static class ProtocolBufferSerializationException
    extends ApplicationException {
        public final String message;

        public ProtocolBufferSerializationException(String message) {
            this.message = message;
        }

        public ProtocolBufferSerializationException(Throwable e, String message) {
            super(e);
            this.message = message;
        }
    }

    public static class ProtocolBufferDeserializationException
    extends ApplicationException {
        public final String message;

        public ProtocolBufferDeserializationException(String message) {
            this.message = message;
        }

        public ProtocolBufferDeserializationException(Throwable e, String message) {
            super(e);
            this.message = message;
        }
    }
}

