/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.session;

import coldfusion.monitor.memory.MemoryMonitor;
import coldfusion.monitor.memory.SessionMemoryMonitor;
import coldfusion.runtime.AppEventInvoker;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.NoNameJ2eeSessionScope;
import coldfusion.runtime.SessionKeyObject;
import coldfusion.runtime.SessionScope;
import coldfusion.runtime.SessionTracker;
import coldfusion.runtime.session.SessionEndEventInvoker;
import coldfusion.runtime.session.SessionStorage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InMemorySessionStorage
implements SessionStorage {
    private ConcurrentMap<String, ConcurrentMap<String, Object>> mSessionPool = new ConcurrentHashMap<String, ConcurrentMap<String, Object>>();
    private int expiredSessionCount = 0;
    private static SessionMemoryMonitor mSessionMemoryMonitor;

    @Override
    public SessionScope getSession(String appName, String key) {
        ConcurrentMap keySessions = (ConcurrentMap)this.mSessionPool.get(key);
        if (keySessions != null) {
            return (SessionScope)keySessions.get(appName);
        }
        return null;
    }

    @Override
    public int getActiveSessionCount(String appName) {
        if (appName == null) {
            return this.getSessionCount();
        }
        int count = 0;
        Set keys = this.mSessionPool.keySet();
        if (keys != null && !keys.isEmpty()) {
            Iterator sessionKeys = keys.iterator();
            while (sessionKeys.hasNext()) {
                SessionScope sessionScope;
                ConcurrentMap appSessions = (ConcurrentMap)this.mSessionPool.get(sessionKeys.next());
                if (appSessions == null || appSessions.isEmpty() || (sessionScope = (SessionScope)appSessions.get(appName)) == null || sessionScope.expired()) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public ConcurrentMap<String, Object> getApplicationSessionMap(String key) {
        ConcurrentHashMap<String, Object> toReturnAppSessions = new ConcurrentHashMap<String, Object>();
        if (key == null) {
            return toReturnAppSessions;
        }
        ConcurrentMap applicationSessionMap = (ConcurrentMap)this.mSessionPool.get(key);
        if (applicationSessionMap != null) {
            return applicationSessionMap;
        }
        return toReturnAppSessions;
    }

    @Override
    public ConcurrentMap<String, Object> getAppSessions(String appName) {
        ConcurrentHashMap<String, Object> toReturnAppSessions = new ConcurrentHashMap<String, Object>();
        if (appName == null) {
            return toReturnAppSessions;
        }
        Set keys = this.mSessionPool.keySet();
        if (keys != null && !keys.isEmpty()) {
            Iterator sessionKeys = keys.iterator();
            while (sessionKeys.hasNext()) {
                SessionScope session;
                ConcurrentMap appSessions = (ConcurrentMap)this.mSessionPool.get(sessionKeys.next());
                if (appSessions == null || appSessions.isEmpty() || (session = (SessionScope)appSessions.get(appName)) == null) continue;
                toReturnAppSessions.put(session.getTrackerSessionId(), session);
            }
        }
        return toReturnAppSessions;
    }

    @Override
    public int getSessionCount() {
        int count = 0;
        Set keys = this.mSessionPool.keySet();
        if (keys != null && !keys.isEmpty()) {
            Iterator sessionKeys = keys.iterator();
            while (sessionKeys != null && sessionKeys.hasNext()) {
                Set appKeySet;
                ConcurrentMap appSessions = (ConcurrentMap)this.mSessionPool.get(sessionKeys.next());
                if (appSessions == null || appSessions.isEmpty() || (appKeySet = appSessions.keySet()) == null) continue;
                Iterator appKeys = appKeySet.iterator();
                while (appKeys.hasNext()) {
                    SessionScope sessionScope = (SessionScope)appSessions.get(appKeys.next());
                    if (sessionScope == null || sessionScope.expired()) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    @Override
    public int getExpiredSessionCount() {
        return this.expiredSessionCount;
    }

    @Override
    public Set<SessionKeyObject> getSessionKeyObjects() {
        HashSet<SessionKeyObject> sessionKeyObjects = new HashSet<SessionKeyObject>();
        Set keys = this.mSessionPool.keySet();
        if (keys != null && !keys.isEmpty()) {
            Iterator sessionKeys = keys.iterator();
            while (sessionKeys != null && sessionKeys.hasNext()) {
                Set appKeySet;
                ConcurrentMap appSessions = (ConcurrentMap)this.mSessionPool.get(sessionKeys.next());
                if (appSessions == null || appSessions.isEmpty() || (appKeySet = appSessions.keySet()) == null) continue;
                Iterator appKeys = appKeySet.iterator();
                while (appKeys.hasNext()) {
                    SessionScope session = (SessionScope)appSessions.get(appKeys.next());
                    if (session == null) continue;
                    String appName = session.getAppName();
                    String sessionId = SessionTracker.extractSessionId(appName, session.getSessionId());
                    if (appName == null) {
                        appName = "";
                    }
                    SessionKeyObject sessionKeyObj = new SessionKeyObject(appName, sessionId);
                    sessionKeyObjects.add(sessionKeyObj);
                }
            }
        }
        return sessionKeyObjects;
    }

    @Override
    public Set<String> getSessionKeys() {
        return this.mSessionPool.keySet();
    }

    @Override
    public boolean sessionExists(String m_cfid, String m_cftoken) {
        boolean sessionExists = false;
        String sessionKey = SessionTracker.getSessionKey(m_cfid, m_cftoken);
        if (this.mSessionPool.containsKey(sessionKey)) {
            sessionExists = true;
        }
        return sessionExists;
    }

    @Override
    public void setSession(String appName, String key, SessionScope s) {
        ConcurrentHashMap<String, SessionScope> keySessions = (ConcurrentHashMap<String, SessionScope>)this.mSessionPool.get(key);
        if (keySessions == null) {
            keySessions = new ConcurrentHashMap<String, SessionScope>();
        }
        keySessions.put(appName, s);
        this.mSessionPool.put(key, keySessions);
    }

    @Override
    public void remove(String key, String appName) {
        this.mSessionPool.remove(key);
    }

    @Override
    public void setAppSession(String key, ConcurrentMap<String, Object> sessions) {
        this.mSessionPool.put(key, sessions);
    }

    @Override
    public boolean isMomoryTrackingSupported() {
        return true;
    }

    @Override
    public SessionMemoryMonitor getSessionMemoryMonitor() {
        if (mSessionMemoryMonitor == null) {
            mSessionMemoryMonitor = MemoryMonitor.getInstance().getSessionMemoryMonitor();
        }
        return mSessionMemoryMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SessionEndEventInvoker> cleanUp() {
        ArrayList<SessionEndEventInvoker> endEventInvokerList = new ArrayList<SessionEndEventInvoker>();
        Object[] sessionKeys = this.mSessionPool.keySet().toArray();
        for (int i = 0; i < sessionKeys.length; ++i) {
            String sessionKey = (String)sessionKeys[i];
            ConcurrentMap appSessions = (ConcurrentMap)this.mSessionPool.get(sessionKey);
            if (appSessions == null) continue;
            ConcurrentMap<String, ConcurrentMap<String, Object>> concurrentMap = this.mSessionPool;
            synchronized (concurrentMap) {
                if (appSessions.isEmpty()) {
                    this.mSessionPool.remove(sessionKey);
                    continue;
                }
            }
            Object[] keys = appSessions.keySet().toArray();
            for (int j = 0; j < keys.length; ++j) {
                String key = (String)keys[j];
                try {
                    SessionScope s = (SessionScope)appSessions.get(key);
                    if (s == null || !s.expired()) continue;
                    ++this.expiredSessionCount;
                    String appName = s instanceof NoNameJ2eeSessionScope ? "" : s.getAppName();
                    String sessionId = s.getSessionId();
                    ApplicationScope scope = ApplicationScopeTracker.getApplicationScope(appName);
                    AppEventInvoker invoker = null;
                    if (scope != null && scope instanceof ApplicationScope) {
                        invoker = scope.getEventInvoker();
                    }
                    ConcurrentMap<String, ConcurrentMap<String, Object>> concurrentMap2 = this.mSessionPool;
                    synchronized (concurrentMap2) {
                        if (s.expired()) {
                            try {
                                s.CleanUp();
                            }
                            finally {
                                s = (SessionScope)appSessions.remove(key);
                            }
                            if (s != null && invoker != null) {
                                endEventInvokerList.add(new SessionEndEventInvoker(s, invoker, scope));
                            }
                        } else {
                            s = null;
                        }
                    }
                    if (s == null || !s.expired()) continue;
                    this.getSessionMemoryMonitor().onSessionExpired(appName, sessionId);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return endEventInvokerList;
    }

    @Override
    public void updateLastAccess(SessionScope session) {
    }

    @Override
    public void test(String host, int port, String password, String ... args) {
    }

    @Override
    public void clearExpiredSessionCount() {
        this.expiredSessionCount = 0;
    }
}

