/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.util;

import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.UDFMethod;
import coldfusion.util.Key;
import java.util.Map;

public class TemplateProxyUtil {
    public static boolean isAbstractComponent(CfJspPage page) {
        if (page != null) {
            return "true".equalsIgnoreCase((String)((Map)page.getMetadata()).get("ABSTRACT"));
        }
        return false;
    }

    public static boolean isAbstractMethod(UDFMethod udfmethod) throws Throwable {
        if (udfmethod != null && udfmethod.getMetadata() != null) {
            return "true".equalsIgnoreCase((String)((AttributeCollection)udfmethod.getMetadata()).get("ABSTRACT"));
        }
        return false;
    }

    public static String getComponentFullName(CfJspPage page) {
        if (page != null) {
            return (String)((AttributeCollection)page.getMetadata()).get(Key.NAME);
        }
        return null;
    }

    public static String getComponentName(CfJspPage page) {
        if (page != null) {
            String compFullName = (String)((AttributeCollection)page.getMetadata()).get(Key.NAME);
            if (compFullName != null && compFullName.endsWith(".cfc")) {
                compFullName = compFullName.replace('/', '.');
                compFullName = compFullName.replace('\\', '.');
                compFullName = TemplateProxyUtil.replaceLastOccurrence(compFullName, ".cfc", "");
                compFullName = TemplateProxyUtil.getLastWord(compFullName, "\\.");
            }
            return compFullName;
        }
        return null;
    }

    public static String getComponentPathPrefix(CfJspPage page, String name) {
        String path = null;
        if (page != null && name != null) {
            String compFullName = (String)((AttributeCollection)page.getMetadata()).get(Key.NAME);
            if (compFullName != null) {
                compFullName = compFullName.replace('/', '.');
                compFullName = compFullName.replace('\\', '.');
                String lastWord = TemplateProxyUtil.getLastWord(compFullName);
                path = TemplateProxyUtil.replaceLastOccurrence(compFullName, lastWord, name);
            }
            return path;
        }
        return path;
    }

    public static String getLastWord(String str) {
        if (str != null) {
            str = str.replace('/', '.');
            str = str.replace('\\', '.');
            str = TemplateProxyUtil.getLastWord(str, "\\.");
            return str;
        }
        return null;
    }

    public static String replaceLastOccurrence(String payload, String regex, String replacement) {
        if (payload == null) {
            return payload;
        }
        int index = payload.lastIndexOf(regex);
        if (index == -1) {
            return payload;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(payload.substring(0, index)).append(replacement).append(payload.substring(index + regex.length()));
        return sb.toString();
    }

    public static String getLastWord(String payload, String regex) {
        if (payload == null) {
            return payload;
        }
        String[] words = payload.split(regex);
        if (words.length == 0) {
            return payload;
        }
        return words[words.length - 1];
    }

    public static boolean isFinalMethod(UDFMethod udfmethod) throws Throwable {
        String isFinalStr;
        boolean isFinal = false;
        if (udfmethod != null && udfmethod.getMetadata() != null && (isFinalStr = (String)((AttributeCollection)udfmethod.getMetadata()).get("FINAL")) != null) {
            isFinal = Boolean.parseBoolean(isFinalStr);
        }
        return isFinal;
    }

    public static boolean isStaticMethod(UDFMethod udfmethod) throws Throwable {
        String isStaticStr;
        boolean isStatic = false;
        if (udfmethod != null && udfmethod.getMetadata() != null && (isStaticStr = (String)((AttributeCollection)udfmethod.getMetadata()).get("STATIC")) != null) {
            isStatic = Boolean.parseBoolean(isStaticStr);
        }
        return isStatic;
    }

    public static boolean isDefaultMethod(UDFMethod udfmethod) throws Throwable {
        String isDefaultStr;
        boolean isDefault = false;
        if (udfmethod != null && udfmethod.getMetadata() != null && (isDefaultStr = (String)((AttributeCollection)udfmethod.getMetadata()).get("DEFAULT")) != null) {
            isDefault = Boolean.parseBoolean(isDefaultStr);
        }
        return isDefault;
    }
}

