/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.xml;

import coldfusion.log.CFLogs;
import coldfusion.runtime.Array;
import coldfusion.runtime.Cast;
import coldfusion.runtime.xml.AbstractHandler;
import coldfusion.runtime.xml.Handler;
import coldfusion.runtime.xml.IndexAccesor;
import coldfusion.runtime.xml.IndexAccessorFactory;
import coldfusion.runtime.xml.Registry;
import coldfusion.runtime.xml.SerializationException;
import coldfusion.runtime.xml.XMLGenerator;
import coldfusion.runtime.xml.XMLReader;
import coldfusion.util.RB;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class ArrayHandler
extends AbstractHandler {
    public ArrayHandler(Registry registry) {
        super(registry);
    }

    @Override
    public boolean canSerialize(Object obj) {
        return obj.getClass().isArray() || List.class.isAssignableFrom(obj.getClass());
    }

    @Override
    public void serialize(XMLGenerator generator, Object obj, boolean useCustomSerializer) throws SerializationException {
        IndexAccesor indexAccessor = IndexAccessorFactory.getIndexAccessor(obj);
        generator.addStartElement("ARRAY");
        Integer idRef = generator.getIDRef(obj);
        if (null == idRef) {
            String simpleName;
            int generatedId = generator.addSerializedObject(obj);
            generator.addAttribute("ID", String.valueOf(generatedId));
            int size = indexAccessor.getSize();
            generator.addAttribute("SIZE", String.valueOf(size));
            Class<?> componentType = obj.getClass().getComponentType();
            if (null != componentType && !"java.lang.Object".equalsIgnoreCase(simpleName = componentType.getName())) {
                generator.addAttribute("TYPE", simpleName);
            }
            for (int i = 0; i < size; ++i) {
                Object object = indexAccessor.getObject(i);
                generator.addStartElement("ITEM");
                generator.addAttribute("INDEX", String.valueOf(i + 1));
                Handler serializer = this.registry.getSerializer(object);
                generator.addAttribute("TYPE", serializer.getType(object));
                serializer.serialize(generator, object, useCustomSerializer);
                generator.addEndElement();
            }
        } else {
            generator.addAttribute("IDREF", String.valueOf(idRef));
        }
        generator.addEndElement();
    }

    @Override
    public String getType(Object obj) {
        return "ARRAY";
    }

    @Override
    public boolean canDeSerialize(String type) {
        return "ARRAY".equalsIgnoreCase(type.trim());
    }

    @Override
    public Object deserialize(XMLReader reader, Class datatype, boolean useCustomeSerializer) throws Handler.XMLParseException {
        Object returnObject = null;
        try {
            int eventType = reader.getEventType();
            while (6 == eventType) {
                reader.next();
                eventType = reader.getEventType();
            }
            if (1 != eventType || !reader.getLocalName().equalsIgnoreCase("ARRAY")) {
                throw new Handler.XMLParseException(RB.getString((Object)this, "ArrayHandler.InvalidStartElement", new Object[]{reader.getLocalName()}));
            }
            String idRef = null;
            String id = null;
            int size = -1;
            int attributeCount = reader.getAttributeCount();
            for (int i = 0; i < attributeCount; ++i) {
                String attributeLocalName = reader.getAttributeLocalName(i);
                if ("SIZE".equalsIgnoreCase(attributeLocalName)) {
                    String attributeValue = null;
                    try {
                        attributeValue = reader.getAttributeValue(i).trim();
                        size = Cast._int(attributeValue);
                        if (size >= 0) continue;
                        throw new Handler.XMLParseException(RB.getString((Object)this, "ArrayHandler.InvalidStartElement", new Object[]{attributeValue}));
                    }
                    catch (Cast.NumberConversionException e) {
                        throw new Handler.XMLParseException(RB.getString((Object)this, "ArrayHandler.InvalidSize", new Object[]{attributeValue}));
                    }
                }
                if ("IDREF".equalsIgnoreCase(attributeLocalName)) {
                    idRef = reader.getAttributeValue(i).trim();
                    continue;
                }
                if (!"ID".equalsIgnoreCase(attributeLocalName)) continue;
                id = reader.getAttributeValue(i).trim();
            }
            if (-1 == size) {
                throw new Handler.XMLParseException(RB.getString(this, "ArrayHandler.NameIsMandatory"));
            }
            if (null == idRef) {
                try {
                    returnObject = new Array(1, size);
                }
                catch (NegativeArraySizeException i) {
                    // empty catch block
                }
                reader.addDeSerializedObject(id, returnObject);
                int next = reader.next();
                while (!(next == 2 && "ARRAY".equalsIgnoreCase(reader.getLocalName()))) {
                    String localName = reader.getLocalName();
                    if (!"ITEM".equalsIgnoreCase(localName)) {
                        throw new Handler.XMLParseException(RB.getString((Object)this, "ArrayHandler.ExpectedItem", new Object[]{localName}));
                    }
                    int index = -1;
                    String type = null;
                    attributeCount = reader.getAttributeCount();
                    for (int i = 0; i < attributeCount; ++i) {
                        String attributeLocalName = reader.getAttributeLocalName(i);
                        if ("INDEX".equalsIgnoreCase(attributeLocalName)) {
                            String indexString = reader.getAttributeValue(i).trim();
                            try {
                                index = Cast._int(indexString);
                                if (index < 0) {
                                    throw new Handler.XMLParseException(RB.getString((Object)this, "ArrayHandler.NegativeIndex", new Object[]{indexString}));
                                }
                                if (index <= size) continue;
                                throw new Handler.XMLParseException(RB.getString((Object)this, "ArrayHandler.IndexGreaterThanSize", new Object[]{indexString, size}));
                            }
                            catch (Cast.NumberConversionException e) {
                                throw new Handler.XMLParseException(RB.getString((Object)this, "ArrayHandler.InvalidIndex", new Object[]{indexString}));
                            }
                        }
                        if ("TYPE".equalsIgnoreCase(attributeLocalName)) {
                            type = reader.getAttributeValue(i);
                            continue;
                        }
                        CFLogs.SERVER_LOG.warn(RB.getString((Object)this, "Handler.InvalidAttribute", new Object[]{attributeLocalName}));
                    }
                    if (-1 == index) {
                        throw new Handler.XMLParseException(RB.getString(this, "ArrayHandler.IndexIsMandatory"));
                    }
                    if (null == type || type.trim().length() == 0) {
                        throw new Handler.XMLParseException(RB.getString(this, "ArrayHandler.TypeIsMandatory"));
                    }
                    Handler handler = this.registry.getDeserializer(type);
                    reader.next();
                    Object deserialized = handler.deserialize(reader, Object.class, useCustomeSerializer);
                    ((Array)returnObject).add(deserialized);
                    next = reader.next();
                }
            } else {
                returnObject = reader.getReferencedObject(idRef);
                reader.next();
            }
            reader.next();
        }
        catch (XMLStreamException e) {
            throw new Handler.XMLParseException(RB.getString(this, "Handler.GeneralMessage"), e);
        }
        return returnObject;
    }
}

