/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.xml;

import coldfusion.log.CFLogs;
import coldfusion.runtime.xml.AbstractHandler;
import coldfusion.runtime.xml.DocumentQueryBeanAdapter;
import coldfusion.runtime.xml.Handler;
import coldfusion.runtime.xml.QueryBeanImqTableAdapter;
import coldfusion.runtime.xml.Registry;
import coldfusion.runtime.xml.SerializationException;
import coldfusion.runtime.xml.XMLGenerator;
import coldfusion.runtime.xml.XMLReader;
import coldfusion.sql.imq.imqTable;
import coldfusion.util.RB;
import coldfusion.xml.rpc.CFCInvocationException;
import coldfusion.xml.rpc.DocumentQueryBean;
import coldfusion.xml.rpc.QueryBean;
import coldfusion.xml.rpc.TypeConverter;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class QueryHandler
extends AbstractHandler {
    public QueryHandler(Registry registry) {
        super(registry);
    }

    @Override
    public boolean canSerialize(Object obj) {
        return QueryBean.class.isAssignableFrom(obj.getClass()) || DocumentQueryBean.class.isAssignableFrom(obj.getClass()) || imqTable.class.isAssignableFrom(obj.getClass());
    }

    @Override
    public void serialize(XMLGenerator generator, Object obj, boolean useCustomSerializer) throws SerializationException {
        QueryBean query = obj instanceof imqTable ? new QueryBeanImqTableAdapter((imqTable)obj) : (obj instanceof DocumentQueryBean ? new DocumentQueryBeanAdapter((DocumentQueryBean)obj) : (QueryBean)obj);
        String[] columnList = query.getColumnList();
        Object[][] data = query.getData();
        generator.addStartElement("QUERY");
        Integer idRef = generator.getIDRef(obj);
        if (null == idRef) {
            int generatedId = generator.addSerializedObject(obj);
            generator.addAttribute("ID", String.valueOf(generatedId));
            generator.addStartElement("COLUMNNAMES");
            for (String columnName : columnList) {
                generator.addStartElement("COLUMN");
                generator.addAttribute("NAME", columnName.trim());
                generator.addEndElement();
            }
            generator.addEndElement();
            generator.addStartElement("ROWS");
            for (int i = 0; i < data.length; ++i) {
                generator.addStartElement("ROW");
                for (int j = 0; j < columnList.length; ++j) {
                    generator.addStartElement("COLUMN");
                    Handler serializer = this.registry.getSerializer(data[i][j]);
                    generator.addAttribute("TYPE", serializer.getType(data[i][j]));
                    serializer.serialize(generator, data[i][j], useCustomSerializer);
                    generator.addEndElement();
                }
                generator.addEndElement();
            }
            generator.addEndElement();
        } else {
            generator.addAttribute("IDREF", String.valueOf(idRef));
        }
        generator.addEndElement();
    }

    @Override
    public String getType(Object obj) {
        return "QUERY";
    }

    @Override
    public boolean canDeSerialize(String type) {
        return "QUERY".equalsIgnoreCase(type);
    }

    @Override
    public Object deserialize(XMLReader reader, Class datatype, boolean useCustomeSerializer) throws Handler.XMLParseException {
        QueryBean bean = new QueryBean();
        LinkedList<String> columnNames = new LinkedList<String>();
        LinkedList<List<Object>> queryData = new LinkedList<List<Object>>();
        try {
            int eventType = reader.getEventType();
            if (1 != eventType || !reader.getLocalName().equalsIgnoreCase("QUERY")) {
                throw new Handler.XMLParseException(RB.getString((Object)this, "QueryHandler.InvalidStartElement", new Object[]{reader.getLocalName()}));
            }
            int attributeCount = reader.getAttributeCount();
            String idRef = null;
            String id = null;
            for (int i = 0; i < attributeCount; ++i) {
                String attributeLocalName = reader.getAttributeLocalName(i);
                if ("IDREF".equalsIgnoreCase(attributeLocalName)) {
                    idRef = reader.getAttributeValue(i).trim();
                    continue;
                }
                if ("ID".equalsIgnoreCase(attributeLocalName)) {
                    id = reader.getAttributeValue(i).trim();
                    continue;
                }
                CFLogs.SERVER_LOG.warn(RB.getString((Object)this, "Handler.InvalidAttribute", new Object[]{attributeLocalName}));
            }
            if (null == idRef) {
                reader.addDeSerializedObject(id, bean);
                int next = reader.next();
                if (1 != eventType || !reader.getLocalName().equalsIgnoreCase("COLUMNNAMES")) {
                    throw new Handler.XMLParseException(RB.getString((Object)this, "QueryHandler.ColumnNamesNotFound", new Object[]{reader.getLocalName()}));
                }
                next = reader.next();
                while (!(next == 2 && "COLUMNNAMES".equalsIgnoreCase(reader.getLocalName()))) {
                    String localName = reader.getLocalName();
                    if (!"COLUMN".equalsIgnoreCase(localName)) {
                        throw new Handler.XMLParseException(RB.getString((Object)this, "QueryHandler.ColumnNotFound", new Object[]{localName}));
                    }
                    String columnName = null;
                    attributeCount = reader.getAttributeCount();
                    for (int i = 0; i < attributeCount; ++i) {
                        String attributeLocalName = reader.getAttributeLocalName(i);
                        if ("NAME".equalsIgnoreCase(attributeLocalName)) {
                            columnName = reader.getAttributeValue(i).trim();
                            continue;
                        }
                        CFLogs.SERVER_LOG.warn(RB.getString((Object)this, "Handler.InvalidAttribute", new Object[]{attributeLocalName}));
                    }
                    if (null == columnName || columnName.trim().length() == 0) {
                        throw new Handler.XMLParseException(RB.getString(this, "QueryHandler.NameIsMandatory"));
                    }
                    columnNames.add(columnName.trim());
                    next = reader.next();
                    next = reader.next();
                }
                next = reader.next();
                if (1 != eventType || !reader.getLocalName().equalsIgnoreCase("ROWS")) {
                    throw new Handler.XMLParseException(RB.getString((Object)this, "QueryHandler.ExpectedRows", new Object[]{reader.getLocalName()}));
                }
                next = reader.next();
                while (!(next == 2 && "ROWS".equalsIgnoreCase(reader.getLocalName()))) {
                    LinkedList<Object> rowData = new LinkedList<Object>();
                    String localName = reader.getLocalName();
                    if (!"ROW".equalsIgnoreCase(localName)) {
                        throw new Handler.XMLParseException(RB.getString((Object)this, "QueryHandler.ExpectedRow", new Object[]{localName}));
                    }
                    next = reader.next();
                    while (!(next == 2 && "ROW".equalsIgnoreCase(reader.getLocalName()))) {
                        localName = reader.getLocalName();
                        if (!"COLUMN".equalsIgnoreCase(localName)) {
                            throw new Handler.XMLParseException(RB.getString((Object)this, "QueryHandler.ExpectedColumn", new Object[]{localName}));
                        }
                        String type = null;
                        attributeCount = reader.getAttributeCount();
                        for (int i = 0; i < attributeCount; ++i) {
                            String attributeLocalName = reader.getAttributeLocalName(i);
                            if ("TYPE".equalsIgnoreCase(attributeLocalName)) {
                                type = reader.getAttributeValue(i).trim();
                                continue;
                            }
                            CFLogs.SERVER_LOG.warn(RB.getString((Object)this, "Handler.InvalidAttribute", new Object[]{attributeLocalName}));
                        }
                        if (null == type || type.trim().length() == 0) {
                            throw new Handler.XMLParseException(RB.getString(this, "QueryHandler.TypeIsMandatory"));
                        }
                        Handler handler = this.registry.getDeserializer(type);
                        reader.next();
                        Object deserialized = handler.deserialize(reader, Object.class, useCustomeSerializer);
                        rowData.add(deserialized);
                        next = reader.next();
                    }
                    queryData.add(rowData);
                    next = reader.next();
                }
                next = reader.next();
            } else {
                Object referencedObject = reader.getReferencedObject(idRef);
                if (!(referencedObject instanceof QueryBean)) {
                    throw new Handler.XMLParseException(RB.getString((Object)this, "QueryHandler.InvalidReferencedObject", new Object[]{this.registry.getSerializer(referencedObject).getType(referencedObject)}));
                }
                bean = (QueryBean)referencedObject;
                reader.next();
            }
            reader.next();
        }
        catch (XMLStreamException e) {
            throw new Handler.XMLParseException(RB.getString(this, "Handler.GeneralMessage"), e);
        }
        return this.createQueryBean(bean, columnNames, queryData);
    }

    private Object createQueryBean(QueryBean bean, List<String> columnNames, List<List<Object>> queryData) throws Handler.XMLParseException {
        bean.setColumnList(columnNames.toArray(new String[0]));
        Object[][] data = new Object[queryData.size()][];
        int index = 0;
        for (List<Object> list : queryData) {
            data[index] = list.toArray();
            ++index;
        }
        bean.setData(data);
        try {
            return TypeConverter.convertIn(bean);
        }
        catch (CFCInvocationException e) {
            throw new Handler.XMLParseException(e);
        }
    }
}

