/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.xml;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XPathExprGenerator {
    private Stack<XPathElementIdentifier> xPathStack = new Stack();
    private final String xml;
    private Document document;
    private boolean isText;
    private XPathElementIdentifier lastPoppedElt;

    public XPathExprGenerator(String xml) throws ParserConfigurationException, SAXException, IOException {
        this.xml = xml;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.parse(new InputSource(new StringReader(this.xml)));
    }

    public void addStartElement(String localName) {
        XPathElementIdentifier item = null;
        if (null != this.lastPoppedElt && this.lastPoppedElt.localName.equals(localName)) {
            ++this.lastPoppedElt.count;
            item = this.lastPoppedElt;
        } else {
            item = new XPathElementIdentifier(localName);
        }
        this.xPathStack.push(item);
        this.lastPoppedElt = null;
        this.isText = false;
    }

    public void addEndElement(String localName) {
        this.lastPoppedElt = this.xPathStack.pop();
    }

    public String getCurrentNodeStr() throws XPathExpressionException, TransformerFactoryConfigurationError, TransformerException {
        Object currentXPath = this.getCurrentXPath();
        if (this.isText) {
            currentXPath = (String)currentXPath + "/text()";
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        XPathExpression expression = xPath.compile((String)currentXPath);
        if (this.isText) {
            return (String)expression.evaluate(this.document, XPathConstants.STRING);
        }
        Object result = expression.evaluate(this.document, XPathConstants.NODE);
        Node node = (Node)result;
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(node), new StreamResult(writer));
        return writer.toString();
    }

    public String getCurrentXPath() {
        StringBuilder builder = new StringBuilder();
        int size = this.xPathStack.size();
        for (int i = 0; i < size; ++i) {
            XPathElementIdentifier xPathElementIdentifier = (XPathElementIdentifier)this.xPathStack.get(i);
            builder.append(xPathElementIdentifier.getElementIdentifier());
        }
        if (builder.length() == 0) {
            return "/";
        }
        return builder.toString();
    }

    public void setText() {
        this.isText = true;
    }

    private static class XPathElementIdentifier {
        private String localName;
        private int count = 1;

        public XPathElementIdentifier(String localName) {
            this.localName = localName;
        }

        public String getElementIdentifier() {
            StringBuilder builder = new StringBuilder();
            builder.append("/");
            builder.append(this.localName);
            builder.append("[");
            builder.append(this.count);
            builder.append("]");
            return builder.toString();
        }
    }
}

