/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.scheduling;

import coldfusion.log.Logger;
import coldfusion.osgi.services.CronService;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.NeoException;
import coldfusion.scheduling.SchedulingParamErrorException;
import coldfusion.server.ConfigMap;
import coldfusion.server.SchedulerService;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.net.HttpTag;
import coldfusion.util.DateUtils;
import coldfusion.util.PasswordUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;

public class CronTabEntry
extends ConfigMap
implements Runnable {
    private static final long serialVersionUID = 1L;
    protected SchedulerService _sscheduler;
    protected Logger _logger;
    protected Logger _schlogger;
    protected Date _startDate = null;
    protected Date _endDate = null;
    protected Date _startTime = null;
    protected Date _endTime = null;
    private String seed;
    private Date _lastRun = null;
    private Date _lastModified = null;
    protected boolean _infinite = true;
    protected boolean _infiniteTime = true;
    protected boolean _once = false;
    protected boolean _publish = false;
    protected boolean _paused = false;
    protected boolean _disabled = false;
    protected boolean _logFlag = false;
    public static final String _datePattern = "M/d/yyyy";
    public static final String _timePattern = "h:mm:ss a";
    public static final String _dateTimePattern = "M/d/yyyy h:mm:ss a";
    public static final String _militaryPattern = "M/d/yyyy HH:mm:ss";

    public CronTabEntry(Map map, boolean b, String seed) throws ServiceException {
        this._logFlag = b;
        this._schlogger = ServiceFactory.getLoggingService().getLogger("coldfusion.scheduler");
        this._sscheduler = ServiceFactory.getSchedulerService();
        this.seed = seed;
        this.setAttributes(map);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof CronTabEntry) {
            return this.getTask().equalsIgnoreCase(((CronTabEntry)o).getTask());
        }
        return false;
    }

    public CronTabEntry(String task2, String operation, String url, String file, String path, Date startdate, Date enddate, Date starttime, Date endtime, String interval, boolean publish, String requesttimeout, String password, String username, String proxyserver, String proxyUser, String proxyPassword, boolean resolveurl, String httpport, String httpproxyport, boolean disabled, boolean b, String seed) throws ServiceException {
        this._logFlag = b;
        this._schlogger = ServiceFactory.getLoggingService().getLogger("coldfusion.scheduler");
        this._sscheduler = ServiceFactory.getSchedulerService();
        this.seed = seed;
        this.setAttributes(task2, operation, url, file, path, startdate, enddate, starttime, endtime, interval, publish, false, requesttimeout, password, username, proxyserver, proxyUser, proxyPassword, resolveurl, httpport, httpproxyport, disabled);
    }

    public void setup() {
        String str = (String)this.get("end_date");
        if (str == null) {
            this._infinite = true;
        } else {
            this._infinite = false;
            this._endDate = CFPage.ParseDateTime(str);
        }
        str = (String)this.get("end_time");
        if (str == null) {
            this._infiniteTime = true;
        } else {
            this._infiniteTime = false;
            this._endTime = CFPage.ParseDateTime(str);
        }
        str = (String)this.get("start_date");
        try {
            this._startDate = CFPage.ParseDateTime(str);
        }
        catch (Exception e) {
            this._startDate = CFPage.internal_LSParseDateTime(str, Locale.getDefault());
        }
        str = (String)this.get("start_time");
        try {
            this._startTime = CFPage.ParseDateTime(str);
        }
        catch (Exception e) {
            this._startTime = CFPage.internal_LSParseDateTime(str, Locale.getDefault());
        }
        str = (String)this.get("interval");
        this._once = str.equalsIgnoreCase("once");
        this._publish = (Boolean)this.get("publish");
        this._paused = null == this.get("paused") ? false : (Boolean)this.get("paused");
    }

    public void setAttributes(String task2, String operation, String url, String file, String path, Date startdate, Date enddate, Date starttime, Date endtime, String interval, boolean publish, boolean paused, String requesttimeout, String password, String username, String proxyserver, String proxyUser, String proxyPassword, boolean resolveurl, String httpport, String httpproxyport, boolean disabled) {
        this.put("task", (Object)task2);
        this.put("operation", (Object)operation);
        this.put("url", (Object)url);
        this.put("file", (Object)file);
        this.put("path", (Object)path);
        this.put("publish", (Object)publish);
        this.put("paused", (Object)paused);
        SimpleDateFormat formatter = new SimpleDateFormat(_datePattern);
        String fout = formatter.format(startdate);
        this.put("start_date", (Object)fout);
        if (enddate != null) {
            formatter = new SimpleDateFormat(_datePattern);
            fout = formatter.format(enddate);
            this.put("end_date", (Object)fout);
        }
        formatter = new SimpleDateFormat(_timePattern);
        fout = formatter.format(starttime);
        this.put("start_time", (Object)fout);
        if (endtime != null) {
            formatter = new SimpleDateFormat(_timePattern);
            fout = formatter.format(endtime);
            this.put("end_time", (Object)fout);
        }
        this.put("interval", (Object)interval);
        if (requesttimeout != null) {
            this.put("request_time_out", (Object)requesttimeout);
        }
        if (password != null) {
            this.put("password", (Object)password);
        }
        if (username != null) {
            this.put("username", (Object)username);
        }
        if (proxyserver != null) {
            this.put("proxy_server", (Object)proxyserver);
        }
        if (proxyUser != null) {
            this.put("proxy_user", (Object)proxyUser);
        }
        if (proxyPassword != null) {
            this.put("proxy_password", (Object)proxyPassword);
        }
        this.put("resolveurl", (Object)resolveurl);
        if (httpport != null) {
            this.put("http_port", (Object)httpport);
        }
        if (httpproxyport != null) {
            this.put("http_proxy_port", (Object)httpproxyport);
        }
        this.put("disabled", (Object)disabled);
        this.setup();
    }

    public void setAttributes(Map map) {
        this.put("task", map.get("task"));
        this.put("operation", map.get("operation"));
        this.put("url", map.get("url"));
        this.put("file", map.get("file"));
        this.put("path", map.get("path"));
        this.put("publish", map.get("publish"));
        Object paused = map.get("paused");
        this.put("paused", (Object)(paused == null ? Boolean.FALSE : paused));
        this.put("start_date", map.get("start_date"));
        String str = (String)map.get("end_date");
        if (str != null) {
            this.put("end_date", (Object)str);
        }
        this.put("start_time", map.get("start_time"));
        str = (String)map.get("end_time");
        if (str != null) {
            this.put("end_time", (Object)str);
        }
        this.put("interval", map.get("interval"));
        str = (String)map.get("request_time_out");
        if (str != null) {
            this.put("request_time_out", (Object)str);
        }
        if ((str = (String)map.get("password")) != null) {
            this.put("password", (Object)str);
        }
        if ((str = (String)map.get("username")) != null) {
            this.put("username", (Object)str);
        }
        if ((str = (String)map.get("proxy_server")) != null) {
            this.put("proxy_server", (Object)str);
        }
        if ((str = (String)map.get("proxy_user")) != null) {
            this.put("proxy_user", (Object)str);
        }
        if ((str = (String)map.get("proxy_password")) != null) {
            this.put("proxy_password", (Object)str);
        }
        this.put("resolveurl", map.get("resolveurl"));
        str = (String)map.get("http_port");
        if (str != null) {
            this.put("http_port", (Object)str);
        }
        if ((str = (String)map.get("http_proxy_port")) != null) {
            this.put("http_proxy_port", (Object)str);
        }
        if ((str = (String)map.get("last_run")) != null) {
            this.put("last_run", (Object)str);
        }
        this.put("disabled", (Object)(map.get("disabled") == null ? Boolean.FALSE : map.get("disabled")));
        this.setup();
    }

    public Date getStartDate() {
        return this._startDate;
    }

    public Date getEndDate() {
        return this._endDate;
    }

    public Date getStartTime() {
        return this._startTime;
    }

    public Date getEndTime() {
        return this._endTime;
    }

    public String getTask() {
        return (String)this.get("task");
    }

    protected HttpTag getHttpTag() {
        Object url = (String)this.get("url");
        String s = (String)this.get("request_time_out");
        if (!this.isEmpty(s)) {
            url = ((String)url).indexOf(63) > 0 ? (String)url + "&RequestTimeout=" + s : (String)url + "?RequestTimeout=" + s;
        }
        HttpTag http = new HttpTag((String)url);
        Boolean b = (Boolean)this.get("resolveurl");
        http.setResolveurl(b);
        http.setUseragent("CFSCHEDULE");
        s = (String)this.get("http_port");
        if (!this.isEmpty(s)) {
            http.setPort(Integer.parseInt(s));
        }
        if (!this.isEmpty(s = (String)this.get("username"))) {
            http.setUsername(s);
        }
        if (!this.isEmpty(s = (String)this.get("password"))) {
            s = PasswordUtils.decryptPassword(s, this.seed);
            http.setPassword(s);
        }
        if (!this.isEmpty(s = (String)this.get("proxy_port"))) {
            http.setProxyport(Integer.parseInt(s));
        }
        if (!this.isEmpty(s = (String)this.get("proxy_server"))) {
            http.setProxyserver(s);
        }
        if (!this.isEmpty(s = (String)this.get("proxy_user"))) {
            http.setProxyUser(s);
        }
        if (!this.isEmpty(s = (String)this.get("proxy_password"))) {
            s = PasswordUtils.decryptPassword(s, this.seed);
            http.setProxyPassword(s);
        }
        if (!this.isEmpty(s = (String)this.get("request_time_out"))) {
            http.setTimeout(Cast._int(s));
        }
        http.disableDeflate();
        return http;
    }

    protected void setSeed(String seedValue) {
        this.seed = seedValue;
    }

    public void setPaused(boolean b) {
        this._paused = b;
        this.put("paused", (Object)b);
    }

    public boolean isPaused() {
        return this._paused;
    }

    public void setDisabled(boolean b) {
        this._disabled = b;
        this.put("disabled", (Object)b);
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setModifiedTime(Date modifiedTime) {
        this._lastModified = modifiedTime;
    }

    public void runCall() throws Throwable {
        PrintWriter out = null;
        if (this._paused) {
            return;
        }
        try {
            HttpTag http = this.getHttpTag();
            if (this._publish) {
                File file = new File(this.get("path") + "/" + this.get("file"));
                out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file))));
                out.println(http.runCall().getFilecontent());
                out.close();
            } else {
                http.setThrowonerror(true);
                http.runCall().getFilecontent();
            }
        }
        catch (Throwable e) {
            this.log("Error while executing task " + e.getMessage());
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public void activate() throws SchedulingParamErrorException {
        String task2 = (String)this.get("task");
        String interval = (String)this.get("interval");
        Boolean disabled = this.get("disabled") == null ? Boolean.FALSE : this.get("disabled");
        Date dt = new Date();
        if (this._endDate != null && this._startDate.after(this._endDate)) {
            throw new SchedulingParamErrorException(this._startDate.toString(), this._endDate.toString());
        }
        if (this._endTime != null && this._startTime.after(this._endTime)) {
            throw new SchedulingParamErrorException(this._startTime.toString(), this._endTime.toString());
        }
        if (this._once && disabled.booleanValue()) {
            this.log("[" + task2 + "] has run once before, and will not be scheduled.");
            return;
        }
        Date next = interval.equalsIgnoreCase("weekly") || interval.equalsIgnoreCase("daily") || interval.equalsIgnoreCase("monthly") || interval.equalsIgnoreCase("once") ? this.NextRunTime(this._startDate, this._startTime, interval) : this.NextRunTime(this._startDate, this._startTime, this._endTime, Cast._long(interval) * 1000L);
        long t = next.getTime();
        if (!this._infinite && !this._once) {
            if (t < CronTabEntry.mergeDates(this._endDate, this._endTime).getTime()) {
                this.log("[" + task2 + "] Activating1 on " + dt + " To run on " + next);
                this._sscheduler.schedule(this, t);
            } else {
                this.log("[" + task2 + "] End time has been reached: " + this._endDate + ". Now is " + dt);
            }
        } else {
            this.log("[" + task2 + "] Activating2 on " + dt + " To run on " + next);
            this._sscheduler.schedule(this, t);
        }
    }

    public void reschedule() {
        String task2 = (String)this.get("task");
        String interval = (String)this.get("interval");
        Date next = interval.equalsIgnoreCase("weekly") || interval.equalsIgnoreCase("daily") || interval.equalsIgnoreCase("monthly") ? this.NextRunTime(this._startDate, this._startTime, interval) : this.NextRunTime(this._startDate, this._startTime, this._endTime, Cast._long(interval) * 1000L);
        if (!this._infinite) {
            if (next.getTime() < CronTabEntry.mergeDates(this._endDate, this._endTime).getTime()) {
                this.log("[" + task2 + "] Rescheduling for :" + next + " Now: " + new Date());
                this._sscheduler.schedule(this, next.getTime());
            } else {
                this.log("[" + task2 + "] End date reached :" + this._endDate + " Now: " + new Date());
            }
        } else {
            this.log("[" + task2 + "] Rescheduling for :" + next + " Now: " + new Date());
            this._sscheduler.schedule(this, next.getTime());
        }
    }

    private Date NextRunTime(Date start, Date stime, Date etime, long interval) {
        Date nextend;
        Date now = new Date();
        Date startTime = CronTabEntry.mergeDates(now, stime);
        if (start.getTime() > now.getTime()) {
            startTime = CronTabEntry.mergeDates(start, stime);
        }
        if (startTime.getTime() > now.getTime()) {
            return startTime;
        }
        if (interval < 1L) {
            interval = 1000L;
        }
        Date newdate = new Date(startTime.getTime() + interval * ((now.getTime() - startTime.getTime()) / interval + 1L));
        if (etime != null && newdate.after(nextend = CronTabEntry.mergeDates(now, etime))) {
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(now);
            cal2.add(5, 1);
            newdate = cal2.getTime();
            newdate = CronTabEntry.mergeDates(newdate, stime);
        }
        return newdate;
    }

    private Date NextRunTime(Date start, Date stime, String interval) {
        Date now = new Date();
        Date startTime = CronTabEntry.mergeDates(start, stime);
        if (interval.equalsIgnoreCase("once")) {
            return startTime;
        }
        if (startTime.getTime() > now.getTime()) {
            return startTime;
        }
        Calendar cal = Calendar.getInstance();
        cal.setLenient(true);
        cal.setTime(startTime);
        Date d = cal.getTime();
        boolean isHourAdjNeeded = false;
        int runHour = cal.get(11);
        int runDayOfMonth = cal.get(5);
        while (true) {
            if (interval.equalsIgnoreCase("daily")) {
                cal.add(10, 24);
            } else if (interval.equalsIgnoreCase("weekly")) {
                cal.add(3, 1);
            } else {
                if (!interval.equalsIgnoreCase("monthly")) break;
                cal.add(2, 1);
                if (cal.get(5) < runDayOfMonth) {
                    int maxDate = cal.getActualMaximum(5);
                    cal.set(5, runDayOfMonth <= maxDate ? runDayOfMonth : maxDate);
                }
            }
            if (isHourAdjNeeded) {
                cal.set(11, runHour);
                isHourAdjNeeded = false;
            }
            if ((d = cal.getTime()).getTime() >= now.getTime()) break;
            if (cal.get(11) == runHour) continue;
            isHourAdjNeeded = true;
        }
        return d;
    }

    @Override
    public void run() {
        CronService cs = null;
        int retrycount = 0;
        while (cs == null && retrycount < 5) {
            try {
                cs = ServiceFactory.getCronService();
            }
            catch (ApplicationException se) {
                try {
                    Thread.sleep(1000L);
                    ++retrycount;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (cs != null) {
            this._logFlag = cs.getLogFlag();
            this._lastRun = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat(_dateTimePattern);
            String fout = formatter.format(this._lastRun);
            this.put("last_run", (Object)fout);
            cs.saveCronEntries();
            String task2 = (String)this.get("task");
            if (this._logFlag) {
                if (!this.isPaused()) {
                    this.log("[" + task2 + "] Executing at " + this._lastRun);
                } else {
                    this.log("[" + task2 + "] Task did not execute at " + this._lastRun + " as the task is paused");
                }
            }
            try {
                this.runCall();
            }
            catch (Throwable e) {
                this.log(e.getMessage());
            }
            if (!this._once) {
                if (this._lastModified == null || this._lastModified != null && this._lastRun.after(this._lastModified)) {
                    this.reschedule();
                }
            } else {
                this.put("disabled", (Object)Boolean.TRUE);
                cs.saveCronEntries();
            }
        }
    }

    protected void log(String str) {
        if (this._logFlag) {
            this._schlogger.info(str);
        }
    }

    public static Date mergeDates(Date adate, Date atime, boolean isLenient) throws SchedulingStartDateTimeException {
        Date mergedDateTime;
        if (atime == null) {
            return adate;
        }
        try {
            Calendar ndate = Calendar.getInstance();
            Calendar dcal = Calendar.getInstance();
            dcal.setTime(adate);
            Calendar tcal = Calendar.getInstance();
            tcal.setTime(atime);
            ndate.setLenient(isLenient);
            ndate.set(2, dcal.get(2));
            ndate.set(5, dcal.get(5));
            ndate.set(1, dcal.get(1));
            ndate.set(10, tcal.get(10));
            ndate.set(12, tcal.get(12));
            ndate.set(13, tcal.get(13));
            ndate.set(14, tcal.get(14));
            ndate.set(9, tcal.get(9));
            mergedDateTime = ndate.getTime();
        }
        catch (IllegalArgumentException e) {
            throw new SchedulingStartDateTimeException(adate, atime);
        }
        return mergedDateTime;
    }

    public static Date mergeDates(Date adate, Date atime) {
        return CronTabEntry.mergeDates(adate, atime, true);
    }

    private void dump(String s, Calendar calendar) {
        System.out.println(s + ": " + calendar.getTime().toString());
    }

    private boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static Date getThisTimeNextDay(Date d) {
        GregorianCalendar cal = new GregorianCalendar(d.getYear() + 1900, d.getMonth(), d.getDate(), d.getHours(), d.getMinutes(), d.getSeconds());
        if (cal.get(6) + 1 <= cal.getActualMaximum(6)) {
            cal.roll(6, true);
        } else {
            cal.roll(1, true);
            cal.set(6, cal.getActualMinimum(6));
        }
        return cal.getTime();
    }

    public static Date getThisTimeNextWeek(Date d) {
        GregorianCalendar cal = new GregorianCalendar(d.getYear() + 1900, d.getMonth(), d.getDate(), d.getHours(), d.getMinutes(), d.getSeconds());
        if (cal.get(3) + 1 <= cal.getActualMaximum(3)) {
            cal.roll(3, true);
        } else {
            cal.roll(1, true);
            cal.set(3, cal.getActualMinimum(3));
        }
        return cal.getTime();
    }

    public static Date getThisTimeNextMonth(Date d) {
        GregorianCalendar cal = new GregorianCalendar(d.getYear() + 1900, d.getMonth(), d.getDate(), d.getHours(), d.getMinutes(), d.getSeconds());
        if (cal.get(2) + 1 <= cal.getActualMaximum(2)) {
            cal.roll(2, true);
        } else {
            cal.roll(1, true);
            cal.set(2, cal.getActualMinimum(2));
        }
        return cal.getTime();
    }

    public Date getLastRun() {
        return this._lastRun;
    }

    public static class SchedulingStartDateTimeException
    extends NeoException {
        private static final long serialVersionUID = 1L;
        public String start;

        public SchedulingStartDateTimeException(Date adate, Date atime) {
            this.start = DateUtils.makeDateString(adate, atime);
        }

        public SchedulingStartDateTimeException(String adate, String atime) {
            this.start = adate + " " + atime;
        }
    }
}

