/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.security;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.cert.CertificateException;

public class KeyStoreUtils {
    private static final String WINDOWS_ROOT = "Windows-ROOT";
    private static final String WINDOWS_MY = "Windows-MY";
    private static final String JKS = "jks";
    private static final String PKCS12 = "pkcs12";

    public static KeyStore getKeyStore(String keyStoreFilePath, String type, String password, String provider) throws Exception {
        if (keyStoreFilePath != null && keyStoreFilePath.trim().length() > 0) {
            return KeyStoreUtils.loadKeyStore(keyStoreFilePath, type, password, provider);
        }
        if (WINDOWS_MY.equalsIgnoreCase(type) || WINDOWS_ROOT.equalsIgnoreCase(type)) {
            return KeyStoreUtils.getWindowsNativeKeyStore(type);
        }
        return null;
    }

    private static KeyStore loadKeyStore(String keyStoreFilePath, String type, String password, String provider) throws Exception {
        char[] keyStorePassword = password == null ? null : password.toCharArray();
        try {
            KeyStore keyStore = KeyStoreUtils._getKeyStore(type, provider);
            keyStore.load(new FileInputStream(keyStoreFilePath), keyStorePassword);
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            if (type == null || type.trim().isEmpty()) {
                return KeyStoreUtils.loadKeyStore(keyStoreFilePath, PKCS12, password, provider);
            }
            throw e;
        }
    }

    private static KeyStore getWindowsNativeKeyStore(String type) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(type);
        keyStore.load(null, null);
        return keyStore;
    }

    private static KeyStore _getKeyStore(String type, String provider) throws KeyStoreException, NoSuchProviderException {
        if (provider == null || provider.trim().isEmpty() || Security.getProvider(provider) == null) {
            return KeyStore.getInstance(type == null || type.trim().isEmpty() ? JKS : type);
        }
        return KeyStore.getInstance(type == null || type.trim().isEmpty() ? JKS : type, provider);
    }
}

