/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.security;

import coldfusion.security.AuthenticationFailureException;
import coldfusion.security.BadGroupNameException;
import coldfusion.security.BadUserNameException;
import coldfusion.security.DomainControllerException;
import coldfusion.security.GetGroupException;
import coldfusion.server.CFService;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;

public class NTAuthentication {
    private String NTdomain;
    final int NERR_BadUsername = 2202;
    final int NERR_DCNotFound = 2453;
    final int NERR_GroupNotFound = 2220;

    public NTAuthentication(String NTDataSrcName) {
        this.NTdomain = NTDataSrcName;
    }

    public boolean IsUserInDirectory(String userName) throws Exception {
        int errCode = this.fnNetUserGetInfo(this.NTdomain, userName);
        if (errCode == 0) {
            return true;
        }
        switch (errCode) {
            case 2202: {
                throw new BadUserNameException(userName, this.NTdomain);
            }
            case 2453: {
                throw new DomainControllerException(userName, this.NTdomain);
            }
        }
        throw new BadUserNameException(userName, this.NTdomain);
    }

    public boolean IsUserInGroup(String userName, String groupName) throws Exception {
        int errCode = this.NetGroupGetUsers(this.NTdomain, userName, groupName);
        if (errCode == 0) {
            return true;
        }
        switch (errCode) {
            case 2202: {
                throw new BadUserNameException(userName, this.NTdomain);
            }
            case 2453: {
                throw new DomainControllerException(userName, this.NTdomain);
            }
            case 2220: {
                throw new BadGroupNameException(userName, groupName, this.NTdomain);
            }
        }
        throw new BadGroupNameException(userName, groupName, this.NTdomain);
    }

    public boolean AuthenticateUser(String userName, String passwd) throws Exception {
        int result = this.fnAAuthNTD(userName, passwd, this.NTdomain);
        if (result == 1) {
            return true;
        }
        throw new AuthenticationFailureException(userName, this.NTdomain);
    }

    public List GetUserGroups(String userName) throws Exception {
        String[] grpList = this.fnNetUserGetGroups(this.NTdomain, userName);
        if (grpList != null && grpList.length > 0) {
            ArrayList<String> tmpList = new ArrayList<String>();
            for (int i = 0; i < grpList.length; ++i) {
                tmpList.add(i, grpList[i]);
            }
            return tmpList;
        }
        throw new GetGroupException(userName, this.NTdomain);
    }

    private native String[] fnNetUserGetGroups(String var1, String var2);

    private native int fnNetUserGetInfo(String var1, String var2);

    private native int fnNetGroupGetUsers(String var1, String var2, String var3);

    private native int fnAAuthNTD(String var1, String var2, String var3);

    private String[] NetUserGetGroups(String domainName, String userName) {
        return this.fnNetUserGetGroups(this.NTdomain, userName);
    }

    private int NetUserGetInfo(String domainName, String userName) {
        return this.fnNetUserGetInfo(this.NTdomain, userName);
    }

    private int NetGroupGetUsers(String domainName, String userName, String groupName) {
        return this.fnNetGroupGetUsers(this.NTdomain, userName, groupName);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.load(CFService.getLibPath() + File.separator + "cfwindowslogin.dll");
                return null;
            }
        });
    }
}

