/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.security;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.server.SystemInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class RolesStore {
    private HashMap roles = new HashMap();
    private HashMap pageRoleMap = new HashMap();
    private static Logger logger = CFLogs.SERVER_LOG;

    RolesStore() {
    }

    boolean canAccessPage(String roleName, String page) {
        boolean isAccessAllowed = false;
        ArrayList pages = (ArrayList)this.roles.get(roleName);
        if (pages != null) {
            isAccessAllowed = pages.contains(page);
        }
        return isAccessAllowed;
    }

    ArrayList getRolesAllowedForPage(String page) {
        if (SystemInfo.isWindows()) {
            page = page.toLowerCase();
        }
        ArrayList rolesForPage = (ArrayList)this.pageRoleMap.get(page);
        return rolesForPage;
    }

    ArrayList getRolesAllowedForPagePath(String page) {
        int queryIndex = page.indexOf("?");
        int lastSlashIndex = queryIndex == -1 ? page.lastIndexOf("/") : page.lastIndexOf("/", queryIndex);
        String pagePath = page.substring(0, lastSlashIndex + 1);
        if (SystemInfo.isWindows()) {
            pagePath = pagePath.toLowerCase();
        }
        ArrayList rolesForPath = (ArrayList)this.pageRoleMap.get(pagePath);
        return rolesForPath;
    }

    List getAllRoles() {
        Vector roleNames = new Vector(this.roles.keySet());
        return roleNames;
    }

    void load(Properties rolesProps) {
        Enumeration<Object> roleNames = rolesProps.keys();
        while (roleNames.hasMoreElements()) {
            String role = (String)roleNames.nextElement();
            String pages = rolesProps.getProperty(role);
            if (SystemInfo.isWindows()) {
                pages = pages.toLowerCase();
            }
            this.addRole(role, pages);
        }
    }

    void addRole(String role, String pages) {
        logger.debug("Loading role [" + role + "], pages [" + pages + "]");
        StringTokenizer st = new StringTokenizer(pages, ",");
        ArrayList<Object> pageList = Collections.list(st);
        this.roles.put(role, pageList);
        for (int i = 0; i < pageList.size(); ++i) {
            String page = (String)pageList.get(i);
            ArrayList<String> rolesForPage = (ArrayList<String>)this.pageRoleMap.get(page);
            if (rolesForPage == null) {
                rolesForPage = new ArrayList<String>();
                this.pageRoleMap.put(page, rolesForPage);
            }
            rolesForPage.add(role);
        }
    }

    void reset() {
        this.roles.clear();
        this.pageRoleMap.clear();
    }
}

