/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.security;

import coldfusion.centralconfig.client.CentralConfigClientUtil;
import coldfusion.log.CFLogs;
import coldfusion.runtime.Array;
import coldfusion.runtime.ClientScopeService;
import coldfusion.runtime.Struct;
import coldfusion.security.SecureProfileOthersHelper;
import coldfusion.security.SecureProfileRuntimeHelper;
import coldfusion.security.SecureProfileSecurityHelper;
import coldfusion.security.SecureProfileSetting;
import coldfusion.server.ConfigMap;
import coldfusion.server.DataSourceService;
import coldfusion.server.DebuggingService;
import coldfusion.server.MetricsService;
import coldfusion.server.RuntimeService;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.WebSocketService;
import coldfusion.serverless.InMemoryFile;
import coldfusion.serverless.ServerlessUtil;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SecureProfileHelper
extends ServiceBase {
    private static final String DELIM = ",";
    public static final String DRIVER_DEFAULTS = "driverdefaults";
    public static final String ALLOWED_ADMIN_IP_LIST = "allowedAdminIPList";
    public static final String SBS_SECURITY_ENABLED = "sbs.security.enabled";
    public static final String RDS_SECURITY_USESINGLERDSPASSWORD = "rds.security.usesinglerdspassword";
    public static final String RDS_ENABLED = "rds.enabled";
    public static final String RDS_SECURITY_ENABLED = "rds.security.enabled";
    public static final String ADMIN_USERID_REQUIRED = "admin.userid.required";
    public static final String ADMIN_SECURITY_ENABLED = "admin.security.enabled";
    public static final String ALLOW_CONCURRENT_ADMIN_LOGIN = "allowconcurrentadminlogin";
    public static final String SCRIPTPROTECT = "scriptprotect";
    public static final String MISSING_TEMPLATE = "missing_template";
    public static final String QUEUE_TIMEOUT = "queue_timeout";
    public static final String SITE_WIDE = "site_wide";
    public static final String DISABLE_SERVICE_FACTORY = "disableServiceFactory";
    public static final String INTERNAL_COOKIES_DISABLE_UPDATE = "internalCookiesDisableUpdate";
    public static final String SESSION_COOKIE_TIMEOUT = "sessionCookieTimeout";
    public static final String POST_SIZE_LIMIT = "postSizeLimit";
    public static final String CFSTAT = "cfstat";
    public static final String ROBUST_ENABLED = "robust_enabled";
    public static final String START_WEB_SOCKET_SERVICE = "startWebSocketService";
    public static final String FLASH_FALL_BACK = "flashFallBack";
    public static final String UUID_TOKEN = "uuidToken";
    public static final String COMPILEEXTFORINCLUDE = "compileextforinclude";
    public static final String NEO_SECUREPROFILE_XML = "neo-secureprofile.xml";
    public static final String PATHNAME = File.separator + "lib" + File.separator + "neo-secureprofile.xml";
    public static final String DRIVER_FILE_NAME = "neodriver";
    private String rootDir;
    private File file;
    private ConfigMap config;
    protected Map<String, SecureProfileSetting> secureSettings = new HashMap<String, SecureProfileSetting>();

    public SecureProfileHelper(String dir) {
        this.rootDir = dir;
        this.file = new File(this.rootDir + PATHNAME);
        this.setWatchFile(this.file);
    }

    public Array getAllSecureProfileSettingsInArray() {
        this.populateCurrentValues();
        Array settings = new Array();
        Object driverDefaultsNames = "";
        Object driverDefaultsValues = "";
        Object driverSecureDefaultsValues = "";
        Object driverCurrentValues = "";
        for (String key : this.secureSettings.keySet()) {
            Struct value = new Struct();
            SecureProfileSetting setting = this.secureSettings.get(key);
            if (setting.getRefNeoFile().equalsIgnoreCase(DRIVER_FILE_NAME)) {
                driverDefaultsNames = (String)driverDefaultsNames + setting.getName();
                driverDefaultsNames = (String)driverDefaultsNames + DELIM;
                driverCurrentValues = (String)driverCurrentValues + setting.getCurrentValue();
                driverCurrentValues = (String)driverCurrentValues + DELIM;
                driverDefaultsValues = (String)driverDefaultsValues + setting.getDefaultValue();
                driverDefaultsValues = (String)driverDefaultsValues + DELIM;
                driverSecureDefaultsValues = (String)driverSecureDefaultsValues + setting.getSecureDefaultValue();
                driverSecureDefaultsValues = (String)driverSecureDefaultsValues + DELIM;
                continue;
            }
            if (key.contains(".")) {
                key = key.replaceAll("\\.", "_");
            }
            value.put("name", (Object)key);
            value.put("currentdefault", (Object)setting.getCurrentValue());
            value.put("securedefault", (Object)setting.getSecureDefaultValue());
            value.put("default", (Object)setting.getDefaultValue());
            settings.add(value);
        }
        this.addDriverDefaults(settings, (String)driverDefaultsNames, (String)driverDefaultsValues, (String)driverSecureDefaultsValues, (String)driverCurrentValues);
        return settings;
    }

    private void populateCurrentValues() {
        SecureProfileOthersHelper.populateOthersSettings(this.secureSettings);
        SecureProfileRuntimeHelper.populateRuntimeSettings(this.secureSettings);
        SecureProfileSecurityHelper.populateSecuritySettings(this.secureSettings);
    }

    private void addDriverDefaults(Array settings, String driverDefaultsNames, String driverDefaultsValues, String driverSecureDefaultsValues, String driverCurrentValues) {
        Struct value = new Struct();
        if (driverDefaultsNames.endsWith(DELIM)) {
            driverDefaultsNames = driverDefaultsNames.substring(0, driverDefaultsNames.length() - 1);
        }
        if (driverSecureDefaultsValues.endsWith(DELIM)) {
            driverSecureDefaultsValues = driverSecureDefaultsValues.substring(0, driverSecureDefaultsValues.length() - 1);
        }
        if (driverDefaultsValues.endsWith(DELIM)) {
            driverDefaultsValues = driverDefaultsValues.substring(0, driverDefaultsValues.length() - 1);
        }
        if (driverCurrentValues.endsWith(DELIM)) {
            driverCurrentValues = driverCurrentValues.substring(0, driverCurrentValues.length() - 1);
        }
        value.put("name", (Object)DRIVER_DEFAULTS);
        value.put("currentdefault", (Object)driverCurrentValues);
        value.put("combinedname", (Object)driverDefaultsNames);
        value.put("securedefault", (Object)driverSecureDefaultsValues);
        value.put("default", (Object)driverDefaultsValues);
        settings.add(value);
    }

    public Set<SecureProfileSetting> getAllSecureProfileSettings() {
        HashSet<SecureProfileSetting> settings = new HashSet<SecureProfileSetting>();
        for (String key : this.secureSettings.keySet()) {
            settings.add(this.secureSettings.get(key));
        }
        return settings;
    }

    public final void enableSecureProfile() throws ServiceException {
        boolean secure = true;
        boolean store = false;
        this.setClientstoreSettings(secure, store);
        this.setWebsocketSettings(secure, store);
        this.setDriverSettings(secure, store);
        this.setDebugSettings(secure, store);
        this.setMetricSettings(secure, store);
        this.setRuntimeSettings(secure, store);
        this.setSecuritySettings(secure, store);
        this.store();
    }

    public final void enableSecureProfile(String rootAdminUser, String allowedAdminIPList) throws ServiceException {
        boolean secure = true;
        boolean store = false;
        this.setClientstoreSettings(secure, store);
        this.setWebsocketSettings(secure, store);
        this.setDriverSettings(secure, store);
        this.setDebugSettings(secure, store);
        this.setMetricSettings(secure, store);
        this.setRuntimeSettings(secure, store);
        this.setSecuritySettings(secure, store, rootAdminUser, allowedAdminIPList);
        this.store();
    }

    public final void disableSecureProfile() throws ServiceException {
        boolean secure = false;
        boolean store = false;
        this.setClientstoreSettings(secure, store);
        this.setWebsocketSettings(secure, store);
        this.setDriverSettings(secure, store);
        this.setDebugSettings(secure, store);
        this.setMetricSettings(secure, store);
        this.setRuntimeSettings(secure, store);
        this.setSecuritySettings(secure, store);
        this.store();
    }

    public final void setDriverSettings(boolean secure, boolean callStore) throws ServiceException {
        try {
            DataSourceService dsService = ServiceFactory.getDataSourceService();
            SecureProfileOthersHelper.setAllowedSQL(this.secureSettings, secure, dsService);
            if (callStore) {
                this.store();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public final void setClientstoreSettings(boolean secure, boolean callStore) throws ServiceException {
        try {
            ClientScopeService clientService = ServiceFactory.getClientScopeService();
            SecureProfileOthersHelper.setUUIDSetting(this.secureSettings, secure, clientService);
            if (callStore) {
                this.store();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public final void setWebsocketSettings(boolean secure, boolean callStore) throws ServiceException {
        try {
            WebSocketService wsService = ServiceFactory.getWebsocketService();
            if (wsService == null) {
                return;
            }
            SecureProfileOthersHelper.setFlashFallBack(this.secureSettings, secure, wsService);
            SecureProfileOthersHelper.setWSEnableSetting(this.secureSettings, secure, wsService);
            if (callStore) {
                this.store();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public final void setDebugSettings(boolean secure, boolean callStore) throws ServiceException {
        try {
            DebuggingService debugService = ServiceFactory.getDebuggingService();
            if (debugService == null) {
                return;
            }
            SecureProfileOthersHelper.setRobustEnableSetting(this.secureSettings, secure, debugService);
            if (callStore) {
                this.store();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public final void setMetricSettings(boolean secure, boolean callStore) throws ServiceException {
        try {
            MetricsService metricService = ServiceFactory.getMetricsService();
            SecureProfileOthersHelper.setCFStatEnableSetting(this.secureSettings, secure, metricService);
            if (callStore) {
                this.store();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public final void setRuntimeSettings(boolean secure, boolean callStore) throws ServiceException {
        try {
            RuntimeService runtimeService = ServiceFactory.getRuntimeService();
            SecureProfileRuntimeHelper.setPostSizeLimitSetting(this.secureSettings, secure, runtimeService);
            SecureProfileRuntimeHelper.setSessionCookieTimeoutSetting(this.secureSettings, secure, runtimeService);
            SecureProfileRuntimeHelper.setInternalCookiesDUSetting(this.secureSettings, secure, runtimeService);
            SecureProfileRuntimeHelper.setDisableServiceFactorySetting(this.secureSettings, secure, runtimeService);
            SecureProfileRuntimeHelper.setSite_wideSetting(this.secureSettings, secure, runtimeService);
            SecureProfileRuntimeHelper.setQueue_timeoutSetting(this.secureSettings, secure, runtimeService);
            SecureProfileRuntimeHelper.setMissing_templateSetting(this.secureSettings, secure, runtimeService);
            SecureProfileRuntimeHelper.setScriptprotectSetting(this.secureSettings, secure, runtimeService);
            SecureProfileRuntimeHelper.setCFIncludeAllowedSetting(this.secureSettings, secure, runtimeService);
            if (callStore) {
                this.store();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public final void setSecuritySettings(boolean secure, boolean callStore) throws ServiceException {
        try {
            SecurityService securityService = ServiceFactory.getSecurityService();
            SecureProfileSecurityHelper.setAdminUseridReqdSetting(this.secureSettings, secure, securityService);
            SecureProfileSecurityHelper.setRDSAuthEnableSetting(this.secureSettings, secure, securityService);
            SecureProfileSecurityHelper.setRDSUseSinglePwdSetting(this.secureSettings, secure, securityService);
            SecureProfileSecurityHelper.setRDSEnableSetting(this.secureSettings, secure, securityService);
            SecureProfileSecurityHelper.setAllowedIPListSetting(this.secureSettings, secure, securityService);
            SecureProfileSecurityHelper.setConcAdminLoginSetting(this.secureSettings, secure, securityService);
            SecureProfileSecurityHelper.setAdminAuthEnableSetting(this.secureSettings, secure, securityService);
            if (callStore) {
                this.store();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public final void setSecuritySettings(boolean secure, boolean callStore, String rootAdminUser, String allowedAdminIPList) throws ServiceException {
        try {
            SecurityService securityService = ServiceFactory.getSecurityService();
            SecureProfileSecurityHelper.setAdminUseridReqdSetting(this.secureSettings, secure, securityService);
            SecureProfileSecurityHelper.setRDSAuthEnableSetting(this.secureSettings, secure, securityService);
            SecureProfileSecurityHelper.setRDSUseSinglePwdSetting(this.secureSettings, secure, securityService);
            SecureProfileSecurityHelper.setRDSEnableSetting(this.secureSettings, secure, securityService);
            SecureProfileSecurityHelper.setAllowedIPListSetting(this.secureSettings, secure, securityService, allowedAdminIPList);
            SecureProfileSecurityHelper.setAdminAuthEnableSetting(this.secureSettings, secure, securityService);
            if (callStore) {
                this.store();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void handleException(Throwable e) {
        CFLogs.SECURITY_LOG.error(e);
    }

    private final void storeSettings() {
        try {
            for (String key : this.secureSettings.keySet()) {
                ConfigMap settingVals;
                SecureProfileSetting setting = this.secureSettings.get(key);
                ConfigMap neoFileVals = (ConfigMap)this.config.get(setting.getRefNeoFile());
                if (neoFileVals == null || (settingVals = (ConfigMap)neoFileVals.get(setting.getName())) == null) continue;
                settingVals.put("default", (Object)setting.getDefaultValue());
                settingVals.put("securedefault", (Object)setting.getSecureDefaultValue());
                settingVals.put("migrate", (Object)setting.getMigrate());
            }
        }
        catch (Exception e) {
            CFLogs.SECURITY_LOG.error("Error while loading secure profile settings.");
        }
    }

    public final void loadSettings(Map newConfig) {
        if (newConfig != null) {
            try {
                Set keys = newConfig.keySet();
                if (keys != null && !keys.isEmpty()) {
                    for (String key : keys) {
                        Set settings;
                        String filename = key;
                        ConfigMap values = (ConfigMap)newConfig.get(filename);
                        if (values == null || values.isEmpty() || (settings = values.keySet()) == null || settings.isEmpty()) continue;
                        for (String setting : settings) {
                            String settingName = setting;
                            ConfigMap settingValue = (ConfigMap)values.get(settingName);
                            if (settingValue == null) continue;
                            SecureProfileSetting settingObj = new SecureProfileSetting(settingName, filename, settingValue);
                            this.secureSettings.put(settingName, settingObj);
                        }
                    }
                }
            }
            catch (Exception e) {
                CFLogs.SECURITY_LOG.error("Error while loading secure profile settings.");
            }
        }
    }

    @Override
    public void load() throws ServiceException {
        try {
            ConfigMap newConfig = (ConfigMap)this.deserialize(this.file);
            if (newConfig instanceof ConfigMap) {
                this.config = newConfig;
            } else {
                this.config = new ConfigMap();
                this.config.putAll((Map)newConfig);
                this.config.setConfigMapListener(this);
            }
            this.loadSettings(this.config);
            this.removeSandBoxSecureProfileSetting();
            SecureProfileRuntimeHelper.fixQueueTimeOutSetting(this.secureSettings);
            CentralConfigClientUtil.delayStore(this);
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    @Override
    public synchronized void store() throws ServiceException {
        this.storeSettings();
        if (ServerlessUtil.isLambdaEnv() && !(this.file instanceof InMemoryFile)) {
            this.file = new InMemoryFile(this.file.getAbsolutePath(), this.file);
        }
        this.serialize(this.config, this.file);
    }

    private void removeSandBoxSecureProfileSetting() {
        SecureProfileSetting sandBoxSetting = this.secureSettings.get(SBS_SECURITY_ENABLED);
        if (sandBoxSetting != null) {
            this.secureSettings.remove(SBS_SECURITY_ENABLED);
        }
    }
}

