/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.security;

import coldfusion.runtime.Cast;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.security.SecureProfileHelper;
import coldfusion.security.SecureProfileSetting;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import java.util.Map;

public class SecureProfileRuntimeHelper
extends SecureProfileHelper {
    private static final String QUEUE_TIMEOUT_SECURE_DEFAULT = "/CFIDE/administrator/templates/request_timeout_error.htm";
    private static final String OLD_QUEUE_TIMEOUT_SECURE_DEFAULT = "/CFIDE/administrator/templates/request_timeout_error.cfm";

    public SecureProfileRuntimeHelper(String dir) {
        super(dir);
    }

    protected static void populateRuntimeSettings(Map<String, SecureProfileSetting> settings) {
        RuntimeService runtimeService = ServiceFactory.getRuntimeService();
        settings.get("scriptprotect").setCurrentValue(runtimeService.getScriptProtect());
        settings.get("missing_template").setCurrentValue(runtimeService.getMissingTemplateErrorHandler());
        settings.get("queue_timeout").setCurrentValue(runtimeService.getTimeoutErrorHandler());
        settings.get("site_wide").setCurrentValue(runtimeService.getSiteWideErrorHandler());
        settings.get("disableServiceFactory").setCurrentValue(String.valueOf(runtimeService.isServiceFactoryDisabled()));
        settings.get("internalCookiesDisableUpdate").setCurrentValue(String.valueOf(runtimeService.isCFInternalCookiesDisableUpdate()));
        settings.get("sessionCookieTimeout").setCurrentValue(String.valueOf(runtimeService.getSessionCookieTimeout() / 60));
        settings.get("postSizeLimit").setCurrentValue(String.valueOf(runtimeService.getPostSizeLimit()));
        settings.get("compileextforinclude").setCurrentValue(runtimeService.getCompileExtForInclude());
    }

    protected static void setScriptprotectSetting(Map<String, SecureProfileSetting> settings, boolean secure, RuntimeService runtimeService) {
        String newValue;
        SecureProfileSetting scriptProtectSetting = settings.get("scriptprotect");
        if (secure) {
            String oldValue = runtimeService.getScriptProtect();
            scriptProtectSetting.setDefaultValue(oldValue.toString());
            newValue = scriptProtectSetting.getSecureDefaultValue();
        } else {
            newValue = scriptProtectSetting.getDefaultValue();
        }
        runtimeService.setScriptProtect(newValue);
    }

    protected static void setMissing_templateSetting(Map<String, SecureProfileSetting> settings, boolean secure, RuntimeService runtimeService) {
        String newValue;
        SecureProfileSetting missingTempSetting = settings.get("missing_template");
        if (secure) {
            String oldValue = runtimeService.getMissingTemplateErrorHandler();
            if (oldValue != null) {
                missingTempSetting.setDefaultValue(oldValue);
                newValue = !oldValue.isEmpty() ? oldValue : missingTempSetting.getSecureDefaultValue();
            } else {
                newValue = missingTempSetting.getSecureDefaultValue();
            }
        } else {
            newValue = missingTempSetting.getDefaultValue();
        }
        runtimeService.setMissingTemplateErrorHandler(newValue);
    }

    protected static void setQueue_timeoutSetting(Map<String, SecureProfileSetting> settings, boolean secure, RuntimeService runtimeService) {
        String newValue;
        SecureProfileSetting queueTimeoutSetting = settings.get("queue_timeout");
        if (secure) {
            String oldValue = runtimeService.getTimeoutErrorHandler();
            if (oldValue != null) {
                queueTimeoutSetting.setDefaultValue(oldValue);
                newValue = !oldValue.isEmpty() ? oldValue : queueTimeoutSetting.getSecureDefaultValue();
            } else {
                newValue = queueTimeoutSetting.getSecureDefaultValue();
            }
        } else {
            newValue = queueTimeoutSetting.getDefaultValue();
        }
        runtimeService.setTimeoutErrorHandler(newValue);
    }

    protected static void fixQueueTimeOutSetting(Map<String, SecureProfileSetting> secureSettings) {
        RuntimeService runtimeService;
        SecureProfileSetting queueTimeoutSetting = secureSettings.get("queue_timeout");
        if (queueTimeoutSetting.getSecureDefaultValue().equalsIgnoreCase(OLD_QUEUE_TIMEOUT_SECURE_DEFAULT)) {
            queueTimeoutSetting.setSecureDefaultValue(QUEUE_TIMEOUT_SECURE_DEFAULT);
        }
        if ((runtimeService = ServiceFactory.getRuntimeService()).getTimeoutErrorHandler().equalsIgnoreCase(OLD_QUEUE_TIMEOUT_SECURE_DEFAULT)) {
            runtimeService.setTimeoutErrorHandler(QUEUE_TIMEOUT_SECURE_DEFAULT);
        }
    }

    protected static void setSite_wideSetting(Map<String, SecureProfileSetting> settings, boolean secure, RuntimeService runtimeService) {
        String newValue;
        SecureProfileSetting sitewideSetting = settings.get("site_wide");
        if (secure) {
            String oldValue = runtimeService.getSiteWideErrorHandler();
            if (oldValue != null) {
                sitewideSetting.setDefaultValue(oldValue);
                newValue = !oldValue.isEmpty() ? oldValue : sitewideSetting.getSecureDefaultValue();
            } else {
                newValue = sitewideSetting.getSecureDefaultValue();
            }
        } else {
            newValue = sitewideSetting.getDefaultValue();
        }
        runtimeService.setSiteWideErrorHandler(newValue);
    }

    protected static void setDisableServiceFactorySetting(Map<String, SecureProfileSetting> settings, boolean secure, RuntimeService runtimeService) {
        String newValue;
        SecureProfileSetting disableServiceFactorySetting = settings.get("disableServiceFactory");
        if (secure) {
            boolean oldValue = runtimeService.isServiceFactoryDisabled();
            disableServiceFactorySetting.setDefaultValue(String.valueOf(oldValue));
            newValue = disableServiceFactorySetting.getSecureDefaultValue();
        } else {
            newValue = disableServiceFactorySetting.getDefaultValue();
        }
        runtimeService.setServiceFactoryDisabled(Boolean.parseBoolean(newValue));
    }

    protected static void setInternalCookiesDUSetting(Map<String, SecureProfileSetting> settings, boolean secure, RuntimeService runtimeService) {
        String newValue;
        SecureProfileSetting internalCookiesDUSetting = settings.get("internalCookiesDisableUpdate");
        if (secure) {
            boolean oldValue = runtimeService.isCFInternalCookiesDisableUpdate();
            internalCookiesDUSetting.setDefaultValue(String.valueOf(oldValue));
            newValue = internalCookiesDUSetting.getSecureDefaultValue();
        } else {
            newValue = internalCookiesDUSetting.getDefaultValue();
        }
        runtimeService.setCFInternalCookiesDisableUpdate(Boolean.parseBoolean(newValue));
    }

    protected static void setSessionCookieTimeoutSetting(Map<String, SecureProfileSetting> settings, boolean secure, RuntimeService runtimeService) {
        String newValue;
        SecureProfileSetting sessionCookieTimeoutSetting = settings.get("sessionCookieTimeout");
        if (secure) {
            int oldValue = runtimeService.getSessionCookieTimeout();
            sessionCookieTimeoutSetting.setDefaultValue(String.valueOf(oldValue / 60));
            newValue = sessionCookieTimeoutSetting.getSecureDefaultValue();
        } else {
            newValue = sessionCookieTimeoutSetting.getDefaultValue();
        }
        runtimeService.setSessionCookieTimeout(Cast._int(newValue) * 60);
    }

    protected static void setPostSizeLimitSetting(Map<String, SecureProfileSetting> settings, boolean secure, RuntimeService runtimeService) {
        String newValue;
        SecureProfileSetting postSizeLimitSetting = settings.get("postSizeLimit");
        if (secure) {
            float oldValue = runtimeService.getPostSizeLimit();
            postSizeLimitSetting.setDefaultValue(String.valueOf(oldValue));
            newValue = postSizeLimitSetting.getSecureDefaultValue();
        } else {
            newValue = postSizeLimitSetting.getDefaultValue();
        }
        runtimeService.setPostSizeLimit(Float.parseFloat(newValue));
    }

    protected static void setCFIncludeAllowedSetting(Map<String, SecureProfileSetting> settings, boolean secure, RuntimeService runtimeService) {
        String newValue;
        SecureProfileSetting cfIncludeAllowedSetting = settings.get("compileextforinclude");
        if (secure) {
            String oldValue = runtimeService.getCompileExtForInclude();
            cfIncludeAllowedSetting.setDefaultValue(oldValue.toString());
            newValue = cfIncludeAllowedSetting.getSecureDefaultValue();
        } else {
            newValue = cfIncludeAllowedSetting.getDefaultValue();
        }
        ((RuntimeServiceImpl)runtimeService).setCompileExtForInclude(newValue);
    }
}

