/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.security;

import coldfusion.security.SecureProfileHelper;
import coldfusion.security.SecureProfileSetting;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceFactory;
import java.util.Map;

public class SecureProfileSecurityHelper
extends SecureProfileHelper {
    public SecureProfileSecurityHelper(String dir) {
        super(dir);
    }

    protected static void populateSecuritySettings(Map<String, SecureProfileSetting> settings) {
        SecurityService securityService = ServiceFactory.getSecurityService();
        settings.get("allowedAdminIPList").setCurrentValue(securityService.getAllowedAdminIPList());
        settings.get("rds.enabled").setCurrentValue(String.valueOf(securityService.isRdsEnabled()));
        settings.get("rds.security.usesinglerdspassword").setCurrentValue(String.valueOf(securityService.getUseSingleRdsPassword()));
        settings.get("rds.security.enabled").setCurrentValue(String.valueOf(securityService.isRdsSecurityEnabled()));
        settings.get("admin.userid.required").setCurrentValue(String.valueOf(securityService.isAdminUserIdRequired()));
        settings.get("admin.security.enabled").setCurrentValue(String.valueOf(securityService.isAdminSecurityEnabled()));
        settings.get("allowconcurrentadminlogin").setCurrentValue(String.valueOf(securityService.isAllowConcurrentAdminLogin()));
    }

    protected static void setAllowedIPListSetting(Map<String, SecureProfileSetting> settings, boolean secure, SecurityService securityService) {
        String newValue;
        SecureProfileSetting allowAdminIPListSetting = settings.get("allowedAdminIPList");
        if (secure) {
            String oldValue = securityService.getAllowedAdminIPList();
            allowAdminIPListSetting.setDefaultValue(String.valueOf(oldValue));
            newValue = allowAdminIPListSetting.getSecureDefaultValue();
        } else {
            newValue = allowAdminIPListSetting.getDefaultValue();
        }
        securityService.setAllowedAdminIPList(newValue);
    }

    protected static void setAllowedIPListSetting(Map<String, SecureProfileSetting> settings, boolean secure, SecurityService securityService, String allowAdminIPList) {
        String newValue;
        SecureProfileSetting allowAdminIPListSetting = settings.get("allowedAdminIPList");
        if (secure) {
            String oldValue = securityService.getAllowedAdminIPList();
            allowAdminIPListSetting.setDefaultValue(String.valueOf(oldValue));
            if (allowAdminIPList != null && !allowAdminIPList.isEmpty()) {
                newValue = allowAdminIPList;
                allowAdminIPListSetting.setSecureDefaultValue(allowAdminIPList);
            } else {
                newValue = allowAdminIPListSetting.getSecureDefaultValue();
            }
        } else {
            newValue = allowAdminIPListSetting.getDefaultValue();
        }
        securityService.setAllowedAdminIPList(newValue);
    }

    protected static void setRDSEnableSetting(Map<String, SecureProfileSetting> settings, boolean secure, SecurityService securityService) {
        String newValue;
        SecureProfileSetting rdsEnableSetting = settings.get("rds.enabled");
        if (secure) {
            boolean oldValue = securityService.isRdsEnabled();
            rdsEnableSetting.setDefaultValue(String.valueOf(oldValue));
            newValue = rdsEnableSetting.getSecureDefaultValue();
        } else {
            newValue = rdsEnableSetting.getDefaultValue();
        }
        securityService.setRdsEnabled(Boolean.parseBoolean(newValue));
    }

    protected static void setRDSUseSinglePwdSetting(Map<String, SecureProfileSetting> settings, boolean secure, SecurityService securityService) {
        String newValue;
        SecureProfileSetting rdsUserIdReqdSetting = settings.get("rds.security.usesinglerdspassword");
        if (secure) {
            boolean oldValue = securityService.getUseSingleRdsPassword();
            rdsUserIdReqdSetting.setDefaultValue(String.valueOf(oldValue));
            newValue = rdsUserIdReqdSetting.getSecureDefaultValue();
        } else {
            newValue = rdsUserIdReqdSetting.getDefaultValue();
        }
        securityService.setUseSingleRdsPassword(Boolean.parseBoolean(newValue));
    }

    protected static void setRDSAuthEnableSetting(Map<String, SecureProfileSetting> settings, boolean secure, SecurityService securityService) {
        String newValue;
        SecureProfileSetting rdsAuthEnableSetting = settings.get("rds.security.enabled");
        if (secure) {
            boolean oldValue = securityService.isRdsSecurityEnabled();
            rdsAuthEnableSetting.setDefaultValue(String.valueOf(oldValue));
            newValue = rdsAuthEnableSetting.getSecureDefaultValue();
        } else {
            newValue = rdsAuthEnableSetting.getDefaultValue();
        }
        securityService.setRdsSecurityEnabled(Boolean.parseBoolean(newValue));
    }

    protected static void setAdminUseridReqdSetting(Map<String, SecureProfileSetting> settings, boolean secure, SecurityService securityService) {
        String newValue;
        SecureProfileSetting adminUserIdReqdSetting = settings.get("admin.userid.required");
        if (secure) {
            boolean oldValue = securityService.isAdminUserIdRequired();
            adminUserIdReqdSetting.setDefaultValue(String.valueOf(oldValue));
            newValue = adminUserIdReqdSetting.getSecureDefaultValue();
        } else {
            newValue = adminUserIdReqdSetting.getDefaultValue();
        }
        securityService.setAdminUserIdRequired(Boolean.parseBoolean(newValue));
    }

    protected static void setAdminAuthEnableSetting(Map<String, SecureProfileSetting> settings, boolean secure, SecurityService securityService) {
        String newValue;
        SecureProfileSetting adminAuthEnableSetting = settings.get("admin.security.enabled");
        if (secure) {
            boolean oldValue = securityService.isAdminSecurityEnabled();
            adminAuthEnableSetting.setDefaultValue(String.valueOf(oldValue));
            newValue = adminAuthEnableSetting.getSecureDefaultValue();
        } else {
            newValue = adminAuthEnableSetting.getDefaultValue();
        }
        securityService.setAdminSecurityEnabled(Boolean.parseBoolean(newValue));
    }

    protected static void setConcAdminLoginSetting(Map<String, SecureProfileSetting> settings, boolean secure, SecurityService securityService) {
        String newValue;
        SecureProfileSetting ConcAdminLoginSetting = settings.get("allowconcurrentadminlogin");
        if (secure) {
            boolean oldValue = securityService.isAllowConcurrentAdminLogin();
            ConcAdminLoginSetting.setDefaultValue(String.valueOf(oldValue));
            newValue = ConcAdminLoginSetting.getSecureDefaultValue();
        } else {
            newValue = ConcAdminLoginSetting.getDefaultValue();
        }
        securityService.setAllowConcurrentAdminLogin(Boolean.parseBoolean(newValue));
    }
}

