/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.security;

import coldfusion.Version;
import coldfusion.centralconfig.client.CentralConfigClientUtil;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.osgi.services.SamlService;
import coldfusion.rds.Encryptor;
import coldfusion.runtime.AppHelper;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Array;
import coldfusion.runtime.CFDummyComponent;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.FunctionPermission;
import coldfusion.runtime.LockManager;
import coldfusion.runtime.MD5;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.RequestMonitor;
import coldfusion.runtime.Scope;
import coldfusion.runtime.SecurityScopeTracker;
import coldfusion.runtime.SecurityTable;
import coldfusion.runtime.SessionScope;
import coldfusion.runtime.Struct;
import coldfusion.security.AuthorizedUser;
import coldfusion.security.BasicPolicy;
import coldfusion.security.ClientCertAuthenticationMappingConfig;
import coldfusion.security.ESAPIUtils;
import coldfusion.security.RolesStore;
import coldfusion.security.SecureProfileHelper;
import coldfusion.security.SecureProfileSetting;
import coldfusion.security.SecurityUtils;
import coldfusion.security.UserUtils;
import coldfusion.security.admin.ExternalLoginScheme;
import coldfusion.security.admin.LdapQuery;
import coldfusion.server.ConfigMap;
import coldfusion.server.RuntimeService;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.ServiceRuntimeException;
import coldfusion.server.SystemInfo;
import coldfusion.server.j2ee.SecurityHelper;
import coldfusion.serverless.InMemoryFile;
import coldfusion.serverless.InMemoryOutputStream;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.sql.DataSourcePermission;
import coldfusion.tagext.GenericTagPermission;
import coldfusion.tagext.io.cache.CacheTO;
import coldfusion.tagext.io.cache.GenericCache;
import coldfusion.tagext.io.cache.GenericCacheFactory;
import coldfusion.tagext.lang.IncludeTag;
import coldfusion.tagext.lang.ModulePermission;
import coldfusion.util.FastHashtable;
import coldfusion.util.FileLock;
import coldfusion.util.PasswordUtils;
import coldfusion.util.RB;
import coldfusion.util.UUIDUtils;
import coldfusion.vfs.VFilePermission;
import coldfusion.wddx.Base64Encoder;
import jakarta.servlet.ServletContext;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.Tag;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.SerializablePermission;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ReflectPermission;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecurityPermission;
import java.sql.SQLPermission;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.LoggingPermission;
import javax.management.MBeanPermission;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.NotificationScope;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.ServicePermission;

public final class SecurityManager
extends ServiceBase
implements SecurityService,
Observer {
    private static final String DIGEST_NTLM = ":DIGEST-NTLM";
    private static final String COMMA = ",";
    private static final String SALT = "salt";
    private static final String ADMIN_USERID_ROOT_SALT = "admin.userid.root.salt";
    private String rootDir;
    public static final String tokenSeparator = "\r";
    private static Logger logger = CFLogs.SERVER_LOG;
    private ServletContext servletContext;
    private static final int AUTH_TIMETOREFRESH = Integer.getInteger("coldfusion.security.cflogin.token.refresh", 20) * 60 * 1000;
    private static final int AUTH_TOKEN_MAPPING_TIMETOLIVE = 60;
    private static final String AUTH_CACHE_NAME = "authcache";
    private static final String AUTH_TOKEN_MAPPING_CACHE_NAME = "authtokenmappingcache";
    private static final String DISABLE_TOKEN_MAPPING_CACHE_PROPERTY = "coldfusion.security.disabletokenmappingcache";
    private static final String SEP = ":";
    private static final String USERNAME_REGEX = "^[\\p{Alnum}_]{5,20}$";
    private static final String EMAIL_REGEX = "^[a-zA-Z0-9_!#$%&\u00e2\u0080\u0099*+/=?`{|}~^.-]+@[a-zA-Z0-9.-]+$";
    private static final String BASIC_EMAIL_REGEX = "^(.+)@(.+)$";
    private static final String FIXED_PASSWORD_SALT = "5B26F9D88AC0A9BEA1D79BFB870054D5";
    private static final String FIXED_PASSWORD = "161E78A348E0F8219C40736F9DAD3CFC12B45A137F94E9CA0CE8DEF2CC1B2544";
    private final SecureProfileHelper spHelper;
    private static ThreadLocal<SecurityState> authenticated = new ThreadLocal();
    private static final LockManager lockManager = LockManager.get();
    private static ExternalAuth extAuth = ExternalAuth.NONE;
    private File file;
    private SecurityHelper helper;
    private ConfigMap contexts;
    private ConfigMap config;
    private FastHashtable AuthorizedUsers;
    private String allowedIPList;
    private HashMap CompiledCrossSiteScriptPatterns = new HashMap();
    PatternCompiler compiler = new Perl5Compiler();
    private Map ldapConfig;
    private HashMap permissions = new HashMap();
    HashMap samlConfig = new HashMap();
    private File customRolesFile;
    private File password_file;
    private InMemoryFile imf;
    private String password;
    private String rdspassword;
    private boolean isEncrypted;
    private String rootSalt;
    private boolean jvmSecurityEnabled = false;
    private boolean _sbsEnabled = false;
    private boolean adminSecurityEnabled = true;
    private boolean isSecureProfile = false;
    private boolean rdsSecurityEnabled = true;
    private boolean rdsEnabled = true;
    private boolean useSingleRdsPassword = true;
    private final String OLDSEEDVAL = "0yJ!@1$r8p0L@r1$6yJ!@1rj";
    private long passwordLastModified = 0L;
    private long customRolesLastModified = 0L;
    private String seed;
    private BasicPolicy basic_policy;
    private boolean allowConcurrentAdminLogin = true;
    private boolean adminUserIdRequired = false;
    private String allowedAdminIPList;
    private String rootAdminUserId = null;
    private RolesStore rolesStore = new RolesStore();
    private static CacheManager ehcacheCacheMngr = null;
    private ClientCertAuthenticationMappingConfig ccaMappingConfig;
    private String cfAdminCookieIdentifier;
    public static final Permission FILE_EXISTS = new FunctionPermission("fileexists");
    public static final Permission FILE_COPY = new FunctionPermission("filecopy");
    public static final Permission FILE_MOVE = new FunctionPermission("filemove");
    public static final Permission FILE_DELETE = new FunctionPermission("filedelete");
    public static final Permission FILE_OPEN = new FunctionPermission("fileopen");
    public static final Permission FILE_READ = new FunctionPermission("fileread");
    public static final Permission FILE_WRITE = new FunctionPermission("filewrite");
    public static final Permission FILE_UPLOAD = new FunctionPermission("fileupload");
    public static final Permission FILE_UPLOADALL = new FunctionPermission("fileuploadall");
    public static final Permission FILE_SET_ATTRIBUTE = new FunctionPermission("filesetattribute");
    public static final Permission FILE_SET_ACCESSMODE = new FunctionPermission("filesetaccessmode");
    public static final Permission FILE_SET_LASTMODIFIED = new FunctionPermission("filesetlastmodified");
    public static final Permission FILE_GET_INFO = new FunctionPermission("getfileinfo");
    public static final Permission DIR_CREATE = new FunctionPermission("directorycreate");
    public static final Permission DIR_COPY = new FunctionPermission("directorycopy");
    public static final Permission DIR_LIST = new FunctionPermission("directorylist");
    public static final Permission DIR_DELETE = new FunctionPermission("directorydelete");
    public static final Permission DIR_RENAME = new FunctionPermission("directoryrename");
    public static final Permission DIR_EXISTS = new FunctionPermission("directoryexists");
    public static final Permission GET_PROPERTY_FILE = new FunctionPermission("getpropertyfile");
    public static final Permission GET_PROPERTY_STRING = new FunctionPermission("getpropertystring");
    public static final Permission SET_PROPERTY_STRING = new FunctionPermission("setpropertystring");
    public static final Permission EXP_PATH = new FunctionPermission("expandpath");
    public static final Permission DIR_FROM_PATH = new FunctionPermission("getdirectoryfrompath");
    public static final Permission FILE_FROM_PATH = new FunctionPermission("getfilefrompath");
    public static final Permission TEMP_DIR = new FunctionPermission("gettempdirectory");
    public static final Permission TEMP_FILE = new FunctionPermission("gettempfile");
    public static final Permission BASE_TEMPLATE_PATH = new FunctionPermission("getbasetemplatepath");
    public static final Permission SET_PROFILE_STRING = new FunctionPermission("setprofilestring");
    public static final Permission GET_PROFILE_STRING = new FunctionPermission("getprofilestring");
    public static final Permission CREATE_OBJECT = new FunctionPermission("createobject");
    public static final Permission CREATE_COM_OBJECT = new FunctionPermission("createobject(com)");
    public static final Permission CREATE_JAVA_OBJECT = new FunctionPermission("createobject(java)");
    public static final Permission CREATE_WS_OBJECT = new FunctionPermission("createobject(webservice)");
    public static final Permission CREATE_CORBA_OBJECT = new FunctionPermission("createobject(corba)");
    public static final Permission CREATE_DOTNET_OBJECT = new FunctionPermission("createobject(.net)");
    public static final Permission SEND_GATEWAY_MESSAGE = new FunctionPermission("sendgatewaymessage");
    public static final Permission GET_GATEWAY_HELPER = new FunctionPermission("getgatewayhelper");
    public static final Permission GET_PRINTER_INFO = new FunctionPermission("getprinterinfo");
    public static final Permission CREATE_DYNAMICPROXY = new FunctionPermission("createdynamicproxy");
    public static final Permission CACHE_PUT = new FunctionPermission("cacheput");
    public static final Permission CACHE_GET = new FunctionPermission("cacheget");
    public static final Permission CACHE_GET_METADATA = new FunctionPermission("cachegetmetadata");
    public static final Permission CACHE_GET_ALL_IDS = new FunctionPermission("cachegetallids");
    public static final Permission CACHE_REMOVE = new FunctionPermission("cacheremove");
    public static final Permission CACHE_SET_PROPERTIES = new FunctionPermission("cachesetproperties");
    public static final Permission CACHE_GET_PROPERTIES = new FunctionPermission("cachegetproperties");
    public static final Permission CACHE_GET_SESSION = new FunctionPermission("cachegetsession");
    public static final Permission CACHE_REGION_NEW = new FunctionPermission("cacheregionnew");
    public static final Permission CACHE_REGION_EXISTS = new FunctionPermission("cacheregionexists");
    public static final Permission CACHE_EXISTS = new FunctionPermission("cacheidexists");
    public static final Permission CACHE_REMOVE_ALL = new FunctionPermission("cacheremoveall");
    public static final Permission CACHE_REGION_REMOVE = new FunctionPermission("cacheregionremove");
    public static final Permission REMOVE_CACHED_QUERY = new FunctionPermission("removecachedquery");
    public static final Permission GET_SYSTEMFREEMEMORY = new FunctionPermission("getsystemfreememory");
    public static final Permission GET_SYSTEMTOTALMEMORY = new FunctionPermission("getsystemtotalmemory");
    public static final Permission GET_CPUUSAGE_DEFAULT = new FunctionPermission("getcpuusage");
    public static final Permission GET_TOTAL_SPACE = new FunctionPermission("gettotalspace");
    public static final Permission GET_FREE_SPACE = new FunctionPermission("getfreespace");
    public static final Permission GET_PAGE_CONTEXT = new FunctionPermission("getpagecontext");
    public static final Permission IS_LOCALHOST = new FunctionPermission("islocalhost");
    public static final Permission OBJECT_SAVE = new FunctionPermission("objectsave");
    public static final Permission OBJECT_LOAD = new FunctionPermission("objectload");
    public static final Permission GET_CLOUD_SERVICE = new FunctionPermission("getcloudservice");
    public static final Permission MONGO_SERVICE = new FunctionPermission("getmongoservice");
    public static final Permission ALLOW_JAVA_NATIVE_CALLS = new RuntimePermission("allowNativeJavaBlocks");
    static final String CF_ROLES_FILE = "coldfusion/security/roles.properties";
    public static final String CUSTOM_ROLES_FILE = "customroles.properties";
    static final String RB_CUSTOM_ROLES = "customrolenames";
    public static final String ROLE_ADMINISTRATOR = "coldfusion.administrator";
    public static final String ROLE_RDS = "coldfusion.rds";
    public static final String ROLE_ADMINAPI = "coldfusion.adminapi";
    static final String DEFAULT_ROOT_ADMIN_USER_ID = "admin";
    private static final boolean clientCertAuthEnabled = Boolean.getBoolean("coldfusion.security.admin.clientcert.auth");
    private static final String ADMIN_CLIENT_CERT_USE_CGI = "coldfusion.security.admin.clientcert.usecgi";
    private static final String ADMIN_CLIENT_CERT_SUBJECT_HEADER = "coldfusion.security.admin.clientcert.subject.header";
    private static final String ADMIN_CLIENT_CERT_SUBJECT_MATCH_CRITERIA = "coldfusion.security.admin.clientcert.subject.matchcriteria";
    private static final String ADMIN_CLIENT_CERT_SUBJECT_EXACT_CRITERIA = "exact";
    private static final String ADMIN_CLIENT_CERT_SUBJECT_CNMATCH_CRITERIA = "cn";
    private static final String ADMIN_CLIENT_CERT_CGI_SUBJECT_HEADER = "CERT_SUBJECT";
    private static final boolean rootAdminClientCertAuthEnabled = Boolean.valueOf(System.getProperty("coldfusion.security.rootadmin.clientcert.auth", String.valueOf(clientCertAuthEnabled)));
    private static final boolean IS_ADMIN_BEHIND_VIRTUAL_DIR = Boolean.getBoolean("coldfusion.admin.isbehindvdir");
    private static final String subjectFormat = System.getProperty("coldfusion.security.admin.clientcert.subject.matchcriteria", "exact");
    private static final String tmpRoot = System.getProperty("coldfusion.temp.dir");
    private static final int USER_SALT_SIZE = 16;
    private final int SEED_VALUE_SIZE = 24;
    private static CacheConfiguration auth_cache_config;
    private static CacheConfiguration auth_tokn_mapping_cache_config;
    private Map<String, GenericCache> cacheMgrMap = new HashMap<String, GenericCache>();
    private ExternalLoginScheme loginScheme = null;
    private static String slash;
    private static String[] admin_pages;
    private static String[] adminapi_cfcs;

    public SecurityManager(File f, File password_file, File customRolesFile, String rootDir, SecurityHelper helper, ServletContext servletContext) {
        this.file = f;
        this.password_file = password_file;
        this.customRolesFile = customRolesFile;
        this.rootDir = rootDir;
        this.helper = helper;
        this.servletContext = servletContext;
        this.setWatchFile(this.file);
        this.setWatchFile(password_file);
        this.setWatchFile(customRolesFile);
        this.spHelper = new SecureProfileHelper(rootDir);
    }

    @Override
    public final Map getContexts() {
        return this.contexts;
    }

    @Override
    public final BasicPolicy getBasicPolicy() {
        return this.basic_policy;
    }

    @Override
    public final boolean isJvmSecurityEnabled() {
        return System.getSecurityManager() != null;
    }

    @Override
    public final void setSandboxSecurityEnabled(boolean b) {
        this.authenticateAdmin();
        this._sbsEnabled = b;
        this.config.put("sbs.security.enabled", (Object)(b ? Boolean.TRUE : Boolean.FALSE));
    }

    @Override
    public final boolean isSandboxSecurityEnabled() {
        return this._sbsEnabled;
    }

    @Override
    public final void checkPermission(Permission perm) {
        boolean bool;
        boolean bl = bool = this._sbsEnabled && perm != null && this.isJvmSecurityEnabled();
        if (bool) {
            AccessController.checkPermission(perm);
        }
    }

    @Override
    public final boolean isAdminSecurityEnabled() {
        return this.adminSecurityEnabled;
    }

    @Override
    public final boolean isRdsSecurityEnabled() {
        return this.rdsSecurityEnabled;
    }

    @Override
    public boolean isRdsEnabled() {
        return this.rdsEnabled;
    }

    @Override
    public final boolean isAdminUserIdRequired() {
        return this.adminUserIdRequired;
    }

    @Override
    public final boolean isAdminClientCertAuthEnabled() {
        return clientCertAuthEnabled;
    }

    @Override
    public final String getRootAdminUserId() {
        return this.rootAdminUserId;
    }

    @Override
    public final void setAdminUserIdRequired(boolean b) {
        this.authenticateAdmin();
        this.adminUserIdRequired = b;
        this.config.put("admin.userid.required", (Object)(b ? Boolean.TRUE : Boolean.FALSE));
    }

    @Override
    public final List getAllAdminRoles() {
        this.authenticateAdmin();
        List rolesList = this.rolesStore.getAllRoles();
        rolesList.remove("coldfusion.admindefault");
        return rolesList;
    }

    @Override
    public final String getL10NRoleName(String role, String locale) {
        String roleName = null;
        Locale lc = new Locale(locale);
        try {
            roleName = RB.getMessage(this, "rolenames", lc, role, null);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (roleName == null) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(RB_CUSTOM_ROLES, lc);
                if (bundle != null) {
                    roleName = bundle.getString(role);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (roleName == null) {
            roleName = role;
        }
        return roleName;
    }

    @Override
    public final void setUseSingleRdsPassword(boolean b) {
        this.authenticateAdmin();
        this.useSingleRdsPassword = b;
        this.config.put("rds.security.usesinglerdspassword", (Object)(b ? Boolean.TRUE : Boolean.FALSE));
    }

    @Override
    public final boolean getUseSingleRdsPassword() {
        return this.useSingleRdsPassword;
    }

    @Override
    public final void setAdminSecurityEnabled(boolean b) {
        this.authenticateAdmin();
        this.adminSecurityEnabled = b;
        this.config.put("admin.security.enabled", (Object)(b ? Boolean.TRUE : Boolean.FALSE));
    }

    @Override
    public final void setRdsSecurityEnabled(boolean b) {
        this.authenticateAdmin();
        this.rdsSecurityEnabled = b;
        this.config.put("rds.security.enabled", (Object)String.valueOf(b));
    }

    @Override
    public final void setRdsEnabled(boolean b) {
        this.authenticateAdmin();
        this.rdsEnabled = b;
        this.config.put("rds.enabled", (Object)String.valueOf(b));
    }

    private void savePasswordFile() {
        boolean isFileLock;
        try {
            RuntimeService runtime = ServiceFactory.getRuntimeService();
            isFileLock = runtime.isFileLockEnabled();
        }
        catch (Exception e) {
            isFileLock = false;
        }
        if (!isFileLock || ServerlessUtil.isLambdaEnv()) {
            this.savePasswordFileWithoutLock();
        } else {
            this.savePasswordFileWithLock();
        }
    }

    private void savePasswordFileWithoutLock() {
        Properties p = new Properties();
        if (this.isEncrypted) {
            p.put("encrypted", "true");
        } else {
            p.put("encrypted", "false");
        }
        p.put("password", this.password);
        p.put("rdspassword", this.rdspassword);
        FileOutputStream passwordOut = null;
        try {
            if (ServerlessUtil.isLambdaEnv()) {
                if (this.imf == null) {
                    this.imf = new InMemoryFile(this.password_file.getAbsolutePath(), this.file);
                }
                InMemoryOutputStream ios = new InMemoryOutputStream(this.imf);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                p.store(bos, null);
                ios.write(bos.toByteArray());
                bos.close();
                ios.close();
            } else {
                passwordOut = new FileOutputStream(this.password_file);
                p.store(passwordOut, null);
            }
        }
        catch (Exception ex) {
            throw new ServiceRuntimeException(ex);
        }
        finally {
            if (passwordOut != null) {
                try {
                    passwordOut.close();
                    this.passwordLastModified = this.password_file.lastModified();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void savePasswordFileWithLock() {
        FileLock fileLock = new FileLock(this.password_file.getParent(), this.password_file.getName());
        try {
            fileLock.obtain();
            this.savePasswordFileWithoutLock();
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
        finally {
            fileLock.release();
        }
    }

    @Override
    public final HashMap getCompiledCrossSiteScriptPatterns() {
        return this.CompiledCrossSiteScriptPatterns;
    }

    @Override
    public final void setSeed(String seedValue) throws Exception {
        this.authenticateAdmin();
        PasswordUtils.getInstance().setSeed(seedValue);
    }

    @Override
    public final void setAdminPassword(String p) {
        this.setAdminPassword(p, false);
    }

    public final void setAdminPassword(String p, boolean isHashed) {
        this.authenticateAdmin();
        if (this.isRootAdminUser()) {
            try {
                String storedPassword = this.getAdminPassword(this.getRootAdminUserId());
                String hashedPassword = null;
                hashedPassword = isHashed ? SecurityUtils.hash(p, "SHA-256", "", this.rootSalt) : SecurityUtils.hash(SecurityUtils.hash(p, "SHA-1", "", ""), "SHA-256", "", this.rootSalt);
                if (storedPassword.equals(hashedPassword)) {
                    return;
                }
                String rootSaltTemp = this.getNewSalt();
                String passwordTemp = isHashed ? SecurityUtils.hash(p, "SHA-256", "", rootSaltTemp) : SecurityUtils.hash(SecurityUtils.hash(p, "SHA-1", "", ""), "SHA-256", "", rootSaltTemp);
                this.config.put(ADMIN_USERID_ROOT_SALT, (Object)rootSaltTemp);
                this.rootSalt = rootSaltTemp;
                this.password = passwordTemp;
                this.savePasswordFile();
            }
            catch (IOException ex) {
                logger.error("Unable to write password file", ex);
            }
        } else {
            AuthorizedUser user = this.getAuthorizedUser(UserUtils.getAuthUserInternal(), true, false);
            user.password = p;
            this.setAuthorizedUser(user, isHashed);
        }
    }

    private String getRootAdminPassword() {
        return this.password;
    }

    private String getAdminPassword(String userId) {
        String adminPassword = null;
        if (userId.equalsIgnoreCase(this.rootAdminUserId)) {
            adminPassword = this.getRootAdminPassword();
        } else if (this.isAuthorizedUser(userId)) {
            AuthorizedUser user = this.getAuthorizedUser(userId, true, false);
            adminPassword = user.password;
        }
        return adminPassword;
    }

    @Override
    public final void setRdsPassword(String p) {
        this.authenticateAdmin();
        this.rdspassword = this.encryptPassword(p);
        this.savePasswordFile();
    }

    @Override
    public final boolean isRdsPasswordSet() {
        return this.rdspassword.length() > 0;
    }

    @Override
    public final boolean checkAdminPassword(String p) {
        return this.checkAdminUserIdPassword(this.rootAdminUserId, p);
    }

    @Override
    public final boolean checkAdminPassword(String p, boolean isHashed) {
        return this.checkAdminUserIdPassword(this.rootAdminUserId, p, false, isHashed);
    }

    @Override
    public final boolean checkAdminUserIdPassword(String userId, String p) {
        return this.checkAdminUserIdPassword(userId, p, false, false);
    }

    @Override
    public final boolean checkAdminUserIdPassword(String userId, String p, boolean isHashed) {
        return this.checkAdminUserIdPassword(userId, p, false, isHashed);
    }

    private final boolean checkAdminUserIdPassword(String userId, String p, boolean isInternal, boolean isHashed) {
        if (!this.isAdminUserIdRequired()) {
            if (userId == null || userId.equals("")) {
                userId = this.rootAdminUserId;
            } else if (!userId.equalsIgnoreCase(this.rootAdminUserId)) {
                return false;
            }
        }
        return this.checkUserIdPassword(userId, p, isInternal, isHashed);
    }

    @Override
    public final boolean checkRDSUserIdPassword(String userId, String password) {
        return this.checkRDSUserIdPassword(userId, password, true);
    }

    @Override
    public final boolean checkRDSUserIdPassword(String userId, String password, boolean validateAdmin) {
        if (userId == null || userId.equalsIgnoreCase(this.rootAdminUserId)) {
            boolean isValid = this.checkRdsPassword(password);
            if (!isValid) {
                try {
                    String dp = Encryptor.decrypt(password);
                    isValid = this.checkRdsPassword(dp);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!isValid && validateAdmin) {
                isValid = this.checkAdminPassword(password);
            }
            return isValid;
        }
        return this.checkUserIdPassword(userId, password);
    }

    private boolean checkUserIdPassword(String userId, String password) {
        return this.checkUserIdPassword(userId, password, false);
    }

    private boolean checkUserIdPassword(String userId, String password, boolean isInternal) {
        return this.checkUserIdPassword(userId, password, isInternal, false);
    }

    private boolean checkUserIdPassword(String userId, String password, boolean isInternal, boolean isHashed) {
        if (password == null || userId == null) {
            return false;
        }
        String storedPassword = null;
        String salt = "";
        if (userId.equalsIgnoreCase(this.rootAdminUserId)) {
            storedPassword = this.getRootAdminPassword();
            salt = this.rootSalt;
        } else {
            try {
                AuthorizedUser user = this.getAuthorizedUser(userId, true, false);
                storedPassword = user.password;
                salt = user.salt;
            }
            catch (AuthorizedUserNotFound user) {
                // empty catch block
            }
        }
        if (storedPassword == null || storedPassword.isEmpty()) {
            storedPassword = FIXED_PASSWORD;
            salt = FIXED_PASSWORD_SALT;
        }
        if (isInternal && storedPassword.equals(password)) {
            return true;
        }
        try {
            String hashedPassword;
            String hashedPwd;
            if (isHashed ? storedPassword.equals(hashedPwd = SecurityUtils.hash(password, "SHA-256", "", salt)) : storedPassword.equals(hashedPassword = SecurityUtils.hash(SecurityUtils.hash(password, "SHA-1", "", ""), "SHA-256", "", salt))) {
                return true;
            }
        }
        catch (IOException ex) {
            return false;
        }
        return false;
    }

    @Override
    public String checkAdminUserClientCertificate() {
        return this.authenticateUsingClientCert(FusionContext.getCurrent());
    }

    @Override
    public final boolean isAdminUser() {
        String adminHash = this.getAdminPassword(UserUtils.getAuthUserInternal());
        if (adminHash == null) {
            adminHash = "";
        }
        return UserUtils.isUserInRoleInternal("CFAdmin" + adminHash);
    }

    @Override
    public final boolean isRootAdminUser() {
        return UserUtils.getAuthUserInternal().equals(this.getRootAdminUserId()) && this.isAdminUser();
    }

    @Override
    public final boolean checkRdsPassword(String p) {
        if (p != null && p.length() > 0) {
            try {
                return p.equals(this.decryptPassword(this.rdspassword));
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private String encryptPassword(String p) {
        if (p != null && p.length() > 0) {
            return PasswordUtils.encryptPassword(p, this.seed);
        }
        return p;
    }

    private String decryptPassword(String p) {
        if (p != null && p.length() > 0) {
            return PasswordUtils.decryptPassword(p, this.seed);
        }
        return p;
    }

    @Override
    public String decryptLdapBindPassword(String password) {
        return PasswordUtils.decryptPassword(password, this.seed);
    }

    @Override
    public final boolean checkAuthorizedUsers(String username, String password) {
        String pwd;
        AuthorizedUser user = this.getAuthorizedUser(username, true, false);
        try {
            pwd = SecurityUtils.hash(SecurityUtils.hash(password, "SHA-1", "", ""), "SHA-256", "", user.salt);
        }
        catch (IOException ex) {
            return false;
        }
        return user.username.equalsIgnoreCase(username) && user.password.equals(pwd);
    }

    @Override
    public final List getRoles(String adminUserId) {
        AuthorizedUser user = this.getAuthorizedUser(adminUserId, false, false);
        return user.roles;
    }

    public final FastHashtable getAuthorizedUsers() {
        FastHashtable toReturnAuthorizedUsers;
        this.authenticateAdmin();
        try {
            toReturnAuthorizedUsers = (FastHashtable)this.AuthorizedUsers.duplicate(null);
        }
        catch (IllegalAccessException e) {
            return this.AuthorizedUsers;
        }
        Set usernames = toReturnAuthorizedUsers.keySet();
        if (usernames != null && !usernames.isEmpty()) {
            for (String uname : usernames) {
                Map userDetails = (Map)toReturnAuthorizedUsers.get(uname);
                userDetails.remove(SALT);
            }
        }
        return toReturnAuthorizedUsers;
    }

    @Override
    public boolean isAuthorizedUser(String username) {
        boolean flag = false;
        if (this.AuthorizedUsers.containsKey(username)) {
            flag = true;
        }
        return flag;
    }

    public boolean isInternalUser(String username) {
        if (this.getRootAdminUserId().equals(username)) {
            return true;
        }
        try {
            AuthorizedUser user = this.getAuthorizedUser(username);
            if (!user.isLdap && !user.isSaml) {
                return true;
            }
        }
        catch (AuthorizedUserNotFound authorizedUserNotFound) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String getUserType(String username) {
        this.authenticateAdmin();
        try {
            AuthorizedUser user = this.getAuthorizedUser(username);
            if (!user.isLdap && !user.isSaml) {
                return "Regular User";
            }
            if (user.isLdap && !user.isGroup) {
                return "LDAP User";
            }
            if (user.isLdap) {
                return "LDAP Group";
            }
            if (user.isSaml && !user.isGroup) {
                return "SAML User";
            }
            return "SAML Group";
        }
        catch (AuthorizedUserNotFound e) {
            throw new AuthorizedUserNotFound(username);
        }
    }

    @Override
    public final AuthorizedUser getAuthorizedUser(String username) throws AuthorizedUserNotFound {
        return this.getAuthorizedUser(username, false, false);
    }

    private final AuthorizedUser getAuthorizedUser(String username, boolean needSalt, boolean detailSandboxes) throws AuthorizedUserNotFound {
        if (this.AuthorizedUsers.containsKey(username)) {
            AuthorizedUser authUser = new AuthorizedUser((Map)this.AuthorizedUsers.get(username), detailSandboxes);
            if (!needSalt) {
                authUser.salt = null;
            }
            return authUser;
        }
        throw new AuthorizedUserNotFound(username);
    }

    @Override
    public final AuthorizedUser getAuthorizedUser(String username, boolean detailSandboxes) throws AuthorizedUserNotFound {
        if (this.AuthorizedUsers.containsKey(username)) {
            AuthorizedUser authUser = new AuthorizedUser((Map)this.AuthorizedUsers.get(username), detailSandboxes);
            authUser.salt = null;
            return authUser;
        }
        throw new AuthorizedUserNotFound(username);
    }

    @Override
    public final void setAuthorizedUser(AuthorizedUser user) {
        this.setAuthorizedUser(user, false);
    }

    public final void setAuthorizedUser(AuthorizedUser user, boolean isHashed) {
        boolean allowAdminAccess = user.roles.contains(ROLE_ADMINISTRATOR);
        boolean allowRDSAccess = user.roles.contains(ROLE_RDS);
        boolean allowAdminAPIAccess = user.roles.contains(ROLE_ADMINAPI);
        this.setAuthorizedUser(user.username, user.password, user.description, allowAdminAccess, allowRDSAccess, allowAdminAPIAccess, user.enabledds, user.filepermissions, user.roles, isHashed, user.isLdap, user.isSaml, user.isGroup);
    }

    @Override
    public final void setAuthorizedUser(String username, String password, String description, boolean allowAdminAccess, boolean allowRDSAccess, boolean allowAdminAPIAccess, List enabledDataSources, List filePermissions, List roles, boolean isLdap, boolean isSaml, boolean isGroup) {
        this.setAuthorizedUser(username, password, description, allowAdminAccess, allowRDSAccess, allowAdminAPIAccess, enabledDataSources, filePermissions, roles, false, isLdap, isSaml, isGroup);
    }

    @Override
    public final void setAuthorizedUser(String username, String password, String description, boolean allowAdminAccess, boolean allowRDSAccess, boolean allowAdminAPIAccess, List enabledDataSources, List filePermissions, List roles, boolean isHashed, boolean isLdap, boolean isSaml, boolean isGroup) {
        this.setAuthorizedUser(username, password, description, allowAdminAccess, allowRDSAccess, allowAdminAPIAccess, enabledDataSources, filePermissions, roles, isHashed, false, isLdap, isSaml, isGroup);
    }

    public final void setAuthorizedUser(String username, String password, String description, boolean allowAdminAccess, boolean allowRDSAccess, boolean allowAdminAPIAccess, List enabledDataSources, List filePermissions, List roles, boolean isHashed, boolean allowClientCertAuth, boolean isLdap, boolean isSaml, boolean isGroup) {
        this.authenticateAdmin();
        Object oldUser = this.AuthorizedUsers.get(username);
        boolean newUser = oldUser == null;
        try {
            HashMap<String, Object> user = new HashMap<String, Object>();
            if (!(isLdap || isSaml || isGroup)) {
                if (allowClientCertAuth && subjectFormat.equalsIgnoreCase(ADMIN_CLIENT_CERT_SUBJECT_EXACT_CRITERIA)) {
                    if (username.length() < 5 || username.length() > 200) {
                        throw new UsernameValidationException();
                    }
                    new LdapName(username);
                } else if (username != null && !username.matches(USERNAME_REGEX)) {
                    throw new UsernameValidationException();
                }
            } else if (isSaml && !isGroup) {
                if (username != null && !username.matches(EMAIL_REGEX)) {
                    throw new SamlUsernameValidationException(username);
                }
            } else if (isSaml && isGroup) {
                if (username == null || username.matches(BASIC_EMAIL_REGEX)) {
                    throw new SamlUsernameValidationException(username);
                }
            } else if (username == null) {
                throw new UsernameValidationException();
            }
            user.put("username", username);
            user.put("description", description);
            user.put("sandboxes", AuthorizedUser.constructSandbox(enabledDataSources, filePermissions));
            user.put("isLdap", isLdap);
            user.put("isSaml", isSaml);
            user.put("isGroup", isGroup);
            if (allowClientCertAuth) {
                user.put("allowclientcertauth", allowClientCertAuth);
            }
            if (!allowAdminAccess) {
                roles.remove(ROLE_ADMINISTRATOR);
            } else if (allowAdminAccess && !roles.contains(ROLE_ADMINISTRATOR)) {
                roles.add(ROLE_ADMINISTRATOR);
                allowAdminAPIAccess = true;
            }
            if (!allowRDSAccess) {
                roles.remove(ROLE_RDS);
            } else if (allowRDSAccess && !roles.contains(ROLE_RDS)) {
                roles.add(ROLE_RDS);
            }
            if (!allowAdminAPIAccess) {
                roles.remove(ROLE_ADMINAPI);
            } else if (allowAdminAPIAccess && !roles.contains(ROLE_ADMINAPI)) {
                roles.add(ROLE_ADMINAPI);
            }
            user.put("roles", roles);
            if (this.isAuthorizedUser(username) && !isLdap && !isSaml) {
                AuthorizedUser origUser = this.getAuthorizedUser(username, true, false);
                if (!origUser.password.equals(password)) {
                    String salt;
                    origUser.salt = salt = this.getNewSalt();
                    password = isHashed ? SecurityUtils.hash(password, "SHA-256", "", origUser.salt) : SecurityUtils.hash(SecurityUtils.hash(password, "SHA-1", "", ""), "SHA-256", "", origUser.salt);
                    origUser.password = password;
                }
                user.put(SALT, origUser.salt);
                user.put("password", origUser.password);
            } else if (!(this.isAuthorizedUser(username) || isLdap || isSaml)) {
                String salt = this.getNewSalt();
                password = isHashed ? SecurityUtils.hash(password, "SHA-256", "", salt) : SecurityUtils.hash(SecurityUtils.hash(password, "SHA-1", "", ""), "SHA-256", "", salt);
                user.put(SALT, salt);
                user.put("password", password);
            }
            this.AuthorizedUsers.put(username, (Object)user);
            this.config.put("AuthorizedUsers", (Object)this.AuthorizedUsers);
            if (newUser) {
                this._store(username, user, null);
            } else {
                this._store(username, user, oldUser);
            }
        }
        catch (IOException io) {
            throw new ServiceRuntimeException(io);
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
        catch (InvalidNameException e) {
            throw new ServiceRuntimeException("User Name must be a valid DN");
        }
        catch (PrivilegedActionException e) {
            throw new ServiceRuntimeException(e);
        }
    }

    public final void deleteAuthorizedUser(String username) {
        this.authenticateAdmin();
        if (this.AuthorizedUsers.containsKey(username)) {
            Object user = this.AuthorizedUsers.get(username);
            this.AuthorizedUsers.remove(username);
            try {
                this.config.put("AuthorizedUsers", (Object)this.AuthorizedUsers);
                this._store(username, null, user);
            }
            catch (ServiceException | PrivilegedActionException ex) {
                throw new ServiceRuntimeException(ex);
            }
            return;
        }
        throw new AuthorizedUserNotFound(username);
    }

    @Override
    public Map getAdminLdapConfiguration() {
        if (this.ldapConfig != null) {
            return this.ldapConfig;
        }
        throw new NoValueException("Ldap Configuration");
    }

    @Override
    public final void setAdminLdapConfiguration(String host, String tcpPort, String userBaseContext, String groupBaseContext, String userbindDN, String userbindPass, boolean isSSLEnabled, boolean isStartTLSEnabled, String userConfig, String usernameAttr, String groupConfig, String groupnameAttr, String timeout) {
        this.authenticateAdmin();
        HashMap<String, Object> ldapConfig = new HashMap<String, Object>();
        ldapConfig.put("host", host);
        ldapConfig.put("tcpPort", tcpPort);
        ldapConfig.put("usernameAttr", usernameAttr);
        if (!userBaseContext.isEmpty()) {
            ldapConfig.put("userBaseContext", userBaseContext);
        }
        if (!groupBaseContext.isEmpty()) {
            ldapConfig.put("groupBaseContext", groupBaseContext);
        }
        if (!userbindDN.isEmpty() && !userbindPass.isEmpty()) {
            ldapConfig.put("userbindDN", userbindDN);
            if (userbindPass.equalsIgnoreCase("***************")) {
                ldapConfig.put("password", (String)this.ldapConfig.get("password"));
            } else {
                try {
                    ldapConfig.put("password", this.encryptPassword(userbindPass));
                }
                catch (Exception e) {
                    throw new ConfigException("Ldap", "set", e.getMessage());
                }
            }
        } else {
            if (!userbindDN.isEmpty() && userbindPass.isEmpty()) {
                throw new NoValueException("userbind Password");
            }
            if (userbindDN.isEmpty() && !userbindPass.isEmpty()) {
                throw new NoValueException("userbind DN");
            }
        }
        ldapConfig.put("isSSLEnabled", isSSLEnabled);
        ldapConfig.put("isStartTLSEnabled", isStartTLSEnabled);
        ldapConfig.put("userConfig", userConfig);
        ldapConfig.put("groupConfig", groupConfig);
        ldapConfig.put("groupnameAttr", groupnameAttr);
        ldapConfig.put("timeout", timeout);
        this.loadLdapConfiguration(ldapConfig);
        try {
            this.config.put("ldapConfiguration", (Object)ldapConfig);
            this._store("ldapConfiguration", ldapConfig, null);
        }
        catch (ServiceException e) {
            throw new ConfigException("Ldap", "set", e.getMessage());
        }
        catch (PrivilegedActionException e) {
            throw new ConfigException("Ldap", "set", e.getMessage());
        }
    }

    @Override
    public final void deleteAdminLdapConfig() {
        this.authenticateAdmin();
        Map ldapConfig = this.ldapConfig;
        this.ldapConfig = null;
        try {
            this.config.remove("ldapConfiguration");
            this._store("ldapConfiguration", null, ldapConfig);
        }
        catch (ServiceException e) {
            throw new ConfigException("Ldap", "deleted", e.getMessage());
        }
        catch (PrivilegedActionException e) {
            throw new ConfigException("Ldap", "deleted", e.getMessage());
        }
    }

    private final void setAdminSamlConfig(String idpName, String spName, String groupName) {
        HashMap<String, String> samlConfig = new HashMap<String, String>();
        samlConfig.put("idpName", idpName);
        samlConfig.put("spName", spName);
        samlConfig.put("groupName", groupName);
        this.loadSamlConfig(samlConfig);
        try {
            this.config.put("SamlConfig", (Object)samlConfig);
            this._store("SamlConfig", samlConfig, null);
        }
        catch (ServiceException e) {
            throw new ConfigException("Saml", "set", e.getMessage());
        }
        catch (PrivilegedActionException e) {
            throw new ConfigException("Saml", "set", e.getMessage());
        }
    }

    @Override
    public HashMap getAdminSamlConfig() {
        if (this.samlConfig != null && !this.samlConfig.isEmpty()) {
            return this.samlConfig;
        }
        throw new NoValueException("Saml Configuration");
    }

    @Override
    public final void deleteAdminSamlConfig() {
        this.authenticateAdmin();
        HashMap samlConfig = this.samlConfig;
        this.samlConfig = null;
        try {
            this.config.remove("SamlConfig");
            this._store("SamlConfig", null, samlConfig);
        }
        catch (ServiceException e) {
            throw new ConfigException("Saml", "deleted", e.getMessage());
        }
        catch (PrivilegedActionException e) {
            throw new ConfigException("Saml", "deleted", e.getMessage());
        }
    }

    @Override
    public void setExternalAuth(String type, Struct samlConfig) {
        this.authenticateAdmin();
        if (type.equalsIgnoreCase("None") || type.equalsIgnoreCase("Ldap") || type.equalsIgnoreCase("Saml")) {
            if (type.equalsIgnoreCase("Saml") && samlConfig != null && !samlConfig.isEmpty()) {
                if (!samlConfig.containsKey("idpName") || ((String)samlConfig.get("idpName")).equals("")) {
                    throw new NoValueException("Identity Provider");
                }
                if (!samlConfig.containsKey("spName") || ((String)samlConfig.get("spName")).equals("")) {
                    throw new NoValueException("Service Provider");
                }
                try {
                    SamlService samlService = ServiceFactory.getSamlService(true);
                    if (!samlService.getAllIdpConfig().containsKey(samlConfig.get("idpName")) || !samlService.getAllSpConfig().containsKey(samlConfig.get("spName"))) {
                        throw new NotAvailableException("Selected Identity Provider Configuration or Service Provider Configuration not present");
                    }
                    this.setAdminSamlConfig((String)samlConfig.get("idpName"), (String)samlConfig.get("spName"), (String)samlConfig.get("groupName"));
                }
                catch (Exception e) {
                    throw new NotAvailableException(e.getMessage());
                }
            } else {
                if (type.equalsIgnoreCase("Saml") && (samlConfig == null || samlConfig.isEmpty())) {
                    throw new ExternalAuthException("set authentication type", "Saml configuration details not passed");
                }
                if (type.equalsIgnoreCase("Ldap") && (this.ldapConfig == null || this.ldapConfig.isEmpty())) {
                    throw new NoValueException("Ldap Configuration");
                }
            }
        } else {
            throw new ExternalAuthException("set authentication type", "Authentication type not supported");
        }
        this.config.put("ExternalAuth", (Object)type);
        this.loadExtAuth(type);
    }

    @Override
    public String getExternalAuth() {
        if (extAuth.equals((Object)ExternalAuth.NONE)) {
            return "None";
        }
        if (extAuth.equals((Object)ExternalAuth.LDAP)) {
            return "Ldap";
        }
        return "Saml";
    }

    @Override
    public void authExternalConnect() {
        this.authenticateAdmin();
        if (this.loginScheme == null || this.loginScheme.isConnected()) {
            throw new ExternalAuthException("connect", "Connection already established or proper authentication not selected");
        }
        this.loginScheme.connect();
    }

    @Override
    public void authExternalDisconnect() {
        this.authenticateAdmin();
        if (this.loginScheme == null || !this.loginScheme.isConnected()) {
            throw new ExternalAuthException("diconnect", "Connection was not established or proper authentication not selected");
        }
        this.loginScheme.disconnect();
    }

    @Override
    public boolean authExternalLookupUser(boolean user, String username) throws JspException {
        if (this.loginScheme != null && this.loginScheme.isConnected()) {
            return this.loginScheme.lookup(user, username);
        }
        throw new ExternalAuthException("lookup", "Either not connected or proper authentication not selected");
    }

    @Override
    public List authExternalAuthenticateUser(String username, String password) throws JspException {
        if (this.loginScheme != null) {
            return this.loginScheme.authenticate(username, password);
        }
        throw new ExternalAuthException("authenticate", "Proper authentication not selected");
    }

    @Override
    public boolean authExternalVerifyConnection(Map config) {
        this.authenticateAdmin();
        LdapQuery loginScheme = new LdapQuery(config);
        try {
            loginScheme.connect();
            loginScheme.disconnect();
            return true;
        }
        catch (LdapQuery.ConnectionFailedException e) {
            return false;
        }
    }

    @Override
    public boolean authExternalVerifyLdapUser(boolean user, String name) throws JspException {
        if (this.ldapConfig == null) {
            throw new NoValueException("Ldap Configuration");
        }
        if (this.loginScheme == null) {
            this.loginScheme = new LdapQuery(this.getAdminLdapConfiguration());
        }
        if (!this.loginScheme.isConnected()) {
            try {
                this.authExternalConnect();
            }
            catch (ExternalAuthException e) {
                return false;
            }
        }
        boolean result = this.authExternalLookupUser(user, name);
        if (this.loginScheme.isConnected()) {
            this.authExternalDisconnect();
        }
        return result;
    }

    private String getNewSalt() {
        return MD5.stringify(SecurityUtils.generateRandom(16));
    }

    @Override
    public final boolean canAccessPage(String page) {
        boolean canAccess = false;
        if (this.isRootAdminUser()) {
            canAccess = true;
        } else {
            ArrayList rolesForPath;
            ArrayList rolesForPage;
            int index;
            if (IS_ADMIN_BEHIND_VIRTUAL_DIR && (index = page.toLowerCase().indexOf("/cfide/administrator/")) != -1) {
                page = page.substring(index);
            }
            if ((rolesForPage = this.rolesStore.getRolesAllowedForPage(page)) != null) {
                canAccess = UserUtils.isUserInRoleListInternal(rolesForPage);
            }
            if (!canAccess && (rolesForPath = this.rolesStore.getRolesAllowedForPagePath(page)) != null) {
                canAccess = UserUtils.isUserInRoleListInternal(rolesForPath);
            }
        }
        return canAccess;
    }

    @Override
    public final boolean canAccessAdministrator() {
        return this.isRootAdminUser() || UserUtils.isUserInRoleInternal(ROLE_ADMINISTRATOR);
    }

    @Override
    public final boolean canAccessRDS() {
        return this.isRootAdminUser() || UserUtils.isUserInRoleInternal(ROLE_RDS);
    }

    @Override
    public final boolean canAccessRDS(String userId) {
        if (userId.equals(this.getRootAdminUserId())) {
            return true;
        }
        List roles = this.getAuthorizedUser((String)userId, (boolean)false, (boolean)false).roles;
        return roles.contains(ROLE_RDS);
    }

    @Override
    public void start() throws ServiceException {
        if (this.startCount == 0) {
            PasswordUtils.getInstance(this.rootDir).addObserver(this);
        }
        super.start();
        CentralConfigClientUtil.delayStore(this);
    }

    @Override
    public final synchronized void load() throws ServiceException {
        this.loadSecurity();
        if (this.isSandboxSecurityEnabled() && System.getSecurityManager() == null) {
            try {
                System.setSecurityManager(new java.lang.SecurityManager());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.jvmSecurityEnabled = System.getSecurityManager() != null;
        this.loadPassword();
        this.loadRoles();
        ESAPIUtils.loadESAPIUtils();
    }

    private void loadSecurity() throws ServiceException {
        try {
            ConfigMap newConfig = (ConfigMap)this.deserialize(this.file);
            ConfigMap localConfig = (ConfigMap)this.deserialize(this.file, true);
            newConfig.put(ADMIN_USERID_ROOT_SALT, localConfig.get(ADMIN_USERID_ROOT_SALT));
            this.setSettings(newConfig);
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    private void loadPassword() {
        Properties p = new Properties();
        try {
            if (ServerlessUtil.isLambdaEnv()) {
                if (this.imf == null) {
                    this.imf = new InMemoryFile(this.password_file.getAbsolutePath(), this.password_file);
                }
                p.load(new FileInputStream(this.password_file));
                InMemoryOutputStream os = new InMemoryOutputStream(this.imf);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                p.store(bos, null);
                os.write(bos.toByteArray());
                if (bos != null) {
                    bos.close();
                }
                if (os != null) {
                    os.close();
                }
            } else {
                p.load(new FileInputStream(this.password_file));
            }
        }
        catch (Exception ex) {
            p.put("encrypted", "false");
            p.put("password", DEFAULT_ROOT_ADMIN_USER_ID);
            p.put("rdspassword", "rds");
        }
        try {
            this.isEncrypted = Boolean.parseBoolean(p.getProperty("encrypted").trim());
            this.password = p.getProperty("password");
            this.rdspassword = p.getProperty("rdspassword");
            if (!this.isEncrypted) {
                this.password = SecurityUtils.hash(this.password, "SHA-1", "", "");
                this.rdspassword = this.encryptPassword(this.rdspassword);
            }
            if (this.rootSalt == null) {
                this.rootSalt = this.getNewSalt();
                this.config.put(ADMIN_USERID_ROOT_SALT, (Object)this.rootSalt);
                this.password = SecurityUtils.hash(this.password, "SHA-256", "", this.rootSalt);
                this.isEncrypted = true;
                this.savePasswordFile();
            } else if (!this.isEncrypted) {
                this.password = SecurityUtils.hash(this.password, "SHA-256", "", this.rootSalt);
                this.isEncrypted = true;
                this.savePasswordFile();
            }
        }
        catch (IOException e) {
            logger.error("Error loading passwords.", e);
            throw new ServiceRuntimeException("Error loading passwords.", e);
        }
    }

    private void loadRoles() {
        this.rolesStore.reset();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream builtInRolesStream = cl.getResourceAsStream(CF_ROLES_FILE);
        try {
            Properties cfRolesProps = new Properties();
            cfRolesProps.load(builtInRolesStream);
            this.rolesStore.load(cfRolesProps);
        }
        catch (IOException e) {
            logger.error("Failed to load built-in roles. Login will be possible only by root administrator.", e);
        }
        try {
            FileInputStream customRolesStream = new FileInputStream(this.customRolesFile);
            Properties customRolesProps = new Properties();
            customRolesProps.load(customRolesStream);
            this.rolesStore.load(customRolesProps);
        }
        catch (FileNotFoundException e1) {
            logger.debug("Custom roles file not found, custom roles not loaded.");
        }
        catch (IOException e2) {
            logger.error("Error loading custom roles file. Custom admin pages will be accessible only by root administrator.", e2);
        }
        this.customRolesLastModified = this.customRolesFile.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private GenericCache getAuthCacheManager() {
        FusionContext context;
        String authConfigFile = this.rootDir + File.separatorChar + "lib" + File.separatorChar + "auth-ehcache.xml";
        if (ehcacheCacheMngr == null) {
            Class<SecurityManager> clazz = SecurityManager.class;
            // MONITORENTER : coldfusion.security.SecurityManager.class
            if (ehcacheCacheMngr == null) {
                this.loadEhcacheAuthManager(authConfigFile);
            }
            // MONITOREXIT : clazz
        }
        String appName = (context = FusionContext.getCurrent()) != null ? (context.getApplicationName() != null ? context.getApplicationName() : "") : "";
        GenericCache cacheMngr1 = this.cacheMgrMap.get(appName);
        if (cacheMngr1 != null) return cacheMngr1;
        if (this.isCFAdmin()) return cacheMngr1;
        Class<SecurityManager> clazz = SecurityManager.class;
        // MONITORENTER : coldfusion.security.SecurityManager.class
        GenericCache cacheMngr2 = this.cacheMgrMap.get(appName);
        if (cacheMngr2 != null) {
            // MONITOREXIT : clazz
            return cacheMngr2;
        }
        try {
            Configuration cacheConfig = this.parseEhcacheConfiguration(authConfigFile);
            auth_cache_config = (CacheConfiguration)cacheConfig.getCacheConfigurations().get(AUTH_CACHE_NAME);
            auth_tokn_mapping_cache_config = (CacheConfiguration)cacheConfig.getCacheConfigurations().get(AUTH_TOKEN_MAPPING_CACHE_NAME);
            cacheConfig.setName("AuthCacheManager");
            GenericCache cacheMngr3 = null;
            boolean useSessionStorageRedis = ServiceFactory.getRuntimeService().getCFLoginUseSessionStorageRedis();
            String storage = ServiceFactory.getRuntimeService().getSessionStorage();
            cacheMngr3 = useSessionStorageRedis && storage.equalsIgnoreCase("redis") ? GenericCacheFactory.getCFLoginRedisSessionStorage() : GenericCacheFactory.getCache();
            final GenericCache cacheMngr = cacheMngr3;
            boolean isTokenMappingCacheDisabled = Boolean.getBoolean(DISABLE_TOKEN_MAPPING_CACHE_PROPERTY);
            boolean authCache = cacheMngr.cacheExists(AUTH_CACHE_NAME);
            if (!authCache) {
                cacheMngr.createCache(AUTH_CACHE_NAME, null, null, null);
            }
            if (!isTokenMappingCacheDisabled) {
                boolean authTokenMappingCache = cacheMngr.cacheExists(AUTH_TOKEN_MAPPING_CACHE_NAME);
                if (!authTokenMappingCache) {
                    cacheMngr.createCache(AUTH_TOKEN_MAPPING_CACHE_NAME, null, null, null);
                }
                final Boolean tokenMappingCache = authTokenMappingCache;
                Runnable AuthOldTokenMappingHandler = new Runnable(){
                    List<String> oldCacheIds;

                    @Override
                    public void run() {
                        if (tokenMappingCache != null) {
                            CacheTO cto = new CacheTO();
                            cto.setKey(SecurityManager.AUTH_TOKEN_MAPPING_CACHE_NAME);
                            List newCacheIds = cacheMngr.getAllCacheIds(cto, true);
                            if (this.oldCacheIds != null && newCacheIds != null) {
                                for (String cid : this.oldCacheIds) {
                                    if (newCacheIds.contains(cid)) continue;
                                    SecurityScopeTracker.getInstance().removeSecurity(cid);
                                }
                            }
                            this.oldCacheIds = newCacheIds;
                        }
                    }
                };
                final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
                final ScheduledFuture<?> schedulerHandle = scheduler.scheduleAtFixedRate(AuthOldTokenMappingHandler, 0L, 1L, TimeUnit.SECONDS);
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            schedulerHandle.cancel(true);
                            scheduler.shutdownNow();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
            this.cacheMgrMap.put(appName, cacheMngr);
            // MONITOREXIT : clazz
            return cacheMngr;
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
            throw e;
        }
    }

    private void loadEhcacheAuthManager(String authConfigFile) {
        Configuration cacheConfig = this.parseEhcacheConfiguration(authConfigFile);
        cacheConfig.setName("AuthCacheManager");
        ehcacheCacheMngr = new CacheManager(cacheConfig);
        boolean isTokenMappingCacheDisabled = Boolean.getBoolean(DISABLE_TOKEN_MAPPING_CACHE_PROPERTY);
        Cache authCache = ehcacheCacheMngr.getCache(AUTH_CACHE_NAME);
        if (!isTokenMappingCacheDisabled && authCache != null) {
            Cache authTokenMappingCache = ehcacheCacheMngr.getCache(AUTH_TOKEN_MAPPING_CACHE_NAME);
            if (authTokenMappingCache == null) {
                CacheConfiguration authMappingCacheConfig = authCache.getCacheConfiguration().clone();
                authMappingCacheConfig.setTimeToLiveSeconds(60L);
                authMappingCacheConfig.setEternal(false);
                authMappingCacheConfig.setName(AUTH_TOKEN_MAPPING_CACHE_NAME);
                authTokenMappingCache = new Cache(authMappingCacheConfig);
                ehcacheCacheMngr.addCache(authTokenMappingCache);
            }
            authTokenMappingCache.getCacheEventNotificationService().registerListener((CacheEventListener)new AuthMappingCacheEventListener(), NotificationScope.LOCAL);
            final Cache tokenMappingCache = authTokenMappingCache;
            Runnable AuthOldTokenMappingHandler = new Runnable(){

                @Override
                public void run() {
                    if (tokenMappingCache != null) {
                        tokenMappingCache.evictExpiredElements();
                    }
                }
            };
            final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
            final ScheduledFuture<?> schedulerHandle = scheduler.scheduleAtFixedRate(AuthOldTokenMappingHandler, 0L, authTokenMappingCache.getCacheConfiguration().getTimeToLiveSeconds(), TimeUnit.SECONDS);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        schedulerHandle.cancel(true);
                        scheduler.shutdownNow();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private Configuration parseEhcacheConfiguration(final String authConfigFile) {
        if (System.getSecurityManager() == null) {
            return ConfigurationFactory.parseConfiguration((File)new File(authConfigFile));
        }
        return AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

            @Override
            public Configuration run() {
                return ConfigurationFactory.parseConfiguration((File)new File(authConfigFile));
            }
        });
    }

    private Hashtable map2Permissions() {
        StringBuilder buffer = new StringBuilder();
        Hashtable<String, Permissions> h = new Hashtable<String, Permissions>();
        for (String key : this.contexts.keySet()) {
            ConfigMap value2 = (ConfigMap)this.contexts.get(key);
            for (String key2 : value2.keySet()) {
                List value = (List)value2.get(key2);
                Permissions c = new Permissions();
                c.add(new LoggingPermission("control", null));
                c.add(new MBeanPermission("*", "getMBeanInfo,getObjectInstance,queryMBeans,queryNames,getAttribute,invoke"));
                if (value.size() != 0) {
                    for (int i = 0; i < value.size(); ++i) {
                        ConfigMap map = ConfigMap.toConfigMap(value.get(i));
                        map.init(this, "permission");
                        String name = (String)map.get("class");
                        String target = (String)map.get("target");
                        String action = (String)map.get("action");
                        try {
                            if ("java.net.NetPermission".equals(name)) {
                                c.add(new NetPermission(target));
                                continue;
                            }
                            if ("java.util.PropertyPermission".equals(name)) {
                                c.add(new PropertyPermission(target, action));
                                continue;
                            }
                            if ("java.lang.reflect.ReflectPermission".equals(name)) {
                                c.add(new ReflectPermission(target));
                                continue;
                            }
                            if ("java.lang.RuntimePermission".equals(name)) {
                                c.add(new RuntimePermission(target));
                                continue;
                            }
                            if ("java.security.SecurityPermission".equals(name)) {
                                c.add(new SecurityPermission(target));
                                continue;
                            }
                            if ("java.io.SerializablePermission".equals(name)) {
                                c.add(new SerializablePermission(target));
                                continue;
                            }
                            if ("java.sql.SQLPermission".equals(name)) {
                                c.add(new SQLPermission(target));
                                continue;
                            }
                            if ("java.io.FilePermission".equals(name)) {
                                c.add(new FilePermission(target, action));
                                continue;
                            }
                            if ("coldfusion.vfs.VFilePermission".equals(name)) {
                                c.add(new VFilePermission(target, action));
                                continue;
                            }
                            if ("java.net.SocketPermission".equals(name)) {
                                c.add(new SocketPermission(target, action));
                                continue;
                            }
                            if ("coldfusion.tagext.GenericTagPermission".equals(name)) {
                                c.add(new GenericTagPermission(target));
                                continue;
                            }
                            if ("coldfusion.runtime.FunctionPermission".equals(name)) {
                                c.add(new FunctionPermission(target));
                                continue;
                            }
                            if ("coldfusion.sql.DataSourcePermission".equals(name)) {
                                c.add(new DataSourcePermission(target));
                                continue;
                            }
                            if ("coldfusion.tagext.lang.ModulePermission".equals(name)) {
                                c.add(new ModulePermission(target));
                                continue;
                            }
                            if ("org.osgi.framework.AdminPermission".equals(name)) {
                                c.add((Permission)new AdminPermission());
                                continue;
                            }
                            if (!"org.osgi.framework.ServicePermission".equals(name)) continue;
                            c.add((Permission)new ServicePermission(target, action));
                            continue;
                        }
                        catch (Throwable t) {
                            value.remove(i);
                            --i;
                            buffer.append(t.getLocalizedMessage());
                            buffer.append(' ');
                        }
                    }
                }
                File libDir = new File(this.rootDir + File.separatorChar + "lib");
                File[] libFiles = libDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        int index = name.lastIndexOf(46);
                        if (index != -1) {
                            String extension = name.substring(index + 1).toLowerCase();
                            return extension.equals("jar") || extension.equals("zip") || extension.equals("dll") || extension.equals("so");
                        }
                        return false;
                    }
                });
                for (int i = 0; i < libFiles.length; ++i) {
                    c.add(new FilePermission(libFiles[i].getAbsolutePath(), "read"));
                }
                File stubDir = new File(this.rootDir + File.separatorChar + "stubs");
                c.add(new FilePermission(stubDir.getAbsolutePath() + File.separator + "-", "read"));
                File openOfficeDir = new File(this.rootDir + File.separatorChar + "lib" + File.separator + "oosdk");
                c.add(new FilePermission(openOfficeDir.getAbsolutePath() + File.separator + "-", "read"));
                c.add(new FilePermission(this.rootDir + File.separator + "CustomTags" + File.separator + "com" + File.separator + "-", "read,execute"));
                if (this.servletContext != null) {
                    Object cfideDir = this.servletContext.getRealPath("/CFIDE");
                    if (cfideDir != null && !((String)cfideDir).endsWith(File.separator)) {
                        cfideDir = (String)cfideDir + File.separator;
                    }
                    c.add(new FilePermission((String)cfideDir + "AIR" + File.separatorChar + "-", "read"));
                    c.add(new FilePermission((String)cfideDir + "orm" + File.separatorChar + "-", "read"));
                    c.add(new FilePermission((String)cfideDir + "portlets" + File.separatorChar + "-", "read"));
                    c.add(new FilePermission((String)cfideDir + "services" + File.separatorChar + "-", "read"));
                    c.add(new FilePermission((String)cfideDir + File.separator + "scripts" + File.separatorChar + "-", "read"));
                    Object webInfDir = this.servletContext.getRealPath("/WEB-INF");
                    if (webInfDir != null && !((String)webInfDir).endsWith(File.separator)) {
                        webInfDir = (String)webInfDir + File.separator;
                    }
                    c.add(new FilePermission((String)webInfDir + "cftags" + File.separatorChar + "*", "read,execute"));
                    c.add(new FilePermission((String)webInfDir + "cftags" + File.separatorChar + "META-INF" + File.separatorChar + "taglib.cftld", "read,execute"));
                    c.add(new FilePermission((String)webInfDir + "cfclasses" + File.separator + "dotNetProxy" + File.separator + "-", "read,execute"));
                    c.add(new FilePermission((String)webInfDir + "cfclasses" + File.separator + "dotNetProxy", "read,execute"));
                }
                String appClassesDir = null;
                appClassesDir = null == tmpRoot ? this.rootDir + File.separatorChar + "tmpCache" + File.separatorChar + "appClasses" : tmpRoot + File.separatorChar + "tmpCache" + File.separatorChar + "appClasses";
                c.add(new FilePermission(appClassesDir + File.separatorChar + "-", "read"));
                c.add(new FilePermission(this.rootDir + File.separator + "ormindex", "read,write"));
                c.add(new FilePermission(this.rootDir + File.separator + "ormindex" + File.separator + "-", "read,write"));
                c.add(new SocketPermission("localhost:0", "listen"));
                h.put(key2, c);
            }
        }
        if (buffer.length() == 0) {
            return h;
        }
        throw new IllegalArgumentException(buffer.toString());
    }

    private void _store(final Object key, final Object value, final Object oldValue) throws ServiceException, PrivilegedActionException {
        if (this.jvmSecurityEnabled) {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws ServiceException {
                    SecurityManager.this.store(key, value, oldValue);
                    return null;
                }
            });
        } else {
            this.store(key, value, oldValue);
        }
    }

    @Override
    public synchronized void store() throws ServiceException {
        this.store(null, null, null, true);
    }

    @Override
    public synchronized void store(Object key, Object value, Object oldValue) throws ServiceException {
        this.store(key, value, oldValue, true);
    }

    @Override
    public void store(boolean broadcast) throws ServiceException {
        this.store(null, null, null, broadcast);
    }

    @Override
    public synchronized void store(Object key, Object value, Object oldValue, boolean broadcast) throws ServiceException {
        Hashtable policy_info = this.map2Permissions();
        if (this._sbsEnabled && this.basic_policy != null) {
            this.basic_policy.setNewPermissions(policy_info);
        }
        this.serialize(this.config, this.file, broadcast, key, value, oldValue);
        this.helper.setSanboxSecuritySwitches(this._sbsEnabled);
    }

    @Override
    public final Map getSettings() {
        this.authenticateAdmin();
        return this.config;
    }

    @Override
    public final void setSettings(Map newConfig) throws ServiceException {
        this.authenticateAdmin();
        try {
            if (newConfig instanceof ConfigMap) {
                this.config = (ConfigMap)newConfig;
            } else {
                this.config = new ConfigMap();
                this.config.putAll(newConfig);
                this.config.setConfigMapListener(this);
                this.store();
            }
            this.adminSecurityEnabled = (Boolean)this.config.get("admin.security.enabled");
            String rdauthsenabled = (String)this.config.get("rds.security.enabled");
            this.rdsSecurityEnabled = Boolean.valueOf(rdauthsenabled);
            String rdsenabled = (String)this.config.get("rds.enabled");
            this.rdsEnabled = Boolean.valueOf(rdsenabled);
            if (this.config.containsKey("rds.security.usesinglerdspassword")) {
                this.useSingleRdsPassword = (Boolean)this.config.get("rds.security.usesinglerdspassword");
            }
            this.adminUserIdRequired = this.config.containsKey("admin.userid.required") && (Boolean)this.config.get("admin.userid.required") != false;
            this.rootAdminUserId = (String)this.config.get("admin.userid.root");
            if (this.rootAdminUserId == null) {
                this.rootAdminUserId = DEFAULT_ROOT_ADMIN_USER_ID;
            }
            this.rootSalt = (String)this.config.get(ADMIN_USERID_ROOT_SALT);
            this.rootAdminUserId = this.rootAdminUserId.trim();
            try {
                this._sbsEnabled = (Boolean)this.config.get("sbs.security.enabled");
            }
            catch (NullPointerException e) {
                this._sbsEnabled = this.jvmSecurityEnabled;
            }
            this.allowedIPList = (String)this.config.get("allowedIPList");
            if (this.allowedIPList == null) {
                this.allowedIPList = "";
            }
            this.allowedAdminIPList = (String)this.config.get("allowedAdminIPList");
            if (this.allowedAdminIPList == null) {
                this.allowedAdminIPList = "";
            }
            ConfigMap crossSiteScriptPatterns = (ConfigMap)this.config.get("CrossSiteScriptPatterns");
            this.loadCrossSiteScriptPatterns(crossSiteScriptPatterns);
            FastHashtable users = (FastHashtable)this.config.get("AuthorizedUsers");
            this.AuthorizedUsers = new FastHashtable();
            boolean updateConfigMap = false;
            updateConfigMap = this.loadUsers(users);
            ConfigMap sandboxes = (ConfigMap)this.config.get("contexts");
            this.loadSandboxes(sandboxes);
            if (this.config.containsKey("ldapConfiguration")) {
                Map ldapconfiguration = (Map)this.config.get("ldapConfiguration");
                this.loadLdapConfiguration(ldapconfiguration);
            }
            if (this.config.containsKey("SamlConfig")) {
                HashMap samlConfig = (HashMap)this.config.get("SamlConfig");
                this.loadSamlConfig(samlConfig);
            }
            String extAuth2 = (String)this.config.get("ExternalAuth");
            this.loadExtAuth(extAuth2);
            this.config.setConfigMapListener(this);
            if (this.config.containsKey("allowconcurrentadminlogin")) {
                this.allowConcurrentAdminLogin = (Boolean)this.config.get("allowconcurrentadminlogin");
            } else {
                this.config.put("allowconcurrentadminlogin", (Object)(this.allowConcurrentAdminLogin ? Boolean.TRUE : Boolean.FALSE));
            }
            if (this.config.containsKey("secureprofile.enabled")) {
                this.isSecureProfile = (Boolean)this.config.get("secureprofile.enabled");
            } else {
                this.config.put("secureprofile.enabled", (Object)(this.isSecureProfile ? Boolean.TRUE : Boolean.FALSE));
            }
            if (clientCertAuthEnabled) {
                this.ccaMappingConfig = this.getDefaultClientCertAuthMappingConfig();
            }
            boolean cfAdminIdentifierChanged = false;
            if (this.config.containsKey("cfadmin.cookieidentifier")) {
                this.cfAdminCookieIdentifier = (String)this.config.get("cfadmin.cookieidentifier");
            } else {
                this.cfAdminCookieIdentifier = Integer.toString(Math.abs(new Random().nextInt()));
                this.config.put("cfadmin.cookieidentifier", (Object)this.cfAdminCookieIdentifier);
                cfAdminIdentifierChanged = true;
            }
            if (updateConfigMap || cfAdminIdentifierChanged) {
                if (updateConfigMap) {
                    this.config.put("AuthorizedUsers", (Object)this.AuthorizedUsers);
                }
                this.store(false);
            }
        }
        catch (Exception ex) {
            throw new ServiceException(ex);
        }
    }

    private void loadExtAuth(String extAuth2) {
        if (extAuth2 == null || extAuth2.equalsIgnoreCase("None")) {
            extAuth = ExternalAuth.NONE;
            this.loginScheme = null;
        } else if (extAuth2.equalsIgnoreCase("Ldap")) {
            extAuth = ExternalAuth.LDAP;
            this.loginScheme = new LdapQuery(this.getAdminLdapConfiguration());
        } else {
            extAuth = ExternalAuth.SAML;
            this.loginScheme = null;
        }
    }

    private void loadSamlConfig(HashMap samlConfig) {
        if (samlConfig.get("idpName") != null && !((String)samlConfig.get("idpName")).isEmpty() && samlConfig.get("spName") != null && !((String)samlConfig.get("spName")).isEmpty()) {
            this.samlConfig = samlConfig;
        } else if (samlConfig.get("idpName") == null || ((String)samlConfig.get("idpName")).isEmpty() || samlConfig.get("spName") == null || ((String)samlConfig.get("spName")).isEmpty()) {
            throw new NoValueException("Identity Provider or Service Provider or groupName alias");
        }
    }

    private void loadLdapConfiguration(Map ldapconfiguration) {
        this.validateLdapConfiguration(ldapconfiguration);
        this.ldapConfig = ldapconfiguration;
        this.loginScheme = new LdapQuery(ldapconfiguration);
    }

    private void validateLdapConfiguration(Map ldapconf) {
        if (ldapconf.get("host") == null || !(ldapconf.get("host") instanceof String) || ldapconf.get("host").toString().isEmpty()) {
            throw new NoValueException("host");
        }
        if (ldapconf.get("tcpPort") == null || !(ldapconf.get("tcpPort") instanceof String) || ldapconf.get("tcpPort").toString().isEmpty()) {
            throw new NoValueException("tcpPort");
        }
        if (ldapconf.get("userBaseContext") == null || !(ldapconf.get("userBaseContext") instanceof String) || ldapconf.get("userBaseContext").toString().isEmpty()) {
            throw new NoValueException("userBaseContext");
        }
        if (ldapconf.get("groupBaseContext") == null || !(ldapconf.get("groupBaseContext") instanceof String) || ldapconf.get("groupBaseContext").toString().isEmpty()) {
            throw new NoValueException("groupBaseContext");
        }
        if (ldapconf.get("isSSLEnabled") == null || !(ldapconf.get("isSSLEnabled") instanceof Boolean) || ldapconf.get("isSSLEnabled").toString().isEmpty()) {
            throw new NoValueException("isSSLEnabled");
        }
        if (ldapconf.get("isStartTLSEnabled") == null || !(ldapconf.get("isStartTLSEnabled") instanceof Boolean) || ldapconf.get("isStartTLSEnabled").toString().isEmpty()) {
            throw new NoValueException("isStartTLSEnabled");
        }
        if (ldapconf.get("usernameAttr") == null || !(ldapconf.get("usernameAttr") instanceof String) || ldapconf.get("usernameAttr").toString().isEmpty()) {
            throw new NoValueException("usernameAttr");
        }
        if (ldapconf.get("groupnameAttr") == null || !(ldapconf.get("groupnameAttr") instanceof String) || ldapconf.get("groupnameAttr").toString().isEmpty()) {
            throw new NoValueException("groupnameAttr");
        }
        if ((ldapconf.containsKey("userbindDN") && ldapconf.get("userbindDN") != null && ((String)ldapconf.get("userbindDN")).isEmpty()) ^ (ldapconf.containsKey("userbindPass") && ldapconf.get("userbindPass") != null && ((String)ldapconf.get("userbindPass")).isEmpty())) {
            throw new NoValueException("userBind DN or userBind Password");
        }
        if (ldapconf.get("timeout") == null || !(ldapconf.get("timeout") instanceof String) || ldapconf.get("timeout").toString().isEmpty()) {
            throw new NoValueException("timeout");
        }
    }

    @Override
    public void loadSandboxes(ConfigMap sandboxes) {
        this.contexts = sandboxes;
        this.contexts.init(this, "appcontexts");
        this.initMap(this.contexts, "contexts");
        Hashtable policy_info = this.map2Permissions();
        if (this.isSandboxSecurityEnabled()) {
            try {
                if (this.basic_policy == null) {
                    this.basic_policy = new BasicPolicy(Policy.getPolicy(), policy_info);
                    this.basic_policy.getClass().getMethods();
                    Policy.setPolicy(this.basic_policy);
                } else {
                    this.basic_policy.setNewPermissions(policy_info);
                }
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error(RB.getString(this, "SecurityManager.policyNotSet"), e);
                this.jvmSecurityEnabled = false;
                this._sbsEnabled = false;
            }
        }
        Iterator i = this.contexts.values().iterator();
        while (i.hasNext()) {
            ((ConfigMap)i.next()).setConfigMapListener(this);
        }
        this.contexts.setConfigMapListener(this);
    }

    @Override
    public void setAuthorizedUsers(FastHashtable users) {
        this.authenticateAdmin();
        boolean updateConfigMap = false;
        try {
            updateConfigMap = this.loadUsers(users);
            if (updateConfigMap) {
                this.config.put("AuthorizedUsers", (Object)this.AuthorizedUsers);
                this.store();
            }
        }
        catch (Exception ex) {
            CFLogs.SERVER_LOG.error(ex);
        }
    }

    @Override
    public void setCrossSiteScriptPatterns(ConfigMap crossSiteScriptPatterns) {
        this.authenticateAdmin();
        this.updateCrossSiteScriptPatterns(crossSiteScriptPatterns);
    }

    private void updateCrossSiteScriptPatterns(ConfigMap crossSiteScriptPatterns) {
        if (crossSiteScriptPatterns != null) {
            Iterator itr = crossSiteScriptPatterns.keySet().iterator();
            if (this.config.get("CrossSiteScriptPatterns") == null) {
                this.config.put("CrossSiteScriptPatterns", (Object)new ConfigMap());
            }
            ConfigMap temp = (ConfigMap)this.config.get("CrossSiteScriptPatterns");
            while (itr.hasNext()) {
                String item = (String)itr.next();
                try {
                    Pattern pattern = this.compiler.compile(item, 1);
                    this.CompiledCrossSiteScriptPatterns.put(pattern, crossSiteScriptPatterns.get(item));
                    temp.put(item, crossSiteScriptPatterns.get(item));
                }
                catch (Exception ex) {
                    CFLogs.SERVER_LOG.error(ex);
                }
            }
            this.config.put("CrossSiteScriptPatterns", (Object)temp);
            try {
                this.store();
            }
            catch (Exception ex) {
                CFLogs.SERVER_LOG.error(ex);
            }
        }
    }

    private void loadCrossSiteScriptPatterns(ConfigMap crossSiteScriptPatterns) {
        if (crossSiteScriptPatterns != null) {
            for (String item : crossSiteScriptPatterns.keySet()) {
                try {
                    Pattern pattern = this.compiler.compile(item, 1);
                    this.CompiledCrossSiteScriptPatterns.put(pattern, crossSiteScriptPatterns.get(item));
                }
                catch (Exception ex) {
                    CFLogs.SERVER_LOG.error(ex);
                }
            }
        }
    }

    private boolean loadUsers(FastHashtable users) throws IOException {
        boolean updateConfigMap = false;
        if (users == null) {
            this.AuthorizedUsers = new FastHashtable();
            return true;
        }
        Set usernames = users.keySet();
        if (usernames != null && !usernames.isEmpty()) {
            for (String uname : usernames) {
                String salt;
                if (this.isAuthorizedUser(uname)) continue;
                Map userDetails = (Map)users.get(uname);
                if (!((Boolean)userDetails.get("isLdap")).booleanValue() && !((Boolean)userDetails.get("isSaml")).booleanValue() && (salt = (String)userDetails.get(SALT)) == null) {
                    salt = this.getNewSalt();
                    String pwd = (String)userDetails.get("password");
                    if (pwd != null) {
                        pwd = SecurityUtils.hash(pwd, "SHA-256", "", salt);
                        userDetails.put("password", pwd);
                    }
                    userDetails.put(SALT, salt);
                }
                updateConfigMap = true;
                this.AuthorizedUsers.put(uname, (Object)userDetails);
            }
        }
        return updateConfigMap;
    }

    private ClientCertAuthenticationMappingConfig getDefaultClientCertAuthMappingConfig() {
        ClientCertAuthenticationMappingConfig mappingConfig = new ClientCertAuthenticationMappingConfig();
        boolean useCGIScope = Boolean.getBoolean(ADMIN_CLIENT_CERT_USE_CGI);
        if (useCGIScope) {
            mappingConfig.setUseCGI(useCGIScope);
        } else {
            String subjectHeader = System.getProperty(ADMIN_CLIENT_CERT_SUBJECT_HEADER);
            if (subjectHeader != null) {
                mappingConfig.setSubjectHeader(subjectHeader);
                mappingConfig.setMatchCriteria(subjectFormat);
            } else {
                return null;
            }
        }
        return mappingConfig;
    }

    @Override
    public final Map getResourceBundle() {
        if (this.rb == null) {
            this.rb = new HashMap();
            this.rb.put("permission.keys", "class,target,action");
            this.rb.put("permission.types", "java.lang.String,java.lang.String,java.lang.String");
            this.rb.put("permission.formats", "coldfusion.server.StringFormatter,coldfusion.server.StringFormatter,coldfusion.server.StringFormatter");
            this.rb.put("appcontexts.keys", "");
            this.rb.put("appcontexts.types", "coldfusion.server.ConfigMap");
            this.rb.put("appcontexts.formats", "coldfusion.server.MapFormatter");
            this.rb.put("appcontexts.value", "contexts");
            this.rb.put("contexts.keys", "");
            this.rb.put("contexts.types", "coldfusion.server.ConfigMap");
            this.rb.put("contexts.formats", "coldfusion.server.MapFormatter");
            this.rb.put("contexts.value", "");
            this.rb.put("CrossSiteScriptPatterns.keys", "");
            this.rb.put("CrossSiteScriptPatterns.types", "coldfusion.server.ConfigMap");
            this.rb.put("CrossSiteScriptPatterns.formats", "coldfusion.server.MapFormatter");
            this.rb.put("CrossSiteScriptPatterns.value", "");
            this.rb.put("authorizedUsers.keys", "");
            this.rb.put("authorizedUsers.types", "coldfusion.server.ConfigMap");
            this.rb.put("authorizedUsers.formats", "coldfusion.server.MapFormatter");
            this.rb.put("authorizedUsers.value", "");
        }
        return this.rb;
    }

    @Override
    public final String getAdminHash(String adminUserId, Object o) {
        block12: {
            String canonicalLocation;
            boolean ignoreCase;
            Tag pageParent;
            Object thePage;
            block11: {
                String pagePath;
                if (!(o instanceof NeoPageContext)) {
                    throw new UnauthenticatedCredentialsException();
                }
                thePage = ((NeoPageContext)o).getPage();
                pageParent = ((CfJspPage)thePage).parent;
                ignoreCase = false;
                if (SystemInfo.isWindows()) {
                    ignoreCase = true;
                } else if (!ignoreCase) {
                    if (thePage instanceof CFDummyComponent) {
                        pagePath = ((CfJspPage)thePage).getPagePath();
                        if (pagePath.contains("/cfide/")) {
                            ignoreCase = true;
                        }
                    } else if (thePage instanceof CfJspPage && pageParent instanceof IncludeTag && (canonicalLocation = ((IncludeTag)pageParent).getCanonicalLocation()).contains("/cfide/")) {
                        ignoreCase = true;
                    }
                }
                if (IS_ADMIN_BEHIND_VIRTUAL_DIR) {
                    ignoreCase = true;
                }
                if (!(thePage instanceof CFDummyComponent)) break block11;
                pagePath = ((CfJspPage)thePage).getPagePath();
                String adminCfc = null;
                for (int i = 0; i < adminapi_cfcs.length; ++i) {
                    adminCfc = adminapi_cfcs[i];
                    if (!pagePath.regionMatches(ignoreCase, pagePath.length() - adminCfc.length(), adminCfc, 0, adminCfc.length())) continue;
                    return this.getAdminPassword(adminUserId);
                }
                break block12;
            }
            if (!(thePage instanceof CfJspPage) || !(pageParent instanceof IncludeTag)) break block12;
            canonicalLocation = ((IncludeTag)pageParent).getCanonicalLocation();
            String adminPage = null;
            for (int i = 0; i < admin_pages.length; ++i) {
                adminPage = admin_pages[i];
                if (!canonicalLocation.regionMatches(ignoreCase, canonicalLocation.length() - adminPage.length(), adminPage, 0, adminPage.length())) continue;
                return this.getAdminPassword(adminUserId);
            }
        }
        throw new UnauthenticatedCredentialsException();
    }

    @Override
    public final void authenticateAdmin() {
        FusionContext fContext = FusionContext.getCurrent();
        if (fContext == null) {
            return;
        }
        if (!this.isAdminSecurityEnabled()) {
            return;
        }
        String disableAuthentication = fContext.getServletContext().getInitParameter("coldfusion.securityservice.disableadminauthentication");
        if (disableAuthentication != null && disableAuthentication.equalsIgnoreCase("true")) {
            return;
        }
        Object passwd = fContext.pageContext.findAttribute("cflogin.password");
        Object userid = null;
        if (passwd == null) {
            String auth = null;
            Scope sessionScope = (Scope)fContext.pageContext.findAttribute("session");
            boolean authFromSession = false;
            if (sessionScope instanceof SessionScope && (auth = (String)sessionScope.get(SecurityScopeTracker.getAppSecureCookieName())) != null && !auth.isEmpty()) {
                authFromSession = true;
            }
            if (auth == null) {
                auth = SecurityScopeTracker.getSecurityCookie(fContext.pageContext);
            }
            if (auth == null) {
                passwd = fContext.getSecurePassword();
                if (passwd != null) {
                    userid = fContext.getSecureUsername();
                } else {
                    passwd = fContext.pageContext.findAttribute("j_password");
                    if (passwd != null) {
                        userid = fContext.pageContext.findAttribute("j_username");
                    } else {
                        String basicHeader = fContext.getRequest().getHeader("authorization");
                        if (basicHeader != null) {
                            int index = basicHeader.indexOf(" ");
                            if (index != -1) {
                                auth = basicHeader.substring(index + 1);
                                try {
                                    auth = new String(Base64Encoder.decode(auth), "utf-8");
                                }
                                catch (UnsupportedEncodingException e) {
                                    auth = new String(Base64Encoder.decode(auth));
                                }
                                String tokenSep = SEP;
                                index = auth.indexOf(tokenSep);
                                if (index != -1) {
                                    userid = auth.substring(0, index);
                                    passwd = "";
                                    if (index + 1 != auth.length()) {
                                        int secIndex = auth.indexOf(tokenSep, index + 1);
                                        if (secIndex == -1) {
                                            passwd = auth.substring(index + 1);
                                        } else if (secIndex + 1 != auth.length()) {
                                            passwd = auth.substring(index + 1, secIndex);
                                        }
                                    }
                                }
                            }
                        } else {
                            this.authenticateUsingClientCert(fContext);
                        }
                    }
                }
            } else {
                SecurityTable tab = null;
                tab = authFromSession ? SecurityScopeTracker.getInstance().getSecurity(auth) : SecurityScopeTracker.getInstance().getSecurity(fContext.pageContext);
                if (tab != null) {
                    userid = tab.getUserName();
                    passwd = tab.getPassword();
                }
            }
        }
        if (passwd != null) {
            boolean isAdmin = false;
            if (this.isAdminUserIdRequired() && userid != null) {
                certUser = this.checkAdminUserClientCertificate();
                if (certUser != null) {
                    isAdmin = certUser.equalsIgnoreCase(userid.toString());
                    if (!isAdmin) {
                        throw new UnauthenticatedCredentialsException();
                    }
                } else {
                    String extAuthType = this.getExternalAuth();
                    isAdmin = extAuthType.equalsIgnoreCase("None") ? this.checkAdminUserIdPassword(userid.toString(), passwd.toString(), true, true) : this.checkAdminUserIdPassword(userid.toString(), passwd.toString(), false, true);
                }
            } else if (!this.isAdminUserIdRequired()) {
                certUser = this.checkAdminUserClientCertificate();
                if (certUser != null) {
                    isAdmin = certUser.equalsIgnoreCase(this.rootAdminUserId);
                    if (!isAdmin) {
                        throw new UnauthenticatedCredentialsException();
                    }
                } else {
                    isAdmin = this.checkAdminUserIdPassword(this.rootAdminUserId, passwd.toString(), true, true);
                }
            }
            if (!isAdmin) {
                try {
                    String encpwd = this.encryptPassword(Encryptor.decrypt(passwd.toString()));
                    if (!encpwd.equals(this.password)) {
                        throw new UnauthenticatedCredentialsException();
                    }
                }
                catch (Exception ex) {
                    if (!this.isAuthenticated()) {
                        throw new UnauthenticatedCredentialsException();
                    }
                }
            }
        } else if (!this.isAuthenticated()) {
            throw new UnauthenticatedCredentialsException();
        }
        userid = null;
        passwd = null;
    }

    protected String authenticateUsingClientCert(FusionContext fContext) {
        if (clientCertAuthEnabled && this.ccaMappingConfig != null && fContext != null) {
            String certSubjectHeader = this.ccaMappingConfig.isUseCGI() ? ADMIN_CLIENT_CERT_CGI_SUBJECT_HEADER : this.ccaMappingConfig.getSubjectHeader();
            String certSubject = fContext.getRequest().getHeader(certSubjectHeader);
            if (certSubject != null && !certSubject.trim().isEmpty()) {
                Object value;
                Map userDetails;
                boolean isAuthorizedUser;
                if (this.ccaMappingConfig.getMatchCriteria().equalsIgnoreCase(ADMIN_CLIENT_CERT_SUBJECT_CNMATCH_CRITERIA)) {
                    certSubject = this.getSubjectFromCN(certSubject);
                } else if (!this.ccaMappingConfig.getMatchCriteria().equalsIgnoreCase(ADMIN_CLIENT_CERT_SUBJECT_EXACT_CRITERIA)) {
                    certSubject = null;
                }
                if (certSubject != null && (this.rootAdminUserId.equalsIgnoreCase(certSubject) ? rootAdminClientCertAuthEnabled : (isAuthorizedUser = this.isAuthorizedUser(certSubject)) && (userDetails = (Map)this.AuthorizedUsers.get(certSubject)) != null && (value = userDetails.get("allowclientcertauth")) != null && Cast._boolean(value, false))) {
                    return certSubject;
                }
            }
        }
        return null;
    }

    protected String getSubjectFromCN(String dn) {
        try {
            List<Rdn> rdns = new LdapName(dn).getRdns();
            if (rdns != null && !rdns.isEmpty() && rdns.get(0).getType().equalsIgnoreCase("CN")) {
                return (String)rdns.get(0).getValue();
            }
        }
        catch (InvalidNameException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public final String crossSiteProtectString(String value) {
        value = value.replace('\u0000', ' ');
        SecurityService sc = ServiceFactory.getSecurityService();
        HashMap patterns = sc.getCompiledCrossSiteScriptPatterns();
        Set patternKeySet = patterns.keySet();
        for (Pattern pattern : patternKeySet) {
            value = Util.substitute((PatternMatcher)new Perl5Matcher(), (Pattern)pattern, (Substitution)new Perl5Substitution((String)patterns.get(pattern), 0), (String)value, (int)-1);
        }
        return value;
    }

    @Override
    public final synchronized void filesModified(List l) {
        for (File modifiedFile : l) {
            try {
                String name = modifiedFile.getName();
                if (name.equalsIgnoreCase(this.file.getName())) {
                    if (modifiedFile.lastModified() <= this.getLastModified()) continue;
                    this.loadSecurity();
                    continue;
                }
                if (name.equalsIgnoreCase(this.password_file.getName())) {
                    if (modifiedFile.lastModified() <= this.passwordLastModified) continue;
                    this.loadPassword();
                    continue;
                }
                if (!name.equalsIgnoreCase(this.customRolesFile.getName()) || modifiedFile.lastModified() <= this.customRolesLastModified) continue;
                this.loadRoles();
            }
            catch (ServiceException e) {
                CFLogs.SERVER_LOG.error(e);
            }
        }
    }

    @Override
    public String getAllowedIPList() {
        return this.allowedIPList;
    }

    @Override
    public void setAllowedIPList(String allowedIP) {
        this.authenticateAdmin();
        try {
            this.allowedIPList = allowedIP;
            this.config.put("allowedIPList", (Object)this.allowedIPList);
            this.store();
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        String seedVal;
        String oldSeed = this.seed;
        if (o instanceof PasswordUtils && arg != null && arg instanceof String && (seedVal = (String)arg) != null && seedVal.length() > 0) {
            this.seed = seedVal;
            if (oldSeed == null) {
                return;
            }
            this.reEncryptPassword(oldSeed);
        }
    }

    private void reEncryptPassword(String oldSeed) {
        Properties p = new Properties();
        try {
            p.load(new FileInputStream(this.password_file));
        }
        catch (Exception ex) {
            p.put("encrypted", "false");
            p.put("password", DEFAULT_ROOT_ADMIN_USER_ID);
            p.put("rdspassword", "rds");
        }
        p.put("rdspassword", this.rdspassword);
        p.put("password", this.password);
        if ("true".equalsIgnoreCase(p.getProperty("encrypted").trim())) {
            this.rdspassword = p.getProperty("rdspassword");
            try {
                this.rdspassword = PasswordUtils.reEncryptWithNewSeed(this.rdspassword, oldSeed, this.seed);
                p.put("rdspassword", this.rdspassword);
                p.put("encrypted", "true");
                this.savePasswordFile();
            }
            catch (Exception e) {
                CFLogs.SECURITY_LOG.error(e);
            }
        }
        if (this.ldapConfig != null && this.ldapConfig.containsKey("password")) {
            Map oldLdapConfig = this.ldapConfig;
            String newLdapBindPassword = PasswordUtils.reEncryptWithNewSeed((String)this.ldapConfig.get("password"), oldSeed, this.seed);
            this.ldapConfig.put("password", newLdapBindPassword);
            try {
                this._store("ldapconfiguration", this.ldapConfig, oldLdapConfig);
            }
            catch (Exception e) {
                CFLogs.SECURITY_LOG.error(e);
            }
        }
    }

    @Override
    public String getRDSHash(String adminUserId, Object o) {
        String rdsHash = this.getAdminHash(adminUserId, o);
        if (rdsHash != null) {
            rdsHash = this.encryptPassword(rdsHash);
        }
        return rdsHash;
    }

    @Override
    public boolean isAllowConcurrentAdminLogin() {
        return this.allowConcurrentAdminLogin;
    }

    @Override
    public void setAllowConcurrentAdminLogin(boolean allowConcurrentAdminLogin) {
        this.authenticateAdmin();
        this.allowConcurrentAdminLogin = allowConcurrentAdminLogin;
        this.config.put("allowconcurrentadminlogin", (Object)(allowConcurrentAdminLogin ? Boolean.TRUE : Boolean.FALSE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String rotateAuthToken(String username, String appName, String password, String oldNonce, String oldAuthToken) {
        GenericCache cacheMngr = this.getAuthCacheManager();
        String cacheKey = this.getCacheKey(username, appName);
        if (cacheKey != null) {
            boolean authCache = false;
            if (this.isCFAdmin()) {
                authCache = ehcacheCacheMngr.getCache(AUTH_CACHE_NAME) != null;
            } else if (null != cacheMngr) {
                authCache = cacheMngr.cacheExists(AUTH_CACHE_NAME);
            }
            if (authCache) {
                try {
                    String noncePwd;
                    lockManager.requestNamedLock(cacheKey, false, this.getLockTimeOut());
                    String value = null;
                    if (this.isCFAdmin()) {
                        Element element = ehcacheCacheMngr.getCache(AUTH_CACHE_NAME).get((Serializable)((Object)cacheKey));
                        if (element != null) {
                            value = (String)element.getObjectValue();
                        }
                    } else {
                        CacheTO xObj = new CacheTO();
                        xObj.setKey(AUTH_CACHE_NAME);
                        xObj.setId(cacheKey);
                        Object element = cacheMngr.get(xObj, false);
                        if (element != null) {
                            value = (String)element;
                        }
                    }
                    if (value != null && (noncePwd = value) != null) {
                        CacheTO xObj;
                        String newNoncePwdStr;
                        String[] nonceArray = noncePwd != null ? noncePwd.split(COMMA) : null;
                        boolean allowConcurrent = false;
                        StringBuilder newNoncePwdList = new StringBuilder("");
                        boolean oldNonceFound = false;
                        if (nonceArray != null && nonceArray.length > 0) {
                            allowConcurrent = true;
                            for (String nonce : nonceArray) {
                                if (!nonce.startsWith(oldNonce)) {
                                    newNoncePwdList.append(nonce).append(COMMA);
                                    continue;
                                }
                                oldNonceFound = true;
                            }
                        }
                        boolean authTokenMappingCache = false;
                        authTokenMappingCache = this.isCFAdmin() ? ehcacheCacheMngr.getCache(AUTH_TOKEN_MAPPING_CACHE_NAME) != null : cacheMngr.cacheExists(AUTH_TOKEN_MAPPING_CACHE_NAME);
                        if (authTokenMappingCache) {
                            String newAuthToken = null;
                            if (this.isCFAdmin()) {
                                Element element = ehcacheCacheMngr.getCache(AUTH_TOKEN_MAPPING_CACHE_NAME).get((Serializable)((Object)oldAuthToken));
                                if (element != null) {
                                    newAuthToken = (String)element.getObjectValue();
                                }
                            } else {
                                CacheTO xObj2 = new CacheTO();
                                xObj2.setKey(AUTH_TOKEN_MAPPING_CACHE_NAME);
                                xObj2.setId(cacheKey);
                                Object element = cacheMngr.get(xObj2, false);
                                if (element != null) {
                                    newAuthToken = (String)element;
                                }
                            }
                            if (newAuthToken != null) {
                                SecurityScopeTracker security = SecurityScopeTracker.getInstance();
                                security.copySecurityTableIfAbsent(oldAuthToken, newAuthToken);
                                String string = newAuthToken;
                                return string;
                            }
                        }
                        if (!oldNonceFound) {
                            String newAuthToken = null;
                            return newAuthToken;
                        }
                        StringBuilder builder = new StringBuilder();
                        long timeCreated = System.currentTimeMillis();
                        byte[] nonceBytes = SecurityUtils.generateRandom(8);
                        String nonce = MD5.stringify(nonceBytes);
                        builder.append(username).append(tokenSeparator).append(appName).append(tokenSeparator).append(timeCreated).append(tokenSeparator).append(nonce);
                        String newAuthToken = SecurityManager.encodeBase64(builder.toString());
                        builder.delete(0, builder.length());
                        String newCacheEntry = this.createAuthCacheEntry(nonce, password, username);
                        if (allowConcurrent) {
                            newNoncePwdStr = newNoncePwdList.append(newCacheEntry).append(COMMA).toString();
                            newNoncePwdList.delete(0, newNoncePwdList.length());
                        } else {
                            newNoncePwdStr = newCacheEntry;
                        }
                        Integer idleTimeOut = this.getAuthCacheIdleTimeOut();
                        if (this.isCFAdmin()) {
                            Element cacheElement = new Element((Serializable)((Object)cacheKey), (Serializable)((Object)newNoncePwdStr));
                            if (idleTimeOut != null) {
                                cacheElement.setTimeToIdle(idleTimeOut.intValue());
                            }
                            ehcacheCacheMngr.getCache(AUTH_CACHE_NAME).put(cacheElement);
                        } else {
                            xObj = new CacheTO();
                            xObj.setId(cacheKey);
                            xObj.setValue(newNoncePwdStr);
                            xObj.setKey(AUTH_CACHE_NAME);
                            if (idleTimeOut != null) {
                                xObj.setTimetoidle(idleTimeOut.intValue());
                            }
                            xObj.setTimetoLive(auth_cache_config.getTimeToLiveSeconds());
                            xObj.eternal = auth_cache_config.isEternal();
                            cacheMngr.put(xObj, false);
                        }
                        if (authTokenMappingCache) {
                            if (this.isCFAdmin()) {
                                Element cacheMappingElement = new Element((Serializable)((Object)oldAuthToken), (Serializable)((Object)newAuthToken));
                                ehcacheCacheMngr.getCache(AUTH_TOKEN_MAPPING_CACHE_NAME).put(cacheMappingElement);
                            } else {
                                xObj = new CacheTO();
                                xObj.setId(oldAuthToken);
                                xObj.setValue(newAuthToken);
                                xObj.setTimetoLive(auth_tokn_mapping_cache_config.getTimeToLiveSeconds());
                                xObj.eternal = auth_tokn_mapping_cache_config.isEternal();
                                xObj.setKey(AUTH_TOKEN_MAPPING_CACHE_NAME);
                                cacheMngr.put(xObj, false);
                            }
                        }
                        SecurityScopeTracker security = SecurityScopeTracker.getInstance();
                        security.copySecurityTableIfAbsent(oldAuthToken, newAuthToken);
                        if (!authTokenMappingCache) {
                            security.removeSecurity(oldAuthToken);
                        }
                        String string = newAuthToken;
                        return string;
                    }
                }
                catch (InterruptedException e) {
                    CFLogs.SECURITY_LOG.error(RB.getString(this, "FetchCacheLockTimeOutError"), e);
                }
                finally {
                    lockManager.releaseNamedLock(cacheKey, false);
                    username = null;
                    password = null;
                }
            }
        }
        return null;
    }

    @Override
    public String createAuthToken(String username, String appName, String password, boolean isNTLM, boolean allowConcurrent) {
        StringBuilder builder = new StringBuilder();
        String nonce = "";
        if (isNTLM) {
            builder.append(UUIDUtils.createUUID(false));
            builder.append(tokenSeparator);
            builder.append(appName);
            builder.append(DIGEST_NTLM);
        } else {
            long timeCreated = System.currentTimeMillis();
            byte[] nonceBytes = SecurityUtils.generateRandom(8);
            nonce = MD5.stringify(nonceBytes);
            builder.append(username);
            builder.append(tokenSeparator);
            builder.append(appName);
            builder.append(tokenSeparator);
            builder.append(timeCreated);
            builder.append(tokenSeparator);
            builder.append(nonce);
        }
        String token = builder.toString();
        try {
            token = SecurityManager.encodeBase64(token);
            builder.delete(0, builder.length());
            if (!isNTLM) {
                this.addUpdateElemToAuthCache(this.getCacheKey(username, appName), this.createAuthCacheEntry(nonce, password, username), allowConcurrent);
            }
        }
        catch (Exception e) {
            CFLogs.SECURITY_LOG.error(e.getMessage());
        }
        username = null;
        password = null;
        return token;
    }

    @Override
    public String verifyAuth(String authToken) {
        return this.verifyAuth(authToken, true);
    }

    private String verifyAuth(String authToken, boolean checkMapping) {
        String toReturnAuth = authToken;
        if (authToken != null && authToken.length() > 0) {
            String appName = null;
            String username = null;
            boolean isNTLM = false;
            String decodedAuthInfo = authToken;
            try {
                decodedAuthInfo = this.decodeBase64(authToken);
                isNTLM = decodedAuthInfo.endsWith(DIGEST_NTLM);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                return toReturnAuth;
            }
            if (!isNTLM) {
                String[] tokens = decodedAuthInfo.split(tokenSeparator, 4);
                username = tokens[0];
                appName = tokens[1];
                String timeCreated = tokens[2];
                String nonce = tokens[3];
                if (timeCreated != null && nonce != null && username != null && appName != null) {
                    String cacheKey = this.getCacheKey(username, appName);
                    String[] servernoncePwds = this.getElemFromAuthCache(cacheKey);
                    boolean tokenFound = false;
                    if (servernoncePwds != null && servernoncePwds.length > 0) {
                        String lockKey;
                        for (String servernoncePwd : servernoncePwds) {
                            String servernonce = this.getNonce(servernoncePwd);
                            if (servernonce == null || !nonce.equals(servernonce)) continue;
                            tokenFound = true;
                            long timeC = Long.parseLong(timeCreated);
                            if (System.currentTimeMillis() - timeC <= (long)AUTH_TIMETOREFRESH) break;
                            String password = this.retrivePassword(servernoncePwd, username);
                            toReturnAuth = this.rotateAuthToken(username, appName, password, nonce, authToken);
                            break;
                        }
                        if (checkMapping && !tokenFound && (toReturnAuth = this.getElemStrFromAuthMappingCache(lockKey = cacheKey, authToken)) != null) {
                            return this.verifyAuth(toReturnAuth, false);
                        }
                    }
                    if (!tokenFound) {
                        toReturnAuth = null;
                    }
                }
            }
            username = null;
        }
        return toReturnAuth;
    }

    @Override
    public String[] parseAuthInfo(String authInfo, String[] usernamepassword) {
        boolean isnonceTimeFine = false;
        String username = null;
        if (authInfo != null && authInfo.length() > 0) {
            String appName = null;
            boolean isNTLM = false;
            try {
                authInfo = this.decodeBase64(authInfo);
                isNTLM = authInfo.endsWith(DIGEST_NTLM);
                if (!isNTLM) {
                    String[] tokens = authInfo.split(tokenSeparator, 4);
                    username = tokens[0];
                    appName = tokens[1];
                    String timeCreated = tokens[2];
                    String nonce = tokens[3];
                    if (timeCreated != null && nonce != null && username != null && appName != null) {
                        String[] servernoncePwds;
                        long timeC = Long.parseLong(timeCreated);
                        if (System.currentTimeMillis() - timeC <= (long)AUTH_TIMETOREFRESH && (servernoncePwds = this.getElemFromAuthCache(this.getCacheKey(username, appName))) != null && servernoncePwds.length > 0) {
                            for (String servernoncePwd : servernoncePwds) {
                                String servernonce = this.getNonce(servernoncePwd);
                                if (servernonce == null || !nonce.equals(servernonce)) continue;
                                usernamepassword[0] = username;
                                usernamepassword[1] = this.retrivePassword(servernoncePwd, username);
                                isnonceTimeFine = true;
                                break;
                            }
                        }
                    }
                    if (!isnonceTimeFine) {
                        this.removeElemFromAuthCache(this.getCacheKey(username, appName), nonce, "current");
                        username = null;
                        usernamepassword = null;
                    }
                }
            }
            catch (Exception e) {
                throw new AuthenticationFailedException((Throwable)e);
            }
        }
        return usernamepassword;
    }

    @Override
    public void processLogoutAuth(String authInfo, String session) {
        if (authInfo != null && authInfo.length() > 0) {
            boolean isNTLM = false;
            try {
                authInfo = this.decodeBase64(authInfo);
                isNTLM = authInfo.endsWith(DIGEST_NTLM);
                if (!isNTLM) {
                    String[] tokens = authInfo.split(tokenSeparator, 5);
                    String username = tokens[0];
                    String appName = tokens[1];
                    String nonce = tokens[3];
                    if (appName != null && nonce != null && username != null) {
                        this.removeElemFromAuthCache(this.getCacheKey(username, appName), nonce, session);
                    }
                }
            }
            catch (Exception e) {
                CFLogs.SECURITY_LOG.error(e.getMessage());
            }
            Object var5_5 = null;
        }
    }

    private boolean isDigest(String str) {
        return str.endsWith(DIGEST_NTLM);
    }

    private String decodeBase64(String str) {
        String sr;
        if (this.isDigest(str)) {
            return str;
        }
        try {
            sr = new String(Base64Encoder.decode(str), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            sr = new String(Base64Encoder.decode(str));
        }
        return sr;
    }

    private static String encodeBase64(String str) {
        byte[] bytes;
        try {
            bytes = str.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            bytes = str.getBytes();
        }
        return Base64Encoder.encode(bytes);
    }

    private String createAuthCacheEntry(String nonce, String pwd, String seedval) {
        return nonce + "_" + this.encryptPassword(pwd, seedval);
    }

    private String getNonce(String cacheEntry) {
        String nonce = null;
        if (cacheEntry != null && cacheEntry.contains("_")) {
            nonce = cacheEntry.substring(0, cacheEntry.indexOf("_"));
        }
        return nonce;
    }

    private String retrivePassword(String cacheEntry, String username) {
        String pwd = null;
        if (cacheEntry != null && cacheEntry.contains("_")) {
            String part = cacheEntry.substring(cacheEntry.indexOf("_") + 1);
            pwd = this.decryptPassword(part, username);
        }
        return pwd;
    }

    private String encryptPassword(String password, String seedval) {
        if (password == null) {
            return "";
        }
        return PasswordUtils.encryptPassword(password, seedval);
    }

    private String decryptPassword(String password, String seedval) {
        if (password == null) {
            return "";
        }
        return PasswordUtils.decryptPassword(password, seedval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUpdateElemToAuthCache(String cacheKey, String noncePwd, boolean allowConcurrent) {
        GenericCache cacheMngr = this.getAuthCacheManager();
        boolean isError = true;
        if (cacheKey != null) {
            boolean authCache = false;
            if (this.isCFAdmin()) {
                authCache = ehcacheCacheMngr.getCache(AUTH_CACHE_NAME) != null;
            } else if (null != cacheMngr) {
                authCache = cacheMngr.cacheExists(AUTH_CACHE_NAME);
            }
            if (authCache) {
                Object noncePwdToSet = "";
                Integer idleTimeOut = this.getAuthCacheIdleTimeOut();
                try {
                    lockManager.requestNamedLock(cacheKey, false, this.getLockTimeOut());
                    String value = null;
                    value = this.isCFAdmin() ? this.getElementValue(cacheKey, ehcacheCacheMngr.getCache(AUTH_CACHE_NAME)) : this.getElementValue(AUTH_CACHE_NAME, cacheMngr, cacheKey);
                    noncePwdToSet = allowConcurrent && value != null ? value + COMMA + noncePwd : noncePwd;
                    if (this.isCFAdmin()) {
                        Element element = new Element((Serializable)((Object)cacheKey), (Serializable)noncePwdToSet);
                        if (idleTimeOut != null) {
                            element.setTimeToIdle(idleTimeOut.intValue());
                        }
                        ehcacheCacheMngr.getCache(AUTH_CACHE_NAME).put(element);
                    } else {
                        CacheTO xObj = new CacheTO();
                        xObj.setId(cacheKey);
                        xObj.setValue(noncePwdToSet);
                        xObj.setKey(AUTH_CACHE_NAME);
                        if (idleTimeOut != null) {
                            xObj.setTimetoidle(idleTimeOut.intValue());
                        } else {
                            xObj.setTimetoidle(auth_cache_config.getTimeToIdleSeconds());
                        }
                        xObj.setTimetoLive(auth_cache_config.getTimeToLiveSeconds());
                        xObj.eternal = auth_cache_config.isEternal();
                        cacheMngr.put(xObj, false);
                    }
                    isError = false;
                }
                catch (InterruptedException e) {
                    isError = false;
                    CFLogs.SECURITY_LOG.error(RB.getString(this, "FetchCacheLockTimeOutError"), e);
                }
                finally {
                    lockManager.releaseNamedLock(cacheKey, false);
                }
            }
        }
    }

    private boolean isCFAdmin() {
        String appName = null;
        FusionContext context = FusionContext.getCurrent();
        if (context != null && (appName = context.getApplicationName()) == null && context.cacheConfig != null) {
            appName = context.cacheConfig.applicationName;
        }
        appName = appName != null ? appName : "";
        return appName.equalsIgnoreCase("componentutils") || appName.equalsIgnoreCase("cfadmin");
    }

    private String getElementValue(String region, GenericCache cacheMngr, String cacheKey) {
        String elementValue;
        CacheTO xObj = new CacheTO();
        xObj.setKey(region);
        xObj.setId(cacheKey);
        Object element1 = cacheMngr.get(xObj, false);
        if (element1 != null && (elementValue = (String)element1) != null && !elementValue.isEmpty()) {
            return elementValue;
        }
        return null;
    }

    private String getElementValue(String cacheKey, Cache authCache) {
        String elementValue;
        Element element1 = authCache.get((Serializable)((Object)cacheKey));
        if (element1 != null && (elementValue = (String)element1.getObjectValue()) != null && !elementValue.isEmpty()) {
            return elementValue;
        }
        return null;
    }

    private Integer getAuthCacheIdleTimeOut() {
        FusionContext fcontext = FusionContext.getCurrent();
        if (fcontext != null) {
            AppHelper appHelper = fcontext.getAppHelper();
            if (appHelper != null) {
                return appHelper.getSessionTimeout();
            }
            return Cast._int(ServiceFactory.getRuntimeService().getSessionTimeout());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getElemStrFromAuthCache(String cacheKey) {
        GenericCache cacheMngr = this.getAuthCacheManager();
        String noncePwd = null;
        boolean isError = true;
        if (cacheKey != null) {
            boolean authCache = false;
            if (this.isCFAdmin()) {
                authCache = ehcacheCacheMngr.getCache(AUTH_CACHE_NAME) != null;
            } else if (null != cacheMngr) {
                authCache = cacheMngr.cacheExists(AUTH_CACHE_NAME);
            }
            if (authCache) {
                try {
                    lockManager.requestNamedLock(cacheKey, true, this.getLockTimeOut());
                    String value = null;
                    if (this.isCFAdmin()) {
                        Element element = ehcacheCacheMngr.getCache(AUTH_CACHE_NAME).get((Serializable)((Object)cacheKey));
                        if (element != null) {
                            value = (String)element.getObjectValue();
                        }
                    } else {
                        CacheTO xObj = new CacheTO();
                        xObj.setKey(AUTH_CACHE_NAME);
                        xObj.setId(cacheKey);
                        Object element = cacheMngr.get(xObj, false);
                        if (element != null) {
                            value = (String)element;
                        }
                    }
                    if (value != null) {
                        noncePwd = value;
                    }
                    isError = false;
                }
                catch (InterruptedException e) {
                    isError = false;
                    CFLogs.SECURITY_LOG.error(RB.getString(this, "FetchCacheLockTimeOutError"), e);
                }
                finally {
                    lockManager.releaseNamedLock(cacheKey, true);
                }
            }
        }
        return noncePwd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getElemStrFromAuthMappingCache(String lockKey, String cacheKey) {
        GenericCache cacheMngr = this.getAuthCacheManager();
        String noncePwd = null;
        boolean isError = true;
        if (cacheKey != null) {
            boolean authTokenMappingCache = false;
            authTokenMappingCache = this.isCFAdmin() ? ehcacheCacheMngr.getCache(AUTH_TOKEN_MAPPING_CACHE_NAME) != null : cacheMngr.cacheExists(AUTH_TOKEN_MAPPING_CACHE_NAME);
            if (authTokenMappingCache) {
                try {
                    lockManager.requestNamedLock(lockKey, false, this.getLockTimeOut());
                    String value = null;
                    if (this.isCFAdmin()) {
                        Element element = ehcacheCacheMngr.getCache(AUTH_TOKEN_MAPPING_CACHE_NAME).get((Serializable)((Object)cacheKey));
                        if (element != null) {
                            value = (String)element.getObjectValue();
                        }
                    } else {
                        CacheTO xObj = new CacheTO();
                        xObj.setKey(AUTH_TOKEN_MAPPING_CACHE_NAME);
                        xObj.setId(cacheKey);
                        Object element = cacheMngr.get(xObj, false);
                        if (element != null) {
                            value = (String)element;
                        }
                    }
                    if (value != null && (noncePwd = value) != null) {
                        isError = false;
                    }
                }
                catch (InterruptedException e) {
                    CFLogs.SECURITY_LOG.error(RB.getString(this, "FetchCacheLockTimeOutError"), e);
                }
                finally {
                    lockManager.releaseNamedLock(lockKey, false);
                }
            }
        }
        return noncePwd;
    }

    private String[] getElemFromAuthCache(String cacheKey) {
        String noncePwd = this.getElemStrFromAuthCache(cacheKey);
        String[] noncePwdArray = null;
        if (noncePwd != null) {
            noncePwdArray = noncePwd.split(COMMA);
        }
        return noncePwdArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeElemFromAuthCache(String cacheKey, String nonce, String session) {
        boolean result;
        block28: {
            GenericCache cacheMngr = this.getAuthCacheManager();
            boolean isError = true;
            result = false;
            if (cacheKey != null) {
                Cache ehAuthCache = ehcacheCacheMngr.getCache(AUTH_CACHE_NAME);
                boolean authCache = false;
                if (this.isCFAdmin()) {
                    authCache = ehAuthCache != null;
                } else if (null != cacheMngr) {
                    authCache = cacheMngr.cacheExists(AUTH_CACHE_NAME);
                }
                if (authCache) {
                    try {
                        CacheTO cObj = new CacheTO();
                        cObj.setId(cacheKey);
                        cObj.setKey(AUTH_CACHE_NAME);
                        cObj.exact = true;
                        lockManager.requestNamedLock(cacheKey, false, this.getLockTimeOut());
                        if (session.equalsIgnoreCase("all")) {
                            result = this.isCFAdmin() ? ehAuthCache.remove((Serializable)((Object)cacheKey)) : cacheMngr.remove(cObj);
                            isError = false;
                            break block28;
                        }
                        if (nonce == null || nonce != null && nonce.length() == 0) {
                            result = this.isCFAdmin() ? ehAuthCache.remove((Serializable)((Object)cacheKey)) : cacheMngr.remove(cObj);
                            isError = false;
                            CFLogs.SECURITY_LOG.error(RB.getString(this, "IncompleteLogoutInfo"));
                        }
                        String value = null;
                        if (this.isCFAdmin()) {
                            Element element = ehAuthCache.get((Serializable)((Object)cacheKey));
                            if (element != null) {
                                value = (String)element.getObjectValue();
                            }
                        } else {
                            CacheTO xObj = new CacheTO();
                            xObj.setKey(AUTH_CACHE_NAME);
                            xObj.setId(cacheKey);
                            Object element = cacheMngr.get(xObj, false);
                            if (element != null) {
                                value = (String)element;
                            }
                        }
                        String noncePwdList = "";
                        Object newNoncePwdList = "";
                        if (value != null && (noncePwdList = value) != null) {
                            String[] noncePwdsArray = noncePwdList.split(COMMA);
                            if (noncePwdsArray != null && noncePwdsArray.length > 0) {
                                if (session.equalsIgnoreCase("current")) {
                                    for (String noncePwd : noncePwdsArray) {
                                        if (!noncePwd.startsWith(nonce)) {
                                            newNoncePwdList = (String)newNoncePwdList + noncePwd + COMMA;
                                            continue;
                                        }
                                        result = true;
                                    }
                                } else if (session.equalsIgnoreCase("others")) {
                                    for (String noncePwd : noncePwdsArray) {
                                        if (!noncePwd.startsWith(nonce)) continue;
                                        newNoncePwdList = (String)newNoncePwdList + noncePwd + COMMA;
                                        result = true;
                                        break;
                                    }
                                }
                            }
                            if (this.isCFAdmin()) {
                                ehAuthCache.put(new Element((Serializable)((Object)cacheKey), (Serializable)newNoncePwdList));
                            } else {
                                CacheTO cto = new CacheTO();
                                cto.setKey(AUTH_CACHE_NAME);
                                cto.setId(cacheKey);
                                cto.setValue(newNoncePwdList);
                                cto.setTimetoLive(auth_cache_config.getTimeToLiveSeconds());
                                cto.eternal = auth_cache_config.isEternal();
                                cacheMngr.put(cto, false);
                            }
                            isError = false;
                            break block28;
                        }
                        if (this.isCFAdmin()) {
                            ehAuthCache.remove((Serializable)((Object)cacheKey));
                        } else {
                            cacheMngr.remove(cObj);
                        }
                        isError = false;
                    }
                    catch (InterruptedException e) {
                        isError = false;
                        CFLogs.SECURITY_LOG.error(RB.getString(this, "FetchCacheLockTimeOutError"), e);
                    }
                    finally {
                        lockManager.releaseNamedLock(cacheKey, false);
                    }
                }
            }
        }
        return result;
    }

    private String getCacheKey(String userName, String appName) {
        if (userName != null && appName != null) {
            return userName + SEP + appName;
        }
        return null;
    }

    private long getLockTimeOut() {
        long requestTimeout = RequestMonitor.getRequestTimeout();
        requestTimeout = requestTimeout == 0L ? 120L : requestTimeout;
        return requestTimeout * 1000L;
    }

    @Override
    public String getAllowedAdminIPList() {
        return this.allowedAdminIPList;
    }

    @Override
    public void setAllowedAdminIPList(String allowedIP) {
        this.authenticateAdmin();
        try {
            this.allowedAdminIPList = allowedIP;
            this.config.put("allowedAdminIPList", (Object)this.allowedAdminIPList);
            this.store();
        }
        catch (ServiceException ex) {
            throw new ServiceRuntimeException(ex);
        }
    }

    @Override
    public boolean isSecureProfile() {
        return this.isSecureProfile;
    }

    @Override
    public void setSecureProfile(boolean flag) {
        this.authenticateAdmin();
        this.isSecureProfile = flag;
        this.config.put("secureprofile.enabled", (Object)(flag ? Boolean.TRUE : Boolean.FALSE));
    }

    @Override
    public void enableSecureProfile() throws ServiceException {
        if (!this.isSecureProfile) {
            this.setSecureProfile(true);
            this.spHelper.enableSecureProfile();
        }
    }

    @Override
    public void disableSecureProfile() throws ServiceException {
        if (this.isSecureProfile) {
            this.setSecureProfile(false);
            this.spHelper.disableSecureProfile();
        }
    }

    @Override
    public Set<SecureProfileSetting> getAllSecureProfileSettings() {
        return this.spHelper.getAllSecureProfileSettings();
    }

    @Override
    public Array getAllSecureProfileSettingsInArray() {
        return this.spHelper.getAllSecureProfileSettingsInArray();
    }

    @Override
    public void loadSecureProfileHelper() throws ServiceException {
        this.spHelper.load();
    }

    @Override
    public void setAuthenticated(boolean b, SecurityTable secTab) {
        authenticated.set(new SecurityState(b, secTab));
    }

    @Override
    public void removeAuthenticated() {
        authenticated.remove();
    }

    private boolean isAuthenticated() {
        SecurityState authState = authenticated.get();
        return authState != null && authState.isAuthenticated();
    }

    @Override
    public SecurityTable getSecurityState() {
        SecurityState authState = authenticated.get();
        if (authState != null) {
            return authState.get_secTab();
        }
        return null;
    }

    public String getCFAdminCookieSuffix() {
        return Version.getMajor() + this.cfAdminCookieIdentifier;
    }

    static {
        slash = File.separator;
        admin_pages = new String[]{slash + "CFIDE" + slash + "administrator" + slash + "Application.cfm", slash + "CFIDE" + slash + "administrator" + slash + "security" + slash + "cfadminpassword.cfm", slash + "CFIDE" + slash + "administrator" + slash + "security" + slash + "userpassword.cfm", slash + "CFIDE" + slash + "administrator" + slash + "filedialog" + slash + "archivefilebrowser.cfm", slash + "CFIDE" + slash + "administrator" + slash + "filedialog" + slash + "index.cfm", slash + "CFIDE" + slash + "componentutils" + slash + "Application.cfm", slash + "CFIDE" + slash + "adminapi" + slash + "_datasource" + slash + "setdsn.cfm", slash + "CFIDE" + slash + "adminapi" + slash + "_datasource" + slash + "geturldefaults.cfm", slash + "CFIDE" + slash + "adminapi" + slash + "_datasource" + slash + "formatjdbcurl.cfm", slash + "CFIDE" + slash + "adminapi" + slash + "_datasource" + slash + "getaccessdefaultsfromregistry.cfm", slash + "CFIDE" + slash + "adminapi" + slash + "_datasource" + slash + "setmsaccessregistry.cfm", slash + "CFIDE" + slash + "adminapi" + slash + "_datasource" + slash + "setsldatasource.cfm"};
        adminapi_cfcs = new String[]{slash + "CFIDE" + slash + "adminapi" + slash + "administrator.cfc", slash + "CFIDE" + slash + "adminapi" + slash + "base.cfc", slash + "CFIDE" + slash + "adminapi" + slash + "collections.cfc", slash + "CFIDE" + slash + "adminapi" + slash + "datasource.cfc", slash + "CFIDE" + slash + "adminapi" + slash + "debugging.cfc", slash + "CFIDE" + slash + "adminapi" + slash + "eventgateway.cfc", slash + "CFIDE" + slash + "adminapi" + slash + "extensions.cfc", slash + "CFIDE" + slash + "adminapi" + slash + "mail.cfc", slash + "CFIDE" + slash + "adminapi" + slash + "office.cfc", slash + "CFIDE" + slash + "adminapi" + slash + "runtime.cfc", slash + "CFIDE" + slash + "adminapi" + slash + "security.cfc", slash + "CFIDE" + slash + "adminapi" + slash + "serverinstance.cfc", slash + "CFIDE" + slash + "adminapi" + slash + "servermonitoring.cfc", slash + "CFIDE" + slash + "adminapi" + slash + "scheduler.cfc"};
    }

    public final class AuthorizedUserNotFound
    extends NeoException {
        private static final long serialVersionUID = 1L;
        public final String username;

        public AuthorizedUserNotFound(String username) {
            this.username = username;
        }
    }

    public final class UsernameValidationException
    extends NeoException {
        private static final long serialVersionUID = 1L;
    }

    public final class SamlUsernameValidationException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String value;

        public SamlUsernameValidationException(String username) {
            this.value = username;
        }
    }

    public final class NoValueException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String attribute;

        public NoValueException(String value) {
            this.attribute = value;
        }
    }

    public final class ConfigException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String msg;
        public String method;
        public String operation;

        public ConfigException(String type, String action, String error) {
            this.method = type;
            this.operation = action;
            this.msg = error;
        }
    }

    public static class NotAvailableException
    extends ApplicationException {
        public String msg;

        public NotAvailableException(String error) {
            this.msg = error;
        }
    }

    public final class ExternalAuthException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String msg;
        public String method;
        public String operation;

        public ExternalAuthException(String action, String error) {
            this.operation = action;
            this.msg = error;
        }
    }

    static enum ExternalAuth {
        NONE,
        SAML,
        LDAP;

    }

    static class AuthMappingCacheEventListener
    implements CacheEventListener {
        AuthMappingCacheEventListener() {
        }

        public void notifyElementEvicted(Ehcache cache, Element elementEvicted) {
            this.removeAuthSecurityTable(elementEvicted);
        }

        public void notifyElementExpired(Ehcache cache, Element elementExpired) {
            this.removeAuthSecurityTable(elementExpired);
        }

        public void notifyElementRemoved(Ehcache cache, Element elementRemoved) throws CacheException {
            this.removeAuthSecurityTable(elementRemoved);
        }

        private void removeAuthSecurityTable(Element element) {
            String oldAuthToken = (String)element.getObjectKey();
            SecurityScopeTracker.getInstance().removeSecurity(oldAuthToken);
        }

        public void notifyElementPut(Ehcache cache, Element elementPut) throws CacheException {
        }

        public void notifyElementUpdated(Ehcache cache, Element arg1) throws CacheException {
        }

        public void notifyRemoveAll(Ehcache cache) {
        }

        public void dispose() {
        }

        public Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException();
        }
    }

    public final class UnauthenticatedCredentialsException
    extends SecurityException {
        private static final long serialVersionUID = 1L;
    }

    public final class AuthenticationFailedException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;

        public AuthenticationFailedException(Throwable e) {
            CFLogs.SECURITY_LOG.error(RB.getString(this, "MixedCookieFound"));
            CFLogs.SECURITY_LOG.error(e);
        }
    }

    private class SecurityState {
        private boolean isAuthenticated;
        private SecurityTable _secTab;

        public SecurityState(boolean isAuthenticated, SecurityTable _secTab) {
            this.isAuthenticated = isAuthenticated;
            this._secTab = _secTab;
        }

        public boolean isAuthenticated() {
            return this.isAuthenticated;
        }

        public SecurityTable get_secTab() {
            return this._secTab;
        }
    }
}

