/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.security;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.AppHelper;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.MD5;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.runtime.Scope;
import coldfusion.runtime.SessionScope;
import coldfusion.runtime.SessionTracker;
import coldfusion.runtime.Struct;
import coldfusion.util.RB;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.scrypt.SCryptPasswordEncoder;

public class SecurityUtils {
    private static final String CFMX_COMPAT = "CFMX_COMPAT";
    public static final String SHA_1 = "SHA-1";
    public static final String SHA_256 = "SHA-256";
    public static final String DEFAULT_HASH_ALGO = "SHA-256";
    private static final String DEFAULT_HMAC_ALGO = "HmacMD5";
    private static final String ROUNDS = "ROUNDS";
    private static final String VERSION = "VERSION";
    private static final String CPU_COST = "CPUCOST";
    private static final String MEMORY_COST = "MEMORYCOST";
    private static final String PARALLELIZATION_PARAMETER = "PARALLEL";
    private static final String KEY_LENGTH = "KEYLENGTH";
    private static final String SALT_LENGTH = "SALTLENGTH";
    private static final int CPU_COST_DEFAULT = 16384;
    private static final int MEMORY_COST_DEFAULT = 8;
    private static final int SALT_LENGTH_DEFAULT = 8;
    private static final int PARALLELIZATION_DEFAULT = 1;
    private static final int KEYLENGTH_DEFAULT = 32;
    private static final int ROUNDS_DEFAULT = 10;
    private static final String SESSION_START_TIME = "STARTTIME";
    private static Random secRandom = new SecureRandom();
    private static final String DEFAULT_OUTPUT_ENCODING = "hex";

    public static final byte[] generateRandom() {
        return SecurityUtils.generateRandom(20);
    }

    public static byte[] generateRandom(int numBytes) {
        if (numBytes <= 0) {
            numBytes = 20;
        }
        byte[] salt = new byte[numBytes];
        secRandom.nextBytes(salt);
        return salt;
    }

    public static String hash(Object string, String algorithm, String encoding, String salt) throws IOException {
        return SecurityUtils.hash(string, algorithm, encoding, salt, 0);
    }

    public static String hash(Object string, String algorithm, String encoding, String salt, int numIter) throws IOException {
        return SecurityUtils.hash(string, algorithm, encoding, salt, numIter, DEFAULT_OUTPUT_ENCODING);
    }

    public static String hash(Object string, String algorithm, String encoding, String salt, int numIter, String outputEncoding) throws IOException {
        MessageDigest digest;
        if (string == null) {
            return null;
        }
        if (algorithm == null) {
            MD5 md5 = null;
            md5 = string instanceof byte[] ? new MD5((byte[])string) : new MD5(Cast._String(string));
            md5.getDigest();
            return md5.getStringDigest(outputEncoding);
        }
        if (encoding == null || encoding.isEmpty()) {
            encoding = RuntimeServiceImpl.getDefaultCharset();
        }
        byte[] input = null;
        input = string instanceof byte[] ? (byte[])string : Cast._String(string).getBytes(encoding);
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            CFLogs.SERVER_LOG.error(RB.getString(SecurityUtils.class, "InvalidAlgoException"), e);
            throw new InvalidAlgoException(algorithm);
        }
        digest.reset();
        if (salt != null && salt.length() > 0) {
            digest.update(salt.getBytes(encoding));
            input = digest.digest(input);
        } else {
            digest.update(input);
            input = digest.digest();
        }
        if (numIter > 0) {
            for (int i = 0; i < numIter; ++i) {
                digest.reset();
                input = digest.digest(input);
            }
        }
        return MD5.stringify(input, outputEncoding);
    }

    public static String BCrypt(Object string, Struct options) {
        if (string == null) {
            return null;
        }
        int rounds = 10;
        String version = "$2a";
        if (options != null) {
            if (options.containsKey(ROUNDS)) {
                rounds = (Integer)options.get(ROUNDS);
            }
            if (options.containsKey(VERSION)) {
                version = (String)options.get(VERSION);
            }
        }
        version = version.toUpperCase();
        SecurityUtils.checkBCryptVerion(version);
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder(BCryptPasswordEncoder.BCryptVersion.valueOf((String)version), rounds, (SecureRandom)secRandom);
        return encoder.encode((CharSequence)((String)string));
    }

    private static void checkBCryptVerion(String givenVersion) {
        BCryptPasswordEncoder.BCryptVersion[] versions;
        boolean found = false;
        for (BCryptPasswordEncoder.BCryptVersion version : versions = BCryptPasswordEncoder.BCryptVersion.values()) {
            if (!version.getVersion().toUpperCase().equals(givenVersion)) continue;
            found = true;
        }
        if (!found) {
            throw new BCryptVersionException();
        }
    }

    public static boolean verifyBCrypt(Object plaintext, Object hash) {
        return new BCryptPasswordEncoder().matches((CharSequence)((String)plaintext), (String)hash);
    }

    public static String SCrypt(Object string, Struct options) {
        if (string == null) {
            return null;
        }
        int cpuCost = 16384;
        int memoryCost = 8;
        int parallelizationParameter = 1;
        int keylength = 32;
        int saltLength = 8;
        if (options != null) {
            if (options.containsKey(CPU_COST)) {
                cpuCost = (Integer)options.get(CPU_COST);
            }
            if (options.containsKey(MEMORY_COST)) {
                memoryCost = (Integer)options.get(MEMORY_COST);
            }
            if (options.containsKey(PARALLELIZATION_PARAMETER)) {
                parallelizationParameter = (Integer)options.get(PARALLELIZATION_PARAMETER);
            }
            if (options.containsKey(KEY_LENGTH)) {
                keylength = (Integer)options.get(KEY_LENGTH);
            }
            if (options.containsKey(SALT_LENGTH)) {
                saltLength = (Integer)options.get(SALT_LENGTH);
            }
        }
        SCryptPasswordEncoder encoder = new SCryptPasswordEncoder(cpuCost, memoryCost, parallelizationParameter, keylength, saltLength);
        return encoder.encode((CharSequence)((String)string));
    }

    public static boolean verifySCrypt(Object plaintext, Object hash, Struct options) {
        int keylength = 32;
        if (options != null && options.containsKey(KEY_LENGTH)) {
            keylength = (Integer)options.get(KEY_LENGTH);
        }
        return new SCryptPasswordEncoder(16384, 8, 1, keylength, 8).matches((CharSequence)((String)plaintext), (String)hash);
    }

    public static String hmac(Object message, Object key, String algorithm, String encoding) throws IOException, HmacException {
        if (message == null || key == null) {
            return null;
        }
        if (algorithm == null) {
            algorithm = DEFAULT_HMAC_ALGO;
        }
        if (algorithm.equalsIgnoreCase(CFMX_COMPAT)) {
            throw new InvalidAlgoException();
        }
        if (encoding == null || encoding.isEmpty()) {
            encoding = RuntimeServiceImpl.getDefaultCharset();
        }
        byte[] input = null;
        input = message instanceof byte[] ? (byte[])message : Cast._String(message).getBytes(encoding);
        byte[] keyBytes = null;
        keyBytes = key instanceof byte[] ? (byte[])key : Cast._String(key).getBytes(encoding);
        SecretKeySpec keyObj = new SecretKeySpec(keyBytes, algorithm);
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(keyObj);
            mac.reset();
            mac.update(input, 0, input.length);
            input = mac.doFinal();
        }
        catch (NoSuchAlgorithmException e) {
            CFLogs.SERVER_LOG.error(RB.getString(SecurityUtils.class, "HmacException"), e);
            throw new HmacException(e);
        }
        catch (InvalidKeyException e) {
            CFLogs.SERVER_LOG.error(RB.getString(SecurityUtils.class, "HmacException"), e);
            throw new HmacException(e);
        }
        return MD5.stringify(input);
    }

    public static void sessionRotate() {
        AppHelper appHelper = FusionContext.getCurrent().getAppHelper();
        if (appHelper != null) {
            appHelper.sessionRotate();
        } else {
            CFLogs.APPLICATION_LOG.warn(RB.getString(SecurityUtils.class, "SessionRotateFailure"));
        }
    }

    public static final void sessionInvalidate() {
        SessionTracker.sessionInvalidate();
    }

    public static Struct getSessionMetadata() {
        Struct metadata = new Struct();
        Scope s = (Scope)FusionContext.getCurrent().hiddenScope.get("SESSION");
        if (s == null || !(s instanceof SessionScope)) {
            CFLogs.APPLICATION_LOG.warn(RB.getString(SecurityUtils.class, "NoSession"));
            throw new SessionManipulationException();
        }
        metadata.put(SESSION_START_TIME, (Object)new OleDateTime(((SessionScope)s).getCreatedTime()));
        return metadata;
    }

    public static String generateCSRFToken(String key, boolean random) {
        Scope s = (Scope)FusionContext.getCurrent().hiddenScope.get("SESSION");
        if (s != null && s instanceof SessionScope) {
            SessionScope sessionScope = (SessionScope)s;
            return sessionScope.generateCSRFToken(key, random);
        }
        throw new CSRFTokenException();
    }

    public static boolean verifyCSRFToken(String token, String key) {
        Scope s = (Scope)FusionContext.getCurrent().hiddenScope.get("SESSION");
        if (s != null && s instanceof SessionScope) {
            SessionScope sessionScope = (SessionScope)s;
            return sessionScope.verifyCSRFToken(token, key);
        }
        throw new CSRFTokenException();
    }

    public boolean isPasswordComplex(String password) {
        if (password.length() < 6) {
            return false;
        }
        boolean hasDigit = false;
        boolean hasUppercase = false;
        boolean hasSpecialchar = false;
        String regex = "~!$%^&*()_=,./;[]{}|-@#";
        char[] cArray = password.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character ch = Character.valueOf(cArray[i]);
            if (!hasDigit) {
                hasDigit = Character.isDigit(ch.charValue());
            }
            if (!hasUppercase) {
                hasUppercase = Character.isUpperCase(ch.charValue());
            }
            if (!hasSpecialchar) {
                hasSpecialchar = regex.contains("" + ch);
            }
            if (!hasDigit || !hasUppercase || !hasSpecialchar) continue;
            return true;
        }
        return false;
    }

    public static boolean isPolicyFilesInstalled() {
        try {
            int keyLength = Cipher.getMaxAllowedKeyLength("AES");
            if (keyLength == Integer.MAX_VALUE) {
                return true;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return false;
    }

    public static class InvalidAlgoException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String algorithm;
        public String function;

        InvalidAlgoException() {
            this.algorithm = "CFMX_COMPAT or null";
        }

        InvalidAlgoException(String algorithm) {
            this.algorithm = algorithm;
        }
    }

    public static class BCryptVersionException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class HmacException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String err;

        public HmacException(Throwable rootCause) {
            this.err = rootCause.getLocalizedMessage();
        }
    }

    public static class SessionManipulationException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class CSRFTokenException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class SaltGenerationException
    extends ExpressionException {
        private static final long serialVersionUID = 1L;
        public String err;

        SaltGenerationException(Throwable rootCause) {
            this.err = rootCause.getLocalizedMessage();
        }
    }
}

