/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.security;

import coldfusion.security.WildcardPermission;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;

public class WildcardPermissionCollection
extends PermissionCollection
implements Serializable {
    private Hashtable permissions = new Hashtable(11);
    private boolean wildcard = false;
    private TreeSet taglist = null;

    @Override
    public void add(Permission permission) {
        if (!(permission instanceof WildcardPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        WildcardPermission tp = (WildcardPermission)permission;
        if (tp.wildcard) {
            this.wildcard = true;
        }
        if (tp.taglist != null) {
            if (this.taglist == null) {
                this.taglist = new TreeSet();
            }
            this.taglist.addAll(tp.taglist);
        }
        this.permissions.put(tp.getName(), permission);
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof WildcardPermission)) {
            return false;
        }
        WildcardPermission tp = (WildcardPermission)permission;
        if (this.wildcard && this.taglist == null) {
            return true;
        }
        if (this.wildcard && this.taglist != null) {
            if (tp.wildcard && tp.taglist == null) {
                return false;
            }
            if (tp.wildcard && tp.taglist != null) {
                Iterator i = tp.taglist.iterator();
                while (i.hasNext()) {
                    if (this.taglist.contains(i.next())) continue;
                    return false;
                }
                return true;
            }
            return !this.taglist.contains(tp.getName());
        }
        return !tp.wildcard;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

