/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.security.admin;

import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.RequestMonitor;
import coldfusion.runtime.RequestTimedOutException;
import coldfusion.security.admin.ExternalLoginScheme;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceFactory;
import coldfusion.tagext.net.LdapResultTable;
import jakarta.servlet.jsp.JspException;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.InvalidSearchControlsException;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class LdapQuery
implements ExternalLoginScheme {
    String separator = ",";
    String attributes;
    String start;
    int maxrows = -1;
    int startrow = 1;
    String timeout;
    Map ldapConfiguration;
    SecurityService secService;
    private LdapContext importCtx;
    boolean reqDN = false;
    List<String> userDN;
    String url;
    String protocol = "ldap";

    public LdapQuery(Map ldapConfigMap) {
        this.ldapConfiguration = ldapConfigMap;
    }

    @Override
    public final void connect() {
        this.secService = ServiceFactory.getSecurityService();
        String host = this.ldapConfiguration.get("host").toString();
        String port = this.ldapConfiguration.get("tcpPort").toString();
        this.timeout = this.ldapConfiguration.get("timeout").toString();
        boolean isBasic = (Boolean)this.ldapConfiguration.get("isSSLEnabled");
        boolean useTLS = (Boolean)this.ldapConfiguration.get("isStartTLSEnabled");
        if (isBasic && !useTLS) {
            this.protocol = "ldaps";
        }
        this.url = this.protocol + "://" + host + ":" + port;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.url);
        env.put("com.sun.jndi.ldap.read.timeout", this.timeout);
        try {
            if (useTLS) {
                StartTlsResponse tls = null;
                this.importCtx = this._getContextObj(env);
                tls = (StartTlsResponse)this.importCtx.extendedOperation(new StartTlsRequest());
                SSLSocketFactory factory = null;
                tls.negotiate(factory);
                if (isBasic) {
                    this.initializeSSL(this.importCtx, false, "javax.net.ssl.SSLSocketFactory");
                    this.importCtx.addToEnvironment("java.naming.security.authentication", "simple");
                    String username = this.ldapConfiguration.get("userBindDN").toString();
                    String password = (String)this.ldapConfiguration.get("password");
                    if (!password.isEmpty()) {
                        password = this.secService.decryptLdapBindPassword((String)this.ldapConfiguration.get("password"));
                    }
                    this.importCtx.addToEnvironment("java.naming.security.principal", username);
                    this.importCtx.addToEnvironment("java.naming.security.credentials", password);
                }
            } else if (this.ldapConfiguration.get("userbindDN") != null) {
                if (isBasic) {
                    this.initializeSSL(env, false, "javax.net.ssl.SSLSocketFactory");
                }
                env.put("java.naming.security.authentication", "simple");
                String username = this.ldapConfiguration.get("userbindDN").toString();
                String password = (String)this.ldapConfiguration.get("password");
                if (!password.isEmpty()) {
                    password = this.secService.decryptLdapBindPassword((String)this.ldapConfiguration.get("password"));
                }
                env.put("java.naming.security.principal", username);
                env.put("java.naming.security.credentials", password);
                this.importCtx = this._getContextObj(env);
            } else {
                if (this.ldapConfiguration.get("userbindDN") == null && isBasic) {
                    throw new ConnectionFailedException("userbindDN required");
                }
                env.put("java.naming.security.authentication", "none");
                this.importCtx = this._getContextObj(env);
            }
        }
        catch (AuthenticationNotSupportedException e) {
            LdapQuery.logException(e);
            throw new ConnectionFailedException(e.getMessage());
        }
        catch (AuthenticationException e) {
            LdapQuery.logException(e);
            throw new ConnectionFailedException(e.getMessage());
        }
        catch (NamingException e) {
            LdapQuery.logException(e);
            throw new ConnectionFailedException(e.getMessage());
        }
        catch (IOException e) {
            LdapQuery.logException(e);
            throw new ConnectionFailedException(e.getMessage());
        }
        catch (PrivilegedActionException e) {
            LdapQuery.logException(e);
            throw new ConnectionFailedException(e.getMessage());
        }
    }

    @Override
    public final void disconnect() {
        try {
            if (this.importCtx != null) {
                this.importCtx.close();
                this.importCtx = null;
            }
        }
        catch (NamingException e) {
            LdapQuery.logException(e);
            throw new ConnectionFailedException(e.getMessage());
        }
    }

    @Override
    public boolean lookup(boolean user, String name) throws JspException {
        Object filter = "";
        if (name.isEmpty()) {
            throw new NoValueException("username");
        }
        if (user) {
            this.attributes = this.ldapConfiguration.get("usernameAttr").toString();
            this.start = this.ldapConfiguration.get("userBaseContext").toString();
            if (this.ldapConfiguration.get("userConfig") != null && !((String)this.ldapConfiguration.get("userConfig")).isEmpty()) {
                filter = (String)filter + "(" + this.transformConfig((String)this.ldapConfiguration.get("userConfig")) + ")";
            }
        } else {
            this.attributes = this.ldapConfiguration.get("groupnameAttr").toString();
            this.start = this.ldapConfiguration.get("groupBaseContext").toString();
            if (this.ldapConfiguration.get("groupConfig") != null && !((String)this.ldapConfiguration.get("groupConfig")).isEmpty()) {
                filter = "(" + this.transformConfig((String)this.ldapConfiguration.get("groupConfig")) + ")";
            }
        }
        filter = "(&(" + this.attributes + "=" + name + ")" + (String)filter + ")";
        try {
            LdapResultTable table = this.query(this.importCtx, (String)filter);
            return table.getRowCount() != 0;
        }
        catch (NamingException e) {
            LdapQuery.logException(e);
            throw new ConnectionFailedException(e.getMessage());
        }
    }

    public final List authenticate(String username, String password) throws JspException {
        try {
            this.connect();
            this.attributes = this.ldapConfiguration.get("usernameAttr").toString() + this.separator + "dn";
            this.start = this.ldapConfiguration.get("userBaseContext").toString();
            Object filter = "(&(" + (String)this.ldapConfiguration.get("usernameAttr") + "=" + username + ")";
            if (this.ldapConfiguration.get("userConfig") != null && !((String)this.ldapConfiguration.get("userConfig")).isEmpty()) {
                filter = (String)filter + "(" + this.transformConfig((String)this.ldapConfiguration.get("userConfig")) + ")";
            }
            filter = (String)filter + ")";
            LdapResultTable table = this.query(this.importCtx, (String)filter);
            this.userDN = table.getColumn("dn");
            this.attributes = this.ldapConfiguration.get("groupnameAttr").toString();
            this.start = this.ldapConfiguration.get("groupBaseContext").toString();
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", this.url);
            env.put("java.naming.security.authentication", "simple");
            env.put("com.sun.jndi.ldap.read.timeout", this.timeout);
            if (this.protocol.equals("ldaps")) {
                this.initializeSSL(env, false, "javax.net.ssl.SSLSocketFactory");
            }
            filter = "(|";
            if (username != null && !username.equals("") && password != null && !password.equals("") && this.userDN.size() != 0) {
                for (int i = 0; i < this.userDN.size(); ++i) {
                    env.put("java.naming.security.principal", this.userDN.get(i));
                    env.put("java.naming.security.credentials", password);
                    try {
                        LdapContext ctx = this._getContextObj(env);
                        ctx.close();
                        filter = (String)filter + "(member=" + this.userDN.get(i) + ")";
                        continue;
                    }
                    catch (Exception ctx) {
                        // empty catch block
                    }
                }
            } else {
                if (username == null || username.equals("") || password == null || password.equals("")) {
                    throw new LoginException("username and password required");
                }
                throw new LoginException("User doesn't exist");
            }
            filter = (String)filter + ")";
            if (!((String)filter).equalsIgnoreCase("(|)")) {
                try {
                    table = this.query(this.importCtx, (String)filter);
                }
                catch (QueryException e) {
                    table = null;
                }
                ArrayList groups = new ArrayList();
                if (table == null) {
                    return null;
                }
                for (int i = 0; i < table.getRowCount(); ++i) {
                    groups.add(table.getColumn(this.ldapConfiguration.get("groupnameAttr").toString()).get(i));
                }
                this.disconnect();
                return this.importedGroups(groups);
            }
            throw new LoginException("Invalid Credentials");
        }
        catch (AuthenticationNotSupportedException e) {
            LdapQuery.logException(e);
            throw new LoginException(e.getMessage());
        }
        catch (AuthenticationException e) {
            LdapQuery.logException(e);
            throw new LoginException(e.getMessage());
        }
        catch (NamingException e) {
            LdapQuery.logException(e);
            throw new LoginException(e.getMessage());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public List importedGroups(List groups) {
        ArrayList<String> group = new ArrayList<String>();
        for (int i = 0; i < groups.size(); ++i) {
            if (!this.secService.isAuthorizedUser(groups.get(i).toString())) continue;
            group.add((String)groups.get(i));
        }
        return group;
    }

    private void initializeSSL(Hashtable env, boolean isExternal, String factoryName) {
        env.put("java.naming.security.protocol", "ssl");
        if (isExternal) {
            env.put("java.naming.security.authentication", "EXTERNAL");
        }
        env.put("java.naming.ldap.factory.socket", factoryName);
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS", "SunJSSE");
            Security.addProvider(sslContext.getProvider());
        }
        catch (Exception e) {
            LdapQuery.logException(e);
            throw new SSLProviderNotFoundException();
        }
    }

    private LdapResultTable query(LdapContext ctx, String filter) throws JspException, NamingException {
        try {
            LdapResultTable table = new LdapResultTable();
            SearchControls ctls = new SearchControls();
            ctls.setReturningObjFlag(true);
            ctls.setSearchScope(2);
            ctls.setReturningAttributes(this.split(this.attributes, ","));
            ctls.setCountLimit(0L);
            if (Integer.valueOf(this.timeout) != 0) {
                ctls.setTimeLimit(Integer.valueOf(this.timeout));
            }
            if (filter == null || filter.equals("")) {
                filter = "objectclass=*";
            }
            NamingEnumeration<SearchResult> results = ctx.search(this.start, filter, ctls);
            String[] columns = new String[]{"NAME", "VALUE"};
            if (!this.attributes.equals("*")) {
                columns = this.split(this.attributes, ",");
            }
            this.checkTimeout();
            table.populate(results, columns, this.maxrows, this.startrow, this.start, this.separator);
            return table;
        }
        catch (InvalidSearchControlsException e) {
            LdapQuery.logException(e);
            throw new QueryException(e.getMessage() + ": Invalid Filter");
        }
        catch (InvalidSearchFilterException e) {
            LdapQuery.logException(e);
            throw new QueryException(e.getMessage() + ": Invalid Filter");
        }
        catch (CommunicationException e) {
            LdapQuery.logException(e);
            throw new QueryException(e.getMessage());
        }
        catch (PartialResultException e) {
            LdapQuery.logException(e);
            throw new QueryException(e.getMessage());
        }
        catch (AuthenticationException e) {
            LdapQuery.logException(e);
            throw new QueryException(e.getMessage());
        }
        catch (NameNotFoundException e) {
            LdapQuery.logException(e);
            throw new QueryException(e.getMessage());
        }
    }

    private void initializeSSL(LdapContext ctx, boolean isExternal, String factoryName) throws NamingException {
        ctx.addToEnvironment("java.naming.security.protocol", "ssl");
        if (isExternal) {
            ctx.addToEnvironment("java.naming.security.authentication", "EXTERNAL");
        }
        if (factoryName != null) {
            ctx.addToEnvironment("java.naming.ldap.factory.socket", factoryName);
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS", "SunJSSE");
            Security.addProvider(sslContext.getProvider());
        }
        catch (Exception e) {
            LdapQuery.logException(e);
            throw new SSLProviderNotFoundException();
        }
    }

    private LdapContext _getContextObj(final Hashtable env) throws NamingException, PrivilegedActionException {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<LdapContext>(){

                @Override
                public LdapContext run() throws NamingException {
                    return LdapQuery.this.getContextObj(env);
                }
            }, null, new FilePermission("<<ALL FILES>>", "read"));
        }
        return this.getContextObj(env);
    }

    private LdapContext getContextObj(Hashtable env) throws NamingException {
        InitialLdapContext ctx;
        try {
            ctx = new InitialLdapContext(env, null);
        }
        catch (UnknownHostException e) {
            ctx = new InitialLdapContext(env, null);
        }
        return ctx;
    }

    private static void logException(Exception e) {
        CFLogs.SERVER_LOG.debug(e);
    }

    public void checkTimeout() throws RequestTimedOutException {
        if (RequestMonitor.isRequestTimedOut()) {
            throw new RequestTimedOutException("timeout");
        }
    }

    private String[] split(String line, String sep) {
        if (sep == null) {
            sep = ",";
        }
        StringTokenizer st = new StringTokenizer(line, sep, false);
        int number = st.countTokens();
        ArrayList<String> L = new ArrayList<String>(number);
        for (int i = 0; i < number; ++i) {
            L.add(i, st.nextToken().trim());
        }
        return L.toArray(new String[0]);
    }

    @Override
    public boolean isConnected() {
        return this.importCtx != null;
    }

    private String transformConfig(String config) {
        config = "objectClass=" + ((String)config).replace(",", ")(objectClass=");
        return config;
    }

    public final class ConnectionFailedException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String error;

        public ConnectionFailedException(String message) {
            this.error = message;
        }
    }

    public final class NoValueException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String attribute;

        public NoValueException(String value) {
            this.attribute = value;
        }
    }

    public final class LoginException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String error;

        public LoginException(String message) {
            this.error = message;
        }
    }

    public final class QueryException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String error;

        public QueryException(String message) {
            this.error = message;
        }
    }

    public class SSLProviderNotFoundException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public class UnknownHostException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String msg;

        public UnknownHostException() {
        }

        public UnknownHostException(String m) {
            this.msg = m;
        }
    }
}

