/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.securityanalyzer;

import coldfusion.compiler.Node;
import coldfusion.compiler.validation.CFMLValidationException;
import com.restfb.json.JsonObject;
import java.io.File;
import java.util.Collection;

public class CFMLSecurityAnalyzerError
extends CFMLValidationException {
    String name;
    String desc;
    File page;
    String filename;
    String filepath;
    String type;
    String vulnerablenode;
    String referencetype;
    int beginColumn;
    int endColumn;

    public CFMLSecurityAnalyzerError(String name, String desc, File page, String warningtype) {
        this.name = name;
        this.desc = desc;
        this.page = page;
        if (null != page) {
            this.filename = page.getName();
            this.filepath = page.getAbsolutePath();
        }
        this.type = warningtype;
    }

    public boolean equals(Object arg0) {
        if (arg0 == this) {
            return true;
        }
        if (!(arg0 instanceof CFMLSecurityAnalyzerError)) {
            return false;
        }
        CFMLSecurityAnalyzerError err = (CFMLSecurityAnalyzerError)arg0;
        return err.filename.equals(this.filename) && err.filepath.equals(this.filepath) && err.getBeginLine() == this.getBeginLine() && err.name.equals(this.name) && this.type.equals(err.type);
    }

    public void collectValidationResult(CFMLValidationException error) {
    }

    public Collection getValidationResult() {
        return null;
    }

    public void reset() {
    }

    public String getName() {
        return this.name;
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public String getFeatureName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCategory() {
        throw new UnsupportedOperationException();
    }

    public JsonObject toJson() {
        JsonObject jobj = new JsonObject();
        jobj.put("Error", (Object)this.getName());
        jobj.put("errormessage", (Object)this.getDescription());
        jobj.put("beginline", this.getBeginLine());
        jobj.put("endline", this.getEndLine());
        jobj.put("begincolumn", this.beginColumn);
        jobj.put("endcolumn", this.endColumn);
        jobj.put("column", this.getColumn());
        jobj.put("filename", (Object)this.getFilename());
        jobj.put("path", (Object)this.filepath);
        jobj.put("vulnerablecode", (Object)this.vulnerablenode);
        jobj.put("referencetype", (Object)this.referencetype);
        jobj.put("type", (Object)this.type);
        return jobj;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setVulnerablenode(String node) {
        this.vulnerablenode = node;
    }

    public void setReferencetype(String node) {
        this.referencetype = node;
    }

    public void setColumnNumbers(Node node) {
        this.beginColumn = node.getStartToken().beginColumn;
        this.endColumn = node.getEndToken().endColumn;
    }

    public void setBeginColumn(int beginColumn) {
        this.beginColumn = beginColumn;
    }

    public void setEndColumn(int endColumn) {
        this.endColumn = endColumn;
    }
}

