/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.securityanalyzer;

import coldfusion.compiler.ASTstart;
import coldfusion.compiler.JJTreeVisitor;
import coldfusion.compiler.NeoTranslator;
import coldfusion.compiler.Node;
import coldfusion.compiler.ParseException;
import coldfusion.compiler.validation.CFMLValidationException;
import coldfusion.filter.FusionContext;
import coldfusion.rds.RdsRequest;
import coldfusion.rds.RdsResponse;
import coldfusion.rds.RdsServlet;
import coldfusion.runtime.ServletConfigWrapper;
import coldfusion.security.AuthorizedUser;
import coldfusion.securityanalyzer.CFMLSecurityAnalyzerError;
import coldfusion.securityanalyzer.CFMLSecurityAnalyzerValidator;
import coldfusion.securityanalyzer.SecurityAnalyzerConfig;
import coldfusion.securityanalyzer.SecurityAnalyzerConstants;
import coldfusion.securityanalyzer.SecurityAnalyzerFileFilter;
import coldfusion.securityanalyzer.SecurityAnalyzerUtils;
import coldfusion.securityanalyzer.rules.RulesCommon;
import coldfusion.securityanalyzer.rules.UnnamedappRule;
import coldfusion.server.ServiceFactory;
import com.restfb.json.JsonArray;
import com.restfb.json.JsonObject;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SecurityAnalyzerServlet
extends RdsServlet {
    private ServletContext application;
    private static NeoTranslator translator = null;
    public static Map<String, Integer> PRIORITYMAP = new HashMap<String, Integer>();
    public static Map<String, String> TYPEMAP = new HashMap<String, String>();
    private JsonArray rules;
    static SecurityAnalyzerServlet securityAnalyzerServlet;
    public static boolean isUnnamed;
    static Node unnamedApplicationNode;
    private static Map<Integer, JsonObject> SCANS;
    private static Integer UNIQUEID;
    List<ExecutorService> executorServices = new ArrayList<ExecutorService>();
    private static ScheduledExecutorService cleanupService;
    private static ScheduledExecutorService executorServiceCleanupService;
    private static ScheduledExecutorService statusCheckerService;
    private final String FILESSCANNED = "filesvisitedcount";
    private final String FILESVISITEDLIST = "filesvisited";
    private final String FILESSCANNEDCOUNT = "filesscannedcount";
    private final String FILESNOTSCANNEDCOUNT = "filesnotscannedcount";
    private final String FILESSCANNEDLIST = "filesscanned";
    private final String LASTUPDATED = "lastupdated";
    private final String TOTALFILES = "totalfiles";
    private final String FILES = "files";
    private final String ID = "id";
    private final String PERCENTAGE = "percentage";
    private final String CANCEL = "cancel";
    private final String CLEAN = "clean";
    private final String RESULT = "result";
    private final String SCAN = "scan";
    private final String FILESNOTSCANNEDLIST = "filesnotscanned";
    private final String REASON = "reason";
    private final String EXECUTORSERVICE = "executorservie";
    private final Map<ExecutorService, Long> executorServiceStartTimeMap = new WeakHashMap<ExecutorService, Long>();
    private final Map<ExecutorService, Long> executorServiceCompletedtasksMap = new WeakHashMap<ExecutorService, Long>();
    private final int QUEUE_THRESHHOLD = 60;
    private final int THREAD_MULTIPIER = 3;
    Runnable cleanupThread = new Runnable(){

        @Override
        public void run() {
            for (Map.Entry<Integer, JsonObject> scan : SCANS.entrySet()) {
                int id = scan.getKey();
                JsonObject scanobj = scan.getValue();
                long current = System.currentTimeMillis();
                if (current - scanobj.getLong("lastupdated") <= 3600000L) continue;
                SCANS.remove(id);
            }
        }
    };
    Runnable executorServiceCleanupThread = new Runnable(){

        @Override
        public void run() {
            for (ExecutorService es : SecurityAnalyzerServlet.this.executorServices) {
                int queueLength = SecurityAnalyzerServlet.this.getQueueLength(es, -1);
                if (queueLength != 0) continue;
                SecurityAnalyzerServlet.this.executorServices.remove(es);
                SecurityAnalyzerServlet.this.executorServiceStartTimeMap.remove(es);
                SecurityAnalyzerServlet.this.executorServiceCompletedtasksMap.remove(es);
                es.shutdown();
                Object var2_2 = null;
            }
        }
    };
    Runnable statusCheckerThread = new Runnable(){

        @Override
        public void run() {
            for (Map.Entry<Integer, JsonObject> scan : SCANS.entrySet()) {
                JsonObject scanobj = scan.getValue();
                long current = System.currentTimeMillis();
                if (current - scanobj.getLong("lastupdated") <= 60000L || scanobj.getInt("percentage") <= 0) continue;
                scanobj.put("filesvisitedcount", scanobj.get("totalfiles"));
            }
        }
    };
    private static int filenum;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(new ServletConfigWrapper(config));
        securityAnalyzerServlet = this;
        this.initCleanupService();
        this.initExecutorservicesCleanupService();
        this.initStatucheckerService();
        this.loadConfigFile();
    }

    protected String doProcess(RdsRequest rdreq, RdsResponse rdresp) {
        HttpServletRequest req = rdreq.getHttpServletRequest();
        HttpServletResponse resp = rdresp.getHttpServletResponse();
        this.readRulesConfigFile(resp);
        try {
            SecurityAnalyzerConfig config = this.createSecurityAnalyzerConfig(rdreq);
            this.initExecutorService(config);
            this.createNeoTranslator(config);
            ArrayList<CFMLSecurityAnalyzerError> ignores = new ArrayList<CFMLSecurityAnalyzerError>();
            JsonObject result = this.scan(config, ignores);
            this.reset();
            this.sendResult(result, resp, config);
            String r = result.toString();
            for (int trycount = 0; r == null && trycount < 10; ++trycount) {
                r = result.toString();
            }
            if (null == r) {
                SecurityAnalyzerUtils.logException(new RuntimeException(), "error");
                JsonObject obj = this.sendError("Server side exception", resp);
                return obj.toString();
            }
            return r;
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "error");
            JsonObject obj = this.sendError(e.getMessage(), resp);
            return obj.toString();
        }
    }

    private void initExecutorService(SecurityAnalyzerConfig config) {
        String cmd = config.getCommand();
        if (!"scan".equalsIgnoreCase(cmd)) {
            return;
        }
        for (ExecutorService es : this.executorServices) {
            int queueLength = this.getQueueLength(es, -1);
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)es;
            long tasksCompleted = threadPoolExecutor.getCompletedTaskCount();
            Long oldTasksCompleted = this.executorServiceCompletedtasksMap.get(es);
            if (null != oldTasksCompleted) {
                tasksCompleted -= oldTasksCompleted.longValue();
            }
            if (tasksCompleted < 1L) {
                tasksCompleted = 1L;
            }
            long timeGap = (System.currentTimeMillis() - this.executorServiceStartTimeMap.get(es)) / 1000L;
            long timePending = (long)queueLength * (timeGap / tasksCompleted);
            if (queueLength == 0) {
                this.executorServiceStartTimeMap.put(es, System.currentTimeMillis());
                this.executorServiceCompletedtasksMap.put(es, tasksCompleted);
            }
            if (timePending >= 60L) continue;
            config.setExecuterService(es);
            break;
        }
        if (config.getExecuterService() == null) {
            ExecutorService executorService = this.createExecutorService(config);
            this.executorServices.add(executorService);
            this.executorServiceStartTimeMap.put(executorService, System.currentTimeMillis());
            config.setExecuterService(executorService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initCleanupService() {
        if (cleanupService != null) return;
        Class<SecurityAnalyzerServlet> clazz = SecurityAnalyzerServlet.class;
        synchronized (SecurityAnalyzerServlet.class) {
            if (cleanupService == null) {
                cleanupService = Executors.newSingleThreadScheduledExecutor();
            }
            cleanupService.scheduleAtFixedRate(this.cleanupThread, 0L, 3600L, TimeUnit.SECONDS);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initExecutorservicesCleanupService() {
        if (executorServiceCleanupService != null) return;
        Class<SecurityAnalyzerServlet> clazz = SecurityAnalyzerServlet.class;
        synchronized (SecurityAnalyzerServlet.class) {
            if (executorServiceCleanupService == null) {
                executorServiceCleanupService = Executors.newSingleThreadScheduledExecutor();
            }
            executorServiceCleanupService.scheduleAtFixedRate(this.executorServiceCleanupThread, 600L, 600L, TimeUnit.SECONDS);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initStatucheckerService() {
        if (statusCheckerService != null) return;
        Class<SecurityAnalyzerServlet> clazz = SecurityAnalyzerServlet.class;
        synchronized (SecurityAnalyzerServlet.class) {
            if (statusCheckerService == null) {
                statusCheckerService = Executors.newSingleThreadScheduledExecutor();
            }
            statusCheckerService.scheduleAtFixedRate(this.statusCheckerThread, 0L, 60L, TimeUnit.SECONDS);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject scan(SecurityAnalyzerConfig config, List<CFMLSecurityAnalyzerError> ignores) throws Exception {
        int id = config.getId();
        JsonObject scan = new JsonObject();
        String cmd = config.getCommand();
        if ("scan".equals(cmd)) {
            Class<SecurityAnalyzerServlet> clazz = SecurityAnalyzerServlet.class;
            synchronized (SecurityAnalyzerServlet.class) {
                UNIQUEID = UNIQUEID + 1;
                id = UNIQUEID;
                // ** MonitorExit[var6_6] (shouldn't be in output)
                scan.put("id", id);
                config.setId(id);
                scan.put("filesvisitedcount", 0);
                scan.put("files", new ArrayList());
                long filescount = this.countFiles(config.getPath(), config.isRecurse(), scan);
                scan.put("totalfiles", filescount);
                scan.put("percentage", 0);
                scan.put("lastupdated", System.currentTimeMillis());
                SCANS.put(id, scan);
                String path = config.getPath();
                CFMLSecurityAnalyzerValidator validator = new CFMLSecurityAnalyzerValidator(config, ignores);
                JsonArray allFiles = (JsonArray)scan.get("files");
                if (allFiles.length() == 1) {
                    this.walkThroughNode(new File(allFiles.getString(0)), validator, config);
                } else {
                    this.validate(config, allFiles, path, validator);
                }
                scan.put("executorservie", (Object)config.getExecuterService());
                scan = new JsonObject();
                scan.put("id", id);
            }
        } else if ("cancel".equals(config.getCommand())) {
            SCANS.remove(config.getId());
        } else {
            scan = SCANS.get(id);
            if (scan != null) {
                int perc = 100;
                int tf = scan.getInt("totalfiles");
                int fs = scan.getInt("filesvisitedcount");
                long lu = scan.getLong("lastupdated");
                if (tf > 0) {
                    perc = fs * 100 / tf;
                }
                scan.put("id", id);
                scan.put("percentage", perc);
                ExecutorService es = (ExecutorService)scan.get("executorservie");
                if (perc == 100 && "clean".equals(config.getCommand())) {
                    SCANS.remove(id);
                    scan = new JsonObject();
                }
                if ("status".equals(cmd)) {
                    scan = new JsonObject();
                    scan.put("id", id);
                    scan.put("percentage", perc);
                    scan.put("totalfiles", tf);
                    scan.put("filesvisitedcount", fs);
                    scan.put("lastupdated", lu);
                    if (perc == 0) {
                        scan.put("queuelength", this.getQueueLength(es, id));
                    }
                }
                if ("result".equals(cmd)) {
                    this.scannedFilesFilter(scan);
                }
            }
        }
        return scan;
    }

    private void scannedFilesFilter(JsonObject scan) {
        JsonArray resultary = new JsonArray();
        if (scan.has("errors")) {
            resultary = scan.getJsonArray("errors");
        }
        JsonArray filesResult = new JsonArray();
        scan.put("filesscanned", (Object)filesResult);
        HashSet<String> vulnerableFiles = new HashSet<String>();
        for (int i = 0; i < resultary.length(); ++i) {
            JsonObject jobj = resultary.getJsonObject(i);
            String filename = jobj.getString("path");
            if (vulnerableFiles.contains(filename)) continue;
            vulnerableFiles.add(filename);
            JsonObject sobj = new JsonObject();
            sobj.put("filename", (Object)filename);
            sobj.put("result", (Object)"vulnerable");
            filesResult.put((Object)sobj);
        }
        JsonArray filesnotscanned = new JsonArray();
        if (scan.has("filesnotscanned")) {
            filesnotscanned = scan.getJsonArray("filesnotscanned");
        }
        scan.put("filesnotscannedcount", filesnotscanned.length());
        JsonArray allFiles = scan.getJsonArray("files");
        JsonArray filesvisited = new JsonArray();
        if (scan.has("filesvisited")) {
            filesvisited = scan.getJsonArray("filesvisited");
        }
        for (int i = 0; i < allFiles.length(); ++i) {
            String filename = allFiles.getString(i);
            boolean isNotScanned = false;
            for (int j = 0; j < filesnotscanned.length(); ++j) {
                String ifile = filesnotscanned.getJsonObject(j).getString("filename");
                if (!ifile.equals(filename)) continue;
                isNotScanned = true;
                break;
            }
            if (isNotScanned || vulnerableFiles.contains(filename)) continue;
            boolean visited = false;
            for (int j = 0; j < filesvisited.length(); ++j) {
                String iifile = filesvisited.getString(j);
                if (!iifile.equals(filename)) continue;
                visited = true;
                break;
            }
            if (!visited) continue;
            JsonObject sobj = new JsonObject();
            sobj.put("filename", (Object)filename);
            sobj.put("result", (Object)"ok");
            filesResult.put((Object)sobj);
        }
        scan.put("filesscannedcount", filesResult.length());
    }

    private long countFiles(String path, boolean recurse, JsonObject scan) {
        long files = 0L;
        JsonArray allFiles = (JsonArray)scan.get("files");
        for (String ipath : path.split(";")) {
            File file = new File(ipath);
            if (file.isFile()) {
                String filename = file.getName();
                if (!SecurityAnalyzerFileFilter.isCFFile(filename = filename.toLowerCase())) continue;
                boolean present = false;
                for (int i = 0; i < allFiles.length(); ++i) {
                    if (!allFiles.getString(i).equals(file.getAbsolutePath())) continue;
                    present = true;
                    break;
                }
                if (present) continue;
                ++files;
                allFiles.put((Object)file.getAbsolutePath());
                continue;
            }
            for (File f : new File(ipath).listFiles()) {
                if (f.isDirectory()) {
                    if (!recurse) continue;
                    files += this.countFiles(f.getAbsolutePath(), recurse, scan);
                    continue;
                }
                String filename = f.getName();
                if (!SecurityAnalyzerFileFilter.isCFFile(filename = filename.toLowerCase())) continue;
                boolean present = false;
                for (int i = 0; i < allFiles.length(); ++i) {
                    if (!allFiles.getString(i).equals(f.getAbsolutePath())) continue;
                    present = true;
                    break;
                }
                if (present) continue;
                ++files;
                allFiles.put((Object)f.getAbsolutePath());
            }
        }
        return files;
    }

    private void createNeoTranslator(SecurityAnalyzerConfig config) {
        if (!config.getCommand().equalsIgnoreCase("scan")) {
            return;
        }
        FusionContext fusionContext = SecurityAnalyzerUtils.getDummyFusionContext(config.getPath());
        FusionContext.setCurrent(fusionContext);
        try {
            translator = new NeoTranslator(fusionContext.application);
        }
        catch (IOException e) {
            SecurityAnalyzerUtils.logException(e, "error");
        }
    }

    public void validate(SecurityAnalyzerConfig config, JsonArray allFiles, String mainPath, JJTreeVisitor validator) throws ParseException, IOException {
        ((CFMLSecurityAnalyzerValidator)validator).setTesting(config.isTesting());
        try {
            SecurityAnalyzerServlet.validateUnnamedApprule(mainPath, validator);
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        for (int i = 0; i < allFiles.length(); ++i) {
            this.execute(config, validator, new File(allFiles.getString(i)));
        }
        if (isUnnamed && unnamedApplicationNode != null) {
            ((CFMLSecurityAnalyzerValidator)validator).collectValidationResult("unnamedapp", SecurityAnalyzerConstants.UNNAMEDAPPMESSAGE, null, "warning", unnamedApplicationNode);
            unnamedApplicationNode = null;
        }
    }

    private ExecutorService createExecutorService(SecurityAnalyzerConfig config) {
        int threads = Runtime.getRuntime().availableProcessors() * 3;
        if (config.getThreadcount() != 0) {
            threads = config.getThreadcount();
        }
        ExecutorService executorService = Executors.newFixedThreadPool(threads);
        return executorService;
    }

    private static void validateUnnamedApprule(String path, JJTreeVisitor validator) {
        if (!((CFMLSecurityAnalyzerValidator)validator).applyRule("unnamedapp")) {
            return;
        }
        File filepath = new File(path + File.separator + "Application.cfc");
        if (!filepath.exists()) {
            filepath = new File(path + File.separator + "Application.cfm");
        }
        boolean isunnamed = true;
        if (new File(path).exists()) {
            if (filepath.exists()) {
                FusionContext.setCurrent(SecurityAnalyzerUtils.getDummyFusionContext(filepath.getAbsolutePath()));
                try {
                    ASTstart node = translator.translateToASTNode(filepath.getAbsolutePath());
                    isunnamed = UnnamedappRule.validate(node);
                    if (isunnamed) {
                        isUnnamed = isunnamed;
                        unnamedApplicationNode = node;
                        return;
                    }
                }
                catch (IOException e) {
                    SecurityAnalyzerUtils.logException(e, "warning");
                }
            } else {
                isunnamed = true;
                String[] splits = (path = path.replace("\\", "/")).split("/");
                if (splits.length < 2) {
                    return;
                }
                path = path.substring(0, path.lastIndexOf("/"));
                SecurityAnalyzerServlet.validateUnnamedApprule(path, validator);
            }
        }
    }

    private void recurseAndValidate(String path, SecurityAnalyzerFileFilter filter, JJTreeVisitor validator, boolean recurse, SecurityAnalyzerConfig config) {
        File file = new File(path);
        if (file.isFile()) {
            this.execute(config, validator, file);
        }
        for (File filepath : file.listFiles(filter)) {
            if (filepath.isDirectory()) {
                if (!recurse) continue;
                this.recurseAndValidate(filepath.getAbsolutePath(), filter, validator, recurse, config);
                continue;
            }
            this.execute(config, validator, filepath);
        }
    }

    private void execute(SecurityAnalyzerConfig config, JJTreeVisitor validator, File filepath) {
        config.getExecuterService().execute(new ExecuteFile(filepath, validator, config));
    }

    private int getQueueLength(ExecutorService service, int currentId) {
        Runnable runnable;
        ExecuteFile r;
        int id;
        if (null == service) {
            return 0;
        }
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)service;
        BlockingQueue<Runnable> queue = threadPoolExecutor.getQueue();
        int count = 0;
        Iterator iterator = queue.iterator();
        while (iterator.hasNext() && (id = (r = (ExecuteFile)(runnable = (Runnable)iterator.next())).getConfig().getId()) != currentId) {
            ++count;
        }
        if (currentId == -1) {
            count += threadPoolExecutor.getActiveCount();
        }
        return count;
    }

    private void createResultary(JJTreeVisitor validator, JsonObject jobj) {
        JsonArray resultary = new JsonArray();
        Collection<CFMLValidationException> result = ((CFMLSecurityAnalyzerValidator)validator).getValidationResult();
        for (CFMLSecurityAnalyzerError cFMLSecurityAnalyzerError : result) {
            JsonObject ijobj = cFMLSecurityAnalyzerError.toJson();
            resultary.put((Object)ijobj);
        }
        jobj.put("errors", (Object)resultary);
        JsonArray jsonArray = new JsonArray();
        Set<String> invalidfiles = ((CFMLSecurityAnalyzerValidator)validator).getInvalidFiles();
        for (String ifile : invalidfiles) {
            JsonObject j = new JsonObject();
            j.put("filename", (Object)ifile);
            j.put("reason", (Object)"Syntax Error");
            jsonArray.put((Object)j);
        }
        Set<String> cannotparsefiles = ((CFMLSecurityAnalyzerValidator)validator).getCannotParseFiles();
        for (String ifile : cannotparsefiles) {
            JsonObject j = new JsonObject();
            j.put("filename", (Object)ifile);
            j.put("reason", (Object)"Encrypted");
            jsonArray.put((Object)j);
        }
        jobj.put("filesnotscanned", (Object)jsonArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void walkThroughNode(File filepath, JJTreeVisitor validator, SecurityAnalyzerConfig config) {
        JsonObject scan = SCANS.get(config.getId());
        if (null == scan) {
            return;
        }
        ASTstart root = null;
        try {
            FusionContext.setCurrent(SecurityAnalyzerUtils.getDummyFusionContext(filepath.getAbsolutePath()));
            root = translator.translateToASTNode(filepath.getAbsolutePath());
            root.accept(validator);
        }
        catch (ParseException ee) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                root = translator.translateToASTNode(filepath.getAbsolutePath());
                root.accept(validator);
            }
            catch (Exception e) {
                ((CFMLSecurityAnalyzerValidator)validator).collectInvalidFiles(filepath.getAbsolutePath());
                SecurityAnalyzerUtils.logException(e, "warning");
            }
        }
        catch (Throwable e) {
            ((CFMLSecurityAnalyzerValidator)validator).collectCannotparseFiles(filepath.getAbsolutePath());
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        JJTreeVisitor jJTreeVisitor = validator;
        synchronized (jJTreeVisitor) {
            scan.put("filesvisitedcount", scan.getInt("filesvisitedcount") + 1);
            if (scan.has("filesvisited")) {
                scan.put("filesvisited", (Object)scan.getJsonArray("filesvisited").put((Object)filepath.getAbsolutePath()));
            } else {
                JsonArray filesVisited = new JsonArray();
                filesVisited.put((Object)filepath.getAbsolutePath());
                scan.put("filesvisited", (Object)filesVisited);
            }
            scan.put("lastupdated", System.currentTimeMillis());
            try {
                this.createResultary(validator, scan);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void sendResult(JsonObject jobj, HttpServletResponse resp, SecurityAnalyzerConfig config) {
        try {
            resp.setHeader("Cache-Control", "no-cache");
            resp.setContentType("application/json");
            jobj.put("status", (Object)"success");
            if (config.getCommand().equals("result")) {
                jobj.put("errorsdescription", (Object)this.rules);
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "error");
        }
    }

    private JsonObject sendError(String message, HttpServletResponse resp) {
        resp.setHeader("Cache-Control", "no-cache");
        resp.setContentType("application/json");
        JsonObject jobj = new JsonObject();
        jobj.put("status", (Object)"error");
        jobj.put("errormessage", (Object)message);
        return jobj;
    }

    private SecurityAnalyzerConfig createSecurityAnalyzerConfig(RdsRequest rdreq) {
        SecurityAnalyzerConfig config = new SecurityAnalyzerConfig();
        String command = rdreq.getMetaString(0).toLowerCase();
        config.setCommand(command);
        if ("cancel".equals(command) || "status".equals(command) || "result".equals(command) || "clean".equals(command)) {
            config.setId(Integer.parseInt(rdreq.getMetaString(1)));
        } else if ("scan".equals(command)) {
            String path = rdreq.getMetaString(1);
            if (path == null) {
                throw new RuntimeException("Invalid file/directory path : " + path);
            }
            for (String ipath : path.split(";")) {
                if (new File(ipath).exists()) continue;
                throw new RuntimeException("Invalid file/directory path : " + path);
            }
            config.setPath(path);
            config.setRuleslist(SecurityAnalyzerConstants.RULESSET);
            try {
                config.setRecurse(Boolean.valueOf(rdreq.getMetaString(2)));
            }
            catch (Exception ex) {
                throw new RuntimeException("Invalid recurse value.It should be third meta param for command scan");
            }
            try {
                config.setThreadcount(Integer.valueOf(rdreq.getMetaString(3)));
            }
            catch (Exception exception) {}
        } else {
            throw new RuntimeException("Invalid command - " + command);
        }
        return config;
    }

    private void reset() {
        RulesCommon.resetVariables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigFile() {
        int y;
        JsonArray ij;
        String next;
        Iterator iter;
        JsonObject j;
        int x;
        if (SecurityAnalyzerConstants.dynamicTagVariablesMap.size() > 0) {
            return;
        }
        String file = "tags.json";
        String fName = ServiceFactory.getRuntimeService().getLibDir() + "/securityanalyzer/" + file;
        FileInputStream ins = null;
        BufferedReader reader = null;
        Object json = "";
        try {
            ins = new FileInputStream(new File(fName));
            InputStreamReader isr = new InputStreamReader(ins);
            reader = new BufferedReader(isr);
            String line = "";
            while ((line = reader.readLine()) != null) {
                json = (String)json + line;
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "error");
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
            }
            catch (IOException e) {
                SecurityAnalyzerUtils.logException(e, "error");
            }
        }
        JsonObject jsondata = new JsonObject((String)json);
        JsonArray dvary = jsondata.getJsonArray("dynamictagvariables");
        for (x = 0; x < dvary.length(); ++x) {
            j = dvary.getJsonObject(x);
            iter = j.keys();
            while (iter.hasNext()) {
                next = (String)iter.next();
                ij = j.getJsonArray(next);
                HashMap map = new HashMap();
                for (y = 0; y < ij.length(); ++y) {
                    JsonObject iij = ij.getJsonObject(y);
                    Iterator iiter = iij.keys();
                    ArrayList<String> list = new ArrayList<String>();
                    while (iiter.hasNext()) {
                        String key = (String)iiter.next();
                        JsonArray iiij = iij.getJsonArray(key);
                        for (int z = 0; z < iiij.length(); ++z) {
                            String value = iiij.getString(z);
                            list.add(value);
                        }
                        map.put(key, list);
                    }
                }
                SecurityAnalyzerConstants.dynamicTagVariablesMap.put(next, map);
            }
        }
        dvary = jsondata.getJsonArray("statictagvariables");
        for (x = 0; x < dvary.length(); ++x) {
            j = dvary.getJsonObject(x);
            iter = j.keys();
            while (iter.hasNext()) {
                next = (String)iter.next();
                ij = j.getJsonArray(next);
                ArrayList<String> list = new ArrayList<String>();
                for (y = 0; y < ij.length(); ++y) {
                    list.add(ij.getString(y));
                }
                SecurityAnalyzerConstants.staticTagVariablesMap.put(next, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRulesConfigFile(HttpServletResponse response) {
        String file = "codeanalyzerrules.json";
        Locale locale = response.getLocale();
        if (locale != null && locale.getLanguage().equals(new Locale("ja").getLanguage())) {
            file = "codeanalyzerrules_ja.json";
        }
        String fName = ServiceFactory.getRuntimeService().getLibDir() + "/securityanalyzer/" + file;
        FileInputStream ins = null;
        BufferedReader reader = null;
        Object json = "";
        try {
            ins = new FileInputStream(new File(fName));
            InputStreamReader isr = new InputStreamReader(ins);
            reader = new BufferedReader(isr);
            String line = "";
            while ((line = reader.readLine()) != null) {
                json = (String)json + line;
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "error");
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                SecurityAnalyzerUtils.logException(e, "error");
            }
        }
        JsonObject jsondata = new JsonObject((String)json);
        this.rules = jsondata.getJsonArray("rules").getJsonObject(0).getJsonArray("security");
        for (int x = 0; x < this.rules.length(); ++x) {
            JsonObject j = this.rules.getJsonObject(x);
            PRIORITYMAP.put(j.getString("name"), j.getInt("severity"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CFMLSecurityAnalyzerError> createIgnoreList() {
        String fName = ServiceFactory.getRuntimeService().getLibDir() + "/securityanalyzer/codeanalyzerrules.json";
        FileInputStream ins = null;
        BufferedReader reader = null;
        Object json = "";
        try {
            ins = new FileInputStream(new File(fName));
            InputStreamReader isr = new InputStreamReader(ins);
            reader = new BufferedReader(isr);
            String line = "";
            while ((line = reader.readLine()) != null) {
                json = (String)json + line;
            }
        }
        catch (Exception e) {
            SecurityAnalyzerUtils.logException(e, "error");
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                SecurityAnalyzerUtils.logException(e, "error");
            }
        }
        ArrayList<CFMLSecurityAnalyzerError> ignoreList = new ArrayList<CFMLSecurityAnalyzerError>();
        JsonObject jsondata = new JsonObject((String)json);
        this.rules = jsondata.getJsonArray("rules").getJsonObject(0).getJsonArray("security");
        for (int x = 0; x < this.rules.length(); ++x) {
            JsonObject j = this.rules.getJsonObject(x);
            CFMLSecurityAnalyzerError exc = new CFMLSecurityAnalyzerError(j.getString("name"), "", new File(j.getString("file")), j.getString("type"));
            exc.setLineNumbers(Integer.parseInt(j.getString("beginline")), Integer.parseInt(j.getString("endline")));
            ignoreList.add(exc);
        }
        return ignoreList;
    }

    @Override
    protected void processCmd(RdsRequest req, RdsResponse resp, AuthorizedUser user) throws ServletException, IOException {
        try {
            String result = this.doProcess(req, resp);
            resp.addMetaData(result);
        }
        catch (Throwable t) {
            SecurityAnalyzerUtils.logException(t, "error");
        }
    }

    static {
        isUnnamed = true;
        unnamedApplicationNode = null;
        SCANS = new HashMap<Integer, JsonObject>();
        UNIQUEID = 0;
        cleanupService = null;
        executorServiceCleanupService = null;
        statusCheckerService = null;
        filenum = 0;
    }

    class ExecuteFile
    implements Runnable {
        File filepath;
        JJTreeVisitor validator;
        SecurityAnalyzerConfig config;

        public ExecuteFile(File filepath, JJTreeVisitor validator, SecurityAnalyzerConfig config) {
            this.filepath = filepath;
            this.validator = validator;
            this.config = config;
        }

        public File getFilepath() {
            return this.filepath;
        }

        public void setFilepath(File filepath) {
            this.filepath = filepath;
        }

        public JJTreeVisitor getValidator() {
            return this.validator;
        }

        public void setValidator(JJTreeVisitor validator) {
            this.validator = validator;
        }

        public SecurityAnalyzerConfig getConfig() {
            return this.config;
        }

        public void setConfig(SecurityAnalyzerConfig config) {
            this.config = config;
        }

        @Override
        public void run() {
            SecurityAnalyzerServlet.this.walkThroughNode(this.filepath, this.validator, this.config);
        }
    }
}

