/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.securityanalyzer.rules;

import coldfusion.compiler.ASTcfscript;
import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTcftag;
import coldfusion.compiler.ASTevalcfoutput;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASToperator;
import coldfusion.compiler.ASTpcdata;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstart;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.NeoTranslator;
import coldfusion.compiler.Node;
import coldfusion.compiler.TagNode;
import coldfusion.filter.FusionContext;
import coldfusion.securityanalyzer.CFMLSecurityAnalyzerValidator;
import coldfusion.securityanalyzer.SecurityAnalyzerConstants;
import coldfusion.securityanalyzer.SecurityAnalyzerUtils;
import coldfusion.securityanalyzer.rules.RulesCommon;
import coldfusion.securityanalyzer.rules.VariableType;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class CSRFRule {
    public static void validate(TagNode node, CFMLSecurityAnalyzerValidator validator) {
        String tagname = node.getTagName();
        if ("cfform".equalsIgnoreCase(tagname)) {
            Boolean isCsrfProtected = CSRFRule._validateCSRF(node, validator);
            if (!isCsrfProtected.booleanValue()) {
                validator.collectValidationResult("csrf", SecurityAnalyzerConstants.CSRFSTARTMESSAGE, null, "warning", node);
                validator.collectInvalidValidationResult("csrf", false, node);
            } else {
                validator.collectInvalidValidationResult("csrf", true, node);
            }
        }
    }

    private static boolean _validateCSRF(Node node, CFMLSecurityAnalyzerValidator validator) {
        Node actionnode = node.getNamedAttribute("action");
        Node parent = node;
        if (null == actionnode) {
            while (!(parent instanceof ASTstart)) {
                parent = parent.jjtGetParent();
            }
        } else {
            Object token = ((ASTliteral)actionnode).tokens.get(0);
            String action = "";
            action = token instanceof ASTsimpleVariableReference ? RulesCommon.getVariableReferenceTypeFromNode(token).getValue() : token.toString();
            Object path = node.getPageFile().getAbsolutePath();
            path = ((String)path).replace("\\", "/");
            path = ((String)path).substring(0, ((String)path).lastIndexOf("/"));
            if (((String)(path = (String)path + "/" + action)).contains("?")) {
                path = ((String)path).substring(0, ((String)path).indexOf("?"));
            }
            FusionContext oldContext = FusionContext.getCurrent();
            FusionContext.setCurrent(SecurityAnalyzerUtils.getDummyFusionContext((String)path));
            try {
                NeoTranslator translator = new NeoTranslator(FusionContext.getCurrent().application);
                parent = translator.translateToASTNode((String)path);
            }
            catch (IOException e) {
                SecurityAnalyzerUtils.logException(e, "warning");
            }
            FusionContext.setCurrent(oldContext);
        }
        List<Node> childs = node.getDirectChildren();
        for (Node n : childs) {
            if (!(n instanceof TagNode)) {
                boolean t = CSRFRule._validateCSRF(n, validator);
                if (!t) continue;
                return t;
            }
            String itagname = ((TagNode)n).getTagName();
            if ("cfinput".equalsIgnoreCase(itagname)) {
                Node type = n.getNamedAttribute("type");
                if (!(type instanceof ASTliteral)) continue;
                Vector tokens = ((ASTliteral)type).tokens;
                for (int i = 0; i < tokens.size(); ++i) {
                    String funcname;
                    VariableType nodetype;
                    Node valuenode;
                    String var;
                    Object t = tokens.get(i);
                    if (!(t instanceof String) || !(var = (String)t).equalsIgnoreCase("hidden") || (valuenode = n.getNamedAttribute("value")) == null) continue;
                    Object value = ((ASTliteral)valuenode).tokens.get(0);
                    if ((value instanceof ASTsimpleVariableReference || value instanceof ASTstructureReference) && RulesCommon.isFunctionType(nodetype = RulesCommon.getVariableReferenceTypeFromNode(value)) && SecurityAnalyzerConstants.CSRFMETHOD.equalsIgnoreCase(funcname = RulesCommon.getFunctionName(nodetype))) {
                        return CSRFRule.checkCsrfVerifyMethod(parent, null);
                    }
                    if (!(value instanceof ASTruntimeCall)) continue;
                    String funcname2 = ((ASTruntimeCall)value).getFunctionName();
                    String arg = CSRFRule._getArg(value, 0);
                    if (!SecurityAnalyzerConstants.CSRFMETHOD.equalsIgnoreCase(funcname2)) continue;
                    return CSRFRule.checkCsrfVerifyMethod(parent, arg);
                }
                continue;
            }
            boolean t = CSRFRule._validateCSRF(n, validator);
            if (!t) continue;
            return t;
        }
        return false;
    }

    private static String _getArg(Object value, int i) {
        List<Node> nodes = ((ASTruntimeCall)value).getNamedAttribute(SecurityAnalyzerConstants.ARGUMENTS).getAllChildren();
        String arg = "";
        if (nodes.size() > i) {
            ASTliteral l = (ASTliteral)nodes.get(i);
            arg = l.tokens.get(0).toString();
        }
        return arg;
    }

    private static boolean checkCsrfVerifyMethod(Node parent, String arg) {
        if (parent instanceof ASTcfscriptStatement && CSRFRule._checkCsrfVerifyMethod((ASTcfscriptStatement)parent, arg)) {
            return true;
        }
        List<Node> childs = parent.getDirectChildren();
        for (Node n : childs) {
            if (n instanceof ASTcfscript) {
                for (Node inode : n.getDirectChildren()) {
                    if (!(inode instanceof ASTcfscriptStatement) || !CSRFRule._checkCsrfVerifyMethod((ASTcfscriptStatement)inode, arg)) continue;
                    return true;
                }
            }
            if (n instanceof ASTcfscriptStatement && CSRFRule._checkCsrfVerifyMethod((ASTcfscriptStatement)n, arg)) {
                return true;
            }
            if (n instanceof ASTruntimeCall && CSRFRule.verifyRuntimeCall((ASTruntimeCall)n, arg)) {
                return true;
            }
            for (Node inode : n.getDirectChildren()) {
                if (!CSRFRule.checkCsrfVerifyMethod(inode, arg)) continue;
                return true;
            }
        }
        return parent instanceof ASTruntimeCall && CSRFRule.verifyRuntimeCall((ASTruntimeCall)parent, arg);
    }

    private static boolean verifyRuntimeCall(ASTruntimeCall n, String arg) {
        String funcname = n.getFunctionName();
        if (SecurityAnalyzerConstants.CSRFVERIFYTOKEN.equalsIgnoreCase(funcname)) {
            String arg2 = CSRFRule._getArg(n, 1);
            if (arg == null || arg.equals(arg2)) {
                return true;
            }
        }
        return false;
    }

    private static boolean _checkCsrfVerifyMethod(ASTcfscriptStatement n, String arg) {
        Node key = null;
        Node value = null;
        key = n.getNamedAttribute("LVAL");
        value = n.getNamedAttribute("RVAL");
        if (null != key) {
            return CSRFRule.checkCsrfVerifyMethod(value, arg);
        }
        String tag = n.getStartToken().toString();
        if (tag.equalsIgnoreCase("cfif") || tag.equalsIgnoreCase("if")) {
            Node innernode = n.getNamedAttribute(SecurityAnalyzerConstants.PREDICATE);
            if (innernode instanceof ASToperator) {
                for (Node iinnernode : innernode.getAllChildren()) {
                    Node fn;
                    if (!(iinnernode instanceof ASToperator ? (fn = iinnernode.getAllChildren().get(0)) instanceof ASTruntimeCall && CSRFRule.checkRuntimecall((ASTruntimeCall)fn, arg) : iinnernode instanceof ASTruntimeCall && CSRFRule.checkRuntimecall((ASTruntimeCall)iinnernode, arg))) continue;
                    return true;
                }
            } else if (innernode instanceof ASTruntimeCall ? CSRFRule.checkRuntimecall((ASTruntimeCall)innernode, arg) : CSRFRule.checkCsrfVerifyMethod(value, arg)) {
                return true;
            }
        }
        return false;
    }

    private static boolean checkRuntimecall(ASTruntimeCall fn, String arg) {
        String funcname = fn.getFunctionName();
        if (SecurityAnalyzerConstants.CSRFVERIFYTOKEN.equalsIgnoreCase(funcname)) {
            String arg2 = CSRFRule._getArg(fn, 1);
            if (arg == null || arg.equals(arg2)) {
                return true;
            }
        }
        return false;
    }

    public static void validate(ASTpcdata node, CFMLSecurityAnalyzerValidator validator) {
        String b = node.buffer.toString().toLowerCase().trim().toLowerCase();
        if (b.contains("<form")) {
            Node parent = node;
            int index = b.indexOf("action");
            if (index == -1) {
                while (!(parent instanceof ASTstart)) {
                    parent = parent.jjtGetParent();
                }
            } else {
                FusionContext oldContext = FusionContext.getCurrent();
                try {
                    int idx1 = b.indexOf("\"", index);
                    int idx2 = b.indexOf("\"", idx1 + 1);
                    String action = b.substring(idx1 + 1, idx2);
                    Object path = node.getPageFile().getAbsolutePath();
                    path = ((String)path).replace("\\", "/");
                    path = ((String)path).substring(0, ((String)path).lastIndexOf("/"));
                    path = (String)path + "/" + action;
                    FusionContext.setCurrent(SecurityAnalyzerUtils.getDummyFusionContext((String)path));
                    NeoTranslator translator = new NeoTranslator(FusionContext.getCurrent().application);
                    parent = translator.translateToASTNode((String)path);
                }
                catch (Exception e) {
                    SecurityAnalyzerUtils.logException(e, "warning");
                }
                FusionContext.setCurrent(oldContext);
            }
            boolean isSafe = false;
            List<Node> childs = node.jjtGetParent().getDirectChildren();
            for (Node child : childs) {
                if (child instanceof ASTcftag) {
                    Node token;
                    List<Node> ichilds;
                    if (child.getDirectChildren().size() == 0 || !(child.getDirectChildren().get(0) instanceof ASTevalcfoutput) || (ichilds = ((ASTevalcfoutput)child.getDirectChildren().get(0)).getDirectChildren()).size() <= 0 || !CSRFRule._validatePcdata(token = ichilds.get(0), parent)) continue;
                    isSafe = true;
                    break;
                }
                if (!(child instanceof ASTevalcfoutput) || !CSRFRule._validatePcdata(child, parent)) continue;
                isSafe = true;
                break;
            }
            if (!isSafe) {
                validator.collectValidationResult("csrf", SecurityAnalyzerConstants.CSRFSTARTMESSAGE, null, "warning", node, false);
            }
        }
    }

    private static boolean _validatePcdata(Node token, Node parent) {
        VariableType nodetype = RulesCommon.getVariableReferenceTypeFromNode(token);
        String funcname = RulesCommon.getFunctionName(nodetype);
        return SecurityAnalyzerConstants.CSRFMETHOD.equalsIgnoreCase(funcname) && CSRFRule.checkCsrfVerifyMethod(parent, null);
    }
}

