/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.securityanalyzer.rules;

import coldfusion.compiler.ASTfuncparams;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.Node;
import coldfusion.compiler.TagNode;
import coldfusion.securityanalyzer.CFMLSecurityAnalyzerValidator;
import coldfusion.securityanalyzer.SecurityAnalyzerConstants;
import coldfusion.securityanalyzer.rules.RulesCommon;
import coldfusion.securityanalyzer.rules.VariableType;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class FileinjectionRule {
    private static Set<String> FILEINJECTIONPRONEMETHODS = new HashSet<String>();
    private static Set<String> FILEINJECTIONALLOWEDFUNCTIONS;

    public static void validate(TagNode node, CFMLSecurityAnalyzerValidator validator) {
        String tagname = node.getTagName().toLowerCase();
        String attr = "";
        if ("cfinclude".equals(tagname)) {
            attr = "template";
        } else if ("cffile".equals(tagname)) {
            attr = "file";
        } else if ("cfdirectory".equals(tagname)) {
            attr = "directory";
        }
        if (attr.length() != 0) {
            Node type = node.getNamedAttribute(attr);
            FileinjectionRule._validate(type, validator);
        }
        if ("cffile".equals(tagname)) {
            Vector tokens;
            String t;
            Node action = node.getNamedAttribute("action");
            if (null != action && ((t = (tokens = ((ASTliteral)action).tokens).get(0).toString().toLowerCase()).equalsIgnoreCase("copy") || t.equalsIgnoreCase("rename"))) {
                FileinjectionRule._validate(node.getNamedAttribute("source"), validator);
                FileinjectionRule._validate(node.getNamedAttribute("destination"), validator);
            }
        } else if ("cfdocument".equals(tagname)) {
            FileinjectionRule._validate(node.getNamedAttribute("src"), validator);
            FileinjectionRule._validate(node.getNamedAttribute("srcfile"), validator);
        } else if ("cfhtmltopdf".equals(tagname)) {
            FileinjectionRule._validate(node.getNamedAttribute("source"), validator);
            FileinjectionRule._validate(node.getNamedAttribute("destination"), validator);
        }
    }

    private static void _validate(Node type, CFMLSecurityAnalyzerValidator validator) {
        boolean vulnerable = false;
        if (type instanceof ASTliteral) {
            Vector tokens = ((ASTliteral)type).tokens;
            for (int i = 0; i < tokens.size(); ++i) {
                ASTruntimeCall func;
                Object value = tokens.get(i);
                if (value instanceof ASTsimpleVariableReference || value instanceof ASTstructureReference) {
                    VariableType nodetype = RulesCommon.getVariableReferenceTypeFromNode(value);
                    if (!RulesCommon.isScopeVulnerable(nodetype) || RulesCommon.isConstantType(nodetype) || FileinjectionRule.isFunctionAllowed(nodetype)) continue;
                    vulnerable = true;
                    break;
                }
                if (!(value instanceof ASTruntimeCall) || FILEINJECTIONALLOWEDFUNCTIONS.contains((func = (ASTruntimeCall)value).getFunctionName().toLowerCase())) continue;
                vulnerable = true;
                break;
            }
        }
        if (vulnerable) {
            validator.collectValidationResult("fileinjection", SecurityAnalyzerConstants.FILEINJECTIONSTARTMESSAGE, null, "warning", type);
            validator.collectInvalidValidationResult("fileinjection", false, type);
        } else {
            validator.collectInvalidValidationResult("fileinjection", true, type);
        }
    }

    private static boolean isFunctionAllowed(VariableType nodetype) {
        if (!RulesCommon.isFunctionType(nodetype)) {
            return false;
        }
        String functionname = nodetype.getValue().toLowerCase();
        return FILEINJECTIONALLOWEDFUNCTIONS.contains(functionname);
    }

    public static void validate(ASTfuncparams node, CFMLSecurityAnalyzerValidator validator) {
        String functionname = node.getFunctionName().toLowerCase();
        if (!FILEINJECTIONPRONEMETHODS.contains(functionname)) {
            return;
        }
        int index = 0;
        for (Node value : node.getAllChildren()) {
            String fn;
            boolean vulnerable = false;
            if (++index != 1 && (index <= 1 || !functionname.equals("filemove") && !functionname.equals("filecopy"))) continue;
            if (value instanceof ASTsimpleVariableReference || value instanceof ASTstructureReference) {
                String nodename = RulesCommon.getVariableReferenceNameFromNode(value);
                VariableType nodetype = RulesCommon.getVariableReferenceType(nodename, node);
                if (!RulesCommon.isConstantType(nodetype) && !FileinjectionRule.isFunctionAllowed(nodetype)) {
                    vulnerable = true;
                }
            } else if (value instanceof ASTliteral) {
                try {
                    fn = ((ASTruntimeCall)value.getAllChildren().get(0)).getFunctionName().toLowerCase();
                    if (!FILEINJECTIONALLOWEDFUNCTIONS.contains(fn)) {
                        vulnerable = true;
                    }
                }
                catch (Throwable fn2) {}
            } else if (value instanceof ASTruntimeCall && !FILEINJECTIONALLOWEDFUNCTIONS.contains(fn = ((ASTruntimeCall)value).getFunctionName().toLowerCase())) {
                vulnerable = true;
            }
            if (vulnerable) {
                validator.collectValidationResult("fileinjection", SecurityAnalyzerConstants.FILEINJECTIONSTARTMESSAGE, null, "warning", value);
                validator.collectInvalidValidationResult("fileinjection", false, value);
                continue;
            }
            validator.collectInvalidValidationResult("fileinjection", true, value);
        }
    }

    static {
        FILEINJECTIONPRONEMETHODS.add("fileopen");
        FILEINJECTIONPRONEMETHODS.add("fileread");
        FILEINJECTIONPRONEMETHODS.add("filewrite");
        FILEINJECTIONPRONEMETHODS.add("filecopy");
        FILEINJECTIONPRONEMETHODS.add("filemove");
        FILEINJECTIONPRONEMETHODS.add("filedelete");
        FILEINJECTIONPRONEMETHODS.add("fileexists");
        FILEINJECTIONPRONEMETHODS.add("directoryexists");
        FILEINJECTIONPRONEMETHODS.add("directorylist");
        FILEINJECTIONPRONEMETHODS.add("directorycreate");
        FILEINJECTIONPRONEMETHODS.add("directorydelete");
        FILEINJECTIONPRONEMETHODS.add("directoryrename");
        FILEINJECTIONALLOWEDFUNCTIONS = new HashSet<String>();
        FILEINJECTIONALLOWEDFUNCTIONS.add("getcurrenttemplatepath");
        FILEINJECTIONALLOWEDFUNCTIONS.add("expandpath");
        FILEINJECTIONALLOWEDFUNCTIONS.add("getdirectoryfrompath");
        FILEINJECTIONALLOWEDFUNCTIONS.add("getbasetemplatepath");
        FILEINJECTIONALLOWEDFUNCTIONS.add("getfilefrompath");
        FILEINJECTIONALLOWEDFUNCTIONS.add("gettempfile");
        FILEINJECTIONALLOWEDFUNCTIONS.add("gettempdirectory");
    }
}

