/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.securityanalyzer.rules;

import coldfusion.compiler.ASTfuncparams;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.Node;
import coldfusion.compiler.TagNode;
import coldfusion.runtime.Cast;
import coldfusion.securityanalyzer.CFMLSecurityAnalyzerValidator;
import coldfusion.securityanalyzer.rules.RulesCommon;
import coldfusion.securityanalyzer.rules.VariableType;
import coldfusion.util.RB;
import java.util.Vector;

public class FileuploadRule {
    public static void validate(TagNode node, CFMLSecurityAnalyzerValidator validator) {
        String tagname = node.getTagName();
        if ("cffile".equalsIgnoreCase(tagname)) {
            Node attr = node.getNamedAttribute("action");
            Vector tokens = ((ASTliteral)attr).tokens;
            Object var = null;
            for (int i = 0; i < tokens.size(); ++i) {
                String value;
                Object t = tokens.get(i);
                if (!(t instanceof String) || !(value = (String)t).equalsIgnoreCase("upload") && !value.equalsIgnoreCase("uploadall")) continue;
                FileuploadRule.checkDestinationAttribute(node, validator);
                Node httponlyattr = node.getNamedAttribute("strict");
                if (null != httponlyattr) {
                    RulesCommon.checkBooleanAttribute("fileupload", node, validator, "strict", "error");
                }
                FileuploadRule.checkAllowedExtensions(node, validator);
            }
        }
    }

    private static void checkAllowedExtensions(TagNode node, CFMLSecurityAnalyzerValidator validator) {
        Object token;
        Node allowedExtensions = node.getNamedAttribute("allowedExtensions");
        if (allowedExtensions != null && allowedExtensions instanceof ASTliteral && (token = ((ASTliteral)allowedExtensions).tokens.get(0)) instanceof String) {
            String v = (String)token;
            String notallowed = "AS,ASP,ASPX,BIN,DMG,CFC,CFM,CFML,CFR,CFSWF,EXE,HBXML,JSP,JSPX,JWS,MXML,PHP,SWC,SWS";
            for (String s : notallowed.split(",")) {
                if (!v.toUpperCase().equals("." + s)) continue;
                validator.collectValidationResult("fileupload", "Allowing such extensions can make your server vulnerable", null, "warning", allowedExtensions);
            }
        }
    }

    private static void checkDestinationAttribute(TagNode node, CFMLSecurityAnalyzerValidator validator) {
        String attribute = "destination";
        String functionname = "gettempdirectory";
        Node httponlyattr = node.getNamedAttribute(attribute);
        if (null == httponlyattr) {
            validator.collectValidationResult("fileupload", attribute + " " + RB.getString(FileuploadRule.class, "AttribNotSpecified"), null, "error", node);
            validator.collectInvalidValidationResult("fileupload", false, node);
        } else {
            Vector tokens = ((ASTliteral)httponlyattr).tokens;
            Object var = null;
            for (int i = 0; i < tokens.size(); ++i) {
                Object t = tokens.get(i);
                VariableType nodetype = null;
                if (t instanceof String) {
                    FileuploadRule.addError(validator, httponlyattr, nodetype);
                    continue;
                }
                if (t instanceof ASTsimpleVariableReference || t instanceof ASTstructureReference) {
                    nodetype = RulesCommon.getVariableReferenceTypeFromNode(node);
                    if (RulesCommon.isFunctionType(nodetype) && functionname.equals(nodetype.getValue().toLowerCase())) continue;
                    FileuploadRule.addError(validator, httponlyattr, nodetype);
                    continue;
                }
                if (!(t instanceof ASTruntimeCall) || ((ASTruntimeCall)t).getFunctionName().toLowerCase().equals(functionname)) continue;
                FileuploadRule.addError(validator, httponlyattr, nodetype);
            }
        }
    }

    private static void addError(CFMLSecurityAnalyzerValidator validator, Node node, VariableType nodetype) {
        validator.collectValidationResult("fileupload", RB.getString(FileuploadRule.class, "UseDestination") + "='#getTempDirectory()#' ", nodetype, "warning", node);
        validator.collectInvalidValidationResult("fileupload", false, node);
    }

    public static void validate(ASTfuncparams node, CFMLSecurityAnalyzerValidator validator) {
        Node child;
        String functionname = node.getFunctionName().toLowerCase();
        if (functionname.equalsIgnoreCase("fileupload") && node.getDirectChildren().size() > 4) {
            child = node.getDirectChildren().get(4);
            FileuploadRule._validateFunctions(child, validator, "fileupload", node);
        }
        if (functionname.equalsIgnoreCase("fileuploadall") && node.getDirectChildren().size() > 3) {
            child = node.getDirectChildren().get(3);
            FileuploadRule._validateFunctions(child, validator, "fileuploadall", node);
        }
    }

    private static void _validateFunctions(Node child, CFMLSecurityAnalyzerValidator validator, String func, Node node) {
        String var = null;
        VariableType nodetype = null;
        if (child instanceof ASTsimpleVariableReference || child instanceof ASTstructureReference) {
            nodetype = RulesCommon.getVariableReferenceTypeFromNode(child);
            if (nodetype.getType().equals("constant")) {
                var = nodetype.getValue();
            } else {
                validator.collectValidationResult("fileupload", " In " + func + " " + RB.getString(FileuploadRule.class, "StrictParam"), nodetype, "error", child);
            }
        } else if (child instanceof ASTliteral) {
            Vector tokens = ((ASTliteral)child).tokens;
            for (int i = 0; i < tokens.size(); ++i) {
                Object t = tokens.get(i);
                if (t instanceof ASTsimpleVariableReference || t instanceof ASTstructureReference) {
                    nodetype = RulesCommon.getVariableReferenceTypeFromNode(t);
                    if (nodetype.getType().equals("constant")) {
                        var = nodetype.getValue();
                    } else {
                        validator.collectValidationResult("fileupload", " In " + func + " " + RB.getString(FileuploadRule.class, "StrictParam"), nodetype, "error", child);
                    }
                }
                if (!(t instanceof String)) continue;
                var = (String)t;
            }
        }
        if (null != var && !Cast._boolean(var)) {
            validator.collectValidationResult("fileupload", " In " + func + " " + RB.getString(FileuploadRule.class, "StrictParam"), nodetype, "error", child);
        }
    }
}

