/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.securityanalyzer.rules;

import coldfusion.compiler.ASTArrayInitializer;
import coldfusion.compiler.ASTStructInitializer;
import coldfusion.compiler.ASTarrayReference;
import coldfusion.compiler.ASTcfargument;
import coldfusion.compiler.ASTcffunction;
import coldfusion.compiler.ASTcfloop;
import coldfusion.compiler.ASTcfscript;
import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTcftag;
import coldfusion.compiler.ASTevalcfoutput;
import coldfusion.compiler.ASTfuncparams;
import coldfusion.compiler.ASTfunctionDefinition;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASToperator;
import coldfusion.compiler.ASTparameterDefinition;
import coldfusion.compiler.ASTpcdata;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstart;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.ASTvariableDefinition;
import coldfusion.compiler.NeoTranslator;
import coldfusion.compiler.Node;
import coldfusion.compiler.TagNode;
import coldfusion.compiler.Token;
import coldfusion.compiler.VariableReference;
import coldfusion.filter.FusionContext;
import coldfusion.runtime.CFPageMethod;
import coldfusion.runtime.Cast;
import coldfusion.securityanalyzer.CFMLSecurityAnalyzerValidator;
import coldfusion.securityanalyzer.SecurityAnalyzerConstants;
import coldfusion.securityanalyzer.SecurityAnalyzerUtils;
import coldfusion.securityanalyzer.rules.VariableType;
import coldfusion.util.RB;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class RulesCommon {
    private static Map<String, Map<String, String>> VARIABLESTYPEMAP = new HashMap<String, Map<String, String>>();
    private static String[] paramDependentInbuiltMethods = new String[]{"repeatstring", "ucase", "lcase", "preservesinglequotes", "left", "right", "mid", "trim", "duplicate"};
    public static List<String> paramDependentInbuiltMethodsList = Arrays.asList(paramDependentInbuiltMethods);
    static Map<String, Node> ApplicationcfcsNodeMap = new HashMap<String, Node>();
    static Map<String, Map<String, VariableType>> ApplicationcfcsVariableMap = new HashMap<String, Map<String, VariableType>>();

    public static boolean isVulnerableType(VariableType vtype) {
        if (!RulesCommon.isScopeVulnerable(vtype)) {
            return false;
        }
        String type = null;
        if (vtype != null) {
            type = vtype.getType();
        }
        return null == type || "vulnerable".equals(type) || "variablenotfound".equals(type) || "cfparaminvalid".equals(type) || "string".equals(type) || "function".equals(type) || RulesCommon.isFunctionType(vtype);
    }

    public static boolean isFunctionType(VariableType type) {
        return type != null && type.getType() != null && (type.getType().equals("function") || type.getType().equals("functionwithvulnerableparam") || type.getType().equals("functioninbuilt"));
    }

    public static boolean isConstantType(VariableType nodetype) {
        return nodetype != null && nodetype.getType() != null && nodetype.getType().equals("constant");
    }

    public static String getFunctionName(VariableType nodetype) {
        return nodetype.getValue();
    }

    public static boolean isScopeVulnerable(VariableType nodetype) {
        String[] scopes = new String[]{""};
        List<String> scopeslist = Arrays.asList(scopes);
        if (null == nodetype || null == nodetype.getType()) {
            return true;
        }
        if (nodetype.getType().equals("vulnerable") || nodetype.getType().equals("variablenotfound")) {
            String value = nodetype.getValue();
            if (value == null) {
                return true;
            }
            String[] split = value.split("\\.");
            return !scopeslist.contains(split[0].toLowerCase()) || split.length == 1;
        }
        return true;
    }

    public static boolean isVulnerableXssType(VariableType type, Node n) {
        if (RulesCommon.isFunctionType(type)) {
            String value = type.getValue().toLowerCase();
            if (SecurityAnalyzerConstants.XSSENCODEFUNCTIONS.contains(value)) {
                if (null == n) {
                    return false;
                }
                return RulesCommon.checkForCorrectEncodingFunction(n, value);
            }
            if (paramDependentInbuiltMethodsList.contains(value)) {
                return type.getType().equalsIgnoreCase("functionwithvulnerableparam");
            }
            if (RulesCommon.isInbuiltSafeMethod(value)) {
                return false;
            }
            return type.getType() == null || !type.getType().equals("functioninbuilt");
        }
        return RulesCommon.isVulnerableType(type);
    }

    private static boolean checkForCorrectEncodingFunction(Node n, String value) {
        String data;
        boolean containsStartTag = false;
        boolean containsEndTag = false;
        for (Node child : n.jjtGetParent().getDirectChildren()) {
            if (n == child) break;
            if (!(child instanceof ASTpcdata)) continue;
            data = ((ASTpcdata)child).buffer.toString().toLowerCase().trim();
            if (data.contains("<style")) {
                containsStartTag = true;
            }
            if (!data.contains("</style>")) continue;
            containsEndTag = true;
        }
        if (containsStartTag && !containsEndTag && !"encodeforcss".equals(value)) {
            return true;
        }
        containsStartTag = false;
        containsEndTag = false;
        for (Node child : n.jjtGetParent().getDirectChildren()) {
            if (n == child) break;
            if (!(child instanceof ASTpcdata)) continue;
            data = ((ASTpcdata)child).buffer.toString().toLowerCase().trim();
            if (data.contains("<script")) {
                containsStartTag = true;
            }
            if (!data.contains("</script>")) continue;
            containsEndTag = true;
        }
        return containsStartTag && !containsEndTag && !"encodeforjavascript".equals(value);
    }

    public static boolean isInbuiltSafeMethod(String mName) {
        if (null == mName) {
            return false;
        }
        String[] safeMethods = new String[]{"repeatstring", "duplicate", "ucase", "lcase", "left", "right", "mid", "trim", "gettickcount", "jstringformat", "chr", "listsort", "getlocale", "expandpath", "createuuid", "getpagecontext", "getrequest", "getcontextpath", "hash", "booleanformat", "inputbasen", "formatbasen"};
        if (mName.equalsIgnoreCase(SecurityAnalyzerConstants.CSRFVERIFYTOKEN) || mName.equalsIgnoreCase(SecurityAnalyzerConstants.CSRFMETHOD)) {
            return true;
        }
        if (Arrays.asList(safeMethods).contains(mName.toLowerCase()) || RulesCommon.isInbuiltDateFunction(mName.toLowerCase())) {
            return true;
        }
        Map map = CFPageMethod.getMethodMap(mName);
        Method method = null;
        if (null != map) {
            for (Map.Entry e : map.entrySet()) {
                method = (Method)e.getValue();
            }
            if (null != method) {
                Class<?> returntype = method.getReturnType();
                return returntype.getName().equalsIgnoreCase("boolean") || returntype.getName().equalsIgnoreCase("int") || returntype.getName().equalsIgnoreCase("double") || returntype.getName().equalsIgnoreCase("java.lang.Long");
            }
        }
        return false;
    }

    public static boolean isInbuiltMethod(String mName) {
        if (null == mName) {
            return false;
        }
        Map map = CFPageMethod.getMethodMap(mName);
        return null != map;
    }

    private static boolean isInbuiltDateFunction(String date) {
        return date.contains("date") && !date.contains("update") || date.equals("now") || date.contains("time") || date.contains("day") || date.contains("month") || date.contains("year") || date.contains("second");
    }

    public static void addVariableType(Node node, String codgen, VariableType type) {
        String file = node.getPageFile().getAbsolutePath();
        Map<String, String> map = VARIABLESTYPEMAP.get(file);
        if (null == map) {
            map = new HashMap<String, String>();
        }
        map.put(codgen, type.getType());
        VARIABLESTYPEMAP.put(file, map);
    }

    public static String getVariableReferenceTypeFromCache(Node node, String codgen) {
        String file = node.getPageFile().getAbsolutePath();
        Map<String, String> map = VARIABLESTYPEMAP.get(file);
        if (null == map) {
            return null;
        }
        return map.get(codgen);
    }

    public static VariableType getVariableReferenceTypeFromNode(Object token, Node parent, List<VariableType> variableTypes) {
        VariableType type;
        String ocodgen;
        VariableReference atoken;
        List<Node> childs;
        if (token instanceof ASTevalcfoutput && (childs = ((ASTevalcfoutput)token).getDirectChildren()).size() > 0) {
            token = childs.get(0);
        }
        if (token instanceof ASToperator) {
            childs = ((ASToperator)token).getAllChildren();
            VariableType type2 = new VariableType();
            for (Node node : childs) {
                type2 = RulesCommon.getVariableReferenceTypeFromNode(node, parent, variableTypes);
                if (type2 == null || type2.getType() == null || !RulesCommon.isVulnerableXssType(type2, node)) continue;
                return type2;
            }
            type2.setType("constant");
            return type2;
        }
        if (token instanceof ASTliteral) {
            childs = ((ASTliteral)token).getDirectChildren();
            if (childs.size() > 0) {
                token = childs.get(0);
            } else {
                Vector tokens = ((ASTliteral)token).tokens;
                Object t = tokens.get(0);
                if (t instanceof String) {
                    VariableType type3 = new VariableType();
                    type3.setType("constant");
                    type3.setValue((String)t);
                    return type3;
                }
            }
        }
        if (token instanceof ASTsimpleVariableReference) {
            atoken = (ASTsimpleVariableReference)token;
            ocodgen = atoken.getCodegenVariableName();
            type = RulesCommon.getVariableTypeFromAppcfcsOrCurrentfile(ocodgen, atoken, parent, variableTypes);
            return type;
        }
        if (token instanceof ASTstructureReference) {
            atoken = (ASTstructureReference)token;
            ocodgen = RulesCommon.getVariablenameFromStruct((ASTstructureReference)atoken);
            type = RulesCommon.getVariableTypeFromAppcfcsOrCurrentfile(ocodgen, atoken, parent, variableTypes);
            return type;
        }
        if (token instanceof ASTarrayReference) {
            atoken = (ASTarrayReference)token;
            ocodgen = RulesCommon.getVariablenameFromArray((ASTarrayReference)atoken);
            type = RulesCommon.getVariableTypeFromAppcfcsOrCurrentfile(ocodgen, atoken, parent, variableTypes);
            return type;
        }
        if (token instanceof ASTruntimeCall) {
            return RulesCommon.createFunctionType(token);
        }
        return null;
    }

    public static VariableType getVariableReferenceTypeFromNode(Object token, List<VariableType> variableTypes) {
        return RulesCommon.getVariableReferenceTypeFromNode(token, null, variableTypes);
    }

    public static VariableType getVariableReferenceTypeFromNode(Object token) {
        return RulesCommon.getVariableReferenceTypeFromNode(token, null, new ArrayList<VariableType>());
    }

    public static VariableType getVariableTypeFromAppcfcsOrCurrentfile(String ocodgen, Node atoken, Node parent, List<VariableType> variableTypes) {
        VariableType type = RulesCommon.getVariableReferenceType(ocodgen, atoken, parent, variableTypes);
        if (type == null || type.getType() == null || type.getType().equals("variablenotfound")) {
            type = RulesCommon.getVariableTypeFromApplicationcfcs(ocodgen, atoken.getPageFile().getAbsolutePath());
        }
        if (type.getType() == null) {
            type.setType("variablenotfound");
        }
        return type;
    }

    public static String getVariableReferenceNameFromNode(Object token) {
        VariableReference atoken;
        List<Node> childs;
        if (token instanceof ASTevalcfoutput && (childs = ((ASTevalcfoutput)token).getDirectChildren()).size() > 0) {
            token = childs.get(0);
        }
        if (token instanceof ASTsimpleVariableReference) {
            atoken = (ASTsimpleVariableReference)token;
            return atoken.getCodegenVariableName();
        }
        if (token instanceof ASTstructureReference) {
            atoken = (ASTstructureReference)token;
            return RulesCommon.getVariablenameFromStruct((ASTstructureReference)atoken);
        }
        return null;
    }

    public static VariableType getVariableReferenceType(String ocodgen, Node currentnode, Node parent, List<VariableType> variableTypes) {
        Node node;
        if (null == parent) {
            parent = currentnode.jjtGetParent();
        }
        if (null == parent) {
            parent = currentnode;
        }
        while (null != parent && !(parent instanceof ASTstart) && null != (node = parent.jjtGetParent())) {
            parent = parent.jjtGetParent();
        }
        int startLength = variableTypes.size();
        RulesCommon._getVariableReferenceType(parent, ocodgen, currentnode, false, variableTypes);
        VariableType finaltype = new VariableType();
        finaltype.setValue(ocodgen);
        finaltype.setType("variablenotfound");
        if (startLength < variableTypes.size()) {
            for (VariableType type : variableTypes) {
                if (type == null || type.getType() == null) continue;
                finaltype = type;
            }
        }
        return finaltype;
    }

    public static VariableType getVariableReferenceType(String ocodgen, Node currentnode) {
        return RulesCommon.getVariableReferenceType(ocodgen, currentnode, null, new ArrayList<VariableType>());
    }

    public static VariableType getVariableReferenceType(String ocodgen, Node currentnode, List<VariableType> variableTypes) {
        return RulesCommon.getVariableReferenceType(ocodgen, currentnode, null, variableTypes);
    }

    public static void _getVariableReferenceType(Node parent, String ocodgen, Node currentnode, boolean currentNodeCrossed, List<VariableType> variableTypes) {
        Node catchNode;
        Node elseNode;
        List<Node> childs = parent.getDirectChildren();
        ocodgen = ocodgen.toLowerCase();
        VariableType vtype = new VariableType();
        vtype.setValue(ocodgen);
        if (ocodgen.contains(".")) {
            String scope = ocodgen.split("\\.")[0];
            if (scope.equalsIgnoreCase("cfcatch")) {
                RulesCommon.addVariableType(RulesCommon.constantType(), variableTypes);
                return;
            }
            if (RulesCommon.isSafeStaticTagVariable(ocodgen)) {
                RulesCommon.addVariableType(RulesCommon.constantType(), variableTypes);
                return;
            }
        }
        if (null != (elseNode = parent.getNamedAttribute("ELSE"))) {
            childs.add(elseNode);
        }
        if (null != (catchNode = parent.getNamedAttribute("CATCH1"))) {
            childs.add(catchNode);
        }
        for (Node node : childs) {
            Object loopParent;
            if (currentNodeCrossed) {
                return;
            }
            if (RulesCommon.metCurrentNode(node, currentnode)) {
                currentNodeCrossed = true;
            }
            if (node instanceof ASTcftag) {
                ASTcftag cftag = (ASTcftag)node;
                if ("cfinclude".equalsIgnoreCase(cftag.getTagName())) {
                    ASTstart root = null;
                    root = RulesCommon.getIncludedFileRoot(cftag);
                    if (null != root) {
                        VariableType type = RulesCommon.getVariableReferenceType(ocodgen, root, variableTypes);
                        RulesCommon.addVariableType(type, variableTypes);
                    }
                } else if ("cfparam".equalsIgnoreCase(cftag.getTagName())) {
                    varnode = cftag.getNamedAttribute("name");
                    Node typenode = cftag.getNamedAttribute("type");
                    type = RulesCommon.getTypeFromCfparamTypeTags(varnode, typenode, ocodgen);
                    RulesCommon.addVariableType(type, variableTypes);
                } else if ("admin:l10n".equalsIgnoreCase(cftag.getTagName())) {
                    varnode = cftag.getNamedAttribute("var");
                    if (varnode instanceof ASTliteral) {
                        Vector tokens = ((ASTliteral)varnode).tokens;
                        for (int i = 0; i < tokens.size(); ++i) {
                            Object t = tokens.get(i);
                            if (!(t instanceof String) || !((String)t).equalsIgnoreCase(ocodgen)) continue;
                            vtype.setType("admin:l10n");
                            RulesCommon.addVariableType(vtype, variableTypes);
                        }
                    }
                } else if ("cfsavecontent".equalsIgnoreCase(cftag.getTagName())) {
                    String variable;
                    Object variableo;
                    varnode = cftag.getNamedAttribute("variable");
                    if (varnode instanceof ASTliteral && (variableo = ((ASTliteral)varnode).tokens.get(0)) instanceof String && ocodgen.equalsIgnoreCase(variable = (String)variableo)) {
                        VariableType type = new VariableType();
                        boolean isvul = false;
                        for (Node node2 : cftag.getAllChildren()) {
                            if (!(node2 instanceof ASTcftag) || ((ASTcftag)node2).getTagName().equalsIgnoreCase("cfqueryparam")) continue;
                            for (Node scnode : node2.getAllChildren()) {
                                VariableType itype = RulesCommon.getVariableReferenceTypeFromNode(scnode, variableTypes);
                                if (itype == null || itype.getType() == null || !RulesCommon.isVulnerableType(itype)) continue;
                                RulesCommon.addVariableType(itype, variableTypes);
                                isvul = true;
                            }
                        }
                        if (!isvul) {
                            type.setType("constant");
                            RulesCommon.addVariableType(type, variableTypes);
                        }
                    }
                } else if (RulesCommon.isSafeDynamicTagVariable(cftag, ocodgen)) {
                    RulesCommon.addVariableType(RulesCommon.constantType(), variableTypes);
                    return;
                }
            } else if (node instanceof ASTcfloop) {
                String varvalue;
                if (RulesCommon.isSafeDynamicTagVariable(node, ocodgen)) {
                    RulesCommon.addVariableType(RulesCommon.constantType(), variableTypes);
                    return;
                }
                Node index = node.getNamedAttribute("index");
                if (index instanceof ASTliteral && null != (varvalue = RulesCommon.getAstliteralValue((ASTliteral)index)) && varvalue.equalsIgnoreCase(ocodgen)) {
                    for (loopParent = currentnode; loopParent != null; loopParent = ((Node)loopParent).jjtGetParent()) {
                        if (loopParent != node) continue;
                        type = new VariableType();
                        type.setType("constant");
                        RulesCommon.addVariableType(type, variableTypes);
                        break;
                    }
                }
            } else if (node instanceof ASTcfargument) {
                RulesCommon.checkCfargument(node, ocodgen, variableTypes, currentnode);
            } else if (node instanceof ASTcfscriptStatement) {
                RulesCommon.getVariableReferenceTypeFromCfscriptstatement(node, ocodgen, currentnode, variableTypes);
            }
            if (node instanceof ASTcfscript) {
                Node key = null;
                Node value = null;
                loopParent = node.getDirectChildren().iterator();
                while (loopParent.hasNext()) {
                    Node pnode;
                    List<Node> fchilds;
                    Node inode = loopParent.next();
                    for (int i = 0; i < inode.jjtGetParent().getAllChildren().size(); ++i) {
                        if (i <= 0) continue;
                        Node n1 = inode.jjtGetParent().getAllChildren().get(i);
                        Node n2 = inode.jjtGetParent().getAllChildren().get(i - 1);
                        if (n1 != inode || !RulesCommon.containsNode(n2, currentnode)) continue;
                        return;
                    }
                    if (inode instanceof ASTcffunction && (fchilds = inode.getAllChildren()).size() > 0 && (pnode = fchilds.get(0)) instanceof ASTparameterDefinition) {
                        List<Node> ipnode = pnode.getAllChildren();
                        for (Node n2 : ipnode) {
                            RulesCommon.checkCfargument(n2, ocodgen, variableTypes, currentnode);
                        }
                    }
                    if (inode instanceof ASTvariableDefinition && inode.getDirectChildren().size() > 0) {
                        inode = inode.getDirectChildren().get(0);
                    }
                    if (inode instanceof ASTcfscriptStatement) {
                        key = ((ASTcfscriptStatement)inode).getNamedAttribute("LVAL");
                        value = ((ASTcfscriptStatement)inode).getNamedAttribute("RVAL");
                    }
                    if (null == key && inode instanceof ASTcfscriptStatement) {
                        String varvalue;
                        List<Node> list;
                        Node varnode;
                        Node expr = ((ASTcfscriptStatement)inode).getNamedAttribute("EXPR");
                        if (!(expr instanceof ASTruntimeCall)) continue;
                        ASTruntimeCall runtime = (ASTruntimeCall)expr;
                        String funcname = runtime.getFunctionName();
                        if ("setvariable".equalsIgnoreCase(funcname) && (varnode = (list = runtime.getParameters().getDirectChildren()).get(0)) instanceof ASTliteral && null != (varvalue = RulesCommon.getAstliteralValue((ASTliteral)varnode)) && varvalue.equalsIgnoreCase(ocodgen)) {
                            Node valuenode = list.get(1);
                            RulesCommon.getType(valuenode, ocodgen, expr, variableTypes);
                        }
                        RulesCommon.getVariableReferenceTypeFromCfscriptstatement(node, ocodgen, node, variableTypes);
                        continue;
                    }
                    RulesCommon.getVariableReferenceTypeFromCfscriptstatement(inode, ocodgen, node, variableTypes);
                }
                continue;
            }
            boolean isOtherfunction = false;
            if (node instanceof ASTfunctionDefinition) {
                isOtherfunction = true;
                String currentfuncname = ((ASTfunctionDefinition)node).getUserName();
                String orignodefunc = RulesCommon.getFunctionnameOfArgument(currentnode);
                if (currentfuncname != null && orignodefunc != null && currentfuncname.equalsIgnoreCase(orignodefunc)) {
                    isOtherfunction = false;
                }
            }
            if (isOtherfunction) continue;
            RulesCommon._getVariableReferenceType(node, ocodgen, currentnode, false, variableTypes);
            if (!currentNodeCrossed) continue;
            return;
        }
    }

    private static void checkCfargument(Node n, String ocodgen, List<VariableType> variableTypes, Node currentnode) {
        if (n instanceof ASTcfargument) {
            ASTcfargument cftag = (ASTcfargument)n;
            String currentnodefunc = RulesCommon.getFunctionnameOfArgument(cftag);
            String orignodefunc = RulesCommon.getFunctionnameOfArgument(currentnode);
            if (currentnodefunc != null && orignodefunc != null && currentnodefunc.equalsIgnoreCase(orignodefunc)) {
                Node varnode = cftag.getNamedAttribute("name");
                Node typenode = cftag.getNamedAttribute("type");
                VariableType type = RulesCommon.getTypeFromCfparamTypeTags(varnode, typenode, ocodgen);
                RulesCommon.addVariableType(type, variableTypes);
            }
        }
    }

    private static boolean containsNode(Node n2, Node currentnode) {
        if (n2 == currentnode) {
            return true;
        }
        List<Node> allchilds = n2.getAllChildren();
        for (Node child : allchilds) {
            if (child == currentnode) {
                return true;
            }
            boolean c = RulesCommon.containsNode(child, currentnode);
            if (!c) continue;
            return true;
        }
        return false;
    }

    private static void addVariableType(VariableType type, List<VariableType> variableTypes) {
        if (type != null && null != type.getType()) {
            variableTypes.add(type);
        }
    }

    private static boolean isSafeDynamicTagVariable(Node cftag, String ocodgen) {
        Map<String, List<String>> attrs;
        String tagName = "cfloop";
        if (cftag instanceof ASTcftag) {
            tagName = ((ASTcftag)cftag).getTagName().toLowerCase();
        }
        if (SecurityAnalyzerConstants.dynamicTagVariablesMap.keySet().contains(tagName) && null != (attrs = SecurityAnalyzerConstants.dynamicTagVariablesMap.get(tagName))) {
            for (Map.Entry<String, List<String>> entry : attrs.entrySet()) {
                Object token;
                Node resultnode = cftag.getNamedAttribute(entry.getKey());
                if (null == resultnode || !(resultnode instanceof ASTliteral) || !((token = ((ASTliteral)resultnode).tokens.get(0)) instanceof String)) continue;
                List<String> values = entry.getValue();
                String value = (String)token;
                for (String attr : values) {
                    if ((value + "." + attr).equalsIgnoreCase(ocodgen)) {
                        return true;
                    }
                    if (!attr.equals("*") || !ocodgen.startsWith(value)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static VariableType constantType() {
        VariableType type = new VariableType();
        type.setType("constant");
        return type;
    }

    private static boolean isSafeStaticTagVariable(String ocodgen) {
        List<String> attrs;
        String tag = ocodgen.split("\\.")[0].toLowerCase();
        if (SecurityAnalyzerConstants.staticTagVariablesMap.keySet().contains(tag) && null != (attrs = SecurityAnalyzerConstants.staticTagVariablesMap.get(tag))) {
            for (String str : attrs) {
                if (!(tag + "." + str).equalsIgnoreCase(ocodgen)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean metCurrentNode(Node node, Node currentnode) {
        if (RulesCommon.containsNode(node, currentnode)) {
            return true;
        }
        try {
            Enumeration iter = node.getAttrNames();
            while (iter.hasMoreElements()) {
                String name = (String)iter.nextElement();
                Node inode = node.getNamedAttribute(name);
                if (!(inode instanceof ASTliteral)) continue;
                Vector tokens = ((ASTliteral)inode).tokens;
                for (int i = 0; i < tokens.size(); ++i) {
                    Object t = tokens.get(i);
                    if (t != currentnode) continue;
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void getVariableReferenceTypeFromCfscriptstatement(Node inode, String ocodgen, Node node, List<VariableType> variableTypes) {
        void var7_14;
        Node key = null;
        Node value = null;
        if (inode instanceof ASTcfscriptStatement) {
            key = ((ASTcfscriptStatement)inode).getNamedAttribute("LVAL");
            value = ((ASTcfscriptStatement)inode).getNamedAttribute("RVAL");
        }
        if (!(key instanceof ASTsimpleVariableReference) && !(key instanceof ASTstructureReference) && !(key instanceof ASTarrayReference)) return;
        String codgen = "";
        if (key instanceof ASTsimpleVariableReference) {
            codgen = ((ASTsimpleVariableReference)key).getCodegenVariableName();
        } else if (key instanceof ASTarrayReference) {
            ASTarrayReference aSTarrayReference = (ASTarrayReference)key;
            codgen = RulesCommon.getVariablenameFromArray(aSTarrayReference);
        } else {
            ASTstructureReference aSTstructureReference = (ASTstructureReference)key;
            codgen = RulesCommon.getVariablenameFromStruct(aSTstructureReference);
        }
        if (value instanceof ASTArrayInitializer) {
            String s0;
            List list = ((ASTArrayInitializer)value).getInitializers();
            if (ocodgen.contains(".") && (s0 = ocodgen.split("\\.")[0]).equalsIgnoreCase(codgen)) {
                String s = ocodgen.split("\\.")[1];
                int idx = 0;
                try {
                    idx = Integer.parseInt(s);
                    Object innernode = list.get(idx - 1);
                    RulesCommon.getVariableReferenceTypeFromNode(innernode, value, variableTypes);
                }
                catch (Exception innernode) {
                    // empty catch block
                }
            }
        }
        String string = "";
        String afterdotOcodgen = "";
        if (ocodgen.contains(".")) {
            String string2 = ocodgen.substring(0, ocodgen.lastIndexOf("."));
            afterdotOcodgen = ocodgen.substring(ocodgen.lastIndexOf(".") + 1, ocodgen.length());
        }
        if (ocodgen.equalsIgnoreCase(codgen) || var7_14.equalsIgnoreCase(codgen) && value instanceof ASTStructInitializer) {
            if (value instanceof ASTliteral) {
                Vector tokens = ((ASTliteral)value).tokens;
                VariableType type = null;
                VariableType currentvulnerableNode = new VariableType();
                currentvulnerableNode.setType("constant");
                for (int i = 0; i < tokens.size(); ++i) {
                    Object t = tokens.get(i);
                    if (tokens.size() == 1 && t instanceof String) {
                        VariableType itype = new VariableType();
                        itype.setType("constant");
                        itype.setValue((String)t);
                        RulesCommon.addVariableType(itype, variableTypes);
                        return;
                    }
                    ArrayList<VariableType> ivariableTypes = new ArrayList<VariableType>();
                    if (t instanceof ASTsimpleVariableReference) {
                        String iocodgen = ((ASTsimpleVariableReference)t).getCodegenVariableName();
                        if (codgen.equalsIgnoreCase(iocodgen)) {
                            if (variableTypes.size() > 0) continue;
                            VariableType itype = new VariableType();
                            itype.setType("variablenotfound");
                            RulesCommon.addVariableType(itype, variableTypes);
                            return;
                        }
                        RulesCommon.getType(t, codgen, inode, ivariableTypes);
                    } else {
                        RulesCommon.getType(t, codgen, inode, ivariableTypes);
                    }
                    if (null != type && tokens.size() == 1) {
                        RulesCommon.addVariableType(node, codgen, type);
                        RulesCommon.addVariableType(type, variableTypes);
                    }
                    if (ivariableTypes.size() == 0) {
                        currentvulnerableNode = new VariableType();
                        currentvulnerableNode.setType("variablenotfound");
                        RulesCommon.addVariableType(currentvulnerableNode, variableTypes);
                        return;
                    }
                    if (!RulesCommon.isVulnerableXssType(ivariableTypes.get(ivariableTypes.size() - 1), node)) continue;
                    currentvulnerableNode = ivariableTypes.get(ivariableTypes.size() - 1);
                    boolean hasCfqueryparam = false;
                    if (null != currentvulnerableNode && RulesCommon.isVulnerableXssType(currentvulnerableNode, null)) {
                        if (i > 0) {
                            for (int j = i - 1; j >= 0; --j) {
                                String pvalue;
                                ArrayList<VariableType> iivariableTypes = new ArrayList<VariableType>();
                                RulesCommon.getType(tokens.get(j), codgen, node, iivariableTypes);
                                if (iivariableTypes.size() <= 0) break;
                                VariableType previousToken = iivariableTypes.get(iivariableTypes.size() - 1);
                                if (!RulesCommon.isConstantType(previousToken) || !(pvalue = previousToken.getValue()).toLowerCase().contains("cfqueryparam")) continue;
                                hasCfqueryparam = true;
                                type.setType("constant");
                                break;
                            }
                        }
                        if (!hasCfqueryparam) break;
                    }
                    if (hasCfqueryparam) continue;
                    RulesCommon.addVariableType(currentvulnerableNode, variableTypes);
                    return;
                }
                RulesCommon.addVariableType(currentvulnerableNode, variableTypes);
                return;
            } else {
                if (value instanceof ASTruntimeCall) {
                    RulesCommon.addVariableType(RulesCommon.createFunctionType(value, codgen), variableTypes);
                    return;
                }
                if (value instanceof ASTstructureReference && value.getNamedAttribute("STEM") instanceof ASTarrayReference) {
                    VariableType type = new VariableType();
                    type.setType("vulnerable");
                    RulesCommon.addVariableType(type, variableTypes);
                    return;
                }
                if (value instanceof ASTStructInitializer) {
                    Map struct = ((ASTStructInitializer)value).getInitializers();
                    for (Map.Entry thisEntry : struct.entrySet()) {
                        String v;
                        Object k = thisEntry.getKey();
                        if (!(k instanceof Token) || !(v = ((Token)k).toString()).equalsIgnoreCase(afterdotOcodgen)) continue;
                        Node structNode = (Node)thisEntry.getValue();
                        Object type = null;
                        if (structNode instanceof ASTliteral) {
                            Vector tokens = ((ASTliteral)structNode).tokens;
                            Object n = tokens.get(0);
                            RulesCommon.getType(n, codgen, node, variableTypes);
                            continue;
                        }
                        RulesCommon.getType(structNode, codgen, node, variableTypes);
                    }
                    return;
                } else if (value instanceof ASToperator) {
                    RulesCommon.getTypeFromASTOperator((ASToperator)value, codgen, inode, variableTypes);
                    return;
                } else {
                    RulesCommon.getType(value, codgen, inode, variableTypes);
                }
            }
            return;
        } else {
            if (!ocodgen.startsWith(codgen.toLowerCase()) || !ocodgen.toLowerCase().startsWith("cookie.")) return;
            try {
                if (ocodgen.charAt(codgen.length()) != '.' || !(value instanceof ASTsimpleVariableReference)) return;
                String newvar = ((ASTsimpleVariableReference)value).getStartToken() + "." + ocodgen.substring(codgen.length() + 1, ocodgen.length());
                RulesCommon.getVariableReferenceType(newvar, inode, node, variableTypes);
                return;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static void getTypeFromASTOperator(ASToperator value, String codgen, Node inode, List<VariableType> variableTypesFinal) {
        for (Node operator : value.getDirectChildren()) {
            ArrayList<VariableType> variableTypes = new ArrayList<VariableType>();
            if (operator instanceof ASTsimpleVariableReference) {
                String iocodgen = ((ASTsimpleVariableReference)operator).getCodegenVariableName();
                if (codgen.equalsIgnoreCase(iocodgen)) {
                    if (variableTypesFinal.size() > 0) continue;
                    VariableType type = new VariableType();
                    type.setType("variablenotfound");
                    RulesCommon.addVariableType(type, variableTypesFinal);
                    return;
                }
                RulesCommon.getType(operator, codgen, inode, variableTypes);
            } else {
                RulesCommon.getType(operator, codgen, inode, variableTypes);
            }
            VariableType finaltype = new VariableType();
            for (VariableType itype : variableTypes) {
                if (itype == null || itype.getType() == null) continue;
                finaltype = itype;
            }
            if (!RulesCommon.isVulnerableXssType(finaltype, inode)) continue;
            finaltype.setValue(codgen);
            RulesCommon.addVariableType(finaltype, variableTypesFinal);
            return;
        }
        for (VariableType vt : variableTypesFinal) {
            if (!RulesCommon.isVulnerableXssType(vt, inode)) continue;
            return;
        }
        RulesCommon.addVariableType(RulesCommon.constantType(), variableTypesFinal);
    }

    private static boolean isConditionLogic(Node node) {
        String nodestr;
        return node.getStartToken() != null && SecurityAnalyzerConstants.LOGIC_NODES.contains(nodestr = node.getStartToken().toString());
    }

    private static String getAstliteralValue(ASTliteral node) {
        Vector tokens = node.tokens;
        if (tokens.size() > 1) {
            return null;
        }
        for (int i = 0; i < tokens.size(); ++i) {
            Object t = tokens.get(i);
            if (!(t instanceof String)) continue;
            return (String)t;
        }
        return null;
    }

    private static ASTstart getIncludedFileRoot(ASTcftag cftag) {
        Node importnode = cftag.getNamedAttribute("template");
        Object importpath = "";
        if (importnode instanceof ASTliteral) {
            Vector tokens = ((ASTliteral)importnode).tokens;
            if (tokens.size() > 1) {
                return null;
            }
            for (int i = 0; i < tokens.size(); ++i) {
                Object t = tokens.get(i);
                if (!(t instanceof String)) continue;
                importpath = (String)t;
            }
        }
        FusionContext current = FusionContext.getCurrent();
        importpath = !new File(FusionContext.getCurrent().getPagePath() + "/../" + (String)importpath).exists() ? FusionContext.getCurrent().getRealPath((String)importpath) : FusionContext.getCurrent().getPagePath() + "/../" + (String)importpath;
        FusionContext.setCurrent(SecurityAnalyzerUtils.getDummyFusionContext(new File(FusionContext.getCurrent().getPagePath() + "/../" + (String)importpath).getAbsolutePath()));
        ASTstart root = null;
        try {
            root = new NeoTranslator(FusionContext.getCurrent().application).translateToASTNode(new File((String)importpath).getAbsolutePath());
        }
        catch (IOException e) {
            SecurityAnalyzerUtils.logException(e, "warning");
        }
        FusionContext.setCurrent(current);
        return root;
    }

    private static String getFunctionnameOfArgument(Node cftag) {
        if (null == cftag) {
            return null;
        }
        Node functionnode = cftag.jjtGetParent();
        String funcname = null;
        while (functionnode != null && !(functionnode instanceof ASTstart)) {
            if (!((functionnode = functionnode.jjtGetParent()) instanceof ASTfunctionDefinition)) continue;
            funcname = ((ASTfunctionDefinition)functionnode).getUserName();
            break;
        }
        return funcname;
    }

    private static VariableType getTypeFromCfparamTypeTags(Node varnode, Node typenode, String ocodgen) {
        VariableType vtype = new VariableType();
        if (varnode instanceof ASTliteral) {
            Vector tokens = ((ASTliteral)varnode).tokens;
            for (int i = 0; i < tokens.size(); ++i) {
                String var;
                Object t = tokens.get(i);
                if (!(t instanceof String) || !(var = (String)t).equalsIgnoreCase(ocodgen) && !("arguments." + var).equalsIgnoreCase(ocodgen)) continue;
                vtype.setValue(ocodgen);
                if (typenode != null && typenode instanceof ASTliteral) {
                    Object type = ((ASTliteral)typenode).tokens.get(0);
                    if (!(type instanceof String)) continue;
                    String typestr = (String)type;
                    if (Arrays.asList(SecurityAnalyzerConstants.PARAM_TYPES_ALLOWED).contains(typestr.toLowerCase())) {
                        vtype.setType(typestr);
                    } else {
                        vtype.setType("cfparaminvalid");
                    }
                    return vtype;
                }
                vtype.setType("cfparaminvalid");
                return vtype;
            }
        }
        return vtype;
    }

    private static void getType(Object t, String codgen, Node node, List<VariableType> variableTypes) {
        VariableType type = new VariableType();
        type.setValue(codgen);
        if (t instanceof ASTsimpleVariableReference) {
            String iocodgen = ((ASTsimpleVariableReference)t).getCodegenVariableName();
            if (codgen.equalsIgnoreCase(iocodgen)) {
                if (variableTypes.size() > 0) {
                    RulesCommon.addVariableType(variableTypes.get(variableTypes.size() - 1), variableTypes);
                } else {
                    type.setType("variablenotfound");
                    RulesCommon.addVariableType(type, variableTypes);
                }
                return;
            }
            type = RulesCommon.getVariableReferenceType(iocodgen, node, variableTypes);
        } else if (t instanceof ASTstructureReference) {
            ASTstructureReference s = (ASTstructureReference)t;
            String iocodgen = RulesCommon.getVariablenameFromStruct(s);
            if (codgen.equalsIgnoreCase(iocodgen)) {
                return;
            }
            type = RulesCommon.getVariableReferenceType(iocodgen, node, variableTypes);
        } else if (t instanceof ASTarrayReference) {
            ASTarrayReference s = (ASTarrayReference)t;
            String iocodgen = RulesCommon.getVariablenameFromArray(s);
            type = RulesCommon.getVariableReferenceType(iocodgen, node, variableTypes);
        } else if (t instanceof String) {
            type.setType("constant");
            type.setValue((String)t);
        } else if (t instanceof ASTruntimeCall) {
            type = RulesCommon.createFunctionType(t, codgen);
        } else if (t instanceof ASTliteral) {
            int i = 0;
            Vector tokens = ((ASTliteral)t).tokens;
            if (i < tokens.size()) {
                Object token = tokens.get(i);
                RulesCommon.getType(token, codgen, node, variableTypes);
            }
        } else if (t instanceof ASToperator) {
            RulesCommon.getTypeFromASTOperator((ASToperator)t, codgen, node, variableTypes);
        } else {
            type.setType("vulnerable");
        }
        RulesCommon.addVariableType(type, variableTypes);
    }

    private static VariableType createFunctionType(Object t, String var) {
        VariableType type = new VariableType();
        type.setType("function");
        ASTruntimeCall func = (ASTruntimeCall)t;
        ASTfuncparams funcparams = func.getParameters();
        for (Node param : funcparams.getDirectChildren()) {
            if (!var.equalsIgnoreCase(RulesCommon.getVariableReferenceNameFromNode(param))) {
                VariableType argtype;
                ArrayList<VariableType> variableTypes;
                if (param instanceof ASTruntimeCall) {
                    type.setType("functionwithvulnerableparam");
                    break;
                }
                if (RulesCommon.isInbuiltSafeMethod(func.getFunctionName())) {
                    variableTypes = new ArrayList<VariableType>();
                    argtype = null;
                    if (!(param instanceof ASToperator)) {
                        argtype = RulesCommon.getVariableReferenceTypeFromNode(param, variableTypes);
                    }
                    if (argtype == null || !RulesCommon.isVulnerableType(argtype)) continue;
                    type.setType("functionwithvulnerableparam");
                    break;
                }
                if (!RulesCommon.isInbuiltMethod(func.getFunctionName())) continue;
                variableTypes = new ArrayList();
                argtype = null;
                if (!(param instanceof ASToperator)) {
                    argtype = RulesCommon.getVariableReferenceTypeFromNode(param, variableTypes);
                }
                if (argtype != null && RulesCommon.isVulnerableType(argtype)) {
                    type.setType("functionwithvulnerableparam");
                    break;
                }
                type.setType("functioninbuilt");
                continue;
            }
            type.setType("functionwithvulnerableparam");
            break;
        }
        type.setValue(func.getFunctionName());
        return type;
    }

    private static VariableType createFunctionType(Object t) {
        return RulesCommon.createFunctionType(t, "");
    }

    private static String getVariablenameFromStruct(ASTstructureReference s) {
        Node stem = s.getNamedAttribute("STEM");
        Object codgen = "";
        if (stem instanceof ASTsimpleVariableReference) {
            codgen = ((ASTsimpleVariableReference)stem).getCodegenVariableName();
        }
        if (stem instanceof ASTarrayReference) {
            codgen = RulesCommon.getVariablenameFromArray((ASTarrayReference)stem);
        }
        for (String key : s.getStructureKeys()) {
            codgen = (String)codgen + "." + key;
        }
        return codgen;
    }

    private static String getVariablenameFromArray(ASTarrayReference s) {
        Node stem = s.getNamedAttribute("STEM");
        Object codgen = "";
        if (stem instanceof ASTstructureReference) {
            codgen = RulesCommon.getVariablenameFromStruct((ASTstructureReference)stem);
        } else if (stem instanceof ASTsimpleVariableReference) {
            codgen = ((ASTsimpleVariableReference)stem).getCodegenVariableName();
        }
        Node index = s.getNamedAttribute("INDEX0");
        String indexstr = "";
        if (index instanceof ASTliteral) {
            Vector tokens = ((ASTliteral)index).tokens;
            for (int i = 0; i < tokens.size(); ++i) {
                Object t = tokens.get(i);
                if (!(t instanceof String)) continue;
                indexstr = (String)t;
            }
        } else if (index instanceof ASTsimpleVariableReference) {
            indexstr = ((ASTsimpleVariableReference)index).getCodegenVariableName();
        }
        codgen = (String)codgen + "." + indexstr;
        return codgen;
    }

    public static void resetVariables() {
        VARIABLESTYPEMAP.clear();
    }

    public static void checkBooleanAttribute(String key, TagNode node, CFMLSecurityAnalyzerValidator validator, String attribute, String vulnerabilityType) {
        Node httponlyattr = node.getNamedAttribute(attribute);
        if (null == httponlyattr) {
            validator.collectValidationResult(key, attribute + " " + RB.getString(RulesCommon.class, "AttribNotGiven"), null, vulnerabilityType, node);
            validator.collectInvalidValidationResult(key, false, node);
        } else if (httponlyattr instanceof ASTliteral) {
            Vector tokens = ((ASTliteral)httponlyattr).tokens;
            String var = null;
            for (int i = 0; i < tokens.size(); ++i) {
                Object t = tokens.get(i);
                VariableType nodetype = null;
                if (t instanceof ASTsimpleVariableReference || t instanceof ASTstructureReference) {
                    ArrayList<VariableType> variableTypes = new ArrayList<VariableType>();
                    nodetype = RulesCommon.getVariableReferenceTypeFromNode(t, variableTypes);
                    if (nodetype.getType().equals("constant")) {
                        var = nodetype.getValue();
                    } else {
                        if (RulesCommon.isFunctionType(nodetype)) {
                            vulnerabilityType = "warning";
                        }
                        validator.collectValidationResult(key, attribute + " " + RB.getString(RulesCommon.class, "ValueNotPresent"), nodetype, vulnerabilityType, httponlyattr);
                        validator.collectInvalidValidationResult(key, false, httponlyattr);
                    }
                } else if (t instanceof ASTruntimeCall) {
                    validator.collectValidationResult(key, attribute + " " + RB.getString(RulesCommon.class, "ValueNotPresent"), nodetype, "warning", httponlyattr);
                }
                if (t instanceof String) {
                    var = (String)t;
                }
                if (null == var) continue;
                if (!Cast._boolean(var)) {
                    validator.collectValidationResult(key, attribute + " " + RB.getString(RulesCommon.class, "AttribFalse"), nodetype, vulnerabilityType, httponlyattr);
                    validator.collectInvalidValidationResult(key, false, httponlyattr);
                    continue;
                }
                validator.collectInvalidValidationResult(key, true, httponlyattr);
            }
        }
    }

    private static VariableType getVariableTypeFromApplicationcfcs(String variablename, String path) {
        File filepath = new File(path + File.separator + "Application.cfc");
        if (!filepath.exists()) {
            filepath = new File(path + File.separator + "Application.cfm");
        }
        VariableType type = new VariableType();
        type.setValue(variablename);
        boolean found = false;
        Map<String, VariableType> map = ApplicationcfcsVariableMap.get(filepath.getAbsolutePath());
        if (null == map) {
            map = new HashMap<String, VariableType>();
            ApplicationcfcsVariableMap.put(filepath.getAbsolutePath(), map);
        }
        if (new File(path).exists() && filepath.exists()) {
            if (map.get(variablename) != null && map.get(variablename).getType() != null) {
                return map.get(variablename);
            }
            FusionContext.setCurrent(SecurityAnalyzerUtils.getDummyFusionContext(filepath.getAbsolutePath()));
            try {
                String abspath = filepath.getAbsolutePath();
                Node root = ApplicationcfcsNodeMap.get(abspath);
                if (null == root && FusionContext.getCurrent().application != null) {
                    root = new NeoTranslator(FusionContext.getCurrent().application).translateToASTNode(abspath);
                    ApplicationcfcsNodeMap.put(abspath, root);
                }
                ArrayList<VariableType> variableTypes = new ArrayList<VariableType>();
                if (null != root) {
                    RulesCommon._getVariableReferenceType(root, variablename, null, false, variableTypes);
                }
                if (variableTypes.size() > 0) {
                    for (VariableType itype : variableTypes) {
                        if (itype == null || itype.getType() == null) continue;
                        type = itype;
                    }
                    if (type != null && type.getType() != null) {
                        found = true;
                    }
                    map.put(variablename, type);
                }
            }
            catch (IOException e) {
                SecurityAnalyzerUtils.logException(e, "warning");
            }
        }
        if (!found) {
            String[] splits = (path = path.replace("\\", "/")).split("/");
            if (splits.length < 2) {
                return type;
            }
            path = path.substring(0, path.lastIndexOf("/"));
            return RulesCommon.getVariableTypeFromApplicationcfcs(variablename, path);
        }
        return type;
    }
}

