/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.securityanalyzer.rules;

import coldfusion.compiler.ASTcfscriptStatement;
import coldfusion.compiler.ASTcftag;
import coldfusion.compiler.ASTevalcfoutput;
import coldfusion.compiler.ASTfuncparams;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASTpcdata;
import coldfusion.compiler.ASTruntimeCall;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstructureReference;
import coldfusion.compiler.Node;
import coldfusion.compiler.TagNode;
import coldfusion.securityanalyzer.CFMLSecurityAnalyzerValidator;
import coldfusion.securityanalyzer.rules.RulesCommon;
import coldfusion.securityanalyzer.rules.VariableType;
import coldfusion.util.RB;
import java.util.List;
import java.util.Vector;

public class SqlRule {
    public static void validateCfquerySqlInjection(TagNode node, CFMLSecurityAnalyzerValidator validator) {
        String tagname = node.getTagName();
        if ("cfquery".equalsIgnoreCase(tagname)) {
            SqlRule._validateCfquerySqlInjection(node, validator);
        }
    }

    private static void _validateCfquerySqlInjection(Node node, CFMLSecurityAnalyzerValidator validator) {
        List<Node> children = node.getDirectChildren();
        if (SqlRule.isQueryOfQueries(node)) {
            return;
        }
        boolean cfparamShouldBeNext = false;
        boolean cfparamused = true;
        boolean noncfparamerror = false;
        boolean isInsertSql = false;
        VariableType type = null;
        Node invalidToken = null;
        for (Node n : children) {
            cfparamused = true;
            invalidToken = n;
            if (cfparamShouldBeNext) {
                if (n instanceof ASTcftag) {
                    String siblingname = ((ASTcftag)n).getTagName();
                    if (!"cfqueryparam".equalsIgnoreCase(siblingname)) {
                        cfparamused = false;
                    }
                } else {
                    type = RulesCommon.getVariableReferenceTypeFromNode(n);
                    if (RulesCommon.isVulnerableType(type) && !RulesCommon.isInbuiltSafeMethod(type.getValue())) {
                        cfparamused = false;
                    }
                }
                cfparamShouldBeNext = false;
                if (cfparamused) continue;
                validator.collectInvalidValidationResult("sqlinjection", false, invalidToken);
                if (RulesCommon.isFunctionType(type)) {
                    validator.collectValidationResult("sqlinjection", RB.getString(SqlRule.class, "CfQueryParam"), type, "warning", invalidToken);
                    continue;
                }
                validator.collectValidationResult("sqlinjection", RB.getString(SqlRule.class, "CfQueryParam"), type, "error", invalidToken);
                continue;
            }
            if (n instanceof ASTpcdata) {
                String text = ((ASTpcdata)n).buffer.toString().trim().toLowerCase();
                if (text.startsWith("insert")) {
                    isInsertSql = true;
                    cfparamShouldBeNext = true;
                    continue;
                }
                if (isInsertSql) {
                    if (!text.endsWith(",")) continue;
                    cfparamShouldBeNext = true;
                    continue;
                }
                if (!SqlRule.isComparatorEnding(text)) continue;
                cfparamShouldBeNext = true;
                continue;
            }
            if (!(n instanceof ASTcfscriptStatement) && !(n instanceof ASTevalcfoutput)) continue;
            if (n instanceof ASTcfscriptStatement) {
                SqlRule.parseScriptstatementNode((ASTcfscriptStatement)n, validator);
            }
            if (!(n instanceof ASTevalcfoutput) || !RulesCommon.isVulnerableType(type = RulesCommon.getVariableReferenceTypeFromNode(n)) || !RulesCommon.isVulnerableXssType(type, null) || !(noncfparamerror = true)) continue;
            validator.collectInvalidValidationResult("sqlinjection", false, invalidToken);
            if (RulesCommon.isFunctionType(type)) {
                validator.collectValidationResult("sqlinjection", RB.getString(SqlRule.class, "SqlInjection"), type, "warning", invalidToken);
                continue;
            }
            validator.collectValidationResult("sqlinjection", RB.getString(SqlRule.class, "SqlInjection"), type, "error", invalidToken);
        }
    }

    private static boolean isQueryOfQueries(Node node) {
        Node dbtypenode = node.getNamedAttribute("dbtype");
        if (null == dbtypenode) {
            return false;
        }
        if (dbtypenode instanceof ASTliteral) {
            Vector tokens = ((ASTliteral)dbtypenode).tokens;
            for (int i = 0; i < tokens.size(); ++i) {
                Object t = tokens.get(i);
                if (!(t instanceof String) || !((String)t).equalsIgnoreCase("query")) continue;
                return true;
            }
        }
        return false;
    }

    private static void parseScriptstatementNode(ASTcfscriptStatement n, CFMLSecurityAnalyzerValidator validator) {
        VariableType type = null;
        List<Node> childs = n.getDirectChildren();
        Node elseNode = n.getNamedAttribute("ELSE");
        if (null != elseNode) {
            childs.add(elseNode);
        }
        for (Node nn : childs) {
            if (nn instanceof ASTevalcfoutput && RulesCommon.isVulnerableType(type = RulesCommon.getVariableReferenceTypeFromNode(nn)) && RulesCommon.isVulnerableXssType(type, null)) {
                validator.collectInvalidValidationResult("sqlinjection", false, nn);
                if (RulesCommon.isFunctionType(type)) {
                    validator.collectValidationResult("sqlinjection", RB.getString(SqlRule.class, "SqlInjection"), type, "warning", nn);
                } else {
                    validator.collectValidationResult("sqlinjection", RB.getString(SqlRule.class, "SqlInjection"), type, "error", nn);
                }
            }
            if (!(nn instanceof ASTcfscriptStatement)) continue;
            SqlRule.parseScriptstatementNode((ASTcfscriptStatement)nn, validator);
        }
    }

    public static void validateQueryexecuteSqlInjection(ASTfuncparams node, CFMLSecurityAnalyzerValidator validator) {
        String functionname = node.getFunctionName();
        if ("queryexecute".equalsIgnoreCase(functionname) || "ormexecutequery".equalsIgnoreCase(functionname) || "setsql".equalsIgnoreCase(functionname)) {
            Node child = node.getAllChildren().get(0);
            boolean pass = true;
            if (child instanceof ASTliteral) {
                Vector tokens = ((ASTliteral)child).tokens;
                for (int i = 0; i < tokens.size(); ++i) {
                    Object token = tokens.get(i);
                    if (!(token instanceof ASTsimpleVariableReference) && !(token instanceof ASTstructureReference) && !(token instanceof ASTruntimeCall)) continue;
                    pass = SqlRule._validateQueryexecuteSqlInjection(token, (Node)token, validator);
                }
            } else if (child instanceof ASTsimpleVariableReference || child instanceof ASTstructureReference) {
                pass = SqlRule._validateQueryexecuteSqlInjection(child, node, validator);
            }
            validator.collectInvalidValidationResult("sqlinjection", pass, node);
        }
    }

    private static boolean _validateQueryexecuteSqlInjection(Object token, Node node, CFMLSecurityAnalyzerValidator validator) {
        VariableType type = RulesCommon.getVariableReferenceTypeFromNode(token);
        boolean pass = true;
        if (RulesCommon.isVulnerableType(type) && !RulesCommon.isInbuiltSafeMethod(type.getValue())) {
            if (RulesCommon.isFunctionType(type)) {
                validator.collectValidationResult("sqlinjection", RB.getString(SqlRule.class, "QueryExecuteVariable"), type, "warning", node);
            } else {
                validator.collectValidationResult("sqlinjection", RB.getString(SqlRule.class, "QueryExecute"), type, "error", node);
            }
            pass = false;
        }
        return pass;
    }

    private static boolean isComparatorEnding(String text) {
        String[] ops;
        for (String op : ops = new String[]{"=", ">", "<", "between"}) {
            if (!text.trim().toLowerCase().endsWith(op)) continue;
            return true;
        }
        return false;
    }

    public static void validateNewQuerySqlInjection(ASTcfscriptStatement cfscript, CFMLSecurityAnalyzerValidator cfmlSecurityAnalyzerValidator) {
    }
}

