/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.securityanalyzer.rules;

import coldfusion.compiler.ASTStructInitializer;
import coldfusion.compiler.ASTevalcfoutput;
import coldfusion.compiler.ASTfuncparams;
import coldfusion.compiler.ASTliteral;
import coldfusion.compiler.ASToperator;
import coldfusion.compiler.ASTsimpleVariableReference;
import coldfusion.compiler.ASTstart;
import coldfusion.compiler.Node;
import coldfusion.compiler.TagNode;
import coldfusion.compiler.Token;
import coldfusion.securityanalyzer.CFMLSecurityAnalyzerValidator;
import coldfusion.securityanalyzer.SecurityAnalyzerConstants;
import coldfusion.securityanalyzer.rules.RulesCommon;
import coldfusion.securityanalyzer.rules.VariableType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XssRule {
    private static String[] allowedEncodeValues = new String[]{"url", "css", "javascript", "xml", "html", "htmlattribute", "xmlattribute", "ldap", "xpath", "dn"};

    public static void validate(TagNode node, CFMLSecurityAnalyzerValidator validator) {
        String tagname = node.getTagName();
        if (SecurityAnalyzerConstants.XSS_PRONE_TAGS.contains(tagname.toLowerCase()) && !XssRule.isChildOfOtherXssproneTag(node)) {
            XssRule._validateXss(node, validator);
        }
    }

    private static boolean isChildOfOtherXssproneTag(TagNode node) {
        Node parent = node.jjtGetParent();
        while (!(parent instanceof ASTstart)) {
            String tagname;
            if (parent instanceof TagNode && SecurityAnalyzerConstants.XSS_PRONE_TAGS.contains((tagname = ((TagNode)parent).getTagName()).toLowerCase())) {
                return true;
            }
            parent = parent.jjtGetParent();
        }
        return false;
    }

    private static void _validateXss(Node node, CFMLSecurityAnalyzerValidator validator) {
        String tagname;
        boolean encodeFor = XssRule.checkEncodeFor(node);
        if (encodeFor) {
            return;
        }
        if (node instanceof TagNode && "cfquery".equalsIgnoreCase(tagname = ((TagNode)node).getTagName())) {
            return;
        }
        List<Node> children = node.getAllChildren();
        for (Node n : children) {
            try {
                if (n instanceof ASTevalcfoutput) {
                    VariableType type = RulesCommon.getVariableReferenceTypeFromNode(n);
                    XssRule.collectXssError(type, n, validator, true);
                    if (validator.isTesting()) break;
                    validator.collectInvalidValidationResult("xss", true, n);
                    continue;
                }
                XssRule._validateXss(n, validator);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean checkEncodeFor(Node node) {
        boolean encodeFor = false;
        Node encodeForNode = node.getNamedAttribute("encodefor");
        if (encodeForNode != null) {
            if (encodeForNode instanceof ASTliteral) {
                encodeFor = XssRule.checkAstLiteral((ASTliteral)encodeForNode, node, allowedEncodeValues, "type");
            } else if (encodeForNode instanceof ASTStructInitializer) {
                ASTStructInitializer struct = (ASTStructInitializer)encodeForNode;
                Map map = struct.getInitializers();
                Set keys = map.keySet();
                for (Object key : keys) {
                    Object val;
                    String k;
                    if (!(key instanceof Token) || !(k = ((Token)key).image).equalsIgnoreCase("type") && !k.equalsIgnoreCase("encodefor") || !((val = map.get(key)) instanceof ASTliteral)) continue;
                    encodeFor = XssRule.checkAstLiteral((ASTliteral)val, node, allowedEncodeValues, "");
                }
            }
        }
        if ((encodeForNode = node.getNamedAttribute("attributecollection")) != null) {
            encodeFor = XssRule.checkAstLiteral((ASTliteral)encodeForNode, node, allowedEncodeValues, "encodefor");
        }
        return encodeFor;
    }

    private static boolean checkAstLiteral(ASTliteral encodeForNode, Node node, String[] values, String attr) {
        boolean encodeFor = false;
        Object val = encodeForNode.tokens.get(0);
        if (val instanceof ASTsimpleVariableReference) {
            String c = ((ASTsimpleVariableReference)val).getCodegenVariableName();
            VariableType v = RulesCommon.getVariableTypeFromAppcfcsOrCurrentfile(c + "." + attr, encodeForNode, node, new ArrayList<VariableType>());
            if (Arrays.asList(values).contains(v.getValue().toLowerCase())) {
                encodeFor = true;
            }
        } else if (val instanceof String && Arrays.asList(values).contains(((String)val).toLowerCase())) {
            encodeFor = true;
        }
        return encodeFor;
    }

    private static void collectXssError(VariableType type, Node n, CFMLSecurityAnalyzerValidator validator, boolean nullIsError) {
        if (null == type) {
            if (nullIsError) {
                type = new VariableType();
                type.setType("variablenotfound");
            } else {
                return;
            }
        }
        if (RulesCommon.isVulnerableXssType(type, n)) {
            validator.collectInvalidValidationResult("xss", false, n);
            if (XssRule.isChildOfHtmltopdf(n)) {
                validator.collectValidationResult("htmltopdfxss", SecurityAnalyzerConstants.HTMLTOPDFXSSATTACKSTARTMESSAGE, type, "warning", n);
            } else if (RulesCommon.isFunctionType(type) && !RulesCommon.paramDependentInbuiltMethodsList.contains(type.getValue().toLowerCase())) {
                validator.collectValidationResult("xss", SecurityAnalyzerConstants.XSSATTACKSTARTMESSAGE, type, "warning", n);
            } else {
                validator.collectValidationResult("xss", SecurityAnalyzerConstants.XSSATTACKSTARTMESSAGE, type, "error", n);
            }
        }
    }

    private static boolean isChildOfHtmltopdf(Node n) {
        Node parent = n.jjtGetParent();
        while (!(parent instanceof ASTstart)) {
            String tagname;
            if (parent instanceof TagNode && "cfhtmltopdf".equalsIgnoreCase(tagname = ((TagNode)parent).getTagName())) {
                return true;
            }
            parent = parent.jjtGetParent();
        }
        return false;
    }

    public static void validate(ASTfuncparams node, CFMLSecurityAnalyzerValidator validator) {
        String funcname = node.getFunctionName();
        if (funcname.equalsIgnoreCase("writeoutput")) {
            Node child;
            if (node.getAllChildren().size() == 2) {
                VariableType type = RulesCommon.getVariableReferenceTypeFromNode(node.getAllChildren().get(1));
                if (Arrays.asList(allowedEncodeValues).contains(type.getValue().toLowerCase())) {
                    return;
                }
            }
            if ((child = node.getAllChildren().get(0)) instanceof ASToperator) {
                XssRule._validate((ASToperator)child, validator);
            } else {
                XssRule.collectXssError(RulesCommon.getVariableReferenceTypeFromNode(child), node, validator, false);
            }
        }
    }

    private static void _validate(ASToperator child, CFMLSecurityAnalyzerValidator validator) {
        for (Node n : child.getDirectChildren()) {
            if (n instanceof ASToperator) {
                XssRule._validate((ASToperator)n, validator);
                continue;
            }
            XssRule.collectXssError(RulesCommon.getVariableReferenceTypeFromNode(n), n, validator, false);
        }
    }
}

