/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server;

import coldfusion.bootstrap.AppServerUtils;
import coldfusion.bootstrap.BootstrapClassLoader;
import coldfusion.bootstrap.ClassloaderHelper;
import coldfusion.bootstrap.FelixClassloader;
import coldfusion.centralconfig.client.CentralConfigClientUtil;
import coldfusion.cloud.VendorCredentialService;
import coldfusion.cloud.config.CloudConfigService;
import coldfusion.compiler.NeoTranslator;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.graphql.client.GraphQLConfigService;
import coldfusion.java.LanguageImpl;
import coldfusion.jsp.JavaCompiler;
import coldfusion.license.LicenseServiceImpl;
import coldfusion.license.SystemInfo;
import coldfusion.license.UsageAnalytics.UsageLoggerTimer;
import coldfusion.license.ngl.security.SecureStorageService;
import coldfusion.log.CFLogLevel;
import coldfusion.log.CFLogs;
import coldfusion.log.LogService;
import coldfusion.log.Logger;
import coldfusion.nosql.NoSQLServiceImpl;
import coldfusion.osgi.registry.MSGraphRegistry;
import coldfusion.osgi.services.ApacheDerbyService;
import coldfusion.osgi.services.AwsLambdaService;
import coldfusion.osgi.services.AzureBlobModuleService;
import coldfusion.osgi.services.CachingService;
import coldfusion.osgi.services.CronService;
import coldfusion.osgi.services.DB2DriverService;
import coldfusion.osgi.services.DynamoDBService;
import coldfusion.osgi.services.ExcelService;
import coldfusion.osgi.services.FTPService;
import coldfusion.osgi.services.FirestoreService;
import coldfusion.osgi.services.GraphQLClientService;
import coldfusion.osgi.services.ImageService;
import coldfusion.osgi.services.InformixDriverService;
import coldfusion.osgi.services.MySQLDriverService;
import coldfusion.osgi.services.OracleDriverService;
import coldfusion.osgi.services.PDFService;
import coldfusion.osgi.services.PostgreSQLDriverService;
import coldfusion.osgi.services.PresentationService;
import coldfusion.osgi.services.PrintService;
import coldfusion.osgi.services.PubSubService;
import coldfusion.osgi.services.S3ModuleService;
import coldfusion.osgi.services.SQLServerDriverService;
import coldfusion.osgi.services.SamlService;
import coldfusion.osgi.services.SequeLinkDriverService;
import coldfusion.osgi.services.SessionStorageService;
import coldfusion.osgi.services.StorageService;
import coldfusion.rest.JaxRsAppEventListener;
import coldfusion.rest.JaxRsServiceImpl;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ClientScopeServiceImpl;
import coldfusion.runtime.EventListeners;
import coldfusion.runtime.ProxyFactory;
import coldfusion.runtime.dotnet.DotNetServiceImpl;
import coldfusion.scheduling.Scheduler;
import coldfusion.security.SecurityManager;
import coldfusion.server.ArchiveDeployService;
import coldfusion.server.CorbaService;
import coldfusion.server.DataSourceService;
import coldfusion.server.DebuggingService;
import coldfusion.server.DocumentService;
import coldfusion.server.DotNetService;
import coldfusion.server.EventGatewayService;
import coldfusion.server.GraphingService;
import coldfusion.server.GrootClassLoader;
import coldfusion.server.LicenseService;
import coldfusion.server.MailSpoolService;
import coldfusion.server.MetricsService;
import coldfusion.server.MonitoringService;
import coldfusion.server.ORMSearchService;
import coldfusion.server.ORMService;
import coldfusion.server.PDFGService;
import coldfusion.server.RegistryService;
import coldfusion.server.ReportService;
import coldfusion.server.SNSService;
import coldfusion.server.SQSService;
import coldfusion.server.SchedulerService;
import coldfusion.server.ServiceBusService;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SolrService;
import coldfusion.server.StoreService;
import coldfusion.server.WatchService;
import coldfusion.server.WebSocketService;
import coldfusion.server.XmlRpcService;
import coldfusion.server.felix.FelixUtil;
import coldfusion.server.j2ee.SecurityHelper;
import coldfusion.server.j2ee.sql.pool.JDBCManager;
import coldfusion.serverless.InMemoryFile;
import coldfusion.serverless.InMemoryOutputStream;
import coldfusion.serverless.LambdaXRayService;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.sql.Executive;
import coldfusion.tagext.lang.RegistryServiceImpl;
import coldfusion.util.RB;
import coldfusion.watch.WatchServiceImpl;
import coldfusion.xml.rpc.CFCServlet;
import com.rsa.jsafe.crypto.CryptoJ;
import com.rsa.jsafe.provider.JsafeJCE;
import jakarta.servlet.ServletContext;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.imageio.spi.IIORegistry;
import javax.net.ssl.SSLContext;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.util.StringMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public abstract class CFService {
    public static String _path;
    public static String _rootdir;
    private static String _sep;
    public static ServletContext context;
    protected String _appServer;
    public static boolean _isJRun;
    public static boolean _isStandalone;
    private ClassLoader grootClassLoader = null;
    private boolean apiManagerStarted = false;
    public static final String GROOT_HOME = "apim.home";
    public static final String INSTALLED_BUNDLES_TXT = "installedBundles.txt";
    public static final String EULA_ACCEPTED = "EULA_ACCEPTED";
    public static final String FELIX_LOG_LEVEL = "felix.log.level";
    public static final String THREAD_LOADING_BUNDLES = "Bundle-parallel-loader";
    public static Map<String, String> onStartNewInstalls;
    static int cores;
    static int threads;
    static int MODULES_STARTUP_TIMEOUT;
    ExecutorService executor = Executors.newFixedThreadPool(cores >= threads ? threads : cores);
    private static ArrayList<Callable<String>> listOfBundlesToInstall;
    public static boolean loadingServicesAtStartup;
    public static Felix felix;

    public CFService(String rootPath) {
        _path = rootPath + _sep;
        _rootdir = rootPath;
        try {
            Class.forName("jrunx.kernel.JRun");
            _isJRun = true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            _isJRun = false;
        }
        try {
            Class.forName("com.adobe.coldfusion.launcher.Launcher");
            _isStandalone = true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            _isStandalone = false;
        }
    }

    public CFService(String rootPath, ServletContext context) {
        this(rootPath);
        CFService.context = context;
    }

    public ServletContext getContext() {
        return context;
    }

    public void setContext(ServletContext context) {
        CFService.context = context;
    }

    public static void setupLambdaXRay() throws Exception {
        CFLogs.SERVER_LOG.info(RB.getString(CFService.class, "CFService.service.start", (Object)"AWS Lambda XRay"));
        Class<?> clazz = Class.forName("coldfusion.serverless.aws.xray.LambdaXRayServiceImpl");
        Constructor<?> ctor = clazz.getConstructor(new Class[0]);
        LambdaXRayService xRayService = (LambdaXRayService)ctor.newInstance(new Object[0]);
        ServiceFactory.setLambdaXRayService(xRayService);
    }

    public abstract void setupMetrics() throws Exception;

    public static void setupScheduler() throws Exception {
        CFLogs.SERVER_LOG.info(RB.getString(CFService.class, "CFService.service.start", (Object)"scheduler"));
        Scheduler scheduler = new Scheduler();
        scheduler.start();
        ServiceFactory.setSchedulerService(scheduler);
    }

    public void setupUsageDataLog() throws Exception {
        LicenseService ls = ServiceFactory.getLicenseService();
        if (ls != null && ls.isCheckUsage()) {
            int callPeriodInMinutes = ServerlessUtil.isLambdaEnv() ? 5 : 1440;
            CFLogs.USAGEDATA_LOG.debug(RB.getString((Object)this, "CFService.service.start", (Object)"LicensingAnalyticsInfo"));
            UsageLoggerTimer usageLoggerTimer = UsageLoggerTimer.getTimer((String)CFService.getRoot());
            Timer timer = new Timer();
            timer.scheduleAtFixedRate((TimerTask)usageLoggerTimer, 0L, (long)(callPeriodInMinutes * 60 * 1000));
        }
    }

    public static void setupImageService(String version) throws Exception {
        String bundleName = "image";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(ImageService.class.getName());
            }
        }) : context.getServiceReference(ImageService.class.getName());
        ImageService sss = System.getSecurityManager() != null ? (ImageService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (ImageService)context.getService(serviceReg);
        ServiceFactory.setImageService(sss);
    }

    public static void setupCachingService(String version) throws Exception {
        String bundleName = "caching";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(CachingService.class.getName());
            }
        }) : context.getServiceReference(CachingService.class.getName());
        CachingService cs = System.getSecurityManager() != null ? (CachingService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (CachingService)context.getService(serviceReg);
        ServiceFactory.setCachingService(cs);
    }

    public static String getXMLFileDir() {
        return "lib";
    }

    public String getJavaPolicyFile() {
        StringBuffer sb = new StringBuffer();
        sb.append(CFService.getPath()).append("lib").append(_sep).append("coldfusion.policy");
        return sb.toString();
    }

    public String getJassPolicyFile() {
        StringBuffer sb = new StringBuffer();
        sb.append(CFService.getPath()).append("lib").append(_sep).append("neo_jaas.policy");
        return sb.toString();
    }

    public String getJvmConfigFile() {
        StringBuffer sb = new StringBuffer();
        sb.append(CFService.getPath()).append("bin").append(_sep).append("jvm.config");
        return sb.toString();
    }

    public static String getRegistryDir() {
        return CFService.getPath() + "registry/cf.registry";
    }

    public static String getPath() {
        return _path;
    }

    public static String getRoot() {
        return _rootdir;
    }

    public static void setupSql() throws Exception {
        CFLogs.SERVER_LOG.info(RB.getString(CFService.class, "CFService.service.start", (Object)"sql"));
        Executive exec = new Executive(CFService.getFile("neo-drivers.xml"), CFService.getFile("neo-datasource.xml"), _rootdir);
        exec.start();
        ServiceFactory.setDataSourceService(exec);
    }

    public static void setupNoSql(String version) throws Exception {
        NoSQLServiceImpl noSQLService = new NoSQLServiceImpl(CFService.getFile("neo-nosql-datasource.xml"), _rootdir);
        ServiceFactory.setNoSQLService(noSQLService);
        noSQLService.start();
    }

    public static void setupMongoDB(String version) throws Exception {
        String bundleName = "cfmongodb";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
    }

    public static File getFile(String fName) {
        File file = new File(_path + CFService.getXMLFileDir() + _sep + fName);
        if (ServerlessUtil.isLambdaEnv()) {
            return CFService.getFile(fName, file);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InMemoryFile getFile(String fName, File f) {
        InMemoryFile mFile = null;
        try {
            mFile = new InMemoryFile(fName, f);
            FileInputStream is = new FileInputStream(f);
            byte[] src = new byte[is.available()];
            is.read(src);
            InMemoryOutputStream os = new InMemoryOutputStream(mFile);
            os.write(src);
            os.close();
        }
        catch (Exception exception) {}
        finally {
            return mFile;
        }
    }

    public static void setupLogger() throws Exception {
        String logDirectory = CFService.getLogDirectoryPath();
        LogService ls = new LogService(CFService.getFile("neo-logging.xml"), logDirectory);
        ls.start();
        CFLogs.SERVER_LOG.info(RB.getString(CFService.class, "CFService.service.start", (Object)"logging"));
        ServiceFactory.setLoggingService(ls);
    }

    private static String getLogDirectoryPath() {
        if (ServerlessUtil.isLambdaEnv()) {
            return "/tmp/cfusion/logs";
        }
        return _path + "logs";
    }

    public static void setupCrypto() throws Exception {
        CFLogs.SERVER_LOG.info(RB.getString(CFService.class, "CFService.service.start", (Object)"crypto"));
        boolean disableJsafe = Boolean.getBoolean("coldfusion.disablejsafe");
        int appServer = AppServerUtils.getAppServerType();
        int appServerVersion = AppServerUtils.getAppServerVersion();
        if (appServer == 5 && appServerVersion < 7) {
            disableJsafe = true;
        }
        if (appServer == 2 && appServerVersion < 6) {
            disableJsafe = true;
        }
        LicenseService licenseService = ServiceFactory.getLicenseService();
        if (!ServerlessUtil.isLambdaEnv() && !disableJsafe && (licenseService.isEnterprise() || licenseService.isDeveloper()) && Security.getProvider("JsafeJCE") == null) {
            String algo = System.getProperty("coldfusion.jsafe.defaultalgo");
            if (algo != null && algo.length() > 0) {
                Security.setProperty("com.rsa.crypto.default.random", algo);
            }
            try {
                if (CryptoJ.isFIPS140Compliant()) {
                    boolean fipsMode = Boolean.getBoolean("coldfusion.enablefipscrypto");
                    if (!fipsMode) {
                        CryptoJ.setMode((int)1);
                    } else {
                        if (!CryptoJ.selfTestPassed()) {
                            CFLogs.SERVER_LOG.fatal(RB.getString(CFService.class, "CFService.server.nojsafe", (Object)"Self Test failed"));
                            return;
                        }
                        CryptoJ.setMode((int)2);
                    }
                }
                if (System.getSecurityManager() == null) {
                    JsafeJCE jsafe = new JsafeJCE();
                    int r = Security.addProvider((Provider)jsafe);
                    if (r > 0) {
                        CFLogs.SERVER_LOG.info(RB.getString(CFService.class, "CFService.server.jsafeok", (Object)Double.toString(jsafe.getVersion()), (Object)jsafe.getInfo()));
                    }
                } else {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            JsafeJCE jsafe = new JsafeJCE();
                            int r = Security.addProvider((Provider)jsafe);
                            if (r > 0) {
                                CFLogs.SERVER_LOG.info(RB.getString((Object)this, "CFService.server.jsafeok", (Object)Double.toString(jsafe.getVersion()), (Object)jsafe.getInfo()));
                            }
                            return null;
                        }
                    });
                }
            }
            catch (Throwable e2) {
                Exception e2;
                if (e2 instanceof PrivilegedActionException) {
                    e2 = ((PrivilegedActionException)e2).getException();
                }
                CFLogs.SERVER_LOG.error(RB.getString(CFService.class, "CFService.server.nojsafe", (Object)e2.toString()), e2);
            }
        }
    }

    public static void setupMail(String version) throws Exception {
        String bundleName = "mail";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(MailSpoolService.class.getName());
            }
        }) : context.getServiceReference(MailSpoolService.class.getName());
        MailSpoolService mss = System.getSecurityManager() != null ? (MailSpoolService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (MailSpoolService)context.getService(serviceReg);
        ServiceFactory.setMailSpoolService(mss);
        mss.start();
    }

    public static void setupSolr(String version) throws Exception {
        String bundleName = "search";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(SolrService.class.getName());
            }
        }) : context.getServiceReference(SolrService.class.getName());
        SolrService solrService = System.getSecurityManager() != null ? (SolrService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (SolrService)context.getService(serviceReg);
        ServiceFactory.setSolrService(solrService);
        solrService.start();
    }

    public static void setupDebugging(String version) throws Exception {
        if (ServerlessUtil.isLambdaEnv()) {
            CFLogs.SERVER_LOG.info(RB.getString(CFService.class, "CFService.service.start", (Object)"AWS Lambda XRay"));
            Class<?> clazz = Class.forName("coldfusion.serverless.debug.DebugServiceImpl");
            Constructor<?> ctor = clazz.getConstructor(File.class);
            DebuggingService debuggingService = (DebuggingService)ctor.newInstance(CFService.getFile("neo-debug.xml"));
            ServiceFactory.setDebuggingService(debuggingService);
            return;
        }
        String bundleName = "debugger";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(DebuggingService.class.getName());
            }
        }) : context.getServiceReference(DebuggingService.class.getName());
        DebuggingService debuggingService = System.getSecurityManager() != null ? (DebuggingService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (DebuggingService)context.getService(serviceReg);
        debuggingService.start();
        ServiceFactory.setDebuggingService(debuggingService);
    }

    public abstract void setupRuntime() throws Exception;

    public static void setupCron(String version) throws Exception {
        String bundleName = "scheduler";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(CronService.class.getName());
            }
        }) : context.getServiceReference(CronService.class.getName());
        CronService cs = System.getSecurityManager() != null ? (CronService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (CronService)context.getService(serviceReg);
        cs.start();
        ServiceFactory.setCronService(cs);
    }

    public static void setupSessionStorageService(String version) throws Exception {
        String bundleName = "redissessionstorage";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(SessionStorageService.class.getName());
            }
        }) : context.getServiceReference(SessionStorageService.class.getName());
        SessionStorageService sss = System.getSecurityManager() != null ? (SessionStorageService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (SessionStorageService)context.getService(serviceReg);
        ServiceFactory.setSessionStorageService(sss);
        ServiceFactory.getRuntimeService().initSessionStore(true);
    }

    public static void setupZip(String version) throws Exception {
        String bundleName = "zip";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
    }

    public static void setupClientStorage() throws Exception {
        CFLogs.SERVER_LOG.info(RB.getString(CFService.class, "CFService.service.start", (Object)"client"));
        ClientScopeServiceImpl clientScopeService = new ClientScopeServiceImpl(CFService.getFile("neo-clientstore.xml"));
        clientScopeService.start();
        ServiceFactory.setClientScopeService(clientScopeService);
    }

    public static void setupXmlrpc(String version) throws Exception {
        CFService.setupXmlrpc(version, false);
    }

    public static void setupXmlrpc(String version, boolean isCommandLineCompile) throws Exception {
        String bundleName = "axis";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        List<URL> urls = CFService.addToClassPath(new File(CFService.getLibPath() + File.separator + "bundleaxis"), version);
        URL[] fileURLs = new URL[urls.size()];
        CFService.addURLToSystemClassLoader(urls.toArray(fileURLs));
        File xconfig = CFService.getFile("neo-xmlrpc.xml");
        String stubDir = _path + "stubs";
        XmlRpcService xmls = null;
        Class[] xmlrpcArgsClasses = new Class[]{File.class, String.class};
        Object[] xmlrpcArgs = new Object[]{xconfig, stubDir};
        try {
            Class<?> classDefxmlRpcServiceImpl = ServerlessUtil.isLambdaEnv() || isCommandLineCompile ? Class.forName("coldfusion.xml.rpc.module.XmlRpcServiceImpl", true, (ClassLoader)BootstrapClassLoader.instance()) : Class.forName("coldfusion.xml.rpc.module.XmlRpcServiceImpl");
            Constructor<?> xmlrpcArgsConstructor = classDefxmlRpcServiceImpl.getConstructor(xmlrpcArgsClasses);
            xmls = (XmlRpcService)CFService.instantiateObject(xmlrpcArgsConstructor, xmlrpcArgs);
        }
        catch (Throwable e) {
            CFLogs.SERVER_LOG.error(RB.getString(CFService.class, "CFService.server.initfailed", (Object)"axis", (Object)e.toString()), e);
        }
        xmls.setClassPath(CFService.getBootStrapClassPath());
        ServiceFactory.setXmlRpcService(xmls);
        xmls.start();
        CFCServlet cfcServlet = CFCServlet.getCFCServlet();
        if (cfcServlet != null) {
            cfcServlet.cfAxisServlet = xmls.initCFAxisServlet(cfcServlet.getServletConfig());
            cfcServlet.cfAxis2Servlet = xmls.initCFAxis2Servlet(cfcServlet.getServletConfig());
        }
    }

    private static Object instantiateObject(Constructor constructor, Object[] arguments) {
        Object object = null;
        try {
            object = constructor.newInstance(arguments);
            return object;
        }
        catch (Throwable e) {
            CFLogs.SERVER_LOG.error(RB.getString(CFService.class, "CFService.server.initfailed", (Object)"axis", (Object)e.toString()), e);
            return object;
        }
    }

    public static void addURLToSystemClassLoader(URL[] url) {
        BootstrapClassLoader bbotstrapClassLoader = BootstrapClassLoader.instance();
        Class<URLClassLoader> classLoaderClass = URLClassLoader.class;
        try {
            Method method = classLoaderClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            for (int i = 0; i < url.length; ++i) {
                method.invoke((Object)bbotstrapClassLoader, url[i]);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static List<URL> addToClassPath(File axisLibDir, String version) {
        ArrayList<URL> cpList = new ArrayList<URL>();
        if (axisLibDir.exists()) {
            if (axisLibDir.isDirectory()) {
                cpList.addAll(CFService.getJarsInDir(axisLibDir, version));
            } else {
                try {
                    cpList.add(axisLibDir.toURL());
                }
                catch (MalformedURLException murl) {
                    System.err.println(murl.getMessage() + ": url=" + murl);
                }
            }
        }
        return cpList;
    }

    public static List getJarsInDir(File axisLibDir, String version) {
        Vector<URL> list = new Vector<URL>();
        File[] libFiles = axisLibDir.listFiles();
        List jarsApplicableToCurrentAxisVersion = FelixUtil.getAxisDependencies((String)"axis", (String)version);
        for (int i = 0; i < libFiles.length; ++i) {
            URL url;
            String fileName = libFiles[i].getName();
            if (!jarsApplicableToCurrentAxisVersion.contains(fileName) || !fileName.endsWith(".jar") && !fileName.endsWith(".zip") || (url = CFService.toURL(libFiles[i])) == null) continue;
            list.add(url);
        }
        return list;
    }

    private static URL toURL(File file) {
        try {
            return file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static void setupJaxrs(String version) throws Exception {
        String bundleName = "rest";
        JaxRsServiceImpl jaxrs = null;
        File config = CFService.getFile("neo-jaxrs.xml");
        jaxrs = new JaxRsServiceImpl(config, context);
        JaxRsAppEventListener listener = new JaxRsAppEventListener();
        EventListeners.addApplicationEventListener(listener);
        jaxrs.start();
        ServiceFactory.setJaxRsService(jaxrs);
        CFLogs.SERVER_LOG.info(RB.getString(CFService.class, "CFService.service.start", (Object)bundleName));
    }

    public static String getBootStrapClassPath() {
        JavaCompiler compiler = new JavaCompiler();
        StringBuffer buf = new StringBuffer();
        if (context != null) {
            buf = new StringBuffer(JavaCompiler.createClasspath(context));
        }
        buf.append(File.pathSeparatorChar);
        buf.append(compiler.getClasspath());
        return buf.toString();
    }

    public static void setupGraphing(String version) throws Exception {
        String bundleName = "chart";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(GraphingService.class.getName());
            }
        }) : context.getServiceReference(GraphingService.class.getName());
        GraphingService gs = System.getSecurityManager() != null ? (GraphingService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (GraphingService)context.getService(serviceReg);
        gs.start();
        ServiceFactory.setNewGraphingService(gs);
    }

    public static void setupArchiveDeploy() throws Exception {
        CFLogs.SERVER_LOG.info(RB.getString(CFService.class, "CFService.service.start", (Object)"archive"));
        File aconfig = CFService.getFile("neo-archivedeploy.xml");
        ArchiveDeployService ads = FeatureRouter.getInstance().createArchiveDeployService(aconfig, _rootdir);
        ads.start();
        ServiceFactory.setArchiveDeployService(ads);
    }

    public static void setupRegistry() throws Exception {
        CFLogs.SERVER_LOG.info(RB.getString(CFService.class, "CFService.service.start", (Object)"registry"));
        File rfile = new File(CFService.getRegistryDir());
        File rconffile = CFService.getFile("neo-registry.xml");
        RegistryServiceImpl rs = new RegistryServiceImpl(rfile, rconffile);
        rs.start();
        ServiceFactory.setRegistryService(rs);
    }

    public static void setupLicense() throws Exception {
        CFLogs.SERVER_LOG.info(RB.getString(CFService.class, "CFService.service.start", (Object)"license"));
        File lfile = CFService.getFile("license.properties");
        LicenseServiceImpl ls = new LicenseServiceImpl(lfile);
        ls.start();
        ServiceFactory.setLicenseService((LicenseService)ls);
    }

    public void setupSecurity() throws Exception {
        CFLogs.SERVER_LOG.info(RB.getString(CFService.class, "CFService.service.start", (Object)"security"));
        File config = CFService.getFile("neo-security.xml");
        File password = CFService.getFile("password.properties");
        File roles = CFService.getFile("customroles.properties");
        SecurityHelper helper = new SecurityHelper(this, _isJRun);
        SecurityManager sc = new SecurityManager(config, password, roles, _rootdir, helper, context);
        sc.start();
        ServiceFactory.setSecurityService(sc);
    }

    public static void setupDocument(String version) throws Exception {
        String bundleName = "document";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(DocumentService.class.getName());
            }
        }) : context.getServiceReference(DocumentService.class.getName());
        DocumentService docService = System.getSecurityManager() != null ? (DocumentService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (DocumentService)context.getService(serviceReg);
        ServiceFactory.setDocumentService(docService);
        docService.start();
    }

    public static void setupORMSearch(String version) throws Exception {
        String bundleName = "ormsearch";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(ORMSearchService.class.getName());
            }
        }) : context.getServiceReference(ORMSearchService.class.getName());
        ORMSearchService ormSearchService = System.getSecurityManager() != null ? (ORMSearchService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (ORMSearchService)context.getService(serviceReg);
        ServiceFactory.setOrmSearchService(ormSearchService);
    }

    public static void setupEventProcessor(String version) throws Exception {
        String bundleName = "eventgateways";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(EventGatewayService.class.getName());
            }
        }) : context.getServiceReference(EventGatewayService.class.getName());
        EventGatewayService eventService = System.getSecurityManager() != null ? (EventGatewayService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (EventGatewayService)context.getService(serviceReg);
        ServiceFactory.setEventProcessorService(eventService);
        eventService.start();
    }

    public static void setupWatchService() throws Exception {
        CFLogs.SERVER_LOG.info(RB.getString(CFService.class, "CFService.service.start", (Object)"WatchService"));
        File config = CFService.getFile("neo-watch.xml");
        String libDirectory = _path + "lib";
        WatchServiceImpl watchservice = new WatchServiceImpl(config, libDirectory);
        watchservice.start();
        ServiceFactory.setWatchService(watchservice);
        watchservice.registerServices();
    }

    public static void setupMonitoringService(String version) throws Exception {
        System.setProperty("lib_dir", _path + CFService.getXMLFileDir() + _sep);
        System.setProperty("log_dir", _path + "logs" + _sep);
        String bundleName = "pmtagent";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(MonitoringService.class.getName());
            }
        }) : context.getServiceReference(MonitoringService.class.getName());
        MonitoringService monitoringService = System.getSecurityManager() != null ? (MonitoringService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (MonitoringService)context.getService(serviceReg);
        ServiceFactory.setMonitoringService(monitoringService);
        monitoringService.setStandaloneCF(_isStandalone);
        monitoringService.start();
    }

    public static void setupPDF(String version) throws Exception {
        String bundleName = "pdf";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(PDFService.class.getName());
            }
        }) : context.getServiceReference(PDFService.class.getName());
        PDFService ps = System.getSecurityManager() != null ? (PDFService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (PDFService)context.getService(serviceReg);
        ServiceFactory.setPDFService(ps);
    }

    private static boolean _setupService(String bundleName, String version) throws Exception {
        if (!FelixUtil.isModuleInstalled((String)bundleName, (File)CFService.getBundleDependencyFile())) {
            CFLogs.SERVER_LOG.info(RB.getString(CFService.class, "CFService.notdeployed", (Object)bundleName));
            return false;
        }
        boolean alreadyDeployed = false;
        if (loadingServicesAtStartup && onStartNewInstalls != null && onStartNewInstalls.containsKey(bundleName)) {
            alreadyDeployed = true;
        }
        if (!alreadyDeployed) {
            if (version == null) {
                version = FelixUtil.getCurrentVersionToInstall((String)bundleName);
            }
            if (bundleName.equalsIgnoreCase("axis")) {
                FelixUtil.deployAXISBundle((String)bundleName, (String)version, (String)CFService.getLibPath());
            } else {
                FelixUtil.deployBundle((String)bundleName, (String)version, (String)CFService.getLibPath());
            }
        }
        if (!FelixUtil.invokedFromClient && !bundleName.equals("felixclassloader")) {
            CFLogs.SERVER_LOG.info(RB.getString(CFService.class, "CFService.module.start", (Object)bundleName));
        }
        return null != felix;
    }

    public static void setupCorba(String version) throws Exception {
        String bundleName = "corba";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(CorbaService.class.getName());
            }
        }) : context.getServiceReference(CorbaService.class.getName());
        CorbaService corbaService = System.getSecurityManager() != null ? (CorbaService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (CorbaService)context.getService(serviceReg);
        ServiceFactory.setCorbaService(corbaService);
        ProxyFactory.registerFactory("CORBA", corbaService.getCorbaProxyFactory());
        if (corbaService != null) {
            ServiceFactory.getRuntimeService().loadCorba();
        }
    }

    public static void setupPDFGService(String version) throws Exception {
        String bundleName = "htmltopdf";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(PDFGService.class.getName());
            }
        }) : context.getServiceReference(PDFGService.class.getName());
        PDFGService pdfgService = System.getSecurityManager() != null ? (PDFGService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (PDFGService)context.getService(serviceReg);
        ServiceFactory.setPDFGService(pdfgService);
        pdfgService.start();
    }

    public static void setupAwsLambdaService(String version) throws Exception {
        String bundleName = "awslambda";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(AwsLambdaService.class.getName());
            }
        }) : context.getServiceReference(AwsLambdaService.class.getName());
        AwsLambdaService lambdaService = System.getSecurityManager() != null ? (AwsLambdaService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (AwsLambdaService)context.getService(serviceReg);
        ServiceFactory.setLambdaService(lambdaService);
    }

    public static void setupDotNetService(String version) throws Exception {
        String bundleName = "dotnet";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        File config = CFService.getFile("neo-dotnet.xml");
        DotNetServiceImpl dotNetService = new DotNetServiceImpl(config);
        dotNetService.start();
        ServiceFactory.setDotNetService(dotNetService);
        ProxyFactory factory = dotNetService.getDotNetProxyFactory();
        ProxyFactory.registerFactory("DOTNET", factory);
        ProxyFactory.registerFactory(".NET", factory);
    }

    public static void setupWebSocketService(String version) throws Exception {
        String bundleName = "websocket";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext bundleContext = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return bundleContext.getServiceReference(WebSocketService.class.getName());
            }
        }) : bundleContext.getServiceReference(WebSocketService.class.getName());
        WebSocketService webSocketService = System.getSecurityManager() != null ? (WebSocketService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return bundleContext.getService(serviceReg);
            }
        }) : (WebSocketService)bundleContext.getService(serviceReg);
        ServiceFactory.setWebsocketService(webSocketService);
        webSocketService.start(context);
    }

    public static void setupSecureProfileService() throws Exception {
        ServiceFactory.getSecurityService().loadSecureProfileHelper();
    }

    public void start() throws Throwable {
        long serverStartTime = System.currentTimeMillis();
        loadingServicesAtStartup = true;
        CFService.setSystemProperties();
        try {
            CFService.setupLogger();
        }
        catch (Throwable ex) {
            System.out.println(RB.getString((Object)this, "CFService.server.initfailed", (Object)"Logging", (Object)ex.toString()));
            ex.printStackTrace();
            if (Logger.isLogger("coldfusion.server")) {
                CFLogs.SERVER_LOG.fatal(RB.getString((Object)this, "CFService.server.initfailed", (Object)"Logging", (Object)ex.toString()), ex);
            }
            throw new RuntimeException(RB.getString((Object)this, "CFService.server.initfailed", (Object)"Logging", (Object)ex.toString()));
        }
        if (!_isStandalone && !ServerlessUtil.isLambdaEnv()) {
            Properties props = new Properties();
            boolean eulaAccepted = false;
            File eulaAcceptFile = new File(CFService.getLibPath() + "/licenseinfo.properties");
            if (eulaAcceptFile != null && eulaAcceptFile.exists()) {
                try {
                    props.load(new FileReader(eulaAcceptFile));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                String eulaAcceptVal = props.getProperty(EULA_ACCEPTED);
                if (eulaAcceptVal != null && eulaAcceptVal.equalsIgnoreCase("true")) {
                    eulaAccepted = true;
                }
            }
            if (!eulaAccepted) {
                boolean isWindows = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS");
                String path = CFService.getRoot() + "/bin";
                if (isWindows) {
                    path = CFService.getRoot() + "\\bin";
                }
                String message = RB.getString((Object)this, "CFService.eula.accept", (Object)path);
                System.err.println(message);
                CFLogs.SERVER_LOG.fatal(message);
                System.exit(3);
            }
        }
        try {
            if (ServerlessUtil.isLambdaEnv()) {
                CFService.setupLambdaXRay();
            }
        }
        catch (Throwable ex) {
            CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"AWS Lambda XRay", (Object)ex.toString()), ex);
        }
        try {
            CFService.setupSecureStorageService();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"Secure Storage", (Object)ex.toString()), ex);
        }
        try {
            CFService.setupLicense();
        }
        catch (Throwable ex) {
            CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"License", (Object)ex.toString()), ex);
        }
        try {
            CFService.setupCrypto();
        }
        catch (Throwable ex) {
            CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"Cryptograpic", (Object)ex.toString()), ex);
        }
        try {
            this.setupSecurity();
        }
        catch (Throwable ex) {
            CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"Security", (Object)ex.toString()), ex);
            throw ex;
        }
        try {
            CFService.setupScheduler();
        }
        catch (Throwable ex) {
            CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"Scheduler", (Object)ex.toString()), ex);
        }
        try {
            this.setupUsageDataLog();
        }
        catch (Throwable ex) {
            CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"UsageLogger", (Object)ex.toString()), ex);
        }
        try {
            CFService.setupWatchService();
        }
        catch (Throwable ex) {
            CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"WatchService", (Object)ex.toString()), ex);
        }
        try {
            CFService.setupNoSql(null);
        }
        catch (Throwable ex) {
            CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"NoSQL", (Object)ex.toString()), ex);
        }
        try {
            this.setupRuntime();
        }
        catch (Throwable ex) {
            CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"Runtime", (Object)ex.toString()), ex);
        }
        try {
            CFService.setupClientStorage();
        }
        catch (Throwable ex) {
            CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"Client Storage", (Object)ex.toString()), ex);
        }
        try {
            this.setupMetrics();
        }
        catch (Throwable ex) {
            CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"Metrics", (Object)ex.toString()), ex);
        }
        try {
            CFService.setupArchiveDeploy();
        }
        catch (Throwable ex) {
            CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"Archive/Deploy", (Object)ex.toString()), ex);
        }
        try {
            CFService.setupVendorCredentialService();
        }
        catch (Throwable ex) {
            CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"vendorCredential", (Object)ex.toString()), ex);
        }
        try {
            CFService.setupJaxrs(null);
        }
        catch (Throwable ex) {
            CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"JAXRS", (Object)ex.toString()), ex);
        }
        try {
            if (!ServerlessUtil.isLambdaEnv()) {
                CFService.setupRegistry();
            }
        }
        catch (Throwable ex) {
            CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"Registry", (Object)ex.toString()), ex);
        }
        try {
            CFService.setupImageProviders();
        }
        catch (Throwable ex) {
            CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"JAI", (Object)ex.toString()), ex);
        }
        try {
            this.loadPackageInTopologicalOrder();
        }
        catch (Exception ex) {
            CFLogs.SERVER_LOG.error(RB.getString(CFService.class, "exception_parallel_bundle_loading"), ex);
        }
        CFLogs.SERVER_LOG.info(RB.getString(this, "CFService.server.start"));
        this.updateServerStatus("started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPackageInTopologicalOrder() {
        loadingServicesAtStartup = true;
        CFService.startFelixContainer(CFService.getLibPath());
        try {
            if (!ServerlessUtil.isLambdaEnv() || ServerlessUtil.isLambdaEnv() && FelixUtil.isLambdaModuleInstalled((String)"felixclassloader")) {
                CFService.setupFelixclassloader();
            }
        }
        catch (Throwable ex) {
            CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"felixclassloader", (Object)ex.toString()), ex);
        }
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupImageService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"image", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupMSGraphService(version);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"msgraph", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupDocument(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"document", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupGraphQLConfigService();
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"graphQLConfig", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupCloudConfigService();
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"cloudConfig", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupAdminAPI(version);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"adminapi", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupXmlrpc(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"axis", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupCachingService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"caching", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupPDF(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"pdf", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupCCS(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"ccs", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupStorageService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"gcpstorage", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupFirestoreService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"gcpfirestore", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupPubSubService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"gcppubsub", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupGraphQLClientService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"graphqlclient", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupAdministrator(version);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"administrator", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupPresentationService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"presentation", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupAjax(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"ajax", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupExcelService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"spreadsheet", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupGraphing(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"chart", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupSessionStorageService(version);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"redissessionstorage", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupZip(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"zip", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupMail(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"mail", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupDotNetService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"dotnet", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupMonitoringService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"pmtagent", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupDebugging(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"debugger", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupSAMLService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"saml", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupCron(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"scheduler", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupAzureBlobService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"azureblob", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupS3Service(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"awss3", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupSharePointService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"sharepoint", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupMongoDB(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"cfmongodb", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupEventProcessor(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"eventgateways", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupORMSearch(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"ormsearch", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupORM(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"orm", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupSolr(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"search", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupPDFGService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"htmltopdf", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupSequeLinkODBC(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"odbc", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupPostgreSQLDriverService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"postgresql", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupDB2DriverService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"db2", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupSQLServerDriverService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"sqlserver", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupMySQLDriverService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"mysql", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupOracleDriverService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"oracle", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupDerbyService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"derby", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupFeedService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"feed", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupExchangeService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"exchange", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupReportService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"report", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupPrint(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"print", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupWebSocketService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"websocket", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupS3OldService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"awss3legacy", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupFTPService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"ftp", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupDynamoDBService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"awsdynamodb", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupServiceBusService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"azureservicebus", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupSNSService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"awssns", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupSQSService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"awssqs", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupAwsLambdaService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"awslambda", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupSql();
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"SQL", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupLanguageService(null);
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"java", (Object)ex.toString()), ex);
            }
        }, null);
        CFService.addBundleForInstallation(version -> {
            try {
                CFService.setupSecureProfileService();
            }
            catch (Throwable ex) {
                CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFService.server.initfailed", (Object)"SecureProfile", (Object)ex.toString()), ex);
            }
        }, null);
        try {
            List<Future<String>> futures = this.executor.invokeAll(listOfBundlesToInstall, MODULES_STARTUP_TIMEOUT, TimeUnit.SECONDS);
            for (Future<String> future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException | CancellationException | ExecutionException ex) {
                    CFLogs.SERVER_LOG.error(RB.getString(this, "CFService.module.start.error"), ex);
                }
            }
            loadingServicesAtStartup = false;
            if (onStartNewInstalls != null && onStartNewInstalls.size() > 0) {
                FelixUtil.updateInstalledBundlesFile((String)CFService.getLibPath());
            }
            onStartNewInstalls = null;
        }
        catch (InterruptedException ex) {
            CFLogs.SERVER_LOG.error(RB.getString(CFService.class, "bundle_installation_interrupted"), ex);
        }
        finally {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.executor.shutdownNow();
                }
            }
            catch (InterruptedException ex) {
                this.executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
            listOfBundlesToInstall = null;
        }
        try {
            SSLContext.getDefault();
        }
        catch (Throwable ex) {
            CFLogs.SERVER_LOG.error(RB.getString(this, "exception_initializing_SSLContext"), ex);
            ex.printStackTrace();
        }
        CentralConfigClientUtil.startCFConfigFilesWatcher();
    }

    public static void addBundleForInstallation(Consumer<String> setupMethod, String argument) {
        Callable<String> callableTask = () -> {
            try {
                setupMethod.accept(argument);
            }
            catch (Exception ex) {
                CFLogs.SERVER_LOG.error(RB.getString(CFService.class, "bundle_installation_start_exception"), ex);
            }
            return setupMethod.toString() + "-success";
        };
        listOfBundlesToInstall.add(callableTask);
    }

    public static boolean isBundlesDepencyAccessible() throws IOException {
        FelixUtil.initializeDownloadBaseURL((String)CFService.getLibPath(), (boolean)true);
        String path = CFService.getBundlesDependencyFile();
        String content = null;
        String bundlesJsonUrl = FelixUtil.CFDownloadRepositoryBaseURL + "bundlesdependency.json";
        if (new File(path).exists()) {
            content = new String(Files.readAllBytes(Paths.get(path, new String[0])));
        } else if (new File(FelixUtil.CFDownloadRepositoryBaseURL + "bundlesdependency.json").exists()) {
            content = new String(Files.readAllBytes(Paths.get(bundlesJsonUrl, new String[0])));
        } else {
            try {
                content = FelixUtil.getBundlesDependencyJSONData((String)bundlesJsonUrl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return content != null;
    }

    public static String getBundlesDependencyFile() {
        return CFService.getLibPath() + File.separator + ".." + File.separator + ".." + File.separator + "bundles" + File.separator + "bundlesdependency.json";
    }

    public static void setupAzureBlobService(String version) throws Exception {
        String bundleName = "azureblob";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(AzureBlobModuleService.class.getName());
            }
        }) : context.getServiceReference(AzureBlobModuleService.class.getName());
        AzureBlobModuleService azureBlobModuleService = System.getSecurityManager() != null ? (AzureBlobModuleService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (AzureBlobModuleService)context.getService(serviceReg);
        ServiceFactory.setAzureBlobService(azureBlobModuleService);
    }

    public static void setupGraphQLClientService(String version) throws Exception {
        String bundleName = "graphqlclient";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(GraphQLClientService.class.getName());
            }
        }) : context.getServiceReference(GraphQLClientService.class.getName());
        GraphQLClientService graphQLClientService = System.getSecurityManager() != null ? (GraphQLClientService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (GraphQLClientService)context.getService(serviceReg);
        ServiceFactory.setGraphQLClientService(graphQLClientService);
    }

    public static void setupReportService(String version) throws Exception {
        String bundleName = "report";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(ReportService.class.getName());
            }
        }) : context.getServiceReference(ReportService.class.getName());
        ReportService reportService = System.getSecurityManager() != null ? (ReportService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (ReportService)context.getService(serviceReg);
        ServiceFactory.setReportService(reportService);
    }

    public static void setupExchangeService(String version) throws Exception {
        String bundleName = "exchange";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
    }

    public static void setupDatabasecoreService(String version) throws Exception {
        String bundleName = "databasecore";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
    }

    public static void setupAjax(String version) throws Exception {
        String bundleName = "ajax";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        ServiceFactory.isAjaxEnabled = true;
    }

    public static void setupAdminAPI(String version) throws Exception {
        String bundleName = "adminapi";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
    }

    public static void setupCCS(String version) throws Exception {
        String bundleName = "ccs";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
    }

    public static void setupAdministrator(String version) throws Exception {
        String bundleName = "administrator";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
    }

    public static void setupInternalService(String version, String bundleName) throws Exception {
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
    }

    public static void setupDerbyService(String version) throws Exception {
        String bundleName = "derby";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(ApacheDerbyService.class.getName());
            }
        }) : context.getServiceReference(ApacheDerbyService.class.getName());
        ApacheDerbyService apacheDerbyService = System.getSecurityManager() != null ? (ApacheDerbyService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (ApacheDerbyService)context.getService(serviceReg);
        ServiceFactory.setApacheDerbyService(apacheDerbyService);
    }

    public static void setupOracleDriverService(String version) throws Exception {
        String bundleName = "oracle";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(OracleDriverService.class.getName());
            }
        }) : context.getServiceReference(OracleDriverService.class.getName());
        OracleDriverService oracleDriverService = System.getSecurityManager() != null ? (OracleDriverService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (OracleDriverService)context.getService(serviceReg);
        ServiceFactory.setOracleDriverService(oracleDriverService);
    }

    public static void setupMySQLDriverService(String version) throws Exception {
        String bundleName = "mysql";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(MySQLDriverService.class.getName());
            }
        }) : context.getServiceReference(MySQLDriverService.class.getName());
        MySQLDriverService mySQLDriverService = System.getSecurityManager() != null ? (MySQLDriverService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (MySQLDriverService)context.getService(serviceReg);
        ServiceFactory.setMySQLDriverService(mySQLDriverService);
    }

    public static void setupSQLServerDriverService(String version) throws Exception {
        String bundleName = "sqlserver";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(SQLServerDriverService.class.getName());
            }
        }) : context.getServiceReference(SQLServerDriverService.class.getName());
        SQLServerDriverService sqlServerDriverService = System.getSecurityManager() != null ? (SQLServerDriverService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (SQLServerDriverService)context.getService(serviceReg);
        ServiceFactory.setSqlServerDriverService(sqlServerDriverService);
    }

    public static void setupDB2DriverService(String version) throws Exception {
        String bundleName = "db2";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        BundleContext context = felix.getBundleContext();
        ServiceReference serviceReg = context.getServiceReference(DB2DriverService.class.getName());
        DB2DriverService db2DriverService = (DB2DriverService)context.getService(serviceReg);
        ServiceFactory.setDb2DriverService(db2DriverService);
    }

    public static void setupInformixDriverService(String version) throws Exception {
        String bundleName = "informix";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(InformixDriverService.class.getName());
            }
        }) : context.getServiceReference(InformixDriverService.class.getName());
        InformixDriverService informixDriverService = System.getSecurityManager() != null ? (InformixDriverService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (InformixDriverService)context.getService(serviceReg);
        ServiceFactory.setInformixDriverService(informixDriverService);
    }

    public static void setupPostgreSQLDriverService(String version) throws Exception {
        String bundleName = "postgresql";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(PostgreSQLDriverService.class.getName());
            }
        }) : context.getServiceReference(PostgreSQLDriverService.class.getName());
        PostgreSQLDriverService postgreSQLDriverService = System.getSecurityManager() != null ? (PostgreSQLDriverService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (PostgreSQLDriverService)context.getService(serviceReg);
        ServiceFactory.setPostgreSQLDriverService(postgreSQLDriverService);
    }

    public static void setupSQSService(String version) throws Exception {
        String bundleName = "awssqs";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(SQSService.class.getName());
            }
        }) : context.getServiceReference(SQSService.class.getName());
        SQSService sqs = System.getSecurityManager() != null ? (SQSService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (SQSService)context.getService(serviceReg);
        ServiceFactory.setSqsService(sqs);
    }

    public static void setupSNSService(String version) throws Exception {
        String bundleName = "awssns";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(SNSService.class.getName());
            }
        }) : context.getServiceReference(SNSService.class.getName());
        SNSService sns = System.getSecurityManager() != null ? (SNSService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (SNSService)context.getService(serviceReg);
        ServiceFactory.setSnsService(sns);
    }

    public static void setupPubSubService(String version) throws Exception {
        String bundleName = "gcppubsub";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(PubSubService.class.getName());
            }
        }) : context.getServiceReference(PubSubService.class.getName());
        PubSubService pubsubSvc = System.getSecurityManager() != null ? (PubSubService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (PubSubService)context.getService(serviceReg);
        ServiceFactory.setPubSubService(pubsubSvc);
    }

    public static void setupServiceBusService(String version) throws Exception {
        String bundleName = "azureservicebus";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(ServiceBusService.class.getName());
            }
        }) : context.getServiceReference(ServiceBusService.class.getName());
        ServiceBusService serviceBusService = System.getSecurityManager() != null ? (ServiceBusService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (ServiceBusService)context.getService(serviceReg);
        ServiceFactory.setServiceBusService(serviceBusService);
    }

    public static void setupDynamoDBService(String version) throws Exception {
        String bundleName = "awsdynamodb";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(DynamoDBService.class.getName());
            }
        }) : context.getServiceReference(DynamoDBService.class.getName());
        DynamoDBService dynamoDBService = System.getSecurityManager() != null ? (DynamoDBService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (DynamoDBService)context.getService(serviceReg);
        ServiceFactory.setDynamoDBService(dynamoDBService);
    }

    public static void setupFTPService(String version) throws Exception {
        String bundleName = "ftp";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(FTPService.class.getName());
            }
        }) : context.getServiceReference(FTPService.class.getName());
        FTPService ftp = System.getSecurityManager() != null ? (FTPService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (FTPService)context.getService(serviceReg);
        ServiceFactory.setFTPService(ftp);
    }

    public static void setupSharePointService(String version) throws Exception {
        String bundleName = "sharepoint";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
    }

    public static void setupPrint(String version) throws Exception {
        String bundleName = "print";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(PrintService.class.getName());
            }
        }) : context.getServiceReference(PrintService.class.getName());
        PrintService ps = System.getSecurityManager() != null ? (PrintService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (PrintService)context.getService(serviceReg);
        ServiceFactory.setPrintService(ps);
    }

    public static void setupPresentationService(String version) throws Exception {
        String bundleName = "presentation";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(PresentationService.class.getName());
            }
        }) : context.getServiceReference(PresentationService.class.getName());
        PresentationService ps = System.getSecurityManager() != null ? (PresentationService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (PresentationService)context.getService(serviceReg);
        ServiceFactory.setPresentationService(ps);
    }

    public static void setupExcelService(String version) throws Exception {
        String bundleName = "spreadsheet";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(ExcelService.class.getName());
            }
        }) : context.getServiceReference(ExcelService.class.getName());
        ExcelService es = System.getSecurityManager() != null ? (ExcelService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (ExcelService)context.getService(serviceReg);
        ServiceFactory.setExcelService(es);
    }

    public static void setupLanguageService(String version) throws Exception {
        ServiceFactory.setLanguageService(new LanguageImpl());
    }

    public static void setupFeedService(String version) throws Exception {
        String bundleName = "feed";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
    }

    public static void setupSAMLService(String version) throws Exception {
        String bundleName = "saml";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(SamlService.class.getName());
            }
        }) : context.getServiceReference(SamlService.class.getName());
        SamlService ss = System.getSecurityManager() != null ? (SamlService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (SamlService)context.getService(serviceReg);
        ServiceFactory.setSamlService(ss);
        ss.addPasswordObserver();
    }

    public static void setupCloudConfigService() throws ServiceException {
        CFLogs.SERVER_LOG.info(RB.getString(CFService.class, "CFService.service.start", (Object)"CloudConfig"));
        File vconfig = CFService.getFile("neo-cloud-config.xml");
        CloudConfigService cloudConfigService = new CloudConfigService(vconfig);
        cloudConfigService.start();
        ServiceFactory.setCloudConfigService(cloudConfigService);
    }

    public static void setupGraphQLConfigService() throws ServiceException {
        if (!FelixUtil.isModuleInstalled((String)"graphqlclient", (File)CFService.getFile(INSTALLED_BUNDLES_TXT))) {
            return;
        }
        CFLogs.SERVER_LOG.info(RB.getString(CFService.class, "CFService.service.start", (Object)"GraphQLConfig"));
        File clientConfig = CFService.getFile("neo-graphql-config.xml");
        File serviceConfig = CFService.getFile("../gql/pom.xml");
        GraphQLConfigService graphqlConfigService = new GraphQLConfigService(clientConfig, serviceConfig);
        graphqlConfigService.start();
        ServiceFactory.setGraphQLConfigService(graphqlConfigService);
    }

    public static void setupS3Service(String version) throws Exception {
        String bundleName = "awss3";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(S3ModuleService.class.getName());
            }
        }) : context.getServiceReference(S3ModuleService.class.getName());
        S3ModuleService s3Service = System.getSecurityManager() != null ? (S3ModuleService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (S3ModuleService)context.getService(serviceReg);
        ServiceFactory.setS3Service(s3Service);
    }

    public static void setupFirestoreService(String version) throws Exception {
        if (!CFService._setupService("gcpfirestore", version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(FirestoreService.class.getName());
            }
        }) : context.getServiceReference(FirestoreService.class.getName());
        FirestoreService firestoreService = System.getSecurityManager() != null ? (FirestoreService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (FirestoreService)context.getService(serviceReg);
        ServiceFactory.setFirestoreService(firestoreService);
    }

    public static void setupStorageService(String version) throws Exception {
        String bundleName = "gcpstorage";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(StorageService.class.getName());
            }
        }) : context.getServiceReference(StorageService.class.getName());
        StorageService storageService = System.getSecurityManager() != null ? (StorageService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (StorageService)context.getService(serviceReg);
        ServiceFactory.setStorageService(storageService);
    }

    public static void setupMSGraphService(String version) throws Exception {
        if (!CFService._setupService("msgraph", version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        MSGraphRegistry msGraphService = System.getSecurityManager() != null ? (MSGraphRegistry)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(context.getServiceReference(MSGraphRegistry.class.getName()));
            }
        }) : (MSGraphRegistry)context.getService(context.getServiceReference(MSGraphRegistry.class.getName()));
        ServiceFactory.setMsGraphService(msGraphService);
    }

    public static void setupSecureStorageService() throws ServiceException {
        CFLogs.SERVER_LOG.info(RB.getString(CFService.class, "CFService.service.start", (Object)"SecureStorage"));
        File secureStorageFile = CFService.getFile("spstore.xml");
        SecureStorageService secureStorageService = new SecureStorageService(secureStorageFile);
        secureStorageService.setBackup(false);
        secureStorageService.start();
        ServiceFactory.setSecureStorageService(secureStorageService);
    }

    public static void setupVendorCredentialService() throws ServiceException {
        CFLogs.SERVER_LOG.info(RB.getString(CFService.class, "CFService.service.start", (Object)"VendorCredential"));
        File vconfig = CFService.getFile("neo-cloudcredential.xml");
        VendorCredentialService vendorCredentialService = new VendorCredentialService(vconfig);
        vendorCredentialService.start();
        ServiceFactory.setVendorCredentialService(vendorCredentialService);
    }

    public static void setupORM(String version) throws Exception {
        String bundleName = "orm";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(ORMService.class.getName());
            }
        }) : context.getServiceReference(ORMService.class.getName());
        ORMService ormService = System.getSecurityManager() != null ? (ORMService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (ORMService)context.getService(serviceReg);
        ServiceFactory.setOrmService(ormService);
        ormService.init();
    }

    public static void setupS3OldService(String version) throws Exception {
        String bundleName = "awss3legacy";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(StoreService.class.getName());
            }
        }) : context.getServiceReference(StoreService.class.getName());
        StoreService storeService = System.getSecurityManager() != null ? (StoreService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (StoreService)context.getService(serviceReg);
        StoreService.register("s3", storeService);
        ServiceFactory.setStoreService(storeService);
    }

    public static void setupSequeLinkODBC(String version) throws Exception {
        String bundleName = "odbc";
        if (!CFService._setupService(bundleName, version)) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(SequeLinkDriverService.class.getName());
            }
        }) : context.getServiceReference(SequeLinkDriverService.class.getName());
        SequeLinkDriverService sequeLinkDriverService = System.getSecurityManager() != null ? (SequeLinkDriverService)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (SequeLinkDriverService)context.getService(serviceReg);
        ServiceFactory.setSequelinkService(sequeLinkDriverService);
    }

    public static void setupImageProviders() {
        IIORegistry.getDefaultInstance().registerApplicationClasspathSpis();
    }

    private void setupGrootEnvironment() {
        Object grootDir = System.getProperty(GROOT_HOME);
        if (grootDir == null) {
            return;
        }
        grootDir = ((String)grootDir).replaceAll("[/\\\\]*$", "");
        System.setProperty(GROOT_HOME, (String)grootDir);
        grootDir = (String)grootDir + _sep + "lib";
        try {
            if (new File((String)grootDir).exists()) {
                String grootClassPaths = (String)grootDir + _sep + "updates" + _sep + "hotfix," + (String)grootDir + _sep + "updates," + (String)grootDir + _sep + "connector," + (String)grootDir;
                this.grootClassLoader = new GrootClassLoader(ClassloaderHelper.getInstance().getURLs(grootClassPaths), ClassLoader.getSystemClassLoader().getParent(), this.getClass().getClassLoader());
            } else {
                CFLogs.SERVER_LOG.warn("The specified apim.home path does not exist.");
            }
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.warn(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupGrootServer() throws Throwable {
        this.setupGrootEnvironment();
        Boolean startAPIManager = ServiceFactory.getRuntimeService().getStartAPIManager();
        if (this.grootClassLoader != null && (startAPIManager == null || startAPIManager.booleanValue())) {
            CFLogs.SERVER_LOG.info(RB.getString((Object)this, "CFService.service.start", (Object)"AMP"));
            ClassLoader coldfusionClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
                System.setProperty("org.jboss.logging.provider", "log4j2");
                if (System.getProperty("log4j.configurationFile") == null) {
                    System.setProperty("log4j.configurationFile", "file:///" + System.getProperty(GROOT_HOME) + _sep + "conf" + _sep + "log4j2.xml");
                }
                if (System.getProperty("Log4jContextSelector") == null) {
                    System.setProperty("Log4jContextSelector", "org.apache.logging.log4j.core.async.AsyncLoggerContextSelector");
                }
                if (System.getProperty("AsyncLogger.RingBufferSize") == null) {
                    System.setProperty("AsyncLogger.RingBufferSize", "1048576");
                }
                Thread.currentThread().setContextClassLoader(this.grootClassLoader);
                Class<?> grootServerClass = this.grootClassLoader.loadClass("com.adobe.amp.GrootServer");
                Object grootServer = grootServerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method method = grootServerClass.getMethod("startAPIMasInVM", new Class[0]);
                this.apiManagerStarted = (Boolean)method.invoke(grootServer, new Object[0]);
                if (startAPIManager == null) {
                    ServiceFactory.getRuntimeService().setStartAPIManager(true);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(coldfusionClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopGrootServer() {
        if (this.apiManagerStarted) {
            ClassLoader coldfusionClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.grootClassLoader);
                Class<?> grootServerClass = this.grootClassLoader.loadClass("com.adobe.amp.GrootServer");
                Object grootServer = grootServerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method method = grootServerClass.getMethod("stop", new Class[0]);
                method.invoke(grootServer, new Object[0]);
            }
            catch (Throwable t) {
                CFLogs.SERVER_LOG.error(t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(coldfusionClassLoader);
            }
        }
    }

    public static String getLibPath() {
        if (_path == null) {
            return null;
        }
        return _path + CFService.getXMLFileDir();
    }

    private static File getBundleDependencyFile() {
        return CFService.getFile(INSTALLED_BUNDLES_TXT);
    }

    public static void setupFelixclassloader() throws Exception {
        String bundleName = "felixclassloader";
        String version = FelixUtil.getCurrentVersionToInstall((String)bundleName);
        FelixUtil.deployBundle((String)bundleName, (String)version, (String)CFService.getLibPath());
        if (FelixUtil.invokedFromClient) {
            return;
        }
        final BundleContext context = felix.getBundleContext();
        final ServiceReference serviceReg = System.getSecurityManager() != null ? (ServiceReference)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getServiceReference(FelixClassloader.class.getName());
            }
        }) : context.getServiceReference(FelixClassloader.class.getName());
        FelixClassloader fcl = System.getSecurityManager() != null ? (FelixClassloader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return context.getService(serviceReg);
            }
        }) : (FelixClassloader)context.getService(serviceReg);
        BootstrapClassLoader.setFelixClassloader((FelixClassloader)fcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startFelixContainer(String lib) {
        Object clearCache;
        String osgiBootDelegation;
        if (ServerlessUtil.isLambdaEnv()) {
            lib = "/var/task/cfusion/lib";
        }
        if (felix != null) {
            return;
        }
        StringMap configMap = new StringMap();
        String packagesToImport = "";
        BufferedReader buf = null;
        try {
            FileInputStream is = new FileInputStream(lib + "/exportpackages.txt");
            buf = new BufferedReader(new InputStreamReader(is));
            String line = buf.readLine();
            StringBuilder sb = new StringBuilder();
            while (line != null) {
                if (!line.startsWith("<!--")) {
                    sb.append(line).append(",");
                }
                line = buf.readLine();
            }
            sb.deleteCharAt(sb.length() - 1);
            packagesToImport = sb.toString().trim();
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
        }
        finally {
            if (null != buf) {
                try {
                    buf.close();
                }
                catch (IOException e) {
                    CFLogs.SERVER_LOG.error(e);
                }
            }
        }
        configMap.put("org.osgi.framework.system.packages.extra", packagesToImport);
        configMap.put("org.osgi.framework.storage", FelixUtil.getFelixCache((String)lib));
        if (SystemInfo.isRunningInsideDocker() && (osgiBootDelegation = System.getProperty("org.osgi.framework.bootdelegation")) != null && osgiBootDelegation.length() > 0) {
            configMap.put("org.osgi.framework.bootdelegation", osgiBootDelegation);
        }
        if ((clearCache = System.getProperties().get("coldfusion.clearFelixCache")) != null && Cast._boolean(clearCache)) {
            configMap.put("org.osgi.framework.storage.clean", "onFirstInit");
        }
        configMap.put("felix.systempackages.substitution", "true");
        configMap.put(FELIX_LOG_LEVEL, CFLogLevel.getFelixLogLevel());
        felix = new Felix((Map)configMap);
        try {
            felix.init();
            felix.start();
        }
        catch (BundleException e) {
            CFLogs.SERVER_LOG.error("Felix container could not be started");
        }
    }

    public void stop() {
        this.updateServerStatus("stopped");
        try {
            ArchiveDeployService archiveDeployService = ServiceFactory.getArchiveDeployService();
            if (archiveDeployService != null) {
                archiveDeployService.stop();
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            GraphingService graphingService = ServiceFactory.getNewGraphingService();
            if (graphingService != null) {
                graphingService.stop();
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            XmlRpcService xmlRpcService = ServiceFactory.getXmlRpcService();
            if (xmlRpcService != null) {
                xmlRpcService.stop();
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            MetricsService metricsService = ServiceFactory.getMetricsService();
            if (metricsService != null) {
                metricsService.stop();
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            ServiceFactory.getClientScopeService().stop();
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            RegistryService registryService = ServiceFactory.getRegistryService();
            if (registryService != null) {
                registryService.stop();
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            CronService cronService = ServiceFactory.getCronService();
            if (cronService != null) {
                cronService.stop();
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            ServiceFactory.getRuntimeService().stop();
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            SolrService solrService = ServiceFactory.getSolrService();
            if (solrService != null) {
                solrService.stop();
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            MailSpoolService mailSpoolService = ServiceFactory.getMailSpoolService();
            if (mailSpoolService != null) {
                mailSpoolService.stop();
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            DataSourceService dataSourceService = ServiceFactory.getDataSourceService();
            if (dataSourceService != null) {
                dataSourceService.stop();
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            DebuggingService debuggingService = ServiceFactory.getDebuggingService();
            if (debuggingService != null) {
                debuggingService.stop();
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            SchedulerService schedulerService = ServiceFactory.getSchedulerService();
            if (schedulerService != null) {
                schedulerService.stop();
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            ServiceFactory.getSecurityService().stop();
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            ServiceFactory.getLicenseService().stop();
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            ServiceFactory.getLoggingService().stop();
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            DocumentService documentService = ServiceFactory.getDocumentService();
            if (documentService != null) {
                documentService.stop();
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            EventGatewayService eventGatewayService = ServiceFactory.getEventProcessorService();
            if (eventGatewayService != null) {
                eventGatewayService.stop();
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            DotNetService dotNetService = ServiceFactory.getDotNetService();
            if (dotNetService != null) {
                dotNetService.stop();
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            WatchService watchService = ServiceFactory.getWatchService();
            if (watchService != null) {
                watchService.stop();
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            MonitoringService monitoringService = ServiceFactory.getMonitoringService();
            if (monitoringService != null) {
                monitoringService.stop();
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            JDBCManager manager = JDBCManager.getInstance();
            if (manager != null) {
                manager.clearPools();
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        try {
            LicenseService ls = ServiceFactory.getLicenseService();
            if (ls != null && ls.isCheckUsage()) {
                UsageLoggerTimer usageLoggerTimer = UsageLoggerTimer.getTimer((String)CFService.getRoot());
                usageLoggerTimer.stopSend();
                usageLoggerTimer.stop();
                CFLogs.USAGEDATA_LOG.debug(RB.getString((Object)this, "CFService.service.stop", (Object)"LicensingAnalyticsInfo"));
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
        ServiceFactory.clear();
        try {
            felix.stop();
            felix.waitForStop(Long.getLong("coldfusion.felix.shutdown.timeout", 2000L).longValue());
        }
        catch (InterruptedException | BundleException be) {
            CFLogs.SERVER_LOG.error(be);
        }
        try {
            NeoTranslator.shutDownExecutorService();
        }
        catch (Exception exception) {
            CFLogs.SERVER_LOG.error(exception);
        }
        CFLogs.SERVER_LOG.info(RB.getString(this, "CFService.server.stop"));
    }

    private static void setSystemProperties() {
        System.setProperty("net.sf.ehcache.skipUpdateCheck", "true");
        System.setProperty("org.terracotta.quartz.skipUpdateCheck", "true");
    }

    public static String getServerStatusFile() {
        String lib = null;
        lib = FelixUtil.invokedFromClient ? FelixUtil.libFolder : ServiceFactory.getRuntimeService().getLibDir();
        String file = lib + "/serverstatus.properties";
        return file;
    }

    private void updateServerStatus(String status) {
        if (ServerlessUtil.isLambdaEnv()) {
            return;
        }
        try {
            String file = CFService.getServerStatusFile();
            Properties prop = new Properties();
            if (!new File(file).exists()) {
                try {
                    new File(file).createNewFile();
                }
                catch (IOException e) {
                    CFLogs.SERVER_LOG.error(e);
                }
            }
            try (FileInputStream input = new FileInputStream(file);
                 BufferedInputStream binput = new BufferedInputStream(input);
                 ByteArrayOutputStream bufOut = new ByteArrayOutputStream();){
                int resChar = binput.read();
                while (resChar != -1) {
                    bufOut.write((byte)resChar);
                    resChar = binput.read();
                }
                String fileContent = bufOut.toString();
                prop.load(new StringReader(fileContent));
                prop.put("status", status);
            }
            catch (IOException ex) {
                CFLogs.SERVER_LOG.error(ex);
            }
            try (FileOutputStream fos = new FileOutputStream(new File(file));){
                prop.store(fos, "");
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error(e);
            }
        }
        catch (Throwable t) {
            CFLogs.SERVER_LOG.error(t);
        }
    }

    static {
        _sep = System.getProperty("file.separator");
        _isJRun = false;
        _isStandalone = false;
        onStartNewInstalls = null;
        cores = Runtime.getRuntime().availableProcessors();
        threads = 3;
        MODULES_STARTUP_TIMEOUT = 120;
        try {
            threads = Integer.parseInt(System.getProperty("coldfusion.modules.startup.threads", "3"));
            MODULES_STARTUP_TIMEOUT = Integer.parseInt(System.getProperty("coldfusion.modules.startup.timeout", "120"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        listOfBundlesToInstall = new ArrayList();
        loadingServicesAtStartup = false;
    }
}

