/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server;

import coldfusion.centralconfig.client.CentralConfigClientUtil;
import coldfusion.log.CFLogs;
import coldfusion.runtime.Array;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.server.UpdateUtil;
import coldfusion.util.RB;
import coldfusion.wddx.Base64Encoder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpdateService {
    private static final String SEND_UPDATE = "sendupdate";
    private static final String AUTO_CHECK = "autocheck";
    private static final String CHECK_INTERVAL = "checkinterval";
    private static final String CHECK_PERIODICALLY = "checkperiodically";
    private static final String URL = "url";
    private static final String PACKAGES_URL = "packagesurl";
    private static final String EMAIL_LIST = "emaillist";
    private static final String FROM_EMAIL = "fromemail";
    private static final String SETTINGS = "settings";
    private static final String UPDATE = "update";
    private static final String NOTIFICATION = "notification";
    private static final String CERTIFICATE_FILE = "adobe.cer";
    private static final String DEFAULT_URL = "defaulturl";
    private static final String DEFAULT_PACKAGES_URL = "defaultpackagesurl";
    private static final String PROXY = "proxy";
    private static final String PROXY_HOSTNAME = "hostname";
    private static final String PROXY_PORT = "port";
    private static final String PROXY_USER = "username";
    private static final String PROXY_PASSWORD = "password";
    private AtomicInteger percentComplete = new AtomicInteger(0);
    private String errorMessage;
    private String installerFilePath;
    private static UpdateService updateService;
    private KeyStore keyStore;
    private boolean autoCheck = false;
    private int interval = 10;
    private boolean checkPeriodically = false;
    private String emails = "";
    private String fromemail = "";
    private String url = "";
    private String default_url = "";
    private String packagesurl = "";
    private String default_packagesurl = "";
    private String proxyHost = "";
    private int proxyPort;
    private String proxyUsername = "";
    private String proxyPassword = "";
    private Boolean sendUpdate;
    private String host;
    private String port;
    private String user;
    private String password;

    private UpdateService() {
        this.init(null);
        this.getKeyStore();
    }

    public void init(Map updateSettings) {
        String value;
        Map settingsMap;
        Map map = settingsMap = updateSettings != null ? updateSettings : this.getSettings();
        if (settingsMap.get(AUTO_CHECK) != null) {
            value = (String)settingsMap.get(AUTO_CHECK);
            this.autoCheck = value.equalsIgnoreCase("true");
        }
        if (settingsMap.get(CHECK_PERIODICALLY) != null) {
            value = (String)settingsMap.get(CHECK_PERIODICALLY);
            this.checkPeriodically = value.equalsIgnoreCase("true");
        }
        if (settingsMap.get(CHECK_INTERVAL) != null) {
            value = (String)settingsMap.get(CHECK_INTERVAL);
            try {
                this.interval = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (settingsMap.get(EMAIL_LIST) != null) {
            this.emails = ((String)settingsMap.get(EMAIL_LIST)).trim();
        }
        if (settingsMap.get(FROM_EMAIL) != null) {
            this.fromemail = ((String)settingsMap.get(FROM_EMAIL)).trim();
        }
        if (settingsMap.get(URL) != null) {
            this.url = ((String)settingsMap.get(URL)).trim();
        }
        if (settingsMap.get(DEFAULT_URL) != null) {
            this.default_url = ((String)settingsMap.get(DEFAULT_URL)).trim();
        }
        if (settingsMap.get(PACKAGES_URL) != null) {
            this.packagesurl = ((String)settingsMap.get(PACKAGES_URL)).trim();
        }
        if (settingsMap.get(DEFAULT_PACKAGES_URL) != null) {
            this.default_packagesurl = ((String)settingsMap.get(DEFAULT_PACKAGES_URL)).trim();
        }
        if (settingsMap.get(SEND_UPDATE) != null) {
            value = (String)settingsMap.get(SEND_UPDATE);
            this.populateFlag(value);
        }
        if (settingsMap.get(PROXY_HOSTNAME) != null) {
            this.proxyHost = (String)settingsMap.get(PROXY_HOSTNAME);
        }
        if (settingsMap.get(PROXY_PORT) != null) {
            this.proxyPort = Integer.valueOf((String)settingsMap.get(PROXY_PORT));
        }
        if (settingsMap.get(PROXY_USER) != null) {
            this.proxyUsername = (String)settingsMap.get(PROXY_USER);
        }
        if (settingsMap.get(PROXY_PASSWORD) != null) {
            this.proxyPassword = (String)settingsMap.get(PROXY_PASSWORD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UpdateService getInstance() {
        if (updateService != null) return updateService;
        Class<UpdateService> clazz = UpdateService.class;
        synchronized (UpdateService.class) {
            if (updateService != null) return updateService;
            updateService = new UpdateService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return updateService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void download(String downloadLink, final String location, String checksum) {
        InputStream inp = null;
        FileOutputStream fileop = null;
        int index = downloadLink.lastIndexOf("/");
        String fileName = downloadLink.substring(index + 1);
        final String filePath = location + File.separator + fileName;
        try {
            HttpResponse response;
            this.percentComplete.set(0);
            this.errorMessage = null;
            this.installerFilePath = null;
            HttpClient httpClient = this.getHTTPClient();
            HttpGet httpGet = new HttpGet(downloadLink);
            HttpClientContext context = null;
            if (this.host != null && this.user != null && this.password != null) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.user, this.password));
                context = HttpClientContext.create();
                context.setCredentialsProvider((CredentialsProvider)credsProvider);
            }
            if ((response = httpClient.execute((HttpUriRequest)httpGet, context)) != null && response.getStatusLine().getStatusCode() == 200) {
                int count;
                int size = (int)(response.getEntity().getContentLength() / 1024L);
                fileop = (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        File installer;
                        File downloadDir = new File(location);
                        if (!downloadDir.exists()) {
                            downloadDir.mkdir();
                        }
                        if (!(installer = new File(filePath)).exists()) {
                            installer.createNewFile();
                        }
                        UpdateService.this.installerFilePath = installer.getAbsolutePath();
                        return new FileOutputStream(installer);
                    }
                });
                float percent = 1.0f;
                byte[] buff = new byte[1024];
                MessageDigest md = MessageDigest.getInstance("md5");
                inp = response.getEntity().getContent();
                int complete = 0;
                while ((count = inp.read(buff)) != -1) {
                    complete = (int)(percent / (float)size * 100.0f);
                    if (complete >= 90) {
                        complete = 90;
                    }
                    this.percentComplete.set(complete);
                    fileop.write(buff, 0, count);
                    percent += 1.0f;
                    md.update(buff, 0, count);
                }
                byte[] b = md.digest();
                StringBuffer fileChecksum = new StringBuffer();
                for (int i = 0; i < b.length; ++i) {
                    fileChecksum.append(Integer.toString((b[i] & 0xFF) + 256, 16).substring(1));
                }
                if (!checksum.equalsIgnoreCase(fileChecksum.toString())) {
                    this.handleError("DownloadService.checksumfalied", null, filePath, fileop, inp);
                } else {
                    if (fileop != null) {
                        fileop.close();
                    }
                    if (!this.verifySignature(filePath)) {
                        this.handleError("DownloadService.signature_verification_failed", null, filePath, fileop, inp);
                    } else {
                        this.percentComplete.set(100);
                    }
                }
            } else {
                this.percentComplete.set(-1);
                this.errorMessage = response != null ? response.getStatusLine().getReasonPhrase() : "Download Error";
            }
        }
        catch (IOException e) {
            this.handleError("DownloadService.filenotfound", new Object[]{downloadLink}, filePath, fileop, inp);
        }
        catch (PrivilegedActionException e) {
            this.handleError("DownloadService.accessdenied", new Object[]{location}, null, fileop, inp);
        }
        catch (Exception e) {
            this.errorMessage = e.getLocalizedMessage();
            this.handleError(null, null, filePath, fileop, inp);
        }
        finally {
            try {
                if (fileop != null) {
                    fileop.close();
                }
                if (inp != null) {
                    inp.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private HttpClient getHTTPClient() {
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        HttpGet httpget = new HttpGet(this.url);
        this.host = System.getProperty("http.proxyHost");
        this.port = System.getProperty("http.proxyPort");
        this.user = System.getProperty("http.proxyUser");
        this.password = System.getProperty("http.proxyPassword");
        if (this.host != null) {
            HttpHost proxy = new HttpHost(this.host, Integer.parseInt(this.port));
            requestBuilder.setProxy(proxy);
            if (this.user != null) {
                String auth = this.password == null ? this.user : this.user + ":" + this.password;
                BasicHeader header = new BasicHeader("Proxy-Authorization", "Basic " + Base64Encoder.encode(auth.getBytes()));
                httpget.setHeader((Header)header);
            }
        }
        requestBuilder.setConnectTimeout(60000);
        return HttpClientBuilder.create().setDefaultRequestConfig(requestBuilder.build()).build();
    }

    private void handleError(String key, Object[] objects, String filePath, FileOutputStream fileop, InputStream inp) {
        this.percentComplete.set(-1);
        if (key != null) {
            this.errorMessage = objects != null ? RB.getString(UpdateService.class, key, objects) : RB.getString(UpdateService.class, key);
        }
        try {
            if (fileop != null) {
                fileop.close();
            }
            if (inp != null) {
                inp.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (filePath != null) {
            this.deleteFile(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifySignature(String filePath) {
        ZipFile jarFile = null;
        try {
            if (filePath != null && !filePath.equals("") && (jarFile = new JarFile(filePath)) != null) {
                this.verifyJarSignature((JarFile)jarFile);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e.getMessage(), e);
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private void verifyJarSignature(JarFile jarFile) throws CertificateException, IOException, KeyStoreException {
        if (jarFile != null) {
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                throw new SecurityException(RB.getString(UpdateService.class, "DownloadService.incorrect_signature"));
            }
            ArrayList<JarEntry> jarEntryList = UpdateService.verifyIntegrityForEntries(jarFile);
            this.verifyProviderCertificate(jarEntryList);
        }
    }

    private void verifyProviderCertificate(List<JarEntry> jarEntryList) throws KeyStoreException {
        if (jarEntryList != null) {
            Enumeration<String> aliases;
            Iterator<JarEntry> itr = jarEntryList.iterator();
            ArrayList<Certificate> trustedCertificates = new ArrayList<Certificate>();
            Certificate cert = null;
            if (this.keyStore != null && (aliases = this.keyStore.aliases()) != null) {
                while (aliases.hasMoreElements()) {
                    cert = this.keyStore.getCertificate(aliases.nextElement());
                    if (cert == null) continue;
                    trustedCertificates.add(cert);
                }
            }
            while (itr.hasNext()) {
                Certificate[] certChain;
                JarEntry entry = itr.next();
                Certificate[] certs = entry.getCertificates();
                if (certs == null) {
                    if (entry.getName().startsWith("META-INF")) continue;
                    throw new SecurityException(RB.getString(UpdateService.class, "DownloadService.unsignedentry") + " - " + entry.getName());
                }
                int startIndex = 0;
                boolean signatureVerified = false;
                String subjectName = null;
                boolean foundMatchingCertificate = false;
                while ((certChain = UpdateService.getCertificateChain(certs, startIndex)) != null) {
                    foundMatchingCertificate = false;
                    if (trustedCertificates != null) {
                        for (int i = certChain.length - 1; i > 0; --i) {
                            if (!UpdateService.checkAgainstTrustStore(trustedCertificates, (X509Certificate)certChain[i])) continue;
                            foundMatchingCertificate = true;
                            break;
                        }
                    }
                    if (foundMatchingCertificate && ((subjectName = ((X509Certificate)certChain[0]).getSubjectDN().getName()).contains("CN=Adobe Inc.") || subjectName.contains("CN=Adobe Systems Incorporated")) && (subjectName.contains("O=Adobe Inc.") || subjectName.contains("O=Adobe Systems Incorporated")) && subjectName.contains("C=US")) {
                        signatureVerified = true;
                        break;
                    }
                    startIndex += certChain.length;
                }
                if (signatureVerified) continue;
                throw new SecurityException(RB.getString(UpdateService.class, "DownloadService.untrustedsignature"));
            }
        }
    }

    private static Certificate[] getCertificateChain(Certificate[] certs, int startIndex) {
        int i;
        if (startIndex > certs.length - 1) {
            return null;
        }
        for (i = startIndex; i < certs.length - 1 && ((X509Certificate)certs[i + 1]).getSubjectDN().equals(((X509Certificate)certs[i]).getIssuerDN()); ++i) {
        }
        int certChainSize = i - startIndex + 1;
        Certificate[] ret = new X509Certificate[certChainSize];
        for (int j = 0; j < certChainSize; ++j) {
            ret[j] = (X509Certificate)certs[startIndex + j];
        }
        return ret;
    }

    private static ArrayList<JarEntry> verifyIntegrityForEntries(JarFile jarFile) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        byte[] buffer = new byte[1024];
        ArrayList<JarEntry> entryList = new ArrayList<JarEntry>();
        while (entries.hasMoreElements()) {
            int n;
            JarEntry je = entries.nextElement();
            if (je.isDirectory()) continue;
            entryList.add(je);
            InputStream is = jarFile.getInputStream(je);
            while ((n = is.read(buffer, 0, buffer.length)) != -1) {
            }
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return entryList;
    }

    private static Certificate getCertificate(byte[] validCertificate) throws CertificateException, IOException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream inStream = new ByteArrayInputStream(validCertificate);
        X509Certificate cert = (X509Certificate)cf.generateCertificate(inStream);
        inStream.close();
        return cert;
    }

    private static byte[] readCertificate() throws CertificateException, IOException {
        RuntimeService runtimeService = ServiceFactory.getRuntimeService();
        String rootDir = runtimeService.getRootDir();
        File settingsFile = new File(rootDir + File.separator + "lib" + File.separator + CERTIFICATE_FILE);
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        FileInputStream certFile = new FileInputStream(settingsFile);
        byte[] certBytes = new byte[certFile.available()];
        certFile.read(certBytes);
        try {
            certFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return certBytes;
    }

    public int getPercentComplete() {
        return this.percentComplete.get();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getInstallerFilePath() {
        return this.installerFilePath;
    }

    public void reset() {
        this.installerFilePath = null;
        this.errorMessage = null;
    }

    public String getServerBaseDir() throws IOException {
        RuntimeService runtimeService = ServiceFactory.getRuntimeService();
        String rootDir = runtimeService.getRootDir();
        File file = new File(rootDir);
        file = file.getParentFile();
        return file.getCanonicalPath();
    }

    public Array getColdFusionInstances(String updateId, String buildNo) {
        try {
            DocumentBuilderFactory dbFactory;
            DocumentBuilder dBuilder;
            Document doc;
            NodeList nList;
            String rootDir = this.getServerBaseDir();
            String configDir = rootDir + File.separator + "config" + File.separator + "instances.xml";
            File fXmlFile = new File(configDir);
            if (fXmlFile.exists() && (nList = (doc = (dBuilder = (dbFactory = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(fXmlFile)).getElementsByTagName("server")) != null) {
                Array serverList = new Array(1, nList.getLength());
                Node serverNode = null;
                Node nameNode = null;
                NodeList children = null;
                for (int i = 0; i < nList.getLength(); ++i) {
                    serverNode = nList.item(i);
                    if (!this.isLocalInstance(serverNode) || (children = serverNode.getChildNodes()) == null) continue;
                    for (int j = 0; j < children.getLength(); ++j) {
                        nameNode = children.item(j);
                        if (nameNode.getNodeType() != 1 || !nameNode.getNodeName().equals("name") || nameNode.getFirstChild() == null) continue;
                        String childInstanceName = nameNode.getFirstChild().getNodeValue().trim();
                        if (updateId != null) {
                            if (this.isUpdateInstalled(rootDir, childInstanceName, updateId, buildNo)) continue;
                            serverList.add(childInstanceName);
                            continue;
                        }
                        serverList.add(childInstanceName);
                    }
                }
                return serverList;
            }
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
        }
        return new Array(1);
    }

    private boolean isLocalInstance(Node serverNode) {
        Node attribute;
        return serverNode.getAttributes() == null || (attribute = serverNode.getAttributes().getNamedItem("remote")) == null || !attribute.getNodeValue().equalsIgnoreCase("true");
    }

    private void deleteFile(String fileName) {
        final File f = new File(fileName);
        if (f.exists()) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        f.delete();
                        return null;
                    }
                });
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error(e);
            }
        }
    }

    public Map getSettings() {
        RuntimeService runtimeService = ServiceFactory.getRuntimeService();
        String rootDir = runtimeService.getRootDir();
        File settingsFile = null;
        try {
            settingsFile = CentralConfigClientUtil.pullFromCCSFile("neo_updates.xml");
        }
        catch (Exception e1) {
            CFLogs.SERVER_LOG.error(e1);
        }
        if (settingsFile == null) {
            settingsFile = new File(rootDir + File.separator + "lib" + File.separator + "neo_updates.xml");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(settingsFile);
            NodeList nodeList = doc.getElementsByTagName(UPDATE);
            Node node = null;
            HashMap<String, String> settingsMap = new HashMap<String, String>();
            if (nodeList != null) {
                node = nodeList.item(0);
                NamedNodeMap attributes = node.getAttributes();
                String value = null;
                if (attributes != null) {
                    value = attributes.getNamedItem(AUTO_CHECK).getNodeValue().trim();
                    settingsMap.put(AUTO_CHECK, value);
                    value = attributes.getNamedItem(CHECK_INTERVAL).getNodeValue().trim();
                    settingsMap.put(CHECK_INTERVAL, value);
                    value = attributes.getNamedItem(CHECK_PERIODICALLY).getNodeValue().trim();
                    settingsMap.put(CHECK_PERIODICALLY, value);
                    Node valueNode = attributes.getNamedItem(SEND_UPDATE);
                    if (valueNode != null && valueNode.getNodeValue() != null) {
                        String val = valueNode.getNodeValue().trim();
                        settingsMap.put(SEND_UPDATE, val);
                    } else {
                        this.updateFlag("true", settingsMap);
                    }
                }
                if ((nodeList = doc.getElementsByTagName(URL)) != null && (node = nodeList.item(0)).getFirstChild() != null) {
                    settingsMap.put(URL, node.getFirstChild().getNodeValue());
                }
                if ((nodeList = doc.getElementsByTagName(DEFAULT_URL)) != null && (node = nodeList.item(0)).getFirstChild() != null) {
                    settingsMap.put(DEFAULT_URL, node.getFirstChild().getNodeValue());
                }
                if ((nodeList = doc.getElementsByTagName(PACKAGES_URL)) != null && (node = nodeList.item(0)).getFirstChild() != null) {
                    settingsMap.put(PACKAGES_URL, node.getFirstChild().getNodeValue());
                }
                if ((nodeList = doc.getElementsByTagName(DEFAULT_PACKAGES_URL)) != null && (node = nodeList.item(0)).getFirstChild() != null) {
                    settingsMap.put(DEFAULT_PACKAGES_URL, node.getFirstChild().getNodeValue());
                }
                if ((nodeList = doc.getElementsByTagName(EMAIL_LIST)) != null && (node = nodeList.item(0)).getFirstChild() != null) {
                    settingsMap.put(EMAIL_LIST, node.getFirstChild().getNodeValue());
                }
                if ((nodeList = doc.getElementsByTagName(FROM_EMAIL)) != null && (node = nodeList.item(0)).getFirstChild() != null) {
                    settingsMap.put(FROM_EMAIL, node.getFirstChild().getNodeValue());
                }
            }
            if ((nodeList = doc.getElementsByTagName(PROXY)) != null) {
                nodeList = doc.getElementsByTagName(PROXY_HOSTNAME);
                if (nodeList != null && (node = nodeList.item(0)).getFirstChild() != null) {
                    settingsMap.put(PROXY_HOSTNAME, node.getFirstChild().getNodeValue());
                }
                if ((nodeList = doc.getElementsByTagName(PROXY_PORT)) != null && (node = nodeList.item(0)).getFirstChild() != null) {
                    settingsMap.put(PROXY_PORT, node.getFirstChild().getNodeValue());
                }
                if ((nodeList = doc.getElementsByTagName(PROXY_USER)) != null && (node = nodeList.item(0)).getFirstChild() != null) {
                    settingsMap.put(PROXY_USER, node.getFirstChild().getNodeValue());
                }
                if ((nodeList = doc.getElementsByTagName(PROXY_PASSWORD)) != null && (node = nodeList.item(0)).getFirstChild() != null) {
                    settingsMap.put(PROXY_PASSWORD, node.getFirstChild().getNodeValue());
                }
            }
            return settingsMap;
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
            return null;
        }
    }

    public void saveSettings(Map updateSettings, boolean init) {
        if (updateSettings != null) {
            try {
                this.init(updateSettings);
                this.store();
            }
            catch (Exception e) {
                CFLogs.SERVER_LOG.error("error writting update setings - " + e.getMessage());
            }
        }
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = Integer.parseInt(proxyPort);
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void store() {
        this.store(true);
    }

    public void store(final boolean broadcast) {
        try {
            RuntimeService runtimeService = ServiceFactory.getRuntimeService();
            String rootDir = runtimeService.getRootDir();
            final File settingsFile = new File(rootDir + File.separator + "lib" + File.separator + "neo_updates.xml");
            final String oldData = new String(Files.readAllBytes(Paths.get(settingsFile.getAbsolutePath(), new String[0])));
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element settingsElement = doc.createElement(SETTINGS);
            Element updateNode = doc.createElement(UPDATE);
            updateNode.setAttribute(AUTO_CHECK, this.autoCheck ? "true" : "false");
            updateNode.setAttribute(CHECK_INTERVAL, "" + this.interval);
            updateNode.setAttribute(CHECK_PERIODICALLY, this.checkPeriodically ? "true" : "false");
            if (this.sendUpdate != null) {
                updateNode.setAttribute(SEND_UPDATE, Boolean.toString(this.sendUpdate));
            }
            Element urlNode = doc.createElement(URL);
            urlNode.setTextContent(this.url);
            updateNode.appendChild(urlNode);
            Element defURLNode = doc.createElement(DEFAULT_URL);
            defURLNode.setTextContent(this.default_url);
            updateNode.appendChild(defURLNode);
            Element packagesUrlNode = doc.createElement(PACKAGES_URL);
            packagesUrlNode.setTextContent(this.packagesurl);
            updateNode.appendChild(packagesUrlNode);
            Element defPackagesURLNode = doc.createElement(DEFAULT_PACKAGES_URL);
            defPackagesURLNode.setTextContent(this.default_packagesurl);
            updateNode.appendChild(defPackagesURLNode);
            Element notificationNode = doc.createElement(NOTIFICATION);
            Element emailNode = doc.createElement(EMAIL_LIST);
            emailNode.setTextContent(this.emails);
            Element fromemailNode = doc.createElement(FROM_EMAIL);
            fromemailNode.setTextContent(this.fromemail);
            notificationNode.appendChild(emailNode);
            notificationNode.appendChild(fromemailNode);
            updateNode.appendChild(notificationNode);
            Element proxyNode = doc.createElement(PROXY);
            Element proxyHostNode = doc.createElement(PROXY_HOSTNAME);
            proxyHostNode.setTextContent(this.proxyHost);
            proxyNode.appendChild(proxyHostNode);
            Element proxyPortNode = doc.createElement(PROXY_PORT);
            proxyPortNode.setTextContent(String.valueOf(this.proxyPort));
            proxyNode.appendChild(proxyPortNode);
            Element proxyUsernameNode = doc.createElement(PROXY_USER);
            proxyUsernameNode.setTextContent(this.proxyUsername);
            proxyNode.appendChild(proxyUsernameNode);
            Element proxyPasswordNode = doc.createElement(PROXY_PASSWORD);
            proxyPasswordNode.setTextContent(this.proxyPassword);
            proxyNode.appendChild(proxyPasswordNode);
            settingsElement.appendChild(updateNode);
            settingsElement.appendChild(proxyNode);
            final DOMSource source = new DOMSource(settingsElement);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Transformer transformer = TransformerFactory.newInstance().newTransformer();
                        StreamResult result = new StreamResult(settingsFile);
                        transformer.transform(source, result);
                        String newData = new String(Files.readAllBytes(Paths.get(settingsFile.getAbsolutePath(), new String[0])));
                        if (broadcast) {
                            CentralConfigClientUtil.pushToCCS(settingsFile, "UpdateSettings", newData, oldData);
                        }
                    }
                    catch (Exception e) {
                        CFLogs.SERVER_LOG.error("error writting update setings - " + e.getMessage());
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error("error writting update setings - " + e.getMessage());
        }
    }

    public void writePropertiesFile(final String fileContent, final String filePath) throws PrivilegedActionException {
        File propFile = new File(filePath);
        final String location = propFile.getParent();
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                File propertiesFile;
                File downloadDir = new File(location);
                if (!downloadDir.exists()) {
                    downloadDir.mkdir();
                }
                if (!(propertiesFile = new File(filePath)).exists()) {
                    propertiesFile.createNewFile();
                }
                FileOutputStream fileOP = null;
                PrintStream pOut = null;
                try {
                    fileOP = new FileOutputStream(propertiesFile);
                    pOut = new PrintStream(fileOP);
                    pOut.print(fileContent);
                }
                finally {
                    if (pOut != null) {
                        pOut.close();
                    }
                    if (fileOP != null) {
                        fileOP.close();
                    }
                }
                return null;
            }
        });
    }

    private static boolean checkAgainstTrustStore(List<Certificate> trustedCertificates, X509Certificate cert) {
        X509Certificate tempCert = null;
        for (int i = 0; i < trustedCertificates.size(); ++i) {
            if (!(trustedCertificates.get(i) instanceof X509Certificate) || !(tempCert = (X509Certificate)trustedCertificates.get(i)).getSubjectX500Principal().getName().equals(cert.getSubjectX500Principal().getName())) continue;
            return true;
        }
        return false;
    }

    private void getKeyStore() {
        String javaHome = System.getProperty("java.home");
        String keyStorePath = javaHome + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
        try {
            this.keyStore = KeyStore.getInstance("JKS");
            this.keyStore.load(new FileInputStream(keyStorePath), null);
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error(e);
        }
    }

    public boolean isAutoCheck() {
        return this.autoCheck;
    }

    public void setAutoCheck(boolean autoCheck) {
        this.autoCheck = autoCheck;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public boolean isCheckPeriodically() {
        return this.checkPeriodically;
    }

    public void setCheckPeriodically(boolean checkPeriodically) {
        this.checkPeriodically = checkPeriodically;
    }

    public String getEmails() {
        return this.emails;
    }

    public void setEmails(String emails) {
        this.emails = emails;
    }

    public String getFromEmail() {
        return this.fromemail;
    }

    public void setFromEmail(String email) {
        this.fromemail = email;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDefaultUrl() {
        return this.default_url;
    }

    public String getPackagesurl() {
        return this.packagesurl;
    }

    public String getDefaultPackagesUrl() {
        return this.default_packagesurl;
    }

    public void setPackagesurl(String packagesurl) {
        this.packagesurl = packagesurl;
    }

    private void populateFlag(String value) {
        this.sendUpdate = value.equalsIgnoreCase("true") ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }

    private void updateFlag(String value, Map settingsMap) {
        settingsMap.put(SEND_UPDATE, value);
        this.sendUpdate = value.equalsIgnoreCase("true") ? Boolean.valueOf(true) : Boolean.valueOf(false);
    }

    private boolean isUpdateInstalled(String rootDir, String childInstanceName, String updateId, String buildNo) {
        String updatesDir = rootDir + File.separator + childInstanceName;
        File uDir = new File(updatesDir);
        if (uDir.exists()) {
            return UpdateUtil.isUpdateInstalled(updatesDir, updateId, buildNo);
        }
        return false;
    }
}

