/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server;

import coldfusion.runtime.ApplicationException;
import coldfusion.tagext.io.FileTag;
import coldfusion.tagext.io.FileUtils;
import coldfusion.util.BOMReader;
import coldfusion.vfs.VFile;
import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class UpdateUtil {
    private static String updateLevel = null;
    private static final String UPDATES_DIR = "hf-updates";
    private static final String UPDATES_INFO_XML = "updates.xml";

    private static String getFriendlyUpdatePath(String path) {
        File f = new File(path);
        return f instanceof VFile ? ((VFile)f).getFriendlyName() : path;
    }

    public static String readUpdateFile(String file, String charset) {
        char[] buf = new char[1024];
        File f = new File(file);
        StringBuilder builder = new StringBuilder((int)f.length());
        Reader in = null;
        try {
            int count;
            in = new BOMReader(new BufferedInputStream(new FileInputStream(file)), charset, false);
            while ((count = in.read(buf)) != -1) {
                builder.append(buf, 0, count);
            }
        }
        catch (CharConversionException cce) {
            throw new UpdateFileCharConversionException(file, charset);
        }
        catch (IOException ioe) {
            throw new FileTag.SingleFileOperationException("read", ioe, file);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return builder.toString();
    }

    public static String getUpdateLevel(String rootDir) {
        return UpdateUtil.getUpdateLevel(rootDir, false);
    }

    public static String getUpdateLevel(String rootDir, boolean reload) {
        if (updateLevel == null || reload) {
            String updateInfoFilePath = rootDir + File.separator + UPDATES_DIR + File.separator + UPDATES_INFO_XML;
            try {
                String content = UpdateUtil.readUpdateFile(updateInfoFilePath, "UTF-8");
                InputSource source = new InputSource(new StringReader(content));
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = builder.parse(source);
                NodeList nodes = doc.getElementsByTagName("cfhf_updatelevel");
                if (nodes == null || nodes != null && nodes.getLength() == 0) {
                    updateLevel = "0";
                } else {
                    int highestLevel = 0;
                    String updateLevelStr = null;
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node node = nodes.item(i);
                        updateLevelStr = node.getFirstChild().getNodeValue().trim();
                        int level = Integer.parseInt(updateLevelStr);
                        if (level <= highestLevel) continue;
                        highestLevel = level;
                        updateLevel = updateLevelStr;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return updateLevel != null ? updateLevel : "0";
    }

    public static List<Integer> getInstalledUpdateLevelsInAscOrder(String rootDir) {
        HashSet<Integer> updateLevels = new HashSet<Integer>();
        updateLevels.add(0);
        String updateInfoFilePath = rootDir + File.separator + UPDATES_DIR + File.separator + UPDATES_INFO_XML;
        if (new File(updateInfoFilePath).exists()) {
            try {
                String content = UpdateUtil.readUpdateFile(updateInfoFilePath, "UTF-8");
                InputSource source = new InputSource(new StringReader(content));
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = builder.parse(source);
                NodeList nodes = doc.getElementsByTagName("cfhf_updatelevel");
                if (nodes != null) {
                    String updateLevelStr = null;
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node node = nodes.item(i);
                        updateLevelStr = node.getFirstChild().getNodeValue().trim();
                        int level = Integer.parseInt(updateLevelStr);
                        updateLevels.add(level);
                    }
                }
            }
            catch (Throwable content) {
                // empty catch block
            }
        }
        ArrayList<Integer> updateLevelsList = new ArrayList<Integer>();
        updateLevelsList.addAll(updateLevels);
        return updateLevelsList;
    }

    public static boolean isUpdateInstalled(String rootDir, String id, String buildNo) {
        if (id != null) {
            String updateInfoFilePath = rootDir + File.separator + UPDATES_DIR + File.separator + UPDATES_INFO_XML;
            try {
                String content = FileUtils.readFile(updateInfoFilePath, "UTF-8");
                InputSource source = new InputSource(new StringReader(content));
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = builder.parse(source);
                NodeList nodes = doc.getElementsByTagName("cfhf_id");
                if (nodes != null) {
                    String updateIdStr = null;
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node node = nodes.item(i);
                        updateIdStr = node.getFirstChild().getNodeValue().trim();
                        if (!updateIdStr.equals(id)) continue;
                        if (buildNo == null || buildNo != null && buildNo.equals("")) {
                            return true;
                        }
                        String installedBuildNumber = null;
                        NodeList nList = node.getParentNode().getChildNodes();
                        for (int temp = 0; temp < nList.getLength(); ++temp) {
                            Element eElement;
                            String buildElement;
                            Node nNode = nList.item(temp);
                            if (nNode.getNodeType() != 1 || !(buildElement = (eElement = (Element)nNode).getTagName()).equals("cfhf_buildnumber")) continue;
                            installedBuildNumber = eElement.getTextContent();
                        }
                        if (installedBuildNumber == null || installedBuildNumber != null && installedBuildNumber.equals("")) {
                            return true;
                        }
                        if (Long.parseLong(installedBuildNumber) < Long.parseLong(buildNo)) continue;
                        return true;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static class UpdateFileCharConversionException
    extends ApplicationException {
        public final String file;
        public final String charType;

        UpdateFileCharConversionException(String file, String charType) {
            this.file = UpdateUtil.getFriendlyUpdatePath(file);
            this.charType = charType;
        }
    }
}

