/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.j2ee;

import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.server.CFService;
import coldfusion.server.ServiceException;
import coldfusion.server.j2ee.CFServiceImpl;
import coldfusion.util.RB;
import jakarta.servlet.http.HttpServlet;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Random;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.StrictHostnameVerifier;

public class CFStartUpServlet
extends HttpServlet {
    String cfRootDir;
    String appServerRootDir;
    String javaPolicyFileLocation;
    String appServer;
    private static final String algorithm = "SHA-256";
    CFService service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        String digest;
        boolean isConfigured;
        String derbyHome;
        File cfRootDirFile;
        String xpathFactory;
        this.log(RB.getString((Object)this, "CFStartUpServlet.service.start"));
        this.log("ColdFusion: VM version = " + System.getProperty("java.vm.version"));
        String transfomerFactory = System.getProperty("javax.xml.transform.TransformerFactory");
        if (transfomerFactory == null) {
            System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        }
        if ((xpathFactory = System.getProperty("javax.xml.xpath.XPathFactory")) == null) {
            System.setProperty("javax.xml.xpath.XPathFactory", "org.apache.xpath.jaxp.XPathFactoryImpl");
        }
        System.setProperty("JINTEGRA_PREFETCH_ENUMS", "");
        this.cfRootDir = this.getInitParameter("cfRootDir");
        if (this.cfRootDir.startsWith("./")) {
            this.cfRootDir = this.getServletContext().getRealPath(this.cfRootDir.substring(1));
        }
        if (!(cfRootDirFile = new File(this.cfRootDir)).isDirectory()) {
            this.cfRootDir = System.getProperty("coldfusion.rootDir");
            if (this.cfRootDir != null) {
                cfRootDirFile = new File(this.cfRootDir);
            }
            if (!cfRootDirFile.isDirectory()) {
                this.cfRootDir = this.getServletContext().getRealPath("../");
                cfRootDirFile = new File(this.cfRootDir);
            }
            try {
                this.cfRootDir = cfRootDirFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.cfRootDir.endsWith(File.separator)) {
            this.cfRootDir = this.cfRootDir.substring(0, this.cfRootDir.length() - 1);
        }
        if ((derbyHome = System.getProperty("derby.system.home")) == null) {
            System.setProperty("derby.system.home", this.cfRootDir + "/db");
        }
        this.appServerRootDir = this.getInitParameter("appServerRootDir");
        this.javaPolicyFileLocation = this.getInitParameter("javaPolicyFileLocation");
        this.appServer = this.getInitParameter("appServer");
        File seedPropertiesFile = new File(this.cfRootDir + "/lib/seed.properties");
        boolean bl = isConfigured = seedPropertiesFile != null && seedPropertiesFile.exists();
        if (!isConfigured && (digest = this.hash()) != null) {
            digest = digest.substring(0, 16);
            seedPropertiesFile.setExecutable(false, false);
            seedPropertiesFile.setReadable(true, true);
            seedPropertiesFile.setWritable(true, true);
            FileWriter writer = null;
            try {
                writer = new FileWriter(seedPropertiesFile);
                writer.write("seed=" + digest + "\n");
                writer.write("algorithm=AES/CBC/PKCS5Padding");
            }
            catch (Exception exception) {
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.initCFService();
        try {
            this.startCFService();
        }
        catch (ServiceException e) {
            e.printStackTrace();
            CFLogs.SERVER_LOG.error(RB.getString((Object)this, "CFStartUpServlet.notInitialised") + e.getLocalizedMessage());
            CFLogs.SERVER_LOG.info(RB.getString((Object)this, "CFStartUpServlet.shutdown"));
            System.exit(-1);
        }
        catch (Throwable e) {
            CFLogs.SERVER_LOG.info(RB.getString((Object)this, "CFStartUpServlet.notInitialised") + e.getLocalizedMessage());
        }
        CFLogs.SERVER_LOG.info(RB.getString((Object)this, "CFStartUpServlet.services.available"));
    }

    public void destroy() {
        this.service.stop();
    }

    public String getCFRootDir() {
        return this.cfRootDir;
    }

    public String getAppServerRootDir() {
        return this.appServerRootDir;
    }

    public String getAppServer() {
        return this.appServer;
    }

    public String getJavaPolicyFileLocation() {
        return this.javaPolicyFileLocation;
    }

    public void startCFService() throws Throwable {
        this.getCFService().start();
    }

    public void initCFService() {
        this.setCFService(new CFServiceImpl(this.getCFRootDir(), this.getAppServerRootDir(), this.getJavaPolicyFileLocation(), this.getAppServer(), this.getServletContext()));
    }

    public void setCFService(CFService serv) {
        this.service = serv;
    }

    public CFService getCFService() {
        return this.service;
    }

    private boolean validVMVersion() {
        String ver = System.getProperty("java.version");
        int version = 0;
        try {
            version = Integer.valueOf(ver);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (version >= 9) {
            return true;
        }
        if (ver.length() >= 3 && ver.startsWith("1.")) {
            return ver.charAt(2) >= '8';
        }
        if (ver.length() >= 5) {
            String versionDetails = "0";
            StringTokenizer verTokens = new StringTokenizer(ver, ".");
            if (verTokens.hasMoreTokens()) {
                versionDetails = verTokens.nextToken();
            }
            Integer vers = 0;
            try {
                vers = Integer.valueOf(versionDetails);
                return vers >= 9;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    private static void sslSupport() throws SSLException {
        String checkHandler = System.getProperty("java.protocol.handler.pkgs");
        if (checkHandler == null) {
            try {
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                SSLContext sslContext = SSLContext.getInstance("TLS", "SunJSSE");
                Security.addProvider(sslContext.getProvider());
            }
            catch (Exception e) {
                throw new SSLException(e);
            }
        }
        CFStartUpServlet.setDefaultHostnameVerifier();
    }

    private static void setDefaultHostnameVerifier() {
        HostnameVerifier verifier = new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostname, SSLSession sslSession) {
                HostnameVerifier hv = HttpsURLConnection.getDefaultHostnameVerifier();
                return hv.verify(urlHostname, sslSession);
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(verifier);
        HostnameVerifier javaxVerifier = CFStartUpServlet.createJavaxVerifier();
        if (javaxVerifier != null) {
            HttpsURLConnection.setDefaultHostnameVerifier(javaxVerifier);
        }
    }

    private static HostnameVerifier createJavaxVerifier() {
        BrowserCompatHostnameVerifier javaxVerifier;
        String verifierType = System.getProperty("coldfusion.ssl.hostnameverifier");
        if (verifierType == null || "WILDCARD".equalsIgnoreCase(verifierType)) {
            javaxVerifier = new BrowserCompatHostnameVerifier();
        } else if ("STRICT".equalsIgnoreCase(verifierType)) {
            javaxVerifier = new StrictHostnameVerifier();
        } else if ("ALL".equalsIgnoreCase(verifierType)) {
            javaxVerifier = new AllowAllHostnameVerifier();
        } else if ("NONE".equalsIgnoreCase(verifierType)) {
            javaxVerifier = null;
        } else {
            throw new WrongHostNameVerifierException(verifierType);
        }
        return javaxVerifier;
    }

    public String hash() {
        byte[] input;
        MessageDigest digest;
        String string = new String(CFStartUpServlet.generateRandom());
        String encoding = "UTF-8";
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        digest.reset();
        try {
            input = string.getBytes(encoding);
            digest.update(input);
            input = digest.digest();
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return CFStartUpServlet.stringify(input);
    }

    public static byte[] generateRandom() {
        int numBytes = 20;
        SecureRandom r = new SecureRandom();
        byte[] salt = new byte[numBytes];
        ((Random)r).nextBytes(salt);
        return salt;
    }

    public static String stringify(byte[] buf) {
        StringBuffer sb = new StringBuffer(2 * buf.length);
        for (int i = 0; i < buf.length; ++i) {
            int h = (buf[i] & 0xF0) >> 4;
            int l = buf[i] & 0xF;
            sb.append((char)(h > 9 ? 65 + h - 10 : 48 + h));
            sb.append((char)(l > 9 ? 65 + l - 10 : 48 + l));
        }
        return sb.toString();
    }

    public static class SSLException
    extends ApplicationException {
        SSLException(Throwable ex) {
            super(ex);
        }
    }

    public static class WrongHostNameVerifierException
    extends ApplicationException {
        public String name = "";

        WrongHostNameVerifierException(String name) {
            this.name = name;
        }
    }
}

