/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.j2ee;

import coldfusion.util.OrderedProperties;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class JvmConfigUtils {
    public static String getJavaArgsList(String jvmConfig, List args) throws FileNotFoundException, IOException {
        return JvmConfigUtils.getJavaArgsList(jvmConfig, args, true);
    }

    public static String getJavaArgsList(String jvmConfig, List args, boolean removeClasspath) throws FileNotFoundException, IOException {
        String obj = JvmConfigUtils.getJavaArgs(jvmConfig);
        StringTokenizer tok = new StringTokenizer(obj, " ");
        String retString = null;
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken();
            if (removeClasspath && str.startsWith("-Dcoldfusion.classPath")) {
                retString = str.substring(23, str.length());
                continue;
            }
            StringTokenizer stok = new StringTokenizer(str, " ");
            while (stok.hasMoreTokens()) {
                args.add(stok.nextToken());
            }
        }
        return retString;
    }

    public static String quoteCFClassPath(String cfcp) {
        StringBuffer newCP = new StringBuffer(100);
        if (cfcp.startsWith("-Dcoldfusion.classPath")) {
            cfcp = cfcp.substring(cfcp.indexOf(61) + 1, cfcp.length());
        }
        StringTokenizer tok = new StringTokenizer(cfcp, ",");
        while (tok.hasMoreElements()) {
            Object str = tok.nextToken();
            if (((String)(str = ((String)str).trim())).indexOf(32) != -1 && ((String)str).indexOf("\"") == -1 && ((String)str).lastIndexOf("\"") == -1) {
                str = "\"" + (String)str + "\"";
            }
            newCP.append((String)str);
            newCP.append(",");
        }
        if (newCP.charAt(newCP.length() - 1) == ',') {
            newCP.deleteCharAt(newCP.length() - 1);
        }
        return newCP.toString();
    }

    public static String getJavaArgs(String jvmConfig) throws FileNotFoundException, IOException {
        OrderedProperties props = JvmConfigUtils.getJVMConfig(jvmConfig);
        return (String)props.get("java.args");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OrderedProperties getJVMConfig(String jvmConfig) throws FileNotFoundException, IOException {
        FileInputStream fis = null;
        try {
            OrderedProperties props = new OrderedProperties();
            fis = new FileInputStream(jvmConfig);
            props.load(fis);
            OrderedProperties orderedProperties = props;
            return orderedProperties;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCFClassPath(String classPath, String jvmConfig) throws FileNotFoundException, IOException {
        ArrayList args = new ArrayList();
        JvmConfigUtils.getJavaArgsList(jvmConfig, args);
        StringBuffer buf = new StringBuffer(100);
        for (Object obj : args) {
            buf.append(obj);
            buf.append(" ");
        }
        buf.append("-Dcoldfusion.classPath=");
        buf.append(classPath);
        OrderedProperties props = JvmConfigUtils.getJVMConfig(jvmConfig);
        props.setProperty("java.args", buf.toString());
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(jvmConfig);
            props.store(fos);
            fos.close();
        }
    }
}

