/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.j2ee.sql;

import coldfusion.server.j2ee.sql.JRunConnectionHandle;
import coldfusion.server.j2ee.sql.JRunDriver;
import coldfusion.server.j2ee.sql.pool.JDBCManager;
import coldfusion.server.j2ee.sql.pool.JDBCPool;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;

public class JRunDataSource
implements DataSource,
ConnectionPoolDataSource,
XADataSource,
Referenceable,
ObjectFactory {
    private String poolName;
    private String jndiName;
    private transient PrintWriter logger;
    private int loginTimeout;
    private transient TransactionManager tm = null;
    private transient HashMap resources = new HashMap();
    private transient HashSet transactions = new HashSet();

    public JRunDataSource() {
    }

    public JRunDataSource(String poolName, String jndiName) {
        this();
        this.poolName = poolName;
        this.jndiName = jndiName;
    }

    public static DataSource getDataSource() throws SQLException {
        return JRunDriver.findDataSource(null);
    }

    public static DataSource getDataSource(String dbname) throws SQLException {
        return JRunDriver.findDataSource(dbname);
    }

    public String getPoolName() {
        return this.poolName;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        JRunConnectionHandle jCon = null;
        if (jCon == null) {
            jCon = (JRunConnectionHandle)JDBCManager.getInstance().requestConnection(this.poolName, username, password);
        }
        return jCon;
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return (PooledConnection)((Object)this.getConnection());
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return (PooledConnection)((Object)this.getConnection(user, password));
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return (XAConnection)((Object)this.getConnection());
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        return (XAConnection)((Object)this.getConnection(user, password));
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logger = out;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logger;
    }

    public boolean equals(Object o) {
        try {
            JRunDataSource ds = (JRunDataSource)o;
            if (ds.getPool().equals(this.getPool())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String toString() {
        return "JRunDataSource: [JNDI Name: " + this.jndiName + ", PoolName: " + this.poolName + "]";
    }

    private JDBCPool getPool() throws SQLException {
        return (JDBCPool)JDBCManager.getInstance().getPool(this.getPoolName());
    }

    @Override
    public Reference getReference() {
        Reference ref = new Reference("jrun.sql.JRunDataSource", "jrun.sql.JRunDataSource", null);
        ref.add(new StringRefAddr("poolname", this.poolName));
        return ref;
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        DataSource result = null;
        try {
            Reference ref = (Reference)obj;
            String poolNM = (String)ref.get("poolname").getContent();
            try {
                JDBCPool jpool = (JDBCPool)JDBCManager.getInstance().getPool(poolNM);
                result = jpool.getDataSource();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public boolean isWrapperFor(Class<?> c) {
        throw new UnsupportedOperationException("Wrapper.isWrapperFor(java.lang.Class<?>)");
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        throw new UnsupportedOperationException("Wrapper.unwrap(Class<T> iface)");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

