/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.j2ee.sql;

import coldfusion.server.j2ee.sql.pool.JDBCManager;
import coldfusion.server.j2ee.sql.pool.JDBCPool;
import coldfusion.util.RB;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class JRunDriver
implements Driver {
    public static final String PROTOCOL = "jdbc:jrun:";
    public static boolean STARTED = false;

    public JRunDriver() {
        this.registerDriver();
    }

    private void registerDriver() {
        boolean registered = false;
        try {
            Enumeration<Driver> driverEnum = DriverManager.getDrivers();
            while (driverEnum.hasMoreElements()) {
                Driver d = driverEnum.nextElement();
                if (!(d instanceof JRunDriver)) continue;
                registered = true;
            }
            if (!registered) {
                DriverManager.registerDriver(this);
            }
        }
        catch (SQLException se) {
            throw new RuntimeException(RB.getString(JRunDriver.class, "JRunDriver.DriverLoadFailure"));
        }
    }

    public static DataSource getDataSource() throws SQLException {
        return JRunDriver.findDataSource(null);
    }

    public static DataSource getDataSource(String dbname) throws SQLException {
        return JRunDriver.findDataSource(dbname);
    }

    public static DataSource findDataSource(String dbname) throws SQLException {
        JDBCManager manager = JDBCManager.getInstance();
        DataSource result = null;
        JDBCPool jpool = null;
        try {
            jpool = (JDBCPool)manager.getPool(dbname);
            result = jpool.getDataSource();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (result == null) {
            throw new SQLException(RB.getString(JRunDriver.class, "JRunDriver.NoSuchDataSource", (Object)dbname));
        }
        return result;
    }

    public static boolean nameIsValid(String dbname) {
        JDBCManager manager = JDBCManager.getInstance();
        Enumeration poolnamesEnum = manager.getAllPoolnames();
        while (poolnamesEnum.hasMoreElements()) {
            String name = poolnamesEnum.nextElement().toString();
            if (!dbname.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(PROTOCOL);
    }

    /*
     * Loose catch block
     */
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        String dbname;
        JDBCManager manager;
        block7: {
            manager = JDBCManager.getInstance();
            dbname = null;
            if (url.indexOf("//") != -1) {
                dbname = url.substring(url.lastIndexOf("/") + 1, url.length());
            }
            if (null != info && info.containsKey("dbname")) {
                dbname = info.getProperty("dbname");
            }
            if (dbname != null && !dbname.equals("")) break block7;
            return manager.requestConnection();
            {
                catch (Exception pe) {
                    throw new SQLException(pe.getMessage());
                }
            }
        }
        try {
            return manager.requestConnection(dbname);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    public static Connection connect(String url) throws SQLException {
        JDBCManager manager = JDBCManager.getInstance();
        String dbname = null;
        if (url.indexOf("//") != -1) {
            dbname = url.substring(url.lastIndexOf("/") + 1, url.length());
        }
        if (dbname == null || dbname.equals("")) {
            return manager.requestConnection();
        }
        try {
            return manager.requestConnection(dbname);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public int getMajorVersion() {
        return -1;
    }

    @Override
    public int getMinorVersion() {
        return -1;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return null;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

