/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.j2ee.sql;

import coldfusion.server.j2ee.pool.ObjectPool;
import coldfusion.server.j2ee.pool.PooledObject;
import coldfusion.server.j2ee.sql.JRunConnection;
import coldfusion.server.j2ee.sql.pool.JDBCPool;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.WeakHashMap;

public class JRunStatement
implements Statement,
PooledObject {
    private static final long serialVersionUID = 1L;
    protected Statement statement;
    protected String sqlString;
    protected ResultSet lastRS;
    protected WeakHashMap openres;
    protected JDBCPool mypool;
    protected JRunConnection jrunCon;
    protected boolean closed = false;
    protected int resultSetType = 1003;
    protected int resultSetConcurrency = 1007;
    protected int resultSetHoldability = -1;

    public JRunStatement(JRunConnection jcon, Statement s, ObjectPool p) {
        this.jrunCon = jcon;
        this.statement = s;
        this.mypool = (JDBCPool)p;
        this.openres = new WeakHashMap();
    }

    public Statement getNativeStatement() {
        return this.statement;
    }

    public void setResultSetType(int i) {
        this.resultSetType = i;
    }

    public void setResultSetConcurrency(int i) {
        this.resultSetConcurrency = i;
    }

    @Override
    public void closeAllResources() {
        try {
            this.statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public boolean clean() {
        Iterator iter = this.openres.keySet().iterator();
        while (iter.hasNext()) {
            JDBCPool.closeResultSet((ResultSet)iter.next());
        }
        return true;
    }

    public void removeOpenResultSet(ResultSet rs) {
        if (this.openres.containsKey(rs)) {
            this.openres.remove(rs);
        }
    }

    @Override
    public ObjectPool getPool() {
        return this.mypool;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.jrunCon.getConnection();
    }

    public String getSQL() {
        return this.sqlString;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.sqlString = sql;
        ArrayList rowlist = new ArrayList();
        ResultSet r = null;
        r = this.statement.executeQuery(sql);
        this.openres.put(r, null);
        this.lastRS = r;
        return r;
    }

    public String fabricateTableName(String sql, int index) {
        String tableName = null;
        try {
            sql = sql.trim().toLowerCase();
            String fromPart = sql.substring(sql.indexOf("from"));
            if (fromPart.indexOf("where") != -1) {
                fromPart = fromPart.substring(0, fromPart.indexOf("where"));
            }
            if ((fromPart = fromPart.substring(4).trim()).indexOf(",") != -1) {
                StringTokenizer stt = new StringTokenizer(fromPart, ",");
                int count = 1;
                while (stt.hasMoreTokens()) {
                    while (count < index) {
                        stt.nextToken();
                        ++count;
                    }
                    tableName = stt.nextToken().trim();
                }
            } else {
                tableName = fromPart;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tableName;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.sqlString = sql;
        return this.statement.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        this.clean();
        this.statement.close();
        this.jrunCon.removeOpenStatement(this);
        this.closed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.statement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.statement.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.statement.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.statement.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.statement.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.statement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.statement.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.statement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.statement.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.statement.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.statement.execute(sql);
    }

    private boolean isExecuteQuery(String sql) {
        return sql.indexOf("create") == -1 && sql.indexOf("delete") == -1 && sql.indexOf("drop") != -1 && sql.indexOf("alter") == -1 && sql.indexOf("insert") != -1 && sql.indexOf("update") == -1;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.lastRS != null) {
            return this.lastRS;
        }
        return this.statement.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.statement.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.statement.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.statement.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.statement.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.statement.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.statement.executeBatch();
    }

    public String toString() {
        return "JRunStatement-[UnderlyingStatement:" + this.statement.toString() + "]";
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.statement.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.statement.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.statement.execute(sql, columnNames);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.sqlString = sql;
        return this.statement.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.sqlString = sql;
        return this.statement.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.sqlString = sql;
        return this.statement.executeUpdate(sql, columnNames);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.statement.getGeneratedKeys();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.statement.getMoreResults(current);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        if (this.resultSetHoldability == -1) {
            this.resultSetHoldability = this.jrunCon.getHoldability();
        }
        return this.resultSetHoldability;
    }

    public void setResultSetHoldability(int i) throws SQLException {
        this.resultSetHoldability = i;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.statement.isPoolable();
    }

    @Override
    public void setPoolable(boolean b) throws SQLException {
        this.statement.setPoolable(b);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.statement.isClosed();
    }

    @Override
    public boolean isWrapperFor(Class<?> c) throws SQLException {
        return this.statement.isWrapperFor(c);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.statement.unwrap(iface);
    }

    public void setBlob(int i, InputStream is) throws SQLException {
        throw new UnsupportedOperationException("Statement.setBlob(int,java.io.InputStream)");
    }

    public void setClob(int i, Reader r) throws SQLException {
        throw new UnsupportedOperationException("Statement.setClob(int,java.io.Reader)");
    }

    public void setNCharacterStream(int i, Reader r) throws SQLException {
        throw new UnsupportedOperationException("Statement.setNCharacterStream(int,java.io.Reader)");
    }

    public void setCharacterStream(int i, Reader r) throws SQLException {
        throw new UnsupportedOperationException("Statement.setCharacterStream(int,java.io.Reader)");
    }

    public void setBinaryStream(int i, InputStream is) throws SQLException {
        throw new UnsupportedOperationException("Statement.setBinaryStream(int,java.io.InputStream) ");
    }

    public void setAsciiStream(int i, InputStream is) throws SQLException {
        throw new UnsupportedOperationException("Statement.setAsciiStream(int,java.io.InputStream)");
    }

    public void setCharacterStream(int i, Reader r, long l) throws SQLException {
        throw new UnsupportedOperationException("Statement.setCharacterStream(int,java.io.Reader,long)");
    }

    public void setBinaryStream(int i, InputStream is, long l) throws SQLException {
        throw new UnsupportedOperationException("Statement.setBinaryStream(int,java.io.InputStream,long)");
    }

    public void setAsciiStream(int i, InputStream is, long l) throws SQLException {
        throw new UnsupportedOperationException("Statement.setAsciiStream(int,java.io.InputStream,long)");
    }

    public void setSQLXML(int i, SQLXML xml) throws SQLException {
        throw new UnsupportedOperationException("Statement.setSQLXML(int,java.sql.SQLXML)");
    }

    public void setNClob(int i, Reader r) throws SQLException {
        throw new UnsupportedOperationException("Statement.setNClob(int,java.io.Reader)");
    }

    public void setNClob(int i, Reader r, long l) throws SQLException {
        throw new UnsupportedOperationException("Statement.setNClob(int,java.io.Reader,long)");
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException("Statement.setRowId(int,RowId)");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }
}

