/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.server.j2ee.sql.pool;

import coldfusion.server.j2ee.sql.pool.JDBCPool;
import coldfusion.sql.DatabaseConnectionException;
import java.sql.Connection;
import java.sql.SQLException;
import macromedia.jdbc.DriverNotSupportedException;

public class ConnectionRunner {
    private JDBCPool _ds;

    public Connection fetchConnection(JDBCPool ds, String uname, String pwd, int timeout) throws SQLException, DriverNotSupportedException {
        this._ds = ds;
        RunnableConnection rCon = new RunnableConnection(ds, uname, pwd);
        Thread t1 = new Thread(rCon);
        ClassLoader cl1 = t1.getContextClassLoader();
        t1.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        try {
            t1.start();
            t1.join(timeout * 1000);
        }
        catch (InterruptedException ie) {
            throw new DatabaseConnectionException(ie);
        }
        finally {
            t1.setContextClassLoader(cl1);
        }
        return rCon.fetchConnection();
    }

    private class RunnableConnection
    implements Runnable {
        private Connection _con = null;
        private JDBCPool _ds = null;
        private String _uname;
        private String _password;
        private SQLException _sqle;
        private DriverNotSupportedException _dnse;

        public RunnableConnection(JDBCPool ds, String uname, String password) {
            this._ds = ds;
            this._uname = uname;
            this._password = password;
        }

        @Override
        public void run() {
            try {
                this._con = this._ds.createPhysicalConnection(this._uname, this._password);
            }
            catch (DriverNotSupportedException dnse) {
                this._dnse = dnse;
            }
            catch (SQLException sqle) {
                this._sqle = sqle;
            }
        }

        public Connection fetchConnection() throws SQLException, DriverNotSupportedException {
            if (this._dnse != null) {
                throw this._dnse;
            }
            if (this._sqle != null) {
                throw this._sqle;
            }
            if (this._con == null) {
                throw new DatabaseConnectionException();
            }
            return this._con;
        }
    }
}

